/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.text.MessageFormat;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceException;
import org.openide.util.Task;

public final class SourceElement
extends Element {
    public static final int STATUS_NOT = 0;
    public static final int STATUS_ERROR = 1;
    public static final int STATUS_PARTIAL = 2;
    public static final int STATUS_OK = 3;
    static final long serialVersionUID = -1439690719608070114L;

    public SourceElement(Impl impl) {
        super(impl);
    }

    final Impl getSourceImpl() {
        return (Impl)this.impl;
    }

    public int getStatus() {
        return this.getSourceImpl().getStatus();
    }

    public Task prepare() {
        return this.getSourceImpl().prepare();
    }

    public void setPackage(Identifier identifier) throws SourceException {
        this.getSourceImpl().setPackage(identifier);
    }

    public Identifier getPackage() {
        return this.getSourceImpl().getPackage();
    }

    public Import[] getImports() {
        return this.getSourceImpl().getImports();
    }

    public void setImports(Import[] importArray) throws SourceException {
        this.getSourceImpl().changeImports(importArray, 0);
    }

    public void addImport(Import import_) throws SourceException {
        this.getSourceImpl().changeImports(new Import[]{import_}, 1);
    }

    public void addImports(Import[] importArray) throws SourceException {
        this.getSourceImpl().changeImports(importArray, 1);
    }

    public void removeImport(Import import_) throws SourceException {
        this.getSourceImpl().changeImports(new Import[]{import_}, -1);
    }

    public void removeImports(Import[] importArray) throws SourceException {
        this.getSourceImpl().changeImports(importArray, -1);
    }

    public void addClass(ClassElement classElement) throws SourceException {
        Identifier identifier = Identifier.create(classElement.getName().getName());
        if (this.getClass(identifier) != null) {
            this.throwAddException("FMT_EXC_AddClassToSource", classElement);
        }
        this.getSourceImpl().changeClasses(new ClassElement[]{classElement}, 1);
    }

    public void addClasses(ClassElement[] classElementArray) throws SourceException {
        int n = 0;
        while (n < classElementArray.length) {
            Identifier identifier = Identifier.create(classElementArray[n].getName().getName());
            if (this.getClass(identifier) != null) {
                this.throwAddException("FMT_EXC_AddClassToSource", classElementArray[n]);
            }
            ++n;
        }
        this.getSourceImpl().changeClasses(classElementArray, 1);
    }

    private void throwAddException(String string, ClassElement classElement) throws SourceException {
        MessageFormat messageFormat = new MessageFormat(ElementFormat.bundle.getString(string));
        String string2 = messageFormat.format(new Object[]{classElement.getName().getName()});
        this.throwSourceException(string2);
    }

    public void removeClass(ClassElement classElement) throws SourceException {
        this.getSourceImpl().changeClasses(new ClassElement[]{classElement}, -1);
    }

    public void removeClasses(ClassElement[] classElementArray) throws SourceException {
        this.getSourceImpl().changeClasses(classElementArray, -1);
    }

    public void setClasses(ClassElement[] classElementArray) throws SourceException {
        this.getSourceImpl().changeClasses(classElementArray, 0);
    }

    public ClassElement[] getClasses() {
        return this.getSourceImpl().getClasses();
    }

    public ClassElement getClass(Identifier identifier) {
        return this.getSourceImpl().getClass(identifier);
    }

    public ClassElement[] getAllClasses() {
        return this.getSourceImpl().getAllClasses();
    }

    public void print(ElementPrinter elementPrinter) throws ElementPrinterInterruptException {
        Identifier identifier = this.getPackage();
        if (identifier != null) {
            elementPrinter.print("package ");
            elementPrinter.print(identifier.getFullName());
            elementPrinter.println(";");
            elementPrinter.println("");
        }
        Import[] importArray = this.getImports();
        int n = 0;
        while (n < importArray.length) {
            elementPrinter.print(importArray[n].toString());
            elementPrinter.println(";");
            ++n;
        }
        if (importArray.length > 0) {
            elementPrinter.println("");
        }
        Element.print(this.getClasses(), elementPrinter);
    }

    public void runAtomic(Runnable runnable) {
        this.getSourceImpl().runAtomic(runnable);
    }

    public void runAtomicAsUser(Runnable runnable) throws SourceException {
        this.getSourceImpl().runAtomicAsUser(runnable);
    }

    public static interface Impl
    extends Element.Impl {
        public static final int ADD = 1;
        public static final int REMOVE = -1;
        public static final int SET = 0;
        public static final long serialVersionUID = -2181228658756563166L;

        public int getStatus();

        public Task prepare();

        public void setPackage(Identifier var1) throws SourceException;

        public Identifier getPackage();

        public Import[] getImports();

        public void changeImports(Import[] var1, int var2) throws SourceException;

        public void changeClasses(ClassElement[] var1, int var2) throws SourceException;

        public ClassElement[] getClasses();

        public ClassElement getClass(Identifier var1);

        public ClassElement[] getAllClasses();

        public void runAtomic(Runnable var1);

        public void runAtomicAsUser(Runnable var1) throws SourceException;
    }
}

