/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ElementFormat;
import org.openide.src.InitializerElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class InitializerElementNode
extends ElementNode {
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[]{"static"};

    public InitializerElementNode(InitializerElement initializerElement, boolean bl) {
        super(initializerElement, Children.LEAF, bl);
        this.setElementFormat0(ElementNode.sourceOptions.getInitializerElementFormat());
        this.superSetName("<initializer>");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.nodes.InitializerNode");
    }

    protected String resolveIconBase() {
        return ((InitializerElement)this.element).isStatic() ? "/org/openide/resources/src/initializerSt" : "/org/openide/resources/src/initializer";
    }

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    protected ElementFormat getHintElementFormat() {
        return ElementNode.sourceOptions.getInitializerElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createStaticProperty(this.isWriteable()));
        return sheet;
    }

    public boolean canRename() {
        return false;
    }

    public void destroy() throws IOException {
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                InitializerElement initializerElement = (InitializerElement)InitializerElementNode.this.element;
                initializerElement.getDeclaringClass().removeInitializer(initializerElement);
            }
        });
        super.destroy();
    }

    protected Node.Property createStaticProperty(boolean bl) {
        return new ElementNode.ElementProp("static", Boolean.TYPE, bl){

            public Object getValue() {
                return new Boolean(((InitializerElement)InitializerElementNode.this.element).isStatic());
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof Boolean)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(InitializerElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, object){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$val = object;
                    }

                    public void run() throws SourceException {
                        ((InitializerElement)2.access$000(this.this$1).element).setStatic((Boolean)this.val$val);
                    }
                });
            }

            static /* synthetic */ InitializerElementNode access$000(2 var0) {
                return var0.InitializerElementNode.this;
            }
        };
    }
}

