/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.editors.ModifierEditor;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ElementBeanModel;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MethodCustomizer
extends JPanel {
    static ResourceBundle bundle = NbBundle.getBundle(class$org$openide$src$nodes$MethodCustomizer == null ? (class$org$openide$src$nodes$MethodCustomizer = MethodCustomizer.class$("org.openide.src.nodes.MethodCustomizer")) : class$org$openide$src$nodes$MethodCustomizer);
    private static final String[] COMMON_TYPES = new String[]{"void", "String", "boolean", "char", "int", "long", "byte", "short", "float", "double"};
    ConstructorElement element;
    MethodElement method;
    boolean isOK = true;
    private JPanel methodPanel;
    private JLabel jLabel1;
    private JTextField nameTextField;
    private JLabel jLabel2;
    private JComboBox returnCombo;
    private JPanel jPanel1;
    private JPanel modifierPanel;
    private JPanel paramsPanel;
    private JPanel exceptionsPanel;
    static /* synthetic */ Class class$org$openide$src$nodes$MethodCustomizer;

    public MethodCustomizer(ConstructorElement constructorElement) {
        this.element = constructorElement;
        this.method = constructorElement instanceof MethodElement ? (MethodElement)constructorElement : null;
        this.initComponents();
        this.methodPanel.setBorder(new CompoundBorder(new TitledBorder(bundle.getString("CTL_MethodFrame")), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.modifierPanel.setBorder(new TitledBorder(bundle.getString("CTL_Modifiers")));
        this.paramsPanel.setBorder(new TitledBorder(bundle.getString("CTL_Parameters")));
        this.exceptionsPanel.setBorder(new TitledBorder(bundle.getString("CTL_Exceptions")));
        PropertyPanel propertyPanel = new PropertyPanel(new ElementBeanModel((Element)constructorElement, "modifiers"), 2);
        this.modifierPanel.add((Component)propertyPanel, "Center");
        PropertyEditor propertyEditor = propertyPanel.getPropertyEditor();
        if (propertyEditor instanceof ModifierEditor) {
            ((ModifierEditor)propertyEditor).setMask(constructorElement.getModifiersMask());
        }
        this.nameTextField.setText(constructorElement.getName().toString());
        if (this.method == null) {
            this.nameTextField.setEnabled(false);
            this.returnCombo.setEnabled(false);
        } else {
            this.returnCombo.setSelectedItem(this.method.getReturn().toString());
        }
        this.paramsPanel.add((Component)new PropertyPanel(new ElementBeanModel((Element)constructorElement, "parameters"), 2), "Center");
        this.exceptionsPanel.add((Component)new PropertyPanel(new ElementBeanModel((Element)constructorElement, "exceptions"), 2), "Center");
        HelpCtx.setHelpIDString(this, "java.method.customizer");
        this.jLabel1.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(bundle.getString("CTL_Type_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int n = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MethodCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.methodPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.returnCombo = new JComboBox<String>(COMMON_TYPES);
        this.jPanel1 = new JPanel();
        this.modifierPanel = new JPanel();
        this.paramsPanel = new JPanel();
        this.exceptionsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.methodPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("CTL_Name"));
        this.jLabel1.setLabelFor(this.nameTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 8, 8);
        gridBagConstraints.anchor = 13;
        this.methodPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MethodCustomizer.this.nameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 8, 0);
        gridBagConstraints.weightx = 1.0;
        this.methodPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("CTL_ReturnType"));
        this.jLabel2.setLabelFor(this.returnCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        gridBagConstraints.anchor = 13;
        this.methodPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.returnCombo.setEditable(true);
        this.returnCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MethodCustomizer.this.returnComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.methodPanel.add((Component)this.returnCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.methodPanel.add((Component)this.jPanel1, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        this.add((Component)this.methodPanel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints2);
        this.paramsPanel.setLayout(new BorderLayout());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add((Component)this.paramsPanel, gridBagConstraints2);
        this.exceptionsPanel.setLayout(new BorderLayout());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add((Component)this.exceptionsPanel, gridBagConstraints2);
    }

    private void returnComboActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        Type type;
        block8: {
            if (this.method == null) {
                return;
            }
            Object object = this.returnCombo.getSelectedItem();
            type = this.method.getReturn();
            bl = false;
            if (object != null) {
                try {
                    final Type type2 = Type.parse(object.toString());
                    if (!type.equals(type2)) {
                        try {
                            SourceEditSupport.runAsUser(this.method, new SourceEditSupport.ExceptionalRunnable(){

                                public void run() throws SourceException {
                                    MethodCustomizer.this.method.setReturn(type2);
                                }
                            });
                            bl = true;
                        }
                        catch (SourceException sourceException) {
                            TopManager.getDefault().notifyException(sourceException);
                        }
                        break block8;
                    }
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    TopManager.getDefault().getErrorManager().annotate(illegalArgumentException, 256, null, bundle.getString("MSG_Not_Valid_Type"), null, null);
                    TopManager.getDefault().notifyException(illegalArgumentException);
                }
            }
        }
        this.isOK = bl;
        if (!bl) {
            this.returnCombo.setSelectedItem(type.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nameTextFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent != null && focusEvent.isTemporary() || this.method == null) {
            return;
        }
        String string = this.nameTextField.getText();
        String string2 = this.method.getName().toString();
        boolean bl = false;
        IllegalArgumentException illegalArgumentException = null;
        if (Utilities.isJavaIdentifier(string)) {
            if (string2.equals(string)) return;
            final Identifier identifier = Identifier.create(string);
            try {
                SourceEditSupport.runAsUser(this.method, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        MethodCustomizer.this.method.setName(identifier);
                    }
                });
                bl = true;
            }
            catch (SourceException sourceException) {
                TopManager.getDefault().notifyException(sourceException);
            }
        } else {
            illegalArgumentException = new IllegalArgumentException("Invalid name");
            TopManager.getDefault().getErrorManager().annotate(illegalArgumentException, 256, null, bundle.getString("MSG_Not_Valid_Identifier"), null, null);
        }
        this.isOK = bl;
        if (!bl) {
            this.nameTextField.setText(string2);
        }
        if (illegalArgumentException == null) return;
        TopManager.getDefault().notifyException(illegalArgumentException);
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_MethodNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_MethodNameTextField"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_MethodCustomizerDialog");
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        this.returnComboActionPerformed(null);
        return this.isOK;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

