/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.cookies.FilterCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;
import org.openide.src.nodes.DefaultFactory;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.src.nodes.SourceElementFilter;
import org.openide.util.WeakListener;

public class SourceChildren
extends Children.Keys
implements FilterCookie {
    static final Object NOT_KEY = new Object();
    static final Object ERROR_KEY = new Object();
    private static int PPP_MASK = 7;
    protected SourceElement element;
    protected SourceElementFilter filter;
    protected ElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private ElementListener propL;
    private boolean nodesInited = false;
    static /* synthetic */ Class class$org$openide$src$nodes$SourceElementFilter;

    public SourceChildren() {
        this(DefaultFactory.READ_WRITE, null);
    }

    public SourceChildren(SourceElement sourceElement) {
        this(DefaultFactory.READ_WRITE, sourceElement);
    }

    public SourceChildren(ElementNodeFactory elementNodeFactory) {
        this(elementNodeFactory, null);
    }

    public SourceChildren(ElementNodeFactory elementNodeFactory, SourceElement sourceElement) {
        this.element = sourceElement;
        this.factory = elementNodeFactory;
        this.filter = new SourceElementFilter();
    }

    public Class getFilterClass() {
        return class$org$openide$src$nodes$SourceElementFilter == null ? (class$org$openide$src$nodes$SourceElementFilter = SourceChildren.class$("org.openide.src.nodes.SourceElementFilter")) : class$org$openide$src$nodes$SourceElementFilter;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object object) {
        if (!(object instanceof SourceElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (SourceElementFilter)object;
        if (this.nodesInited) {
            this.refreshKeys();
        }
    }

    protected void addNotify() {
        if (this.element != null) {
            if (this.wPropL == null) {
                this.propL = new ElementListener();
                this.wPropL = WeakListener.propertyChange(this.propL, this.element);
            }
            this.element.addPropertyChangeListener(this.wPropL);
            this.element.prepare();
        }
        this.refreshKeys();
        this.nodesInited = true;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof ClassElement) {
            return new Node[]{this.factory.createClassNode((ClassElement)object)};
        }
        if (NOT_KEY.equals(object)) {
            return new Node[]{this.factory.createWaitNode()};
        }
        return new Node[]{this.factory.createErrorNode()};
    }

    public Node findChild(String string) {
        Node node = super.findChild(string);
        if (node != null) {
            return node;
        }
        if (this.element != null) {
            this.element.prepare().waitFinished();
            this.refreshKeys();
            return super.findChild(string);
        }
        return null;
    }

    public SourceElement getElement() {
        return this.element;
    }

    public void setElement(SourceElement sourceElement) {
        if (this.element != null) {
            this.element.removePropertyChangeListener(this.wPropL);
        }
        this.element = sourceElement;
        if (this.element != null) {
            if (this.wPropL == null) {
                this.propL = new ElementListener();
                this.wPropL = WeakListener.propertyChange(this.propL, this.element);
            }
            this.element.addPropertyChangeListener(this.wPropL);
        }
        if (this.nodesInited) {
            if (this.element != null) {
                this.element.prepare();
            }
            this.refreshKeys();
        }
    }

    private void refreshKeys() {
        int n = this.element == null ? 1 : this.element.getStatus();
        switch (n) {
            case 0: {
                this.setKeys(new Object[]{NOT_KEY});
                this.element.prepare();
                break;
            }
            case 1: {
                this.setKeys(new Object[]{ERROR_KEY});
                break;
            }
            case 2: 
            case 3: {
                this.refreshAllKeys();
            }
        }
    }

    private void refreshAllKeys() {
        int[] nArray = this.filter == null || this.filter.getOrder() == null ? SourceElementFilter.DEFAULT_ORDER : this.filter.getOrder();
        LinkedList linkedList = new LinkedList();
        int n = 0;
        while (n < nArray.length) {
            this.addKeysOfType(linkedList, nArray[n]);
            ++n;
        }
        this.setKeys(linkedList);
    }

    private void addKeysOfType(Collection collection, int n) {
        if (n == 1) {
            return;
        }
        List<ClassElement> list = this.filter != null && this.filter.isAllClasses() ? Arrays.asList(this.element.getAllClasses()) : Arrays.asList(this.element.getClasses());
        int n2 = 0;
        while (n2 < list.size()) {
            ClassElement classElement = list.get(n2);
            int n3 = classElement.getModifiers();
            if ((n3 & PPP_MASK) == 0) {
                n3 += 65536;
            }
            if ((this.filter.getModifiers() & n3) != 0) {
                if (classElement.isClass()) {
                    if ((n & 2) != 0) {
                        collection.add(classElement);
                    }
                } else if ((n & 4) != 0) {
                    collection.add(classElement);
                }
            }
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class ElementListener
    implements PropertyChangeListener {
        private ElementListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = "classes".equals(propertyChangeEvent.getPropertyName());
            if (!bl && "status".equals(propertyChangeEvent.getPropertyName())) {
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                boolean bl2 = bl = n == null || n != 0;
            }
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SourceChildren.this.refreshKeys();
                    }
                });
            }
        }
    }
}

