/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.TopManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.OpenSupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;

public class DataEditorSupport
extends CloneableEditorSupport {
    private final DataObject obj;
    private NodeListener nodeL;
    static /* synthetic */ Class class$org$openide$text$DataEditorSupport;

    public DataEditorSupport(DataObject dataObject, CloneableEditorSupport.Env env) {
        super(env);
        this.obj = dataObject;
    }

    public final DataObject getDataObject() {
        return this.obj;
    }

    protected String messageOpening() {
        return NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "CTL_ObjectOpen", this.obj.getName(), this.obj.getPrimaryFile().toString());
    }

    protected String messageOpened() {
        return NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "CTL_ObjectOpened", this.obj.getName(), this.obj.getPrimaryFile().toString());
    }

    protected String messageSave() {
        return NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "MSG_SaveFile", this.obj.getName());
    }

    protected String messageName() {
        if (!this.obj.isValid()) {
            return "";
        }
        String string = this.obj.getNodeDelegate().getDisplayName();
        int n = 3;
        if (this.isModified()) {
            n = this.obj.getPrimaryFile().isReadOnly() ? 2 : 1;
        } else if (this.obj.getPrimaryFile().isReadOnly()) {
            n = 0;
        }
        return MessageFormat.format(NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "LAB_EditorName"), new Integer(n), string);
    }

    protected String messageToolTip() {
        FileObject fileObject = this.obj.getPrimaryFile();
        try {
            File file = FileUtil.toFile(fileObject);
            if (file != null) {
                return file.getAbsolutePath();
            }
            return NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "LAB_EditorToolTip", new Object[]{fileObject.getPackageNameExt('/', '.'), fileObject.getFileSystem().getDisplayName()});
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return fileObject.getPackageNameExt('/', '.');
        }
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        if (this.obj.isValid()) {
            Node node = this.obj.getNodeDelegate();
            cloneableEditor.setActivatedNodes(new Node[]{node});
            cloneableEditor.setIcon(node.getIcon(1));
            this.nodeL = new DataNodeListener(cloneableEditor);
            node.addNodeListener(WeakListener.node(this.nodeL, node));
        }
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = super.createStyledDocument(editorKit);
        styledDocument.putProperty("title", this.obj.getPrimaryFile().getPackageNameExt('/', '.'));
        styledDocument.putProperty("stream", this.obj);
        return styledDocument;
    }

    final DataObject getDataObjectHack() {
        return this.obj;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class DataNodeListener
    extends NodeAdapter {
        CloneableEditor editor;

        DataNodeListener(CloneableEditor cloneableEditor) {
            this.editor = cloneableEditor;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                DataEditorSupport.this.updateTitles();
            }
            if ("icon".equals(propertyChangeEvent.getPropertyName()) && DataEditorSupport.this.obj.isValid()) {
                this.editor.setIcon(DataEditorSupport.this.obj.getNodeDelegate().getIcon(1));
            }
        }
    }

    private static final class EnvListener
    extends FileChangeAdapter {
        private Reference env;

        public EnvListener(Env env) {
            this.env = new WeakReference<Env>(env);
        }

        public void fileChanged(FileEvent fileEvent) {
            Env env = (Env)this.env.get();
            if (env == null || env.getFileImpl() != fileEvent.getFile()) {
                fileEvent.getFile().removeFileChangeListener(this);
                return;
            }
            if (fileEvent.getFile().isVirtual()) {
                fileEvent.getFile().removeFileChangeListener(this);
                env.fileRemoved();
                fileEvent.getFile().addFileChangeListener(this);
            } else {
                env.fileChanged(fileEvent.isExpected(), fileEvent.getTime());
            }
        }
    }

    public static abstract class Env
    extends OpenSupport.Env
    implements CloneableEditorSupport.Env,
    Serializable,
    PropertyChangeListener,
    VetoableChangeListener {
        static final long serialVersionUID = -2945098431098324441L;
        private transient FileObject fileObject;
        private transient FileLock fileLock;

        public Env(DataObject dataObject) {
            super(dataObject);
        }

        private FileObject getFileImpl() {
            this.changeFile();
            return this.fileObject;
        }

        protected abstract FileObject getFile();

        protected abstract FileLock takeLock() throws IOException;

        protected final void changeFile() {
            boolean bl;
            FileObject fileObject = this.getFile();
            if (fileObject.equals(this.fileObject)) {
                return;
            }
            if (this.fileLock != null) {
                this.fileLock.releaseLock();
                bl = true;
            } else {
                bl = false;
            }
            this.fileObject = fileObject;
            this.fileObject.addFileChangeListener(new EnvListener(this));
            if (bl) {
                try {
                    this.fileLock = this.takeLock();
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify(1, iOException);
                }
            }
        }

        public InputStream inputStream() throws IOException {
            InputStream inputStream = this.getFileImpl().getInputStream();
            return inputStream;
        }

        public OutputStream outputStream() throws IOException {
            return this.getFileImpl().getOutputStream(this.fileLock);
        }

        public Date getTime() {
            return this.getFileImpl().lastModified();
        }

        public String getMimeType() {
            return this.getFileImpl().getMIMEType();
        }

        public void markModified() throws IOException {
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.takeLock();
            }
            this.getDataObject().setModified(true);
        }

        public void unmarkModified() {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.releaseLock();
            }
            this.getDataObject().setModified(false);
        }

        final void fileChanged(boolean bl, long l) {
            if (bl) {
                this.firePropertyChange("time", null, null);
            } else {
                this.firePropertyChange("time", null, new Date(l));
            }
        }

        private void fileRemoved() {
            try {
                this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }
    }
}

