/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.JComponent;
import org.openide.ErrorManager;
import org.openide.util.Utilities;

public final class HelpCtx {
    private static final ErrorManager err;
    public static final HelpCtx DEFAULT_HELP;
    private URL helpCtx;
    private String helpID;
    static /* synthetic */ Class class$org$openide$util$HelpCtx;

    public HelpCtx(URL uRL) {
        this.helpCtx = uRL;
    }

    public HelpCtx(String string) {
        this.helpID = string;
    }

    public HelpCtx(Class clazz) {
        this(clazz.getName());
    }

    public URL getHelp() {
        return this.helpCtx;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public int hashCode() {
        int n = (class$org$openide$util$HelpCtx == null ? (class$org$openide$util$HelpCtx = HelpCtx.class$("org.openide.util.HelpCtx")) : class$org$openide$util$HelpCtx).hashCode();
        if (this.helpCtx != null) {
            n ^= this.helpCtx.hashCode();
        }
        if (this.helpID != null) {
            n ^= this.helpID.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof HelpCtx)) {
            return false;
        }
        HelpCtx helpCtx = (HelpCtx)object;
        return Utilities.compareObjects(this.helpCtx, helpCtx.helpCtx) && Utilities.compareObjects(this.helpID, helpCtx.helpID);
    }

    public String toString() {
        return "org.openide.util.HelpCtx[helpID=" + this.helpID + ",helpCtx=" + this.helpCtx + "]";
    }

    public static void setHelpIDString(JComponent jComponent, String string) {
        if (err != null) {
            err.log("setHelpIDString: " + string + " on " + jComponent);
        }
        jComponent.putClientProperty("HelpID", string);
    }

    public static HelpCtx findHelp(Component component) {
        if (err != null) {
            err.log("findHelp on " + component);
        }
        while (component != null) {
            if (component instanceof JComponent) {
                Object object;
                JComponent jComponent = (JComponent)component;
                Object object2 = jComponent.getClientProperty("HelpIDMethod");
                if (object2 instanceof Method) {
                    object = (Method)object2;
                    try {
                        HelpCtx helpCtx = (HelpCtx)((Method)object).invoke((Object)jComponent, new Object[0]);
                        if (err != null) {
                            err.log("found help " + helpCtx + " by method call");
                        }
                        return helpCtx;
                    }
                    catch (Exception exception) {
                        IllegalStateException illegalStateException = new IllegalStateException("Cannot call method " + ((Method)object).getName() + " on " + jComponent.getClass());
                        ErrorManager errorManager = Utilities.errMan();
                        if (errorManager != null) {
                            errorManager.copyAnnotation(illegalStateException, exception);
                        } else {
                            exception.printStackTrace();
                        }
                        throw illegalStateException;
                    }
                }
                object = (String)jComponent.getClientProperty("HelpID");
                if (object != null) {
                    if (err != null) {
                        err.log("found help " + (String)object + " by client property");
                    }
                    return new HelpCtx((String)object);
                }
            }
            component = component.getParent();
            if (err == null) continue;
            err.log("no luck, trying parent " + component);
        }
        if (err != null) {
            err.log("nothing found");
        }
        return DEFAULT_HELP;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ErrorManager errorManager;
        ErrorManager errorManager2 = Utilities.errMan();
        err = errorManager2 != null ? ((errorManager = errorManager2.getInstance("org.netbeans.core.Help")).isLoggable(0) ? errorManager : null) : null;
        DEFAULT_HELP = new HelpCtx((class$org$openide$util$HelpCtx == null ? (class$org$openide$util$HelpCtx = HelpCtx.class$("org.openide.util.HelpCtx")) : class$org$openide$util$HelpCtx).getName() + ".DEFAULT_HELP");
    }
}

