/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RequestProcessor {
    private static RequestProcessor DEFAULT = new RequestProcessor();
    private static int processorCount = 0;
    private final TreeSet waiting = new TreeSet(new Cmp(true));
    private ProcessorThread thread;
    private int counter;
    private String name;
    static /* synthetic */ Class class$org$openide$util$RequestProcessor;

    public RequestProcessor() {
    }

    public RequestProcessor(String string) {
        this.name = string;
    }

    protected void finalize() {
        this.stop();
    }

    public Task post(Runnable runnable) {
        return this.post(runnable, 0, 1);
    }

    public Task post(Runnable runnable, int n) {
        return this.post(runnable, n, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task post(Runnable runnable, int n, int n2) {
        Task task = new Task(runnable, n, n2);
        TreeSet treeSet = this.waiting;
        synchronized (treeSet) {
            Holder holder = task.createHolder();
            this.waiting.add(holder);
            this.checkTimerQueue();
        }
        return task;
    }

    public Task create(Runnable runnable) {
        return new Task(runnable, 0L, 1);
    }

    public boolean isRequestProcessorThread() {
        return Thread.currentThread().equals(this.thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TreeSet treeSet = this.waiting;
        synchronized (treeSet) {
            if (this.thread != null) {
                this.thread.stopProcessing();
                this.thread = null;
            }
        }
    }

    public static Task postRequest(Runnable runnable) {
        return DEFAULT.post(runnable);
    }

    public static Task postRequest(Runnable runnable, int n) {
        return DEFAULT.post(runnable, n);
    }

    public static Task postRequest(Runnable runnable, int n, int n2) {
        return DEFAULT.post(runnable, n, n2);
    }

    public static Task createRequest(Runnable runnable) {
        return DEFAULT.create(runnable);
    }

    final void checkTimerQueue() {
        if (this.thread == null) {
            this.thread = new ProcessorThread(this.name, this.waiting);
            this.thread.start();
        } else {
            if (this.waiting.size() == 0) {
                return;
            }
            this.waiting.notify();
        }
    }

    final int incrementCounter() {
        if (this.counter != Integer.MAX_VALUE) {
            return ++this.counter;
        }
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                Holder holder = (Holder)object;
                Holder holder2 = (Holder)object2;
                return holder.count - holder2.count;
            }
        });
        treeSet.addAll(this.waiting);
        if (this.thread != null) {
            treeSet.addAll(this.thread.pending);
        }
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Holder holder = (Holder)iterator.next();
            holder.count = n++;
        }
        if (n == Integer.MAX_VALUE) {
            throw new IllegalStateException("Request processor is full of tasks > Integer.MAX_VALUE");
        }
        this.counter = n + 1;
        return this.counter;
    }

    static ThreadGroup getTopLevelThreadGroup() {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                while (threadGroup.getParent() != null) {
                    threadGroup = threadGroup.getParent();
                }
                return threadGroup;
            }
        };
        return (ThreadGroup)AccessController.doPrivileged(privilegedAction);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class Cmp
    implements Comparator {
        private boolean timeFirst;

        public Cmp(boolean bl) {
            this.timeFirst = bl;
        }

        public int compare(Object object, Object object2) {
            Holder holder = (Holder)object;
            Holder holder2 = (Holder)object2;
            int n = this.timeFirst ? Cmp.compareTimes(holder, holder2, true) : Cmp.comparePriorities(holder, holder2, true);
            return n;
        }

        private static int compareTimes(Holder holder, Holder holder2, boolean bl) {
            if (holder.time == holder2.time) {
                if (bl) {
                    return Cmp.comparePriorities(holder, holder2, false);
                }
                return holder.count - holder2.count;
            }
            if (holder.time > holder2.time) {
                return 1;
            }
            return -1;
        }

        private static int comparePriorities(Holder holder, Holder holder2, boolean bl) {
            if (holder.time == holder2.time) {
                if (bl) {
                    return Cmp.compareTimes(holder, holder2, false);
                }
                return holder.count - holder2.count;
            }
            if (holder.time > holder2.time) {
                return 1;
            }
            return -1;
        }
    }

    private static final class ProcessorThread
    extends Thread {
        private TreeSet pending = new TreeSet(new Cmp(false));
        private TreeSet waiting;
        private boolean stop;
        private int priority;

        public ProcessorThread(String string, TreeSet treeSet) {
            super(RequestProcessor.getTopLevelThreadGroup(), string == null ? "OpenIDE Request Processor-" + processorCount++ : string);
            this.setDaemon(true);
            this.priority = this.getPriority();
            this.waiting = treeSet;
        }

        public void stopProcessing() {
            this.stop = true;
            this.interrupt();
        }

        private long waitingToPending() {
            if (this.waiting.isEmpty()) {
                return 0L;
            }
            Iterator iterator = this.waiting.iterator();
            while (iterator.hasNext()) {
                Holder holder = (Holder)iterator.next();
                if (holder.task == null) {
                    iterator.remove();
                    continue;
                }
                long l = holder.time - System.currentTimeMillis();
                if (l > 0L) {
                    return l;
                }
                iterator.remove();
                this.pending.add(holder);
            }
            return 0L;
        }

        private Object synch() {
            return this.waiting;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = this.getPriority();
            while (!this.stop) {
                Task task;
                Holder holder;
                Object object = this.synch();
                synchronized (object) {
                    Iterator iterator;
                    while (true) {
                        holder = null;
                        task = null;
                        iterator = null;
                        long l = this.waitingToPending();
                        if (!this.pending.isEmpty()) break;
                        try {
                            this.synch().wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.stop) {
                                return;
                            }
                            throw new InternalError();
                        }
                    }
                    iterator = this.pending.iterator();
                    holder = (Holder)iterator.next();
                    iterator.remove();
                    task = holder.task;
                    if (task == null) {
                        continue;
                    }
                    task.holder = null;
                }
                int n2 = task.getPriority();
                if (n != n2) {
                    n = n2;
                    this.setPriority(n);
                }
                try {
                    task.run();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    ErrorManager errorManager = Utilities.errMan();
                    if (errorManager != null) {
                        errorManager.annotate((Throwable)holder, throwable);
                        errorManager.annotate((Throwable)holder, NbBundle.getMessage(class$org$openide$util$RequestProcessor == null ? RequestProcessor.class$("org.openide.util.RequestProcessor") : class$org$openide$util$RequestProcessor, "EXC_IN_REQUEST_PROCESSOR"));
                        errorManager.notify(holder);
                    } else {
                        throwable.printStackTrace();
                    }
                    Object var8_8 = null;
                }
            }
        }
    }

    public final class Task
    extends org.openide.util.Task {
        long time;
        int priority;
        Holder holder;

        Task(Runnable runnable, long l, int n) {
            super(runnable);
            this.time = System.currentTimeMillis() + l;
            this.priority = n;
        }

        Holder createHolder() {
            if (this.holder != null) {
                this.holder.task = null;
            }
            this.holder = new Holder(this, RequestProcessor.this.incrementCounter());
            return this.holder;
        }

        public int getDelay() {
            long l = this.time - System.currentTimeMillis();
            if (l < 0L) {
                return 0;
            }
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(int n) {
            TreeSet treeSet = RequestProcessor.this.waiting;
            synchronized (treeSet) {
                this.time = System.currentTimeMillis() + (long)n;
                RequestProcessor.this.waiting.add(this.createHolder());
                RequestProcessor.this.checkTimerQueue();
                this.setFinished(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            TreeSet treeSet = RequestProcessor.this.waiting;
            synchronized (treeSet) {
                block4: {
                    if (this.holder == null) break block4;
                    this.holder.task = null;
                    this.holder = null;
                    this.notifyFinished();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPriority(int n) {
            if (this.priority != n) {
                if (n < 1) {
                    n = 1;
                }
                if (n > 10) {
                    n = 10;
                }
                TreeSet treeSet = RequestProcessor.this.waiting;
                synchronized (treeSet) {
                    this.priority = n;
                    if (this.holder != null) {
                        RequestProcessor.this.waiting.add(this.createHolder());
                        RequestProcessor.this.checkTimerQueue();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFinished() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean bl = false;
                TreeSet treeSet = RequestProcessor.this.waiting;
                synchronized (treeSet) {
                    if (this.holder != null) {
                        this.holder.task = null;
                        this.holder = null;
                        bl = true;
                    }
                }
                if (bl) {
                    this.run();
                }
            } else {
                super.waitFinished();
            }
        }

        final String toString(long l) {
            Holder holder = this.holder;
            int n = holder == null ? -1 : holder.count;
            return super.toString() + " [" + (this.time - l) + ", " + this.priority + ", " + n + ']';
        }

        public String toString() {
            return this.toString(System.currentTimeMillis());
        }
    }

    private static final class Holder
    extends Exception {
        private static final boolean FAST = Boolean.getBoolean("org.openide.util.RequestProcessor.Holder.FAST");
        public Task task;
        public int priority;
        public long time;
        public int count;

        public Holder(Task task, int n) {
            super("Posted StackTrace");
            this.task = task;
            this.priority = task.priority;
            this.time = task.time;
            this.count = n;
        }

        final String toString(long l) {
            Task task = this.task;
            return super.toString() + "(" + (task == null ? "null" : task.toString(l)) + ")";
        }

        public String toString() {
            return this.toString(System.currentTimeMillis());
        }

        public Throwable fillInStackTrace() {
            if (FAST) {
                return this;
            }
            return super.fillInStackTrace();
        }
    }
}

