/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.openide.ErrorManager;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

public final class NbMarshalledObject
implements Serializable {
    private byte[] objBytes = null;
    private int hash;
    private static final long serialVersionUID = 7842398740921434354L;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public NbMarshalledObject(Object object) throws IOException {
        if (object == null) {
            this.hash = 17;
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        NbObjectOutputStream nbObjectOutputStream = new NbObjectOutputStream(byteArrayOutputStream);
        nbObjectOutputStream.writeObject(object);
        nbObjectOutputStream.flush();
        this.objBytes = byteArrayOutputStream.toByteArray();
        int n = 0;
        int n2 = 0;
        while (n2 < this.objBytes.length) {
            n = 37 * n + this.objBytes[n2];
            ++n2;
        }
        this.hash = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get() throws IOException, ClassNotFoundException {
        Object object;
        NbObjectInputStream nbObjectInputStream;
        block8: {
            if (this.objBytes == null) {
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.objBytes);
            nbObjectInputStream = new NbObjectInputStream(byteArrayInputStream);
            try {
                int n;
                StringBuffer stringBuffer;
                IOException iOException;
                try {
                    object = nbObjectInputStream.readObject();
                    Object var9_5 = null;
                    break block8;
                }
                catch (RuntimeException runtimeException) {
                    iOException = new IOException(runtimeException.toString());
                    stringBuffer = new StringBuffer(this.objBytes.length * 2 + 20);
                    stringBuffer.append("Bad ser data: ");
                    n = 0;
                }
                while (true) {
                    if (n >= this.objBytes.length) {
                        ErrorManager errorManager = NbObjectOutputStream.errMan();
                        if (errorManager == null) break;
                        errorManager.annotate(iOException, 0, stringBuffer.toString(), null, runtimeException, null);
                        throw iOException;
                    }
                    int n2 = this.objBytes[n];
                    if (n2 < 0) {
                        n2 += 256;
                    }
                    stringBuffer.append(HEX[n2 / 16]);
                    stringBuffer.append(HEX[n2 % 16]);
                    ++n;
                }
                System.err.println(stringBuffer.toString());
                runtimeException.printStackTrace();
                throw iOException;
            }
            catch (Throwable throwable) {
                Object var9_6 = null;
                nbObjectInputStream.close();
                throw throwable;
            }
        }
        nbObjectInputStream.close();
        return object;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof NbMarshalledObject) {
            NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)object;
            return Arrays.equals(this.objBytes, nbMarshalledObject.objBytes);
        }
        return false;
    }
}

