/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationTargetException;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.io.NbObjectOutputStream;
import org.openide.util.io.SafeException;

public class NbObjectInputStream
extends ObjectInputStream {
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public NbObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        try {
            this.enableResolveObject(true);
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = NbObjectInputStream.getNBClassLoader();
        try {
            return Class.forName(Utilities.translate(objectStreamClass.getName()), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "Offending classloader: " + classLoader;
            ErrorManager errorManager = NbObjectOutputStream.errMan();
            if (errorManager != null) {
                errorManager.annotate(classNotFoundException, 1, string, null, null, null);
            } else {
                System.err.println(string);
            }
            throw classNotFoundException;
        }
    }

    private static ClassLoader getNBClassLoader() {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = NbObjectInputStream.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        return classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass objectStreamClass = super.readClassDescriptor();
        if (objectStreamClass.getSerialVersionUID() == -1490768532464888185L && "org.netbeans.modules.text.TXTEditorSupport$Environment".equals(objectStreamClass.getName()) || objectStreamClass.getSerialVersionUID() == -8722179556833610258L && "org.netbeans.modules.image.ImageOpenSupport$Environment".equals(objectStreamClass.getName())) {
            ClassLoader classLoader = NbObjectInputStream.getNBClassLoader();
            Class<?> clazz = Class.forName(Utilities.translate(objectStreamClass.getName()), false, classLoader);
            ObjectStreamClass objectStreamClass2 = ObjectStreamClass.lookup(clazz);
            return objectStreamClass2;
        }
        return objectStreamClass;
    }

    public static Object readSafely(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        byte[] byArray = new byte[n];
        objectInput.readFully(byArray, 0, n);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            NbObjectInputStream nbObjectInputStream = new NbObjectInputStream(byteArrayInputStream);
            Object object = nbObjectInputStream.readObject();
            byteArrayInputStream.close();
            return object;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                throw new SafeException((Exception)throwable);
            }
            throw new SafeException(new InvocationTargetException(throwable));
        }
    }

    public static void skipSafely(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        objectInput.skip(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

