/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.lookup.InheritanceTree;
import org.openide.util.lookup.WaitableResult;

public class AbstractLookup
extends Lookup {
    private Content treeLock;
    private InheritanceTree tree;
    private Map reg;
    private int count;

    public AbstractLookup(Content content) {
        this.treeLock = content;
        content.attach(this);
    }

    protected AbstractLookup() {
        this(new Content());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InheritanceTree getTree() {
        if (this.tree != null) {
            return this.tree;
        }
        Content content = this.treeLock;
        synchronized (content) {
            if (this.tree == null) {
                this.tree = new InheritanceTree();
                this.initialize();
            }
        }
        return this.tree;
    }

    protected void initialize() {
        this.treeLock.initialize();
    }

    protected void beforeLookup(Lookup.Template template) {
        this.treeLock.beforeLookup(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addPair(Pair pair) {
        HashSet hashSet = new HashSet();
        InheritanceTree inheritanceTree = this.getTree();
        AbstractLookup abstractLookup = this;
        synchronized (abstractLookup) {
            ArrayList arrayList = new ArrayList();
            if (inheritanceTree.add(pair, arrayList)) {
                this.collectListenersForList(hashSet, arrayList);
                pair.index = this.count++;
            }
        }
        AbstractLookup.notifyListeners(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removePair(Pair pair) {
        HashSet hashSet;
        AbstractLookup abstractLookup = this;
        synchronized (abstractLookup) {
            if (this.tree == null) {
                return;
            }
            hashSet = new HashSet();
            ArrayList arrayList = new ArrayList();
            this.tree.remove(pair, arrayList);
            this.collectListenersForList(hashSet, arrayList);
        }
        AbstractLookup.notifyListeners(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setPairs(Collection collection) {
        HashSet hashSet = new HashSet(27);
        InheritanceTree inheritanceTree = this.getTree();
        AbstractLookup abstractLookup = this;
        synchronized (abstractLookup) {
            Object object;
            HashMap<Object, Info> hashMap = new HashMap<Object, Info>(collection.size() * 2);
            this.count = 0;
            Iterator iterator = collection.iterator();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                object = (Pair)iterator.next();
                if (inheritanceTree.add((Pair)object, arrayList)) {
                    this.collectListenersForList(hashSet, arrayList);
                }
                hashMap.put(object, new Info(this.count++, arrayList));
                arrayList.clear();
            }
            object = new ArrayList(27);
            inheritanceTree.retainAll(hashMap, (Collection)object);
            this.collectListenersForList(hashSet, (ArrayList)object);
        }
        AbstractLookup.notifyListeners(hashSet);
    }

    public final Object lookup(Class clazz) {
        Lookup.Item item = this.lookupItem(new Lookup.Template(clazz));
        return item == null ? null : item.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Lookup.Item lookupItem(Lookup.Template template) {
        this.beforeLookup(template);
        InheritanceTree inheritanceTree = this.getTree();
        AbstractLookup abstractLookup = this;
        synchronized (abstractLookup) {
            Enumeration enumeration = inheritanceTree.lookup(template.getType());
            while (enumeration.hasMoreElements()) {
                Pair pair = (Pair)enumeration.nextElement();
                if (!AbstractLookup.matches(template, pair)) continue;
                return pair;
            }
            return null;
        }
    }

    public final synchronized Lookup.Result lookup(Lookup.Template template) {
        LinkedList<WeakReference<R>> linkedList;
        R r = new R(template);
        if (this.reg == null) {
            this.reg = new HashMap(11);
        }
        if ((linkedList = (LinkedList<WeakReference<R>>)this.reg.get(template.getType())) == null) {
            linkedList = new LinkedList<WeakReference<R>>();
            this.reg.put(template.getType(), linkedList);
        }
        linkedList.add(new WeakReference<R>(r));
        return r;
    }

    private void collectListenersForList(HashSet hashSet, ArrayList arrayList) {
        if (arrayList.size() == 1) {
            this.collectListeners(hashSet, (Class)arrayList.get(0));
        } else {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.collectListeners(hashSet, (Class)iterator.next());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void collectListeners(HashSet var1_1, Class var2_2) {
        if (this.reg != null) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = (List)this.reg.get(var2_2);
            if (var3_3 != null && !var3_3.isEmpty()) {
                var4_4 = var3_3.iterator();
                while (var4_4.hasNext()) {
                    var5_5 = (Reference)var4_4.next();
                    var6_6 = (R)var5_5.get();
                    if (var6_6 == null) {
                        var4_4.remove();
                        continue;
                    }
                    var1_1.add(var6_6);
                }
            }
            var2_2 = var2_2.getSuperclass();
lbl16:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl17:
        // 1 sources

    }

    private static void notifyListeners(HashSet hashSet) {
        if (hashSet.isEmpty()) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            R r = (R)iterator.next();
            r.fireStateChanged();
        }
    }

    private static boolean matches(Lookup.Template template, Pair pair) {
        String string = template.getId();
        if (string != null && !pair.getId().equals(string)) {
            return false;
        }
        Object object = template.getInstance();
        return object == null || pair.creatorOf(object);
    }

    static final class Info {
        public int index;
        public ArrayList modified;

        public Info(int n, ArrayList arrayList) {
            this.index = n;
            this.modified = (ArrayList)arrayList.clone();
        }
    }

    public static class Content {
        private AbstractLookup al = null;
        private ArrayList earlyPairs = new ArrayList(3);

        final synchronized void attach(AbstractLookup abstractLookup) {
            if (this.al == null) {
                this.al = abstractLookup;
                Pair[] pairArray = this.earlyPairs.toArray(new Pair[this.earlyPairs.size()]);
                int n = 0;
                while (n < pairArray.length) {
                    this.addPair(pairArray[n]);
                    ++n;
                }
            } else {
                throw new IllegalStateException("Trying to use content for " + abstractLookup + " but it is already used for " + this.al);
            }
            this.earlyPairs = null;
        }

        public final void addPair(Pair pair) {
            AbstractLookup abstractLookup = this.al;
            if (abstractLookup != null) {
                abstractLookup.addPair(pair);
            } else {
                this.earlyPairs.add(pair);
            }
        }

        public final void removePair(Pair pair) {
            AbstractLookup abstractLookup = this.al;
            if (abstractLookup != null) {
                abstractLookup.removePair(pair);
            } else {
                this.earlyPairs.remove(pair);
            }
        }

        public final void setPairs(Collection collection) {
            AbstractLookup abstractLookup = this.al;
            if (abstractLookup != null) {
                abstractLookup.setPairs(collection);
            } else {
                this.earlyPairs.clear();
                this.earlyPairs.addAll(collection);
            }
        }

        void initialize() {
        }

        void beforeLookup(Lookup.Template template) {
        }
    }

    private final class R
    extends WaitableResult
    implements Comparator {
        private Lookup.Template template;
        private Set classesCache;
        private Collection instancesCache;
        private Collection itemsCache;
        private ArrayList listeners;

        R(Lookup.Template template) {
            this.template = template;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireStateChanged() {
            Object[] objectArray;
            Object[] objectArray2;
            Collection collection = this.itemsCache;
            this.classesCache = null;
            this.instancesCache = null;
            this.itemsCache = null;
            if (collection != null && Utilities.compareObjects(objectArray2 = collection.toArray(), objectArray = this.allItems().toArray())) {
                return;
            }
            objectArray = this;
            synchronized (objectArray) {
                if (this.listeners == null) {
                    return;
                }
                objectArray2 = this.listeners.toArray(new LookupListener[this.listeners.size()]);
            }
            LookupEvent lookupEvent = new LookupEvent((Lookup.Result)this);
            int n = 0;
            while (n < objectArray2.length) {
                objectArray2[n].resultChanged(lookupEvent);
                ++n;
            }
        }

        public synchronized void addLookupListener(LookupListener lookupListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(lookupListener);
        }

        public synchronized void removeLookupListener(LookupListener lookupListener) {
            this.listeners.remove(lookupListener);
        }

        public Collection allInstances() {
            ArrayList<Object> arrayList = this.instancesCache;
            if (arrayList != null) {
                return arrayList;
            }
            arrayList = new ArrayList<Object>(this.allItems().size());
            Iterator iterator = this.allItems().iterator();
            while (iterator.hasNext()) {
                Lookup.Item item = (Lookup.Item)iterator.next();
                Object object = item.getInstance();
                if (object == null) continue;
                arrayList.add(object);
            }
            this.instancesCache = arrayList;
            return arrayList;
        }

        public Set allClasses() {
            HashSet<Class> hashSet = this.classesCache;
            if (hashSet != null) {
                return hashSet;
            }
            hashSet = new HashSet<Class>();
            Iterator iterator = this.allItems().iterator();
            while (iterator.hasNext()) {
                Lookup.Item item = (Lookup.Item)iterator.next();
                Class clazz = item.getType();
                if (clazz == null) continue;
                hashSet.add(clazz);
            }
            this.classesCache = hashSet;
            return hashSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection allItems() {
            AbstractLookup.this.beforeLookup(this.template);
            if (this.itemsCache != null) {
                return this.itemsCache;
            }
            InheritanceTree inheritanceTree = AbstractLookup.this.getTree();
            AbstractLookup abstractLookup = AbstractLookup.this;
            synchronized (abstractLookup) {
                Object object;
                Enumeration enumeration = inheritanceTree.lookup(this.template.getType());
                TreeSet<Object> treeSet = new TreeSet<Object>(this);
                while (enumeration.hasMoreElements()) {
                    object = (Pair)enumeration.nextElement();
                    if (!AbstractLookup.matches(this.template, (Pair)object)) continue;
                    treeSet.add(object);
                }
                this.itemsCache = treeSet;
                object = treeSet;
                return object;
            }
        }

        public int compare(Object object, Object object2) {
            Pair pair = (Pair)object;
            Pair pair2 = (Pair)object2;
            int n = pair.index - pair2.index;
            if (n == 0) {
                if (pair != pair2) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(byteArrayOutputStream);
                    printStream.println("Please report this exception as issue http://www.netbeans.org/issues/show_bug.cgi?id=13779 Pair1: " + pair + " pair2: " + pair2 + " index1: " + pair.index + " index2: " + pair2.index + " item1: " + pair.getInstance() + " item2: " + pair2.getInstance() + " id1: " + Integer.toHexString(System.identityHashCode(pair)) + " id2: " + Integer.toHexString(System.identityHashCode(pair2)));
                    AbstractLookup.this.tree.print(printStream, false);
                    printStream.close();
                    throw new IllegalStateException(byteArrayOutputStream.toString());
                }
                return 0;
            }
            return n;
        }

        protected void beforeLookup(Lookup.Template template) {
            if (template.getType() == this.template.getType()) {
                AbstractLookup.this.beforeLookup(template);
            }
        }
    }

    public static abstract class Pair
    extends Lookup.Item {
        int index = -1;

        protected Pair() {
        }

        protected abstract boolean instanceOf(Class var1);

        protected abstract boolean creatorOf(Object var1);
    }
}

