/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.rmi;

import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.rmi.RMIDWrapper;
import org.netbeans.rmi.UnknownRMIDException;
import sun.rmi.server.ActivatableRef;
import sun.rmi.server.Activation;
import sun.rmi.transport.Target;

public class RMIDWrapperImpl
extends UnicastRemoteObject
implements RMIDWrapper,
Runnable {
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.rmi.test");
    private static final boolean exception = Boolean.getBoolean("netbeans.debug.exceptions");
    private static ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/rmi/Bundle");
    private Registry registry = null;
    private ActivationSystem system = null;
    public static final long MAX_REGISTRY_TIMEOUT = 1024000L;
    static /* synthetic */ Class class$java$rmi$registry$Registry;
    static /* synthetic */ Class class$java$rmi$activation$ActivationSystem;
    static /* synthetic */ Class class$sun$rmi$transport$ObjectTable;
    static /* synthetic */ Class class$sun$rmi$transport$Target;
    static /* synthetic */ Class class$java$rmi$activation$ActivationMonitor;

    private RMIDWrapperImpl() throws RemoteException {
    }

    static void argsToString(String[] stringArray) {
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            System.out.print('[' + stringArray[n] + "] ");
            ++n;
        }
        System.out.println("\nEnd of argument list.");
    }

    public static void main(String[] stringArray) {
        try {
            System.setSecurityManager(new RMISecurityManager());
            Thread thread = new Thread(new RMIDWrapperImpl());
            thread.setDaemon(true);
            thread.start();
        }
        catch (RemoteException remoteException) {
            System.err.println(bundle.getString("MSG_RMIDWrapperImpl.UnableStart"));
            if (exception) {
                remoteException.printStackTrace();
            }
            System.exit(1);
        }
        Activation.main((String[])stringArray);
    }

    public void run() {
        this.initService();
    }

    private void initService() {
        long l = 1000L;
        do {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.registry = (Registry)this.findObjectTableTarget(class$java$rmi$registry$Registry == null ? (class$java$rmi$registry$Registry = RMIDWrapperImpl.class$("java.rmi.registry.Registry")) : class$java$rmi$registry$Registry);
                this.registry.bind("org.netbeans.rmi.RMIDWrapper", this);
                return;
            }
            catch (AlreadyBoundException alreadyBoundException) {
                return;
            }
            catch (AccessException accessException) {
                if (exception) {
                    accessException.printStackTrace();
                }
                return;
            }
            catch (RemoteException remoteException) {
                if (!exception) continue;
                remoteException.printStackTrace();
            }
            catch (UnknownRMIDException unknownRMIDException) {
                if (!exception) continue;
                unknownRMIDException.printStackTrace();
            }
        } while ((l <<= 1) <= 1024000L);
    }

    private ActivationSystem getSystem() throws ActivationException {
        if (this.system == null) {
            try {
                this.system = (ActivationSystem)this.registry.lookup("java.rmi.activation.ActivationSystem");
            }
            catch (Exception exception) {
                throw new ActivationException("ActivationSystem not running", (Throwable)exception);
            }
        }
        return this.system;
    }

    public ActivationID[] getActivationIDs() throws RemoteException, UnknownRMIDException {
        try {
            Object object = this.findObjectTableTarget(class$java$rmi$activation$ActivationSystem == null ? (class$java$rmi$activation$ActivationSystem = RMIDWrapperImpl.class$("java.rmi.activation.ActivationSystem")) : class$java$rmi$activation$ActivationSystem);
            Field field = object.getClass().getDeclaredField("this$0");
            ((AccessibleObject)field).setAccessible(true);
            object = field.get(object);
            field = object.getClass().getDeclaredField("idTable");
            ((AccessibleObject)field).setAccessible(true);
            Hashtable hashtable = (Hashtable)field.get(object);
            Set set = hashtable.keySet();
            return set.toArray(new ActivationID[set.size()]);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (exception) {
                illegalAccessException.printStackTrace();
            }
            throw new UnknownRMIDException(illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (exception) {
                noSuchFieldException.printStackTrace();
            }
            throw new UnknownRMIDException(noSuchFieldException);
        }
        catch (NullPointerException nullPointerException) {
            if (exception) {
                nullPointerException.printStackTrace();
            }
            throw new UnknownRMIDException(nullPointerException);
        }
    }

    public ActivationGroupID[] getActivationGroupIDs() throws RemoteException, UnknownRMIDException {
        try {
            Object object = this.findObjectTableTarget(class$java$rmi$activation$ActivationSystem == null ? (class$java$rmi$activation$ActivationSystem = RMIDWrapperImpl.class$("java.rmi.activation.ActivationSystem")) : class$java$rmi$activation$ActivationSystem);
            Field field = object.getClass().getDeclaredField("this$0");
            ((AccessibleObject)field).setAccessible(true);
            object = field.get(object);
            field = object.getClass().getDeclaredField("groupTable");
            ((AccessibleObject)field).setAccessible(true);
            Hashtable hashtable = (Hashtable)field.get(object);
            Set set = hashtable.keySet();
            return set.toArray(new ActivationGroupID[set.size()]);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (exception) {
                illegalAccessException.printStackTrace();
            }
            throw new UnknownRMIDException(illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (exception) {
                noSuchFieldException.printStackTrace();
            }
            throw new UnknownRMIDException(noSuchFieldException);
        }
        catch (NullPointerException nullPointerException) {
            if (exception) {
                nullPointerException.printStackTrace();
            }
            throw new UnknownRMIDException(nullPointerException);
        }
    }

    private Object findObjectTableTarget(Class clazz) throws UnknownRMIDException {
        block10: {
            try {
                Field field = (class$sun$rmi$transport$ObjectTable == null ? (class$sun$rmi$transport$ObjectTable = RMIDWrapperImpl.class$("sun.rmi.transport.ObjectTable")) : class$sun$rmi$transport$ObjectTable).getDeclaredField("objTable");
                ((AccessibleObject)field).setAccessible(true);
                Object object = field.get(null);
                if (!(object instanceof Map)) {
                    throw new UnknownRMIDException();
                }
                Map map = (Map)object;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object v = entry.getValue();
                    if (!(v instanceof Target)) {
                        throw new UnknownRMIDException();
                    }
                    field = (class$sun$rmi$transport$Target == null ? RMIDWrapperImpl.class$("sun.rmi.transport.Target") : class$sun$rmi$transport$Target).getDeclaredField("weakImpl");
                    ((AccessibleObject)field).setAccessible(true);
                    object = field.get(v);
                    if (!(object instanceof WeakReference)) {
                        throw new UnknownRMIDException();
                    }
                    WeakReference weakReference = (WeakReference)object;
                    Object t = weakReference.get();
                    if (!clazz.isInstance(t)) continue;
                    return t;
                }
            }
            catch (NullPointerException nullPointerException) {
                if (exception) {
                    nullPointerException.printStackTrace();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (exception) {
                    illegalAccessException.printStackTrace();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!exception) break block10;
                noSuchFieldException.printStackTrace();
            }
        }
        throw new UnknownRMIDException();
    }

    public ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException, UnknownObjectException, UnknownGroupException, RemoteException {
        return this.getSystem().setActivationDesc(activationID, activationDesc);
    }

    public ActivationID registerObject(ActivationDesc activationDesc) throws ActivationException, UnknownGroupException, RemoteException {
        return this.getSystem().registerObject(activationDesc);
    }

    public ActivationMonitor activeGroup(ActivationGroupID activationGroupID, ActivationInstantiator activationInstantiator, long l) throws UnknownGroupException, ActivationException, RemoteException {
        return this.getSystem().activeGroup(activationGroupID, activationInstantiator, l);
    }

    public void shutdown() throws RemoteException {
        try {
            Thread thread;
            final ActivationSystem activationSystem = this.getSystem();
            final RMIDWrapperImpl rMIDWrapperImpl = this;
            Thread thread2 = thread = new Thread(){

                public synchronized void run() {
                    try {
                        RMIDWrapperImpl.this.unexport(rMIDWrapperImpl);
                        activationSystem.shutdown();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            };
            synchronized (thread2) {
                thread.start();
                return;
            }
        }
        catch (ActivationException activationException) {
            throw new RemoteException(null, activationException);
        }
    }

    public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
        return this.getSystem().getActivationGroupDesc(activationGroupID);
    }

    public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) throws ActivationException, UnknownGroupException, RemoteException {
        return this.getSystem().setActivationGroupDesc(activationGroupID, activationGroupDesc);
    }

    public ActivationDesc getActivationDesc(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        return this.getSystem().getActivationDesc(activationID);
    }

    public ActivationGroupID registerGroup(ActivationGroupDesc activationGroupDesc) throws ActivationException, RemoteException {
        return this.getSystem().registerGroup(activationGroupDesc);
    }

    public void unregisterObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        this.getSystem().unregisterObject(activationID);
    }

    public void unregisterGroup(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
        this.getSystem().unregisterGroup(activationGroupID);
    }

    private void unexport(Remote remote) {
        while (true) {
            try {
                while (!UnicastRemoteObject.unexportObject(remote, false)) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        if (debug) {
            System.err.println("RMIDWrapperImpl unexported");
        }
    }

    public Remote getStub(ActivationID activationID) throws RemoteException, ActivationException, UnknownObjectException, StubNotFoundException {
        ActivationDesc activationDesc = this.getSystem().getActivationDesc(activationID);
        return ActivatableRef.getStub((ActivationDesc)activationDesc, (ActivationID)activationID);
    }

    public void rebind(ActivationID activationID, String string, int n) throws RemoteException, AccessException, MalformedURLException, ActivationException, UnknownObjectException, StubNotFoundException {
        Registry registry = LocateRegistry.getRegistry(n);
        registry.rebind(string, this.getStub(activationID));
    }

    public void inactivateObject(ActivationID activationID) throws RemoteException, UnknownObjectException, UnknownRMIDException {
        try {
            ActivationMonitor activationMonitor = (ActivationMonitor)this.findObjectTableTarget(class$java$rmi$activation$ActivationMonitor == null ? (class$java$rmi$activation$ActivationMonitor = RMIDWrapperImpl.class$("java.rmi.activation.ActivationMonitor")) : class$java$rmi$activation$ActivationMonitor);
            activationMonitor = (ActivationMonitor)RemoteObject.toStub((Remote)activationMonitor);
            activationMonitor.inactiveObject(activationID);
        }
        catch (NullPointerException nullPointerException) {
            if (exception) {
                nullPointerException.printStackTrace();
            }
            throw new UnknownRMIDException(nullPointerException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            if (exception) {
                noSuchObjectException.printStackTrace();
            }
            throw new UnknownRMIDException(noSuchObjectException);
        }
    }

    public void inactivateGroup(ActivationGroupID activationGroupID) throws RemoteException, UnknownGroupException, UnknownRMIDException {
        try {
            ActivationMonitor activationMonitor = (ActivationMonitor)this.findObjectTableTarget(class$java$rmi$activation$ActivationMonitor == null ? (class$java$rmi$activation$ActivationMonitor = RMIDWrapperImpl.class$("java.rmi.activation.ActivationMonitor")) : class$java$rmi$activation$ActivationMonitor);
            Field field = activationMonitor.getClass().getDeclaredField("this$0");
            ((AccessibleObject)field).setAccessible(true);
            Object object = field.get(activationMonitor);
            field = object.getClass().getDeclaredField("groupTable");
            ((AccessibleObject)field).setAccessible(true);
            Hashtable hashtable = (Hashtable)field.get(object);
            object = hashtable.get(activationGroupID);
            if (object == null) {
                throw new UnknownGroupException("unknown group: " + activationGroupID);
            }
            field = object.getClass().getDeclaredField("incarnation");
            ((AccessibleObject)field).setAccessible(true);
            long l = field.getLong(object);
            activationMonitor.inactiveGroup(activationGroupID, l);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (exception) {
                noSuchFieldException.printStackTrace();
            }
            throw new UnknownRMIDException(noSuchFieldException);
        }
        catch (NullPointerException nullPointerException) {
            if (exception) {
                nullPointerException.printStackTrace();
            }
            throw new UnknownRMIDException(nullPointerException);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (exception) {
                illegalAccessException.printStackTrace();
            }
            throw new UnknownRMIDException(illegalAccessException);
        }
    }

    private void findObjectTableTargets() throws UnknownRMIDException {
        try {
            Field field = (class$sun$rmi$transport$ObjectTable == null ? (class$sun$rmi$transport$ObjectTable = RMIDWrapperImpl.class$("sun.rmi.transport.ObjectTable")) : class$sun$rmi$transport$ObjectTable).getDeclaredField("objTable");
            ((AccessibleObject)field).setAccessible(true);
            Object object = field.get(null);
            if (!(object instanceof Map)) {
                throw new UnknownRMIDException();
            }
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object v = entry.getValue();
                if (!(v instanceof Target)) {
                    throw new UnknownRMIDException();
                }
                field = (class$sun$rmi$transport$Target == null ? RMIDWrapperImpl.class$("sun.rmi.transport.Target") : class$sun$rmi$transport$Target).getDeclaredField("weakImpl");
                ((AccessibleObject)field).setAccessible(true);
                object = field.get(v);
                if (!(object instanceof WeakReference)) {
                    throw new UnknownRMIDException();
                }
                WeakReference weakReference = (WeakReference)object;
                Object t = weakReference.get();
                System.err.println(t.getClass() + " : " + t.toString());
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        throw new UnknownRMIDException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

