/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.beans.FeatureDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.vcscore.VcsAction;
import org.netbeans.modules.vcscore.VcsActionSupporter;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheReference;
import org.netbeans.modules.vcscore.caching.FileCacheProvider;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.util.Table;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;

public class VcsAttributes
extends DefaultAttributes {
    public static final String FILE_ATTRIBUTE = "java.io.File";
    public static final String VCS_ACTION = "VCS_ACTION";
    public static final String VCS_REFRESH = "VCS_REFRESH";
    public static final String VCS_SCHEDULING_SECONDARY_FO_ACTION = "VCS_SCHEDULING_SECONDARY_FO_ACTION";
    public static final String VCS_SCHEDULING_ADD = "ADD";
    public static final String VCS_SCHEDULING_REMOVE = "REMOVE";
    public static final String VCS_SCHEDULED_FILES_ATTR = "VCS_SCHEDULED_FILES";
    public static final String VCS_SCHEDULED_FILE_ATTR = "VCS_SCHEDULED_FILE";
    public static final String VCS_SCHEDULING_MASTER_FILE_NAME_ATTR = "VCS_SCHEDULING_MASTER_FILE_NAME";
    public static final String VCS_ACTION_ADD = "VCS_ADD";
    public static final String VCS_ACTION_REMOVE = "VCS_REMOVE";
    public static final String VCS_ACTION_DONE = "VCS_ACTION_DONE";
    public static final String VCS_ACTION_DESCRIPTION = "VCS_ACTION_DESCRIPTION";
    public static String VCS_STATUS = "VCS_STATUS";
    public static String VCS_STATUS_LOCAL = "VCS_STATUS_LOCAL";
    public static String VCS_STATUS_MISSING = "VCS_STATUS_MISSING";
    public static String VCS_STATUS_UP_TO_DATE = "VCS_STATUS_UP_TO_DATE";
    public static String VCS_STATUS_UNKNOWN = "VCS_STATUS_UNKNOWN";
    private VcsActionSupporter supporter;
    private VcsFileSystem fileSystem;
    private static RequestProcessor vcsActionRequestProcessor;
    static final long serialVersionUID = 8084585278800267078L;
    private transient Map schedulingFilesByFolders;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader;

    public VcsAttributes(AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list, VcsFileSystem vcsFileSystem, VcsActionSupporter vcsActionSupporter) {
        super(info, change, list);
        this.fileSystem = vcsFileSystem;
        this.supporter = vcsActionSupporter;
    }

    public VcsActionSupporter getCurrentSupporter() {
        return this.supporter;
    }

    public void setCurrentSupporter(VcsActionSupporter vcsActionSupporter) {
        this.supporter = vcsActionSupporter;
    }

    public Object readAttribute(String string, String string2) {
        CacheReference cacheReference;
        if (FILE_ATTRIBUTE.equals(string2)) {
            return this.fileSystem.getFile(string);
        }
        if (VCS_STATUS.equals(string2)) {
            if (!this.fileSystem.getFile(string).exists()) {
                return VCS_STATUS_MISSING;
            }
            FileStatusProvider fileStatusProvider = this.fileSystem.getStatusProvider();
            if (fileStatusProvider != null) {
                String string3 = fileStatusProvider.getFileStatus(string);
                if (fileStatusProvider.getLocalFileStatus().equals(string3)) {
                    return VCS_STATUS_LOCAL;
                }
                return VCS_STATUS_UP_TO_DATE;
            }
            return VCS_STATUS_UNKNOWN;
        }
        if ("VcsActionAttributeCookie".equals(string2)) {
            return this.supporter;
        }
        if ("NetBeansAttrAssignedLoader".equals(string2)) {
            CacheReference cacheReference2 = this.fileSystem.getCacheReference(string);
            if (cacheReference2 != null && cacheReference2.isVirtual()) {
                return (class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader == null ? (class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader = VcsAttributes.class$("org.netbeans.modules.vcscore.util.virtuals.VirtualsDataLoader")) : class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader).getName();
            }
        } else if ("NetBeansAttrAssignedLoaderModule".equals(string2) && (cacheReference = this.fileSystem.getCacheReference(string)) != null && cacheReference.isVirtual()) {
            return "org.netbeans.modules.vcscore";
        }
        return super.readAttribute(string, string2);
    }

    public void writeAttribute(final String string, String string2, final Object object) throws IOException, UnknownServiceException {
        if (VCS_ACTION.equals(string2) && object instanceof FeatureDescriptor) {
            this.performVcsAction(string, (FeatureDescriptor)object);
        } else if (VCS_REFRESH.equals(string2)) {
            this.performRefresh(string, object);
        } else if (VCS_SCHEDULING_SECONDARY_FO_ACTION.equals(string2) && object instanceof String) {
            FileObject fileObject;
            DataObject dataObject;
            final FileObject fileObject2 = this.fileSystem.findFileObject(string);
            if (fileObject2 == null) {
                return;
            }
            try {
                dataObject = DataObject.find((FileObject)fileObject2);
                fileObject = dataObject.getPrimaryFile();
                if (fileObject.equals(fileObject2)) {
                    return;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
                return;
            }
            this.startFileScheduling(string);
            dataObject = fileObject;
            RequestProcessor.postRequest((Runnable)new Runnable((FileObject)dataObject){
                private final /* synthetic */ FileObject val$primaryFO;
                {
                    this.val$primaryFO = fileObject22;
                }

                public void run() {
                    VcsAttributes.this.scheduleSecondaryFOVcsAction(string, (String)object, fileObject2, this.val$primaryFO);
                }
            });
            super.writeAttribute(string, VCS_SCHEDULED_FILE_ATTR, object);
        } else {
            if ("NetBeansAttrAssignedLoader".equals(string2)) {
                CacheReference cacheReference;
                if (object != null && "org.netbeans.modules.vcscore.util.virtuals.VirtualsDataLoader".equals(object.toString())) {
                    CacheReference cacheReference2 = this.fileSystem.getCacheReference(string);
                    if (cacheReference2 != null) {
                        cacheReference2.setVirtual(true);
                    }
                    return;
                }
                if (object == null && (cacheReference = this.fileSystem.getCacheReference(string)) != null) {
                    cacheReference.setVirtual(false);
                }
            }
            if ("NetBeansAttrAssignedLoaderModule".equals(string2) && object != null && "org.netbeans.modules.vcscore".equals(object.toString()) && this.fileSystem.checkVirtual(string)) {
                return;
            }
            super.writeAttribute(string, string2, object);
        }
    }

    private static synchronized RequestProcessor getVcsActionRequestProcessor() {
        if (vcsActionRequestProcessor == null) {
            vcsActionRequestProcessor = new RequestProcessor("Vcs Attribute Action Request Processor");
        }
        return vcsActionRequestProcessor;
    }

    private void performVcsAction(String string, final FeatureDescriptor featureDescriptor) throws UnknownServiceException {
        String string2 = featureDescriptor.getName();
        final VcsCommand vcsCommand = this.fileSystem.getCommand(string2);
        if (vcsCommand == null) {
            throw new UnknownServiceException(string2);
        }
        final Table table = new Table();
        table.put(string, this.fileSystem.findResource(string));
        final Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Enumeration<String> enumeration = featureDescriptor.attributeNames();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            hashtable.put(string3, featureDescriptor.getValue(string3));
        }
        VcsAttributes.getVcsActionRequestProcessor();
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                VcsCommandExecutor[] vcsCommandExecutorArray = VcsAction.doCommand(table, vcsCommand, hashtable, VcsAttributes.this.fileSystem);
                boolean bl = true;
                int n = 0;
                while (n < vcsCommandExecutorArray.length) {
                    try {
                        VcsAttributes.this.fileSystem.getCommandsPool().waitToFinish(vcsCommandExecutorArray[n]);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    bl &= vcsCommandExecutorArray[n].getExitStatus() == 0;
                    ++n;
                }
                featureDescriptor.setValue(VcsAttributes.VCS_ACTION_DONE, new Boolean(bl));
            }
        });
    }

    private void performRefresh(final String string, final Object object) {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                boolean bl = Boolean.TRUE.equals(object);
                FileCacheProvider fileCacheProvider = VcsAttributes.this.fileSystem.getCacheProvider();
                if (fileCacheProvider != null) {
                    if (bl) {
                        fileCacheProvider.refreshCacheDirRecursive(string);
                    } else {
                        fileCacheProvider.refreshCacheDir(string);
                    }
                }
            }
        });
    }

    private boolean scheduleSecondaryFOVcsAction(final String string, String string2, FileObject fileObject, FileObject fileObject2) {
        int n;
        if (VCS_STATUS_LOCAL.equals(fileObject2.getAttribute(VCS_STATUS))) {
            this.endFileScheduling(string);
            return false;
        }
        FeatureDescriptor featureDescriptor = new FeatureDescriptor(){

            public void setValue(String string2, Object object) {
                if (VcsAttributes.VCS_ACTION_DONE.equals(string2)) {
                    VcsAttributes.this.fileSystem.removeScheduledFileToBeProcessed(string);
                    VcsAttributes.this.endFileScheduling(string);
                }
                super.setValue(string2, object);
            }
        };
        boolean bl = false;
        if (VCS_SCHEDULING_ADD.equals(string2)) {
            featureDescriptor.setName("SCHEDULE_ADD");
            try {
                this.fileSystem.addScheduledFileToBeProcessed(string);
                this.performVcsAction(string, featureDescriptor);
            }
            catch (UnknownServiceException unknownServiceException) {
                this.fileSystem.removeScheduledFileToBeProcessed(string);
                bl = true;
            }
            n = 1;
        } else if (VCS_SCHEDULING_REMOVE.equals(string2)) {
            featureDescriptor.setName("SCHEDULE_REMOVE");
            try {
                this.fileSystem.addScheduledFileToBeProcessed(string);
                this.performVcsAction(string, featureDescriptor);
            }
            catch (UnknownServiceException unknownServiceException) {
                this.fileSystem.removeScheduledFileToBeProcessed(string);
                bl = true;
            }
            n = 0;
        } else {
            this.endFileScheduling(string);
            return false;
        }
        Set[] setArray = (Set[])fileObject2.getAttribute(VCS_SCHEDULED_FILES_ATTR);
        if (setArray == null) {
            setArray = new HashSet[2];
        }
        if (setArray[n] == null) {
            setArray[n] = new HashSet();
        }
        setArray[n].add(string);
        try {
            fileObject2.setAttribute(VCS_SCHEDULED_FILES_ATTR, (Object)setArray);
            File file = NbClassPath.toFile((FileObject)fileObject2);
            if (file != null) {
                fileObject2.setAttribute(VCS_SCHEDULING_MASTER_FILE_NAME_ATTR, (Object)file.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            if (bl) {
                this.endFileScheduling(string);
            }
            return false;
        }
        if (bl) {
            this.endFileScheduling(string);
        }
        return true;
    }

    private void startFileScheduling(String string) {
        VcsAttributes vcsAttributes = this;
        synchronized (vcsAttributes) {
            int n;
            String string2;
            if (this.schedulingFilesByFolders == null) {
                this.schedulingFilesByFolders = new HashMap();
            }
            String string3 = string2 = (n = string.lastIndexOf(47)) < 0 ? "" : string.substring(0, n);
            String string4 = n < 0 ? string : (n < string.length() - 1 ? string.substring(n + 1) : "");
            HashSet<String> hashSet = (HashSet<String>)this.schedulingFilesByFolders.get(string2);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(string4);
            this.schedulingFilesByFolders.put(string2, hashSet);
        }
    }

    private void endFileScheduling(String string) {
        Set set;
        String string2;
        VcsAttributes vcsAttributes = this;
        synchronized (vcsAttributes) {
            int n;
            if (this.schedulingFilesByFolders == null) {
                this.schedulingFilesByFolders = new HashMap();
            }
            String string3 = string2 = (n = string.lastIndexOf(47)) < 0 ? "" : string.substring(0, n);
            String string4 = n < 0 ? string : (n < string.length() - 1 ? string.substring(n + 1) : "");
            set = (Set)this.schedulingFilesByFolders.get(string2);
            if (set != null) {
                set.remove(string4);
                if (set.size() == 0) {
                    set = null;
                }
            }
            if (set == null) {
                this.schedulingFilesByFolders.remove(string2);
            }
        }
        if (set == null) {
            this.performRefresh(string2, Boolean.FALSE);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.supporter != null && this.supporter instanceof VcsActionSupporter) {
            this.supporter.setFileSystem(this.fileSystem);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

