/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheQueue;
import org.netbeans.modules.vcscore.cache.CacheReference;
import org.netbeans.modules.vcscore.cache.CachedFileSystem;
import org.netbeans.modules.vcscore.cache.FileSystemCache;

public class CacheHandler {
    public static final int STRAT_LOCAL = 0;
    public static final int STRAT_DISK = 3;
    public static final int STRAT_NONE = -1;
    public static final int STRAT_REFRESH = 11;
    public static final int STRAT_REFRESH_RECURS = 12;
    public static final int STRAT_REFRESHING = 10;
    public static final int STRAT_DISK_OR_REFRESH = 5;
    private static CacheHandler instance = null;
    private ArrayList listeners = new ArrayList();
    private HashMap cacheMap = new HashMap(5);
    private CacheQueue queue = new CacheQueue();

    private CacheHandler() {
        this.queue.start();
    }

    public static CacheHandler getInstance() {
        if (instance == null) {
            instance = new CacheHandler();
        }
        return instance;
    }

    private ReferenceQueue getRefQueue() {
        return this.queue.getQueue();
    }

    public Reference createReference(Object object, File file, String string) {
        CacheFile cacheFile = this.getCacheFile(file, -1, string);
        CacheReference cacheReference = new CacheReference(object, this.getRefQueue(), file, string);
        if (cacheFile != null) {
            cacheFile.addReference(cacheReference);
        }
        return cacheReference;
    }

    public CacheFile getCacheFile(File file, int n, CachedFileSystem cachedFileSystem) {
        return this.getCacheFile(file, n, cachedFileSystem.getCacheId());
    }

    public CacheFile getCacheFile(File file, int n, String string) {
        FileSystemCache fileSystemCache = this.getCache(string);
        if (fileSystemCache == null) {
            return null;
        }
        return fileSystemCache.getCacheFile(file, n);
    }

    public void registerCacheType(String string, FileSystemCache fileSystemCache) {
        this.cacheMap.put(string, fileSystemCache);
    }

    public void unregistedType(String string) {
        this.cacheMap.remove(string);
    }

    public FileSystemCache getCache(CachedFileSystem cachedFileSystem) {
        FileSystemCache fileSystemCache = (FileSystemCache)this.cacheMap.get(cachedFileSystem.getCacheId());
        return fileSystemCache;
    }

    public FileSystemCache getCache(String string) {
        FileSystemCache fileSystemCache = (FileSystemCache)this.cacheMap.get(string);
        return fileSystemCache;
    }

    public void uninstall() {
        if (this.cacheMap != null) {
            Iterator iterator = this.cacheMap.values().iterator();
            while (iterator.hasNext()) {
                FileSystemCache fileSystemCache = (FileSystemCache)iterator.next();
                fileSystemCache.removeAllListeners();
            }
            this.cacheMap.clear();
            this.cacheMap = null;
        }
        instance = null;
    }
}

