/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;
import org.openide.filesystems.FileObject;

public abstract class FileSystemCache {
    protected boolean isSaved = false;
    protected String identifier;
    private ArrayList listeners = new ArrayList();
    public static final int EVENT_ADD = 0;
    public static final int EVENT_REMOVE = 1;
    public static final int EVENT_CHANGED = 2;
    public static final int EVENT_CHANGED_RECURSIVELY = 3;
    public static final int EVENT_CHANGED_IGNORE_LIST = 4;
    private HashMap lockedFileObjects;
    private HashMap locks;

    public FileSystemCache(String string) {
        this.identifier = string;
        this.lockedFileObjects = new HashMap();
        this.locks = new HashMap();
    }

    public String getId() {
        return this.identifier;
    }

    public boolean isWrittenToDisk() {
        return this.isSaved;
    }

    public abstract void writeAllToDisk();

    public abstract CacheFile getCacheFile(File var1, int var2);

    public abstract void registerDir(CacheDir var1);

    public abstract void unregisterDir(CacheDir var1);

    public abstract CacheDir getDir(String var1);

    protected boolean doesStrategyApply(CacheDir cacheDir, int n, int n2) {
        if (cacheDir.getAppliedLevel() >= n2) {
            return false;
        }
        if (n < n2) {
            return false;
        }
        if (n <= cacheDir.getAppliedLevel()) {
            return false;
        }
        return n < 10 || n2 <= 0 || n == n2;
    }

    protected void loadDir(CacheDir cacheDir, int n) {
        if (cacheDir == null) {
            return;
        }
        if (n == 11 || n == 12) {
            boolean bl;
            cacheDir.setAppliedLevel(-1);
            boolean bl2 = bl = n == 12;
            if (bl) {
                cacheDir.removeAll(bl);
            } else {
                cacheDir.removeFiles();
            }
        }
        if (!cacheDir.isComplete() && n >= 0) {
            cacheDir.setAppliedLevel(-1);
        }
        if (this.doesStrategyApply(cacheDir, n, 0)) {
            cacheDir.populateWithLocal();
            cacheDir.setComplete(true);
        }
        if (cacheDir.isLocal()) {
            return;
        }
        if (this.doesStrategyApply(cacheDir, n, 3)) {
            if (!cacheDir.readFromDisk() && n == 5) {
                cacheDir.checkServer();
                cacheDir.setComplete(true);
            }
            cacheDir.setComplete(true);
        }
        if (this.doesStrategyApply(cacheDir, n, 11)) {
            cacheDir.checkServer();
            cacheDir.setComplete(true);
        }
        if (this.doesStrategyApply(cacheDir, n, 10)) {
            cacheDir.setComplete(true);
            cacheDir.setAppliedLevel(10);
        }
        if (this.doesStrategyApply(cacheDir, n, 12)) {
            cacheDir.checkServerRecursive();
            cacheDir.setComplete(true);
        }
    }

    public void addCacheHandlerListener(CacheHandlerListener cacheHandlerListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(cacheHandlerListener);
    }

    public void removeCacheHandlerListener(CacheHandlerListener cacheHandlerListener) {
        if (this.listeners != null) {
            ((AbstractCollection)this.listeners).remove(cacheHandlerListener);
        }
    }

    void removeAllListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public void fireCacheHandlerEvent(int n, CacheFile cacheFile) {
        CacheHandlerEvent cacheHandlerEvent = new CacheHandlerEvent(cacheFile, n == 3);
        this.fireCacheHandlerEvent(n, cacheHandlerEvent);
    }

    public void fireCacheHandlerEvent(int n, CacheHandlerEvent cacheHandlerEvent) {
        ArrayList arrayList;
        FileSystemCache fileSystemCache = this;
        synchronized (fileSystemCache) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            if (n == 2 || n == 3) {
                ((CacheHandlerListener)arrayList.get(n2)).statusChanged(cacheHandlerEvent);
            }
            if (n == 0) {
                ((CacheHandlerListener)arrayList.get(n2)).cacheAdded(cacheHandlerEvent);
            }
            if (n == 1) {
                ((CacheHandlerListener)arrayList.get(n2)).cacheRemoved(cacheHandlerEvent);
            }
            ++n2;
        }
    }

    public void removeLockedFileObjects(CacheDir cacheDir) {
        this.removeLockedFileObjects(cacheDir.getAbsolutePath());
    }

    public void removeLockedFileObjects(String string) {
        LinkedList linkedList = (LinkedList)this.lockedFileObjects.get(string);
        if (linkedList != null) {
            Integer n = (Integer)this.locks.get(string);
            if (n == 1) {
                linkedList.clear();
                this.lockedFileObjects.remove(string);
                this.locks.remove(string);
            } else {
                Integer n2 = new Integer(n - 1);
                this.locks.put(string, n2);
            }
        }
    }

    protected boolean doLockFileObjects(FileObject fileObject, String string, boolean bl) {
        LinkedList linkedList = null;
        LinkedList linkedList2 = (LinkedList)this.lockedFileObjects.get(string);
        if (linkedList2 != null) {
            linkedList = linkedList2;
        }
        linkedList2 = new LinkedList();
        if (fileObject != null) {
            this.recursiveAddParentFO(fileObject, linkedList2);
            this.recursiveFOCollect(fileObject, linkedList2, bl);
            if (linkedList != null && linkedList2.size() < linkedList.size()) {
                linkedList2 = linkedList;
            }
            this.lockedFileObjects.put(string, linkedList2);
            HashMap hashMap = this.locks;
            synchronized (hashMap) {
                Integer n = (Integer)this.locks.get(string);
                n = n != null ? new Integer(n + 1) : new Integer(1);
                this.locks.put(string, n);
            }
            return true;
        }
        return false;
    }

    private void recursiveFOCollect(FileObject fileObject, LinkedList linkedList, boolean bl) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = 0;
        while (n < fileObjectArray.length) {
            linkedList.add(fileObjectArray[n]);
            if (fileObjectArray[n].isFolder() && bl) {
                this.recursiveFOCollect(fileObjectArray[n], linkedList, bl);
            }
            ++n;
        }
    }

    private void recursiveAddParentFO(FileObject fileObject, LinkedList linkedList) {
        linkedList.add(fileObject);
        if (fileObject.getParent() != null) {
            this.recursiveAddParentFO(fileObject.getParent(), linkedList);
        }
    }

    public void prepareCache(File file, boolean bl, int n) {
        File[] fileArray = file.listFiles();
        CacheDir cacheDir = null;
        if (fileArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (!fileArray[n2].isDirectory()) {
                CacheFile cacheFile = CacheHandler.getInstance().getCacheFile(fileArray[n2], n, this.getId());
            } else {
                cacheDir = (CacheDir)CacheHandler.getInstance().getCacheFile(fileArray[n2], n, this.getId());
                if (cacheDir != null && bl) {
                    cacheDir.setAppliedLevel(n);
                    this.prepareCache(new File(cacheDir.getAbsolutePath()), bl, n);
                }
            }
            ++n2;
        }
    }
}

