/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.caching.RefreshCommandSupport;
import org.netbeans.modules.vcscore.caching.VcsCache;
import org.netbeans.modules.vcscore.caching.VcsCacheFile;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.TopManager;

public class VcsCacheDir
extends CacheDir {
    private Debug E;
    private Debug D;
    private volatile boolean loaded;
    private volatile boolean beingLoaded;

    public VcsCacheDir(String string, File file) {
        super(string, file);
        this.D = this.E = new Debug("VcsCacheDir", true);
        this.loaded = false;
        this.beingLoaded = false;
        this.setLocal(true);
        this.setLoaded(false);
    }

    public String getPath() {
        return this.dirFile.getAbsolutePath();
    }

    public File getFile() {
        return this.dirFile;
    }

    public String getFSPath() {
        return ((VcsCache)this.getCacheObject()).getPath(this.getFile());
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public boolean isBeingLoaded() {
        return this.beingLoaded;
    }

    public void setBeingLoaded(boolean bl) {
        this.beingLoaded = bl;
    }

    public void setLoadedRecursive(boolean bl) {
        this.loaded = bl;
        CacheDir[] cacheDirArray = this.getSubDirs();
        int n = 0;
        while (n < cacheDirArray.length) {
            ((VcsCacheDir)cacheDirArray[n]).setLoadedRecursive(bl);
            ++n;
        }
    }

    public void add(CacheFile cacheFile) {
        if (cacheFile instanceof VcsCacheDir || cacheFile instanceof CacheDir) {
            this.addChildDir((CacheDir)cacheFile, true);
        } else {
            this.addFile(cacheFile, true);
        }
    }

    public String[] getFilesAndSubdirs() {
        CacheDir[] cacheDirArray = this.getSubDirs();
        CacheFile[] cacheFileArray = this.getFiles();
        int n = cacheDirArray.length;
        int n2 = cacheFileArray.length;
        int n3 = n + n2;
        String[] stringArray = new String[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            stringArray[n4++] = cacheDirArray[n5].getName();
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2) {
            stringArray[n4++] = cacheFileArray[n6].getName();
            ++n6;
        }
        return stringArray;
    }

    protected String getCacheFileName() {
        return ((VcsCache)this.getCacheObject()).getCacheFileName(this.dirFile);
    }

    public void removeChildDir(String string, boolean bl) {
        CacheDir cacheDir = this.getSubDir(string);
        if (cacheDir != null) {
            ((VcsCacheDir)cacheDir).deleteDiskCache(true);
            super.removeChildDir(string, bl);
        }
    }

    public void populateWithLocal() {
        File[] fileArray;
        FilenameFilter filenameFilter = ((VcsCache)this.getCacheObject()).getLocalFileFilter();
        File[] fileArray2 = fileArray = filenameFilter == null ? this.dirFile.listFiles() : this.dirFile.listFiles(filenameFilter);
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                File file = fileArray[n];
                if (file != null && file.isDirectory()) {
                    VcsCacheDir vcsCacheDir = (VcsCacheDir)this.getCacheObject().getDir(file.getAbsolutePath());
                    if (vcsCacheDir == null) {
                        vcsCacheDir = new VcsCacheDir(this.getCacheObject().getId(), file);
                    }
                    vcsCacheDir.setStatus(((VcsCache)this.getCacheObject()).getLocalFileStatus());
                    vcsCacheDir.setLocker("");
                    vcsCacheDir.setRevision("");
                    vcsCacheDir.setSticky("");
                    vcsCacheDir.setAttr("");
                    vcsCacheDir.setDate("");
                    vcsCacheDir.setTime("");
                    vcsCacheDir.setSize(0);
                    vcsCacheDir.setLocal(true);
                    this.addChildDir(vcsCacheDir, false);
                }
                ++n;
            }
        }
        this.setAppliedLevel(0);
    }

    public void refreshLocal(boolean bl) {
        CacheFile cacheFile;
        Object object;
        int n;
        File[] fileArray;
        Object object2;
        String[] stringArray = this.getFilesAndSubdirs();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        int n2 = 0;
        while (n2 < arrayList.size()) {
            object2 = arrayList.get(n2);
            fileArray = this.getFile((String)object2);
            if (fileArray instanceof VcsCacheFile) {
                if (!((VcsCacheFile)fileArray).isLocal()) {
                    arrayList.remove(n2--);
                }
            } else if (fileArray instanceof VcsCacheDir && !((VcsCacheDir)fileArray).isLocal()) {
                arrayList.remove(n2--);
            }
            ++n2;
        }
        object2 = ((VcsCache)this.getCacheObject()).getLocalFileFilter();
        File[] fileArray2 = fileArray = object2 == null ? this.dirFile.listFiles() : this.dirFile.listFiles((FilenameFilter)object2);
        if (fileArray != null) {
            n = 0;
            while (n < fileArray.length) {
                object = fileArray[n].getName();
                if (arrayList.contains(object)) {
                    ((AbstractCollection)arrayList).remove(object);
                } else if (fileArray[n].isDirectory() && this.getSubDir((String)object) != null) {
                    cacheFile = (VcsCacheDir)this.getCacheObject().getDir(fileArray[n].getAbsolutePath());
                    if (cacheFile == null) {
                        cacheFile = new VcsCacheDir(this.getCacheObject().getId(), fileArray[n]);
                    }
                    cacheFile.setStatus(((VcsCache)this.getCacheObject()).getLocalFileStatus());
                    cacheFile.setLocker("");
                    cacheFile.setRevision("");
                    cacheFile.setSticky("");
                    cacheFile.setAttr("");
                    cacheFile.setDate("");
                    cacheFile.setTime("");
                    cacheFile.setSize(0);
                    ((CacheDir)cacheFile).setLocal(true);
                    this.addChildDir((CacheDir)cacheFile, false);
                }
                ++n;
            }
        }
        n = 0;
        while (n < arrayList.size()) {
            object = arrayList.get(n);
            cacheFile = this.getFile((String)object);
            if (cacheFile != null) {
                this.removeFile((String)object, true);
            } else {
                CacheDir cacheDir = this.getSubDir((String)object);
                if (cacheDir != null) {
                    this.removeChildDir((String)object, true);
                }
            }
            ++n;
        }
        if (bl) {
            object = this.getSubDirs();
            int n3 = 0;
            while (n3 < ((CacheDir[])object).length) {
                ((VcsCacheDir)object[n3]).refreshLocal(bl);
                ++n3;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean readFromDisk() {
        Object object;
        Object object2;
        ArrayList<CacheFile> arrayList;
        boolean bl;
        block14: {
            bl = false;
            String string = this.getCacheFileName();
            if (string == null) {
                return false;
            }
            File file = new File(string);
            arrayList = new ArrayList<CacheFile>();
            if (file.exists() && file.canRead()) {
                object2 = null;
                object2 = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file))));
                object = null;
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    CacheFile cacheFile = VcsCacheFile.readFileCache((String)object, this.getCacheName(), this.getFile());
                    arrayList.add(cacheFile);
                }
                ((BufferedReader)object2).close();
                bl = true;
                Object var9_9 = null;
                if (object2 == null) break block14;
                try {
                    ((BufferedReader)object2).close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                object2 = null;
                {
                    break block14;
                    catch (IOException iOException) {
                        this.E.err(iOException, "readDirFromDiskCache() failed");
                        var9_9 = null;
                        if (object2 == null) break block14;
                        try {
                            ((BufferedReader)object2).close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        object2 = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (object2 != null) {
                        try {
                            ((BufferedReader)object2).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        object2 = null;
                    }
                    throw throwable;
                }
            }
        }
        object2 = ((AbstractList)arrayList).iterator();
        while (object2.hasNext()) {
            object = (CacheFile)object2.next();
            this.add((CacheFile)object);
            if (!(object instanceof CacheDir)) continue;
            this.getCacheObject().registerDir((CacheDir)object);
        }
        if (bl) {
            this.setLoaded(true);
            this.setAppliedLevel(3);
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    public void writeToDisk() {
        block17: {
            Object object;
            String string = this.getCacheFileName();
            if (string == null) {
                return;
            }
            File file = new File(string);
            BufferedWriter bufferedWriter = null;
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException(TopManager.getDefault().getErrorManager().annotate((Throwable)iOException, "Exception when trying to create a new file '" + file.getAbsolutePath() + "', file exists = " + file.exists() + ", parent exists = " + file2.exists() + "\nIf this happens to you, please attach this comment and exception stack to issue #16295."));
            }
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(file))));
            ArrayList arrayList = new ArrayList(this.cachedFiles.values());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (VcsCacheFile)iterator.next();
                if (((VcsCacheFile)object).isLocal()) continue;
                bufferedWriter.write(((VcsCacheFile)object).writeLineToDisk());
                bufferedWriter.newLine();
            }
            object = new ArrayList(this.childDirs.values());
            iterator = object.iterator();
            while (iterator.hasNext()) {
                VcsCacheDir vcsCacheDir = (VcsCacheDir)iterator.next();
                if (vcsCacheDir.isLocal()) continue;
                bufferedWriter.write(vcsCacheDir.writeLineToDisk());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            Object var10_11 = null;
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                break block17;
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException((Throwable)iOException);
            }
            break block17;
            {
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException((Throwable)iOException);
                    Object var10_12 = null;
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException2) {
                        TopManager.getDefault().notifyException((Throwable)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException((Throwable)iOException);
                }
                throw throwable;
            }
        }
    }

    public String writeLineToDisk() {
        String[] stringArray = RefreshCommandSupport.makeElements(this);
        stringArray[0] = stringArray[0] + "/";
        return RefreshCommandSupport.getLineFromElements(stringArray);
    }

    private void deleteDiskCache(boolean bl) {
        String string = this.getCacheFileName();
        if (string == null) {
            return;
        }
        File file = new File(string);
        file.delete();
        if (bl) {
            CacheDir[] cacheDirArray = this.getSubDirs();
            int n = 0;
            while (n < cacheDirArray.length) {
                ((VcsCacheDir)cacheDirArray[n]).deleteDiskCache(bl);
                ++n;
            }
        }
    }

    public void checkServer() {
        boolean bl;
        VcsCacheDir vcsCacheDir = this;
        synchronized (vcsCacheDir) {
            if (this.isBeingLoaded()) {
                return;
            }
            if (!this.isLoaded() || !this.isLocal()) {
                this.setAppliedLevel(3);
                bl = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            VcsCache vcsCache = (VcsCache)this.getCacheObject();
            vcsCache.runVcsDirReader(this.dirFile);
        }
    }

    public void checkServerRecursive() {
        boolean bl;
        VcsCacheDir vcsCacheDir = this;
        synchronized (vcsCacheDir) {
            if (this.isBeingLoaded()) {
                return;
            }
            if (!this.isLoaded() || !this.isLocal()) {
                this.setAppliedLevel(3);
                bl = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            VcsCache vcsCache = (VcsCache)this.getCacheObject();
            vcsCache.runVcsDirReaderRecursive(this.dirFile);
        }
    }

    public String toString() {
        CacheFile[] cacheFileArray = this.getFiles();
        String[] stringArray = new String[cacheFileArray.length];
        int n = 0;
        while (n < cacheFileArray.length) {
            stringArray[n] = cacheFileArray[n].getName();
            ++n;
        }
        CacheDir[] cacheDirArray = this.getSubDirs();
        String[] stringArray2 = new String[cacheDirArray.length];
        int n2 = 0;
        while (n2 < cacheDirArray.length) {
            stringArray2[n2] = cacheDirArray[n2].getName();
            ++n2;
        }
        String string = "VcsDir[name='" + this.name + "',status=" + this.getStatus() + "\n files=" + VcsUtilities.arrayToString(stringArray) + ",\n subdir=" + VcsUtilities.arrayToString(stringArray2) + "\n isLocal = " + this.isLocal() + " isLoaded = " + this.isLoaded() + " isBeingLoaded = " + this.isBeingLoaded() + "]";
        return string;
    }
}

