/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cmdline;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.vcscore.FileReaderListener;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsAction;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReader;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.VcsAdditionalCommand;
import org.netbeans.modules.vcscore.cmdline.exec.BadRegexException;
import org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.VariableValueAdjustment;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class ExecuteCommand
implements VcsCommandExecutor {
    private Debug E;
    private Debug D;
    public static final String DEFAULT_REGEX = "^(.*$)";
    public static final String STATUS_USE_REG_EXP_PARSE_OUTPUT = "REG_EXP_PARSE_OUTPUT";
    private VcsFileSystem fileSystem;
    private UserCommand cmd;
    private Hashtable vars;
    private String preferredExec;
    private ArrayList commandOutputListener;
    private ArrayList commandErrorOutputListener;
    private ArrayList commandDataOutputListener;
    private ArrayList commandDataErrorOutputListener;
    private ArrayList fileReaderListeners;
    private boolean doFileRefresh;
    private boolean doPostExecutionRefresh;
    private boolean getFileRefreshFromErrOut;
    private ArrayList filesToRefresh;
    private ArrayList refreshInfoElements;
    private boolean substituteStatuses;
    private RE[] substituitionRegExps;
    private String[] substituitionStatuses;
    private Collection processingFilesCollection;
    private int exitStatus;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsFileSystem;

    public ExecuteCommand(VcsFileSystem vcsFileSystem, UserCommand userCommand, Hashtable hashtable) {
        this(vcsFileSystem, userCommand, hashtable, null);
    }

    public ExecuteCommand(VcsFileSystem vcsFileSystem, UserCommand userCommand, Hashtable hashtable, String string) {
        this.D = this.E = new Debug("ExecuteCommand", true);
        this.fileSystem = null;
        this.cmd = null;
        this.vars = null;
        this.preferredExec = null;
        this.commandOutputListener = new ArrayList();
        this.commandErrorOutputListener = new ArrayList();
        this.commandDataOutputListener = new ArrayList();
        this.commandDataErrorOutputListener = new ArrayList();
        this.fileReaderListeners = new ArrayList();
        this.getFileRefreshFromErrOut = false;
        this.substituteStatuses = false;
        this.processingFilesCollection = null;
        this.exitStatus = 0;
        this.fileSystem = vcsFileSystem;
        this.cmd = userCommand;
        this.vars = hashtable;
        if (string == null) {
            string = (String)userCommand.getProperty("exec");
        }
        this.preferredExec = string;
        this.doFileRefresh = VcsCommandIO.getIntegerPropertyAssumeNegative(userCommand, "data.fileName.index") >= 0;
        this.doPostExecutionRefresh = VcsCommandIO.getBooleanProperty(userCommand, "refreshProcessedFiles");
        if (this.doFileRefresh) {
            this.refreshInfoElements = new ArrayList();
            String string2 = (String)userCommand.getProperty("refreshFileStatusSubstitutions");
            boolean bl = this.substituteStatuses = string2 != null && string2.length() > 0;
            if (this.substituteStatuses) {
                this.parseStatusSubstitutions(string2);
            }
            this.getFileRefreshFromErrOut = VcsCommandIO.getBooleanProperty(userCommand, "refreshInfoFromBothDataOuts");
        }
    }

    private void parseStatusSubstitutions(String string) {
        String[] stringArray = VcsUtilities.getQuotedStrings(string);
        int n = stringArray.length / 2;
        RE[] rEArray = new RE[n];
        String[] stringArray2 = new String[n];
        int n2 = n;
        int n3 = 0;
        while (n3 < n) {
            block8: {
                try {
                    rEArray[n3] = new RE(stringArray[2 * n3]);
                }
                catch (RESyntaxException rESyntaxException) {
                    TopManager.getDefault().notifyException(TopManager.getDefault().getErrorManager().annotate((Throwable)rESyntaxException, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand") : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)"MSG_BadRegExpInStatusSubstitution", (Object)stringArray[2 * n3])));
                    --n2;
                    break block8;
                }
                stringArray2[n3] = stringArray[2 * n3 + 1];
            }
            ++n3;
        }
        if (n == n2) {
            this.substituitionRegExps = rEArray;
            this.substituitionStatuses = stringArray2;
        } else {
            n = n2;
            this.substituitionRegExps = new RE[n];
            this.substituitionStatuses = new String[n];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                if (rEArray[n4] == null) {
                    --n5;
                } else {
                    this.substituitionRegExps[n5] = rEArray[n4];
                    this.substituitionStatuses[n5] = stringArray2[n4];
                }
                ++n4;
                ++n5;
            }
        }
    }

    public synchronized void addOutputListener(CommandOutputListener commandOutputListener) {
        if (this.commandOutputListener != null) {
            this.commandOutputListener.add(commandOutputListener);
        }
    }

    public synchronized void addErrorOutputListener(CommandOutputListener commandOutputListener) {
        if (this.commandErrorOutputListener != null) {
            this.commandErrorOutputListener.add(commandOutputListener);
        }
    }

    public synchronized void addDataOutputListener(CommandDataOutputListener commandDataOutputListener) {
        if (this.commandDataOutputListener != null) {
            this.commandDataOutputListener.add(commandDataOutputListener);
        }
    }

    public synchronized void addDataErrorOutputListener(CommandDataOutputListener commandDataOutputListener) {
        if (this.commandDataErrorOutputListener != null) {
            this.commandDataErrorOutputListener.add(commandDataOutputListener);
        }
    }

    public VcsCommand getCommand() {
        return this.cmd;
    }

    public Hashtable getVariables() {
        return this.vars;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public VcsCommandVisualizer getVisualizer() {
        return null;
    }

    private void commandFinished(String string, boolean bl) {
        this.commandOutputListener.clear();
        this.commandErrorOutputListener.clear();
        this.commandDataOutputListener.clear();
        this.commandDataErrorOutputListener.clear();
        if (this.doFileRefresh) {
            this.flushRefreshInfo();
        }
        this.fileReaderListeners.clear();
        this.commandOutputListener = null;
        this.commandErrorOutputListener = null;
        this.commandDataOutputListener = null;
        this.commandDataErrorOutputListener = null;
        this.fileReaderListeners = null;
        if (bl || VcsCommandIO.getIntegerPropertyAssumeNegative(this.cmd, "refreshOnFail") == 1) {
            this.refreshRemainingFiles();
            boolean bl2 = false;
            Object var4_4 = null;
        }
    }

    public String preprocessCommand(VcsCommand vcsCommand, Hashtable hashtable, String string) {
        this.preferredExec = string;
        this.fileSystem.getVarValueAdjustment().adjustVarValues(hashtable);
        return string;
    }

    public String getExec() {
        return this.preferredExec;
    }

    private StringBuffer[] addRegexListeners(ExternalCommand externalCommand, RE[] rEArray) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        String string;
        String string2 = (String)this.cmd.getProperty("data.regex");
        if (string2 == null) {
            string2 = DEFAULT_REGEX;
        }
        if ((string = (String)this.cmd.getProperty("error.regex")) == null) {
            string = DEFAULT_REGEX;
        }
        String string3 = (String)this.cmd.getProperty("data.regex.global");
        String string4 = (String)this.cmd.getProperty("error.regex.global");
        RE rE = null;
        RE rE2 = null;
        if (string3 != null) {
            try {
                rE = new RE(string3);
            }
            catch (RESyntaxException rESyntaxException) {
                TopManager.getDefault().notifyException(TopManager.getDefault().getErrorManager().annotate((Throwable)rESyntaxException, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"BadRegexMessageInfo", (Object)string3)));
            }
            if (rE != null) {
                rEArray[0] = rE;
                stringBuffer2 = new StringBuffer();
            } else {
                stringBuffer2 = null;
            }
        } else {
            stringBuffer2 = null;
        }
        if (string4 != null) {
            try {
                rE2 = new RE(string4);
            }
            catch (RESyntaxException rESyntaxException) {
                TopManager.getDefault().notifyException(TopManager.getDefault().getErrorManager().annotate((Throwable)rESyntaxException, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"BadRegexMessageInfo", (Object)string4)));
            }
            if (rE2 != null) {
                rEArray[1] = rE2;
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer = null;
            }
        } else {
            stringBuffer = null;
        }
        try {
            if (rE == null) {
                externalCommand.addStdoutRegexListener(new CommandDataOutputListener(){

                    public void outputData(String[] stringArray) {
                        ExecuteCommand.this.printDataOutput(stringArray);
                    }
                }, string2);
            } else {
                externalCommand.addStdoutRegexListener(new CommandDataOutputListener(){

                    public void outputData(String[] stringArray) {
                        if (stringArray != null) {
                            int n = 0;
                            while (n < stringArray.length) {
                                stringBuffer2.append(stringArray[n]);
                                ++n;
                            }
                            stringBuffer2.append(" ");
                        }
                    }
                }, string2);
            }
        }
        catch (BadRegexException badRegexException) {
            TopManager.getDefault().notifyException(TopManager.getDefault().getErrorManager().annotate((Throwable)badRegexException, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"BadRegexMessageInfo", (Object)string2)));
        }
        try {
            if (rE2 == null) {
                externalCommand.addStderrRegexListener(new CommandDataOutputListener(){

                    public void outputData(String[] stringArray) {
                        ExecuteCommand.this.printDataErrorOutput(stringArray);
                    }
                }, string);
            } else {
                externalCommand.addStderrRegexListener(new CommandDataOutputListener(){

                    public void outputData(String[] stringArray) {
                        if (stringArray != null) {
                            int n = 0;
                            while (n < stringArray.length) {
                                stringBuffer.append(stringArray[n]);
                                ++n;
                            }
                            stringBuffer.append(" ");
                        }
                    }
                }, string);
            }
        }
        catch (BadRegexException badRegexException) {
            TopManager.getDefault().notifyException(TopManager.getDefault().getErrorManager().annotate((Throwable)badRegexException, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"BadRegexMessageInfo", (Object)string)));
        }
        if (stringBuffer2 != null || stringBuffer != null) {
            return new StringBuffer[]{stringBuffer2, stringBuffer};
        }
        return null;
    }

    private void printGlobalDataOutput(String string, RE rE) {
        if (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        String[] stringArray = ExternalCommand.matchToStringArray(rE, string);
        this.printDataOutput(stringArray);
    }

    private void printGlobalErrorDataOutput(String string, RE rE) {
        if (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        String[] stringArray = ExternalCommand.matchToStringArray(rE, string);
        this.printDataErrorOutput(stringArray);
    }

    private void runCommand(String[] stringArray) {
        this.preferredExec = VcsUtilities.array2stringNl(stringArray);
        StringBuffer[] stringBufferArray = null;
        RE[] rEArray = new RE[2];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            ExternalCommand externalCommand = new ExternalCommand(string);
            externalCommand.setInput((String)this.cmd.getProperty("input"));
            externalCommand.setEnv(this.fileSystem.getEnvironmentVars());
            StringBuffer[] stringBufferArray2 = this.addRegexListeners(externalCommand, rEArray);
            Iterator iterator = ((AbstractList)this.commandOutputListener).iterator();
            while (iterator.hasNext()) {
                externalCommand.addStdoutListener((CommandOutputListener)iterator.next());
            }
            Iterator iterator2 = ((AbstractList)this.commandErrorOutputListener).iterator();
            while (iterator2.hasNext()) {
                externalCommand.addStderrListener((CommandOutputListener)iterator2.next());
            }
            int n2 = externalCommand.exec();
            if (n2 != this.exitStatus && (this.exitStatus == 0 || this.exitStatus == 1 && n2 == 2)) {
                this.exitStatus = n2;
            }
            if (stringBufferArray2 != null) {
                if (stringBufferArray == null) {
                    stringBufferArray = stringBufferArray2;
                } else {
                    stringBufferArray[0].append((Object)stringBufferArray2[0]);
                    stringBufferArray[1].append((Object)stringBufferArray2[1]);
                }
            }
            ++n;
        }
        if (stringBufferArray != null) {
            if (stringBufferArray[0] != null) {
                this.printGlobalDataOutput(stringBufferArray[0].toString(), rEArray[0]);
            }
            if (stringBufferArray[1] != null) {
                this.printGlobalErrorDataOutput(stringBufferArray[1].toString(), rEArray[1]);
            }
        }
        this.E.deb("Command exited with exit status = " + this.exitStatus);
        switch (this.exitStatus) {
            case 0: {
                this.commandFinished(this.preferredExec, true);
                break;
            }
            case 1: 
            case 2: {
                this.commandFinished(this.preferredExec, false);
                this.fileSystem.removeNumDoAutoRefresh((String)this.vars.get("DIR"));
            }
        }
        this.D.deb("run(" + this.cmd.getName() + ") finished");
    }

    private void printOutput(String string) {
        Iterator iterator = ((AbstractList)this.commandOutputListener).iterator();
        while (iterator.hasNext()) {
            ((CommandOutputListener)iterator.next()).outputLine(string);
        }
    }

    private void printErrorOutput(String string) {
        Iterator iterator = ((AbstractList)this.commandErrorOutputListener).iterator();
        while (iterator.hasNext()) {
            ((CommandOutputListener)iterator.next()).outputLine(string);
        }
    }

    private void printDataOutput(String[] stringArray) {
        Iterator iterator = ((AbstractList)this.commandDataOutputListener).iterator();
        while (iterator.hasNext()) {
            ((CommandDataOutputListener)iterator.next()).outputData(stringArray);
        }
        if (this.doFileRefresh) {
            this.collectRefreshInfo(stringArray);
        }
    }

    private void printDataErrorOutput(String[] stringArray) {
        Iterator iterator = ((AbstractList)this.commandDataErrorOutputListener).iterator();
        while (iterator.hasNext()) {
            ((CommandDataOutputListener)iterator.next()).outputData(stringArray);
        }
        if (this.getFileRefreshFromErrOut) {
            this.collectRefreshInfo(stringArray);
        }
    }

    private void runClass(String string, String string2, StringTokenizer stringTokenizer) {
        this.E.deb("runClass: " + string2);
        boolean bl = true;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2, true, TopManager.getDefault().currentClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                this.printErrorOutput("CLASS EXEC: " + this.g("ERR_ClassNotFound", string2));
            }
            catch (MissingResourceException missingResourceException) {
                this.printErrorOutput("CLASS EXEC: Class " + string2 + " not found");
            }
            bl = false;
        }
        VcsAdditionalCommand vcsAdditionalCommand = null;
        if (bl) {
            this.D.deb(clazz + " loaded");
            try {
                vcsAdditionalCommand = (VcsAdditionalCommand)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                this.printErrorOutput("CLASS EXEC: " + this.g("ERR_CanNotInstantiate", clazz));
                bl = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.printErrorOutput("CLASS EXEC: " + this.g("ERR_IllegalAccessOnClass", clazz));
                bl = false;
            }
        }
        if (bl) {
            this.E.deb("VcsAdditionalCommand created.");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            ExecuteCommand.setAdditionalParams(vcsAdditionalCommand, this.fileSystem);
            String string3 = (String)this.cmd.getProperty("data.regex");
            String string4 = (String)this.cmd.getProperty("error.regex");
            String string5 = (String)this.cmd.getProperty("input");
            if (string3 != null) {
                this.vars.put("DATAREGEX", string3);
            }
            if (string4 != null) {
                this.vars.put("ERRORREGEX", string4);
            }
            if (string5 != null) {
                this.vars.put("INPUT", string5);
            }
            bl = vcsAdditionalCommand.exec(this.vars, stringArray, new CommandOutputListener(){

                public void outputLine(String string) {
                    ExecuteCommand.this.printOutput(string);
                }
            }, new CommandOutputListener(){

                public void outputLine(String string) {
                    ExecuteCommand.this.printErrorOutput(string);
                }
            }, new CommandDataOutputListener(){

                public void outputData(String[] stringArray) {
                    ExecuteCommand.this.printDataOutput(stringArray);
                }
            }, string3, new CommandDataOutputListener(){

                public void outputData(String[] stringArray) {
                    ExecuteCommand.this.printDataErrorOutput(stringArray);
                }
            }, string4);
        }
        Thread.currentThread();
        if (Thread.interrupted()) {
            this.exitStatus = 2;
            this.commandFinished(string, false);
            this.fileSystem.removeNumDoAutoRefresh((String)this.vars.get("DIR"));
        } else if (bl) {
            this.exitStatus = 0;
            this.commandFinished(string, true);
        } else {
            this.exitStatus = 1;
            this.commandFinished(string, false);
            this.fileSystem.removeNumDoAutoRefresh((String)this.vars.get("DIR"));
        }
    }

    public void run() {
        String string;
        int n = 0;
        String string2 = (String)this.vars.get("MAX_CMD_LENGTH");
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = this.preferredExec != null ? this.preferredExec : (String)this.cmd.getProperty("exec")) == null) {
            return;
        }
        String string3 = string;
        string = Variables.expand(this.vars, string, true);
        if ((string = string.trim()).trim().length() == 0) {
            this.preferredExec = "";
            return;
        }
        String[] stringArray = n > 0 && string.length() > n ? this.splitExec(string3, n) : new String[]{string};
        if (this.doPostExecutionRefresh) {
            this.filesToRefresh = new ArrayList(this.getFiles());
        } else if (this.doFileRefresh) {
            this.filesToRefresh = new ArrayList();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string4 = stringTokenizer.nextToken();
        this.E.deb("first = " + string4);
        boolean bl = VcsCommandIO.getBooleanProperty(this.cmd, "checkForModifications");
        if (bl) {
            this.fileSystem.disableRefresh();
        }
        try {
            if (string4 != null && string4.toLowerCase().endsWith(".class")) {
                this.runClass(string, string4.substring(0, string4.length() - ".class".length()), stringTokenizer);
            } else {
                this.runCommand(stringArray);
            }
            Object var10_10 = null;
            if (bl) {
                this.fileSystem.enableRefresh();
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (bl) {
                this.fileSystem.enableRefresh();
            }
            throw throwable;
        }
    }

    private String[] splitExec(String string, int n) {
        Object object;
        String[] stringArray = new String[]{"FILES", "QFILES", "PATHS", "QPATHS", "MPATHS", "QMPATHS"};
        int n2 = stringArray.length;
        int[][] nArrayArray = new int[n2][];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            object = (String)this.vars.get(stringArray[n4] + "_FILE_POS_INDEXES");
            if (object != null) {
                try {
                    nArrayArray[n4] = (int[])VcsUtilities.decodeValue((String)object);
                    n3 = nArrayArray[n4].length;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n4;
        }
        object = new String[n2];
        int n5 = 0;
        while (n5 < n2) {
            object[n5] = (String)this.vars.get(stringArray[n5]);
            ++n5;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n6 = 0;
        do {
            int n7 = n6;
            int n8 = n3;
            String string2 = null;
            while (n7 < n8) {
                int n9 = (n7 + n8) / 2;
                string2 = this.getTempExec(n6, n9, nArrayArray, string, n2, stringArray, (String[])object);
                if (string2.length() < n) {
                    n7 = n9;
                    n8 = n9;
                    continue;
                }
                n8 = n9;
            }
            if (n7 == n6 || string2 == null) {
                return new String[]{Variables.expand(this.vars, string, true)};
            }
            arrayList.add(string2);
            n6 = n7;
            string2 = this.getTempExec(n6, n3, nArrayArray, string, n2, stringArray, (String[])object);
            if (string2.length() >= n && n6 != n3 - 1) continue;
            arrayList.add(string2);
            break;
        } while (n6 < n3);
        return arrayList.toArray(new String[0]);
    }

    private String getTempExec(int n, int n2, int[][] nArray, String string, int n3, String[] stringArray, String[] stringArray2) {
        String string2;
        int n4 = 0;
        while (n4 < n3) {
            string2 = n2 < nArray[n4].length ? stringArray2[n4].substring(nArray[n4][n], nArray[n4][n2]) : stringArray2[n4].substring(nArray[n4][n]);
            this.vars.put(stringArray[n4], string2);
            ++n4;
        }
        string2 = Variables.expand(this.vars, string, true);
        string2 = string2.trim();
        return string2;
    }

    static void setAdditionalParams(Object object, VcsFileSystem vcsFileSystem) {
        Class<?> clazz = object.getClass();
        Class[] classArray = new Class[]{class$org$netbeans$modules$vcscore$VcsFileSystem == null ? (class$org$netbeans$modules$vcscore$VcsFileSystem = ExecuteCommand.class$("org.netbeans.modules.vcscore.VcsFileSystem")) : class$org$netbeans$modules$vcscore$VcsFileSystem};
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("setFileSystem", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (SecurityException securityException) {
            method = null;
        }
        if (method != null) {
            Object[] objectArray = new Object[]{vcsFileSystem};
            try {
                method.invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                // empty catch block
            }
        }
    }

    public Collection getFiles() {
        if (this.processingFilesCollection == null) {
            this.processingFilesCollection = ExecuteCommand.createProcessingFiles(this.fileSystem, this.vars);
        }
        return this.processingFilesCollection;
    }

    public static Collection createProcessingFiles(VcsFileSystem vcsFileSystem, Hashtable hashtable) {
        VariableValueAdjustment variableValueAdjustment = vcsFileSystem.getVarValueAdjustment();
        String string = (String)hashtable.get("PS");
        char c = string != null && string.length() == 1 ? string.charAt(0) : File.separatorChar;
        String string2 = (String)hashtable.get("PATHS");
        if ((string2 = variableValueAdjustment.revertAdjustedVarValue(string2)) != null && string2.length() > 0) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = string2.length();
            int n3 = 0;
            do {
                if ((n = string2.indexOf("" + c + c, n3)) < 0) {
                    n = n2;
                }
                String string3 = string2.substring(n3, n);
                arrayList.add(string3.replace(c, '/'));
            } while ((n3 = n + 2) < n2);
            return Collections.unmodifiableList(arrayList);
        }
        String string4 = (String)hashtable.get("DIR");
        String string5 = (String)hashtable.get("FILE");
        string5 = variableValueAdjustment.revertAdjustedVarValue(string5);
        if ((string4 = variableValueAdjustment.revertAdjustedVarValue(string4)) != null) {
            String string6 = (string4.length() > 0 ? string4.replace(c, '/') + "/" : "") + (string5 == null ? "" : string5);
            return Collections.singleton(string6);
        }
        return Collections.EMPTY_SET;
    }

    private void collectRefreshInfo(String[] stringArray) {
        if ((stringArray = CommandLineVcsDirReader.translateElements(stringArray, this.cmd)).length == 1) {
            this.flushRemoveFile(stringArray[0]);
            return;
        }
        if (stringArray[0] != null && stringArray[0].trim().length() > 0) {
            this.flushRefreshInfo();
        }
        this.refreshInfoElements.add(stringArray);
    }

    private void flushRemoveFile(String string) {
        String string2;
        String string3 = "";
        string.replace(File.separatorChar, '/');
        int n = string.indexOf(47);
        if (n < 0 || n == string.length() - 1) {
            string3 = this.findFileDir(string);
            if (string.startsWith(string3 + "/")) {
                string = string.substring(string3.length() + 1);
            }
            string2 = string3.length() == 0 ? string : string3 + "/" + string;
        } else {
            string2 = string;
            string3 = VcsUtilities.getDirNamePart(string2);
            string = VcsUtilities.getFileNamePart(string2);
        }
        Iterator iterator = ((AbstractList)new ArrayList(this.fileReaderListeners)).iterator();
        while (iterator.hasNext()) {
            ((FileReaderListener)iterator.next()).readFileFinished(string3, Collections.singleton(new String[]{string}));
        }
        ((AbstractCollection)this.filesToRefresh).remove(string2);
    }

    private void flushRefreshInfo() {
        Object var1_1 = null;
        String[] stringArray = this.mergeInfoElements();
        while (stringArray != null) {
            if (stringArray[0] != null && stringArray[0].trim().length() > 0) {
                String string;
                stringArray[0].replace(File.separatorChar, '/');
                String string2 = stringArray[0];
                String string3 = "";
                int n = string2.indexOf(47);
                if (n < 0 || n == string2.length() - 1) {
                    string3 = this.findFileDir(string2);
                    if (string2.startsWith(string3 + "/")) {
                        stringArray[0] = string2 = string2.substring(string3.length() + 1);
                    }
                    string = string3.length() == 0 ? string2 : string3 + "/" + string2;
                } else {
                    string = string2;
                    string3 = VcsUtilities.getDirNamePart(string);
                    stringArray[0] = string2 = VcsUtilities.getFileNamePart(string);
                }
                if (this.substituteStatuses && (stringArray = this.performStatusSubstitution(stringArray)) == null) {
                    if (!this.doPostExecutionRefresh) {
                        this.filesToRefresh.add(string);
                    }
                } else {
                    string2 = stringArray[0];
                    if (!string2.endsWith("/") && this.fileSystem.folder(string3 + "/" + string2)) {
                        stringArray[0] = string2 = string2 + "/";
                    }
                    Iterator iterator = ((AbstractList)new ArrayList(this.fileReaderListeners)).iterator();
                    while (iterator.hasNext()) {
                        ((FileReaderListener)iterator.next()).readFileFinished(string3, Collections.singleton(stringArray));
                    }
                    ((AbstractCollection)this.filesToRefresh).remove(string);
                }
            }
            stringArray = this.mergeInfoElements();
        }
    }

    private String[] mergeInfoElements() {
        String[] stringArray = null;
        while (this.refreshInfoElements.size() > 0) {
            String[] stringArray2 = (String[])this.refreshInfoElements.get(0);
            if (stringArray == null) {
                stringArray = stringArray2;
                this.refreshInfoElements.remove(0);
                continue;
            }
            if (stringArray2[0] != null && stringArray2[0].trim().length() != 0) break;
            stringArray = this.mergeElements(stringArray, stringArray2);
            this.refreshInfoElements.remove(0);
        }
        return stringArray;
    }

    private String[] mergeElements(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length && n < stringArray2.length) {
            if (n != 0 && (stringArray[n] == null || stringArray[n].trim().length() == 0 && stringArray2[n] != null && stringArray2[n].trim().length() > 0)) {
                stringArray[n] = stringArray2[n];
            }
            ++n;
        }
        return stringArray;
    }

    private String[] performStatusSubstitution(String[] stringArray) {
        String string = stringArray[1];
        if (string == null) {
            return stringArray;
        }
        int n = 0;
        while (n < this.substituitionRegExps.length) {
            if (this.substituitionRegExps[n].match(string)) {
                string = STATUS_USE_REG_EXP_PARSE_OUTPUT.equals(this.substituitionStatuses[n]) ? this.substituitionRegExps[n].getParen(0) : this.substituitionStatuses[n];
                stringArray[1] = string;
                return stringArray;
            }
            ++n;
        }
        return null;
    }

    private String findFileDir(String string) {
        String string2 = "";
        Collection collection = this.doPostExecutionRefresh ? this.filesToRefresh : this.getFiles();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.endsWith(string)) continue;
            if (string3.length() <= string.length()) break;
            string2 = string3.substring(0, string3.length() - string.length() - 1);
            break;
        }
        return string2;
    }

    private void refreshRemainingFiles() {
        if (!"LIST_FILE".equals(this.cmd.getName())) {
            if (this.filesToRefresh != null && this.filesToRefresh.size() > 0) {
                ExecuteCommand.doRefreshFiles(this.fileSystem, this.filesToRefresh);
            } else if (VcsCommandIO.getBooleanProperty(this.cmd, "refreshProcessedFiles")) {
                ExecuteCommand.doRefreshFiles(this.fileSystem, this.getFiles());
            }
        }
    }

    private static void doRefreshFiles(VcsFileSystem vcsFileSystem, Collection collection) {
        VcsCommand vcsCommand = vcsFileSystem.getCommand("LIST_FILE");
        if (vcsCommand != null) {
            Table table = new Table();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                table.put(string, vcsFileSystem.findFileObject(string));
            }
            VcsAction.doCommand(table, vcsCommand, null, vcsFileSystem);
        }
    }

    public void addFileReaderListener(FileReaderListener fileReaderListener) {
        if (this.fileReaderListeners != null) {
            this.fileReaderListeners.add(fileReaderListener);
        }
    }

    String g(String string) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand")) : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)string);
    }

    String g(String string, Object object) {
        return MessageFormat.format(this.g(string), object);
    }

    String g(String string, Object object, Object object2) {
        return MessageFormat.format(this.g(string), object, object2);
    }

    String g(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(this.g(string), object, object2, object3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

