/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.CommandsPool;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.openide.TopManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class CommandOutputCollector
implements CommandListener {
    private static final int DEFAULT_NUM_OF_LINES_OF_OUTPUT_TO_COLLECT = 5000;
    private int numOfLinesOfOutputToCollect = 5000;
    private CommandsPool commandsPool;
    private VcsCommandExecutor vce;
    private long cmdId;
    private static final int NUM_OUTPUTS = 4;
    private static final String[] OUTPUT_FILE_ID = new String[]{"so", "eo", "sd", "ed"};
    private static final String RUNNING_FOLDER_PATH = "system/vcs/running/";
    private static final String FILE_PREFIX = "cmd";
    private static final String FILE_MIDFIX = "_";
    private static final String FILE_POSTFIX = ".txt";
    private static File runningFolder = null;
    private static ArrayList outputCollectorsToFree = new ArrayList();
    private static RequestProcessor.Task collectorsFreeTask = null;
    private ArrayList[] cmdOutput;
    private ArrayList[] cmdOutputListeners;
    private File[] outputFiles;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandOutputCollector;

    public CommandOutputCollector(VcsCommandExecutor vcsCommandExecutor, CommandsPool commandsPool) {
        this.vce = vcsCommandExecutor;
        this.commandsPool = commandsPool;
        this.cmdId = commandsPool.getCommandID(vcsCommandExecutor);
        this.outputFiles = new File[4];
        if (runningFolder == null) {
            CommandOutputCollector.initRunningFolder();
        }
        this.createOutputListeners();
        commandsPool.addCommandListener(this);
    }

    private static synchronized void initRunningFolder() {
        String string;
        if (runningFolder == null && !(runningFolder = new File(string = System.getProperty("netbeans.user"), RUNNING_FOLDER_PATH)).exists() && !runningFolder.mkdirs()) {
            runningFolder = new File(string);
        }
    }

    private void createOutputListeners() {
        this.cmdOutput = new ArrayList[4];
        this.cmdOutputListeners = new ArrayList[4];
        int n = 0;
        while (n < 4) {
            this.cmdOutput[n] = new ArrayList();
            this.cmdOutputListeners[n] = new ArrayList();
            ++n;
        }
        this.vce.addOutputListener(new CommandOutputListener(){

            public void outputLine(String string) {
                CommandOutputCollector.this.addOutput(0, string);
            }
        });
        this.vce.addErrorOutputListener(new CommandOutputListener(){

            public void outputLine(String string) {
                CommandOutputCollector.this.addOutput(1, string);
            }
        });
        this.vce.addDataOutputListener(new CommandDataOutputListener(){

            public void outputData(String[] stringArray) {
                CommandOutputCollector.this.addOutput(2, stringArray);
            }
        });
        this.vce.addDataErrorOutputListener(new CommandDataOutputListener(){

            public void outputData(String[] stringArray) {
                CommandOutputCollector.this.addOutput(3, stringArray);
            }
        });
    }

    private void addOutput(int n, Object object) {
        ArrayList arrayList = this.cmdOutput[n];
        synchronized (arrayList) {
            this.cmdOutput[n].add(object);
            if (this.cmdOutput[n].size() > this.numOfLinesOfOutputToCollect) {
                this.flushOutput(n);
                this.cmdOutput[n].clear();
            }
            if (object instanceof String) {
                String string = (String)object;
                Iterator iterator = ((AbstractList)this.cmdOutputListeners[n]).iterator();
                while (iterator.hasNext()) {
                    ((CommandOutputListener)iterator.next()).outputLine(string);
                }
            } else if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                Iterator iterator = ((AbstractList)this.cmdOutputListeners[n]).iterator();
                while (iterator.hasNext()) {
                    ((CommandDataOutputListener)iterator.next()).outputData(stringArray);
                }
            }
        }
    }

    public final void commandStarted(VcsCommandExecutor vcsCommandExecutor) {
    }

    public void commandDone(VcsCommandExecutor vcsCommandExecutor) {
        if (!this.vce.equals(vcsCommandExecutor)) {
            return;
        }
        Class clazz = class$org$netbeans$modules$vcscore$commands$CommandOutputCollector == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputCollector = CommandOutputCollector.class$("org.netbeans.modules.vcscore.commands.CommandOutputCollector")) : class$org$netbeans$modules$vcscore$commands$CommandOutputCollector;
        synchronized (clazz) {
            if (collectorsFreeTask == null) {
                collectorsFreeTask = new RequestProcessor().create(new Runnable(){
                    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandOutputCollector;

                    public void run() {
                        Class clazz = class$org$netbeans$modules$vcscore$commands$CommandOutputCollector == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputCollector = 5.class$("org.netbeans.modules.vcscore.commands.CommandOutputCollector")) : class$org$netbeans$modules$vcscore$commands$CommandOutputCollector;
                        synchronized (clazz) {
                            Iterator iterator = ((AbstractList)outputCollectorsToFree).iterator();
                            while (iterator.hasNext()) {
                                ((CommandOutputCollector)iterator.next()).freeCommandOutput();
                            }
                            outputCollectorsToFree.clear();
                        }
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
                collectorsFreeTask.setPriority(1);
            }
        }
        outputCollectorsToFree.add(this);
        collectorsFreeTask.schedule(5000);
        this.commandsPool.removeCommandListener(this);
    }

    private void freeCommandOutput() {
        int n = 0;
        while (n < 4) {
            ArrayList arrayList = this.cmdOutput[n];
            synchronized (arrayList) {
                this.cmdOutputListeners[n] = null;
                this.flushOutput(n);
                this.cmdOutput[n] = null;
            }
            ++n;
        }
        this.cmdOutput = null;
    }

    private void addOutputListener(int n, Object object) {
        this.sendCommandOutputFromFile(n, object);
        if (this.cmdOutput != null && this.cmdOutput[n] != null) {
            ArrayList arrayList = this.cmdOutput[n];
            synchronized (arrayList) {
                Iterator iterator;
                Object object2;
                if (object instanceof CommandOutputListener) {
                    object2 = (CommandOutputListener)object;
                    iterator = ((AbstractList)this.cmdOutput[n]).iterator();
                    while (iterator.hasNext()) {
                        object2.outputLine((String)iterator.next());
                    }
                }
                if (object instanceof CommandDataOutputListener) {
                    object2 = (CommandDataOutputListener)object;
                    iterator = ((AbstractList)this.cmdOutput[n]).iterator();
                    while (iterator.hasNext()) {
                        object2.outputData((String[])iterator.next());
                    }
                }
                if (this.cmdOutputListeners[n] != null) {
                    this.cmdOutputListeners[n].add(object);
                }
            }
        }
    }

    public void addOutputListener(CommandOutputListener commandOutputListener) {
        this.addOutputListener(0, commandOutputListener);
    }

    public void addErrorOutputListener(CommandOutputListener commandOutputListener) {
        this.addOutputListener(1, commandOutputListener);
    }

    public void addDataOutputListener(CommandDataOutputListener commandDataOutputListener) {
        this.addOutputListener(2, commandDataOutputListener);
    }

    public synchronized void addDataErrorOutputListener(CommandDataOutputListener commandDataOutputListener) {
        this.addOutputListener(3, commandDataOutputListener);
    }

    private File createOutputFile(int n) {
        if (this.outputFiles[n] == null) {
            String string = FILE_PREFIX + this.cmdId + FILE_MIDFIX + OUTPUT_FILE_ID[n] + FILE_POSTFIX;
            this.outputFiles[n] = new File(runningFolder, string);
            try {
                this.outputFiles[n].delete();
                this.outputFiles[n].createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputFiles[n].deleteOnExit();
        }
        return this.outputFiles[n];
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flushOutput(int n) {
        File file = this.createOutputFile(n);
        BufferedWriter bufferedWriter = null;
        bufferedWriter = new BufferedWriter(new FileWriter(file.getAbsolutePath(), true));
        Iterator iterator = ((AbstractList)this.cmdOutput[n]).iterator();
        while (iterator.hasNext()) {
            String string;
            Object e = iterator.next();
            if (e instanceof String) {
                string = (String)e;
            } else if (e instanceof String[]) {
                String[] stringArray = (String[])e;
                string = this.encodeElements(stringArray);
            } else {
                string = "";
            }
            bufferedWriter.write(string + "\n");
        }
        Object var9_9 = null;
        if (bufferedWriter == null) return;
        try {
            bufferedWriter.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                TopManager.getDefault().notifyException((Throwable)iOException);
                Object var9_10 = null;
                if (bufferedWriter == null) return;
                try {
                    bufferedWriter.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (bufferedWriter == null) throw throwable;
            try {
                bufferedWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendCommandOutputFromFile(int n, Object object) {
        String string;
        if (this.outputFiles[n] == null) {
            return;
        }
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new FileReader(this.outputFiles[n]));
        while ((string = bufferedReader.readLine()) != null) {
            Object object2;
            if (object instanceof CommandOutputListener) {
                object2 = (CommandOutputListener)object;
                object2.outputLine(string);
            }
            if (!(object instanceof CommandDataOutputListener)) continue;
            object2 = (CommandDataOutputListener)object;
            object2.outputData(this.decodeElements(string));
        }
        Object var7_7 = null;
        if (bufferedReader == null) return;
        try {
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                TopManager.getDefault().notifyException((Throwable)iOException);
                Object var7_8 = null;
                if (bufferedReader == null) return;
                try {
                    bufferedReader.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private String encodeElements(String[] stringArray) {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n] != null ? string + Utilities.replaceString((String)stringArray[n], (String)"/", (String)" // ") + " / " : string + " /null/ ";
            ++n;
        }
        return string;
    }

    private String[] decodeElements(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3;
            int n4 = string.indexOf(" / ", n2);
            int n5 = string.indexOf(" /null/ ", n2);
            if (n4 < 0 && n5 < 0) break;
            n = n4 >= 0 ? n4 : n5;
            if (n5 >= 0 && n5 < n) {
                n = n5;
                n3 = " /null/ ".length();
            } else {
                n3 = " / ".length();
            }
            String string2 = string.substring(n2, n);
            arrayList.add(Utilities.replaceString((String)string2, (String)" // ", (String)"/"));
            n2 = n + n3;
        }
        return arrayList.toArray(new String[0]);
    }

    protected void finalize() {
        if (this.outputFiles != null) {
            int n = 0;
            while (n < 4) {
                if (this.outputFiles[n] != null) {
                    this.outputFiles[n].delete();
                }
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

