/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.commands;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.netbeans.modules.vcscore.FileReaderListener;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandExecutorSupport;
import org.netbeans.modules.vcscore.commands.CommandListener;
import org.netbeans.modules.vcscore.commands.CommandOutputCollector;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputVisualizer;
import org.netbeans.modules.vcscore.commands.CommandsThreadsPool;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.runtime.RuntimeCommand;
import org.netbeans.modules.vcscore.runtime.RuntimeSupport;
import org.netbeans.modules.vcscore.runtime.VcsRuntimeCommand;
import org.netbeans.modules.vcscore.util.TopComponentCloseListener;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.TopManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CommandsPool {
    public static final int PREPROCESS_CANCELLED = 0;
    public static final int PREPROCESS_NEXT_FILE = 1;
    public static final int PREPROCESS_DONE = 2;
    private static final int MAX_NUM_RUNNING_COMMANDS = 10;
    private static final int MAX_NUM_RUNNING_LISTS = 7;
    private static long lastCommandID = 0L;
    private static CommandsPool instance = null;
    private Hashtable commandsWrappers;
    private ArrayList commandsToRun;
    private ArrayList commandsWaitQueue;
    private ArrayList commandsRunning;
    private ArrayList commandsExceptionallyRunning;
    private Hashtable outputContainers;
    private Hashtable outputVisualizers;
    private ArrayList commandsFinished;
    private int numRunningListCommands = 0;
    private CommandsThreadsPool threadsPool;
    private boolean collectOutput = true;
    private boolean collectErrOutput = true;
    private ArrayList commandListeners = new ArrayList();
    private boolean execStarterLoopStarted = false;
    private boolean execStarterLoopRunning = true;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandsPool;

    private CommandsPool() {
        this.commandsToRun = new ArrayList();
        this.commandsRunning = new ArrayList();
        this.commandsExceptionallyRunning = new ArrayList();
        this.commandsFinished = new ArrayList();
        this.commandsWaitQueue = new ArrayList();
        this.commandsWrappers = new Hashtable();
        this.outputContainers = new Hashtable();
        this.outputVisualizers = new Hashtable();
        this.threadsPool = new CommandsThreadsPool();
    }

    public static synchronized CommandsPool getInstance() {
        if (instance == null) {
            instance = new CommandsPool();
        }
        return instance;
    }

    protected void finalize() {
        this.cleanup();
    }

    public void cleanup() {
        CommandsPool commandsPool = this;
        synchronized (commandsPool) {
            this.execStarterLoopRunning = false;
            this.notifyAll();
        }
    }

    public void setCollectOutput(boolean bl) {
        this.collectOutput = bl;
    }

    public boolean isCollectOutput() {
        return this.collectOutput;
    }

    public long getCommandID(VcsCommandExecutor vcsCommandExecutor) {
        VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)this.commandsWrappers.get(vcsCommandExecutor);
        if (vcsCommandWrapper != null) {
            return vcsCommandWrapper.getCommandID();
        }
        return -1L;
    }

    public int preprocessCommand(VcsCommandExecutor vcsCommandExecutor, Hashtable hashtable, VcsFileSystem vcsFileSystem) {
        return this.preprocessCommand(vcsCommandExecutor, hashtable, vcsFileSystem, null);
    }

    public int preprocessCommand(VcsCommandExecutor vcsCommandExecutor, Hashtable hashtable, VcsFileSystem vcsFileSystem, boolean[] blArray) {
        int n;
        VcsCommandWrapper vcsCommandWrapper = new VcsCommandWrapper(vcsCommandExecutor, vcsFileSystem);
        this.commandsWrappers.put(vcsCommandExecutor, vcsCommandWrapper);
        ArrayList arrayList = this.commandsToRun;
        synchronized (arrayList) {
            this.commandsToRun.add(vcsCommandWrapper);
        }
        VcsCommand vcsCommand = vcsCommandExecutor.getCommand();
        String string = vcsCommand.getDisplayName();
        if (string == null || string.length() == 0) {
            string = vcsCommand.getName();
        }
        String string2 = vcsCommandExecutor.getExec();
        VcsRuntimeCommand vcsRuntimeCommand = null;
        if (vcsFileSystem != null) {
            vcsFileSystem.debug(this.g("MSG_Command_preprocessing", string, string2));
            if (vcsFileSystem.isCreateRuntimeCommands()) {
                vcsRuntimeCommand = new VcsRuntimeCommand(vcsCommandExecutor, this);
                vcsCommandWrapper.setRuntimeCommand(vcsRuntimeCommand);
                ((RuntimeCommand)vcsRuntimeCommand).setState(10);
                RuntimeSupport.getInstance().updateCommand(vcsFileSystem.getSystemName(), vcsRuntimeCommand);
            }
        }
        if (0 == (n = CommandExecutorSupport.preprocessCommand(vcsFileSystem, vcsCommandExecutor, hashtable, blArray))) {
            CommandsPool commandsPool = this;
            synchronized (commandsPool) {
                ((AbstractCollection)this.commandsToRun).remove(vcsCommandWrapper);
                this.commandsWrappers.remove(vcsCommandExecutor);
                this.notifyAll();
            }
            if (vcsFileSystem != null) {
                vcsFileSystem.debug(this.g("MSG_Command_canceled", string));
                if (vcsFileSystem.isCreateRuntimeCommands()) {
                    RuntimeSupport.getInstance().removeDone(vcsFileSystem.getSystemName(), vcsRuntimeCommand);
                }
            }
        }
        return n;
    }

    private void commandStarted(VcsCommandWrapper vcsCommandWrapper) {
        FileSystemCache fileSystemCache;
        Object object;
        Object object2;
        final VcsCommandExecutor vcsCommandExecutor = vcsCommandWrapper.getExecutor();
        final VcsFileSystem vcsFileSystem = vcsCommandWrapper.getFileSystem();
        VcsCommand vcsCommand = vcsCommandExecutor.getCommand();
        String string = vcsCommand.getDisplayName();
        if (string == null || string.length() == 0) {
            string = vcsCommand.getName();
        }
        final String string2 = string;
        if (vcsFileSystem != null && vcsFileSystem.isCreateRuntimeCommands()) {
            object2 = vcsCommandWrapper.getRuntimeCommand();
            if (object2 == null) {
                object2 = new VcsRuntimeCommand(vcsCommandExecutor, this);
                vcsCommandWrapper.setRuntimeCommand((RuntimeCommand)object2);
            }
            ((RuntimeCommand)object2).setState(11);
            RuntimeSupport.getInstance().updateCommand(vcsFileSystem.getSystemName(), (RuntimeCommand)object2);
        }
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                TopManager.getDefault().setStatusText(CommandsPool.this.g("MSG_Command_name_running", string2));
                if (vcsFileSystem != null) {
                    vcsFileSystem.debug(CommandsPool.this.g("MSG_Command_started", string2, vcsCommandExecutor.getExec()));
                }
            }
        });
        object2 = this.commandListeners;
        synchronized (object2) {
            object = ((AbstractList)this.commandListeners).iterator();
            while (object.hasNext()) {
                ((CommandListener)object.next()).commandStarted(vcsCommandExecutor);
            }
        }
        object = new CommandOutputCollector(vcsCommandExecutor, this);
        this.outputContainers.put(vcsCommandExecutor, object);
        VcsCommandVisualizer vcsCommandVisualizer = vcsCommandExecutor.getVisualizer();
        if (vcsCommandVisualizer != null && !vcsCommandVisualizer.openAfterCommandFinish()) {
            vcsCommandVisualizer.open();
        }
        if (VcsCommandIO.getBooleanProperty(vcsCommandExecutor.getCommand(), "display")) {
            this.openCommandOutput(vcsCommandExecutor);
        }
        if (vcsFileSystem != null && (fileSystemCache = CacheHandler.getInstance().getCache(vcsFileSystem.getCacheIdStr())) != null && fileSystemCache instanceof FileReaderListener) {
            vcsCommandExecutor.addFileReaderListener((FileReaderListener)((Object)fileSystemCache));
        }
        vcsCommandWrapper.setStartTime(System.currentTimeMillis());
    }

    private void commandDone(VcsCommandWrapper vcsCommandWrapper) {
        VcsCommandVisualizer vcsCommandVisualizer;
        VcsCommandVisualizer vcsCommandVisualizer2;
        Object object;
        Object object2;
        vcsCommandWrapper.setFinishTime(System.currentTimeMillis());
        VcsCommandExecutor vcsCommandExecutor = vcsCommandWrapper.getExecutor();
        VcsFileSystem vcsFileSystem = vcsCommandWrapper.getFileSystem();
        VcsCommand vcsCommand = vcsCommandExecutor.getCommand();
        String string = vcsCommand.getDisplayName();
        if (string == null || string.length() == 0) {
            string = vcsCommand.getName();
        }
        CommandsPool commandsPool = this;
        synchronized (commandsPool) {
            if (this.isListCommand(vcsCommand)) {
                --this.numRunningListCommands;
            }
            ((AbstractCollection)this.commandsRunning).remove(vcsCommandWrapper);
            this.commandsFinished.add(vcsCommandWrapper);
            ((AbstractCollection)this.commandsExceptionallyRunning).remove(vcsCommandWrapper);
            this.notifyAll();
        }
        if (vcsFileSystem != null && vcsFileSystem.isCreateRuntimeCommands()) {
            object2 = vcsCommandWrapper.getRuntimeCommand();
            if (object2 == null) {
                object2 = new VcsRuntimeCommand(vcsCommandExecutor, this);
                vcsCommandWrapper.setRuntimeCommand((RuntimeCommand)object2);
            }
            ((RuntimeCommand)object2).setState(12);
            object = RuntimeSupport.getInstance();
            ((RuntimeSupport)object).updateCommand(vcsFileSystem.getSystemName(), (RuntimeCommand)object2);
        } else {
            object2 = this;
            synchronized (object2) {
                ((AbstractCollection)this.commandsFinished).remove(vcsCommandWrapper);
                this.commandsWrappers.remove(vcsCommandExecutor);
                this.outputContainers.remove(vcsCommandExecutor);
            }
        }
        if (!this.isCollectOutput()) {
            this.outputContainers.remove(vcsCommandExecutor);
        }
        object2 = this.commandListeners;
        synchronized (object2) {
            object = ((AbstractList)this.commandListeners).iterator();
            while (object.hasNext()) {
                ((CommandListener)object.next()).commandDone(vcsCommandExecutor);
            }
        }
        if (vcsFileSystem != null) {
            CommandExecutorSupport.postprocessCommand(vcsFileSystem, vcsCommandExecutor);
        }
        int n = vcsCommandExecutor.getExitStatus();
        if (vcsCommandWrapper.isInterrupted()) {
            n = 2;
        }
        String string2 = "";
        switch (n) {
            case 0: {
                string2 = this.g("MSG_Command_name_finished", string);
                break;
            }
            case 1: {
                if (VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "ignoreFail")) {
                    string2 = this.g("MSG_Command_name_finished", string);
                    break;
                }
                string2 = this.g("MSG_Command_name_failed", string);
                break;
            }
            case 2: {
                string2 = this.g("MSG_Command_name_interrupted", string);
            }
        }
        final String string3 = string2;
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                TopManager.getDefault().setStatusText(string3);
            }
        });
        String string4 = null;
        if (n != 0 && !VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "ignoreFail")) {
            if (vcsFileSystem != null) {
                vcsFileSystem.debugErr(string2);
            }
            this.printErrorOutput(vcsCommandExecutor, vcsFileSystem);
            if (vcsFileSystem == null || vcsFileSystem.isCommandNotification()) {
                string4 = (String)vcsCommand.getProperty("notificationFailMsg");
            }
        } else {
            if (vcsFileSystem != null) {
                vcsFileSystem.debug(string2);
            }
            if (vcsFileSystem == null || vcsFileSystem.isCommandNotification()) {
                string4 = (String)vcsCommand.getProperty("notificationSuccessMsg");
            }
        }
        if (string4 != null) {
            CommandExecutorSupport.commandNotification(vcsCommandExecutor, string4, vcsFileSystem);
        }
        if ((vcsCommandVisualizer2 = vcsCommandExecutor.getVisualizer()) != null) {
            vcsCommandVisualizer2.setExitStatus(n);
            if (vcsCommandVisualizer2.openAfterCommandFinish()) {
                vcsCommandVisualizer2.open();
            }
        }
        if ((vcsCommandVisualizer = (VcsCommandVisualizer)((Object)this.outputVisualizers.get(vcsCommandExecutor))) != null) {
            vcsCommandVisualizer.setExitStatus(n);
        }
    }

    public void removeFinishedCommand(VcsCommandExecutor vcsCommandExecutor) {
        VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)this.commandsWrappers.get(vcsCommandExecutor);
        if (vcsCommandWrapper == null) {
            return;
        }
        CommandsPool commandsPool = this;
        synchronized (commandsPool) {
            ((AbstractCollection)this.commandsFinished).remove(vcsCommandWrapper);
            this.commandsWrappers.remove(vcsCommandExecutor);
            this.outputContainers.remove(vcsCommandExecutor);
        }
        RuntimeCommand runtimeCommand = vcsCommandWrapper.getRuntimeCommand();
        vcsCommandWrapper.setRuntimeCommand(null);
    }

    private void printErrorOutput(VcsCommandExecutor vcsCommandExecutor, final VcsFileSystem vcsFileSystem) {
        if (vcsFileSystem == null) {
            return;
        }
        vcsFileSystem.debugErr(this.g("MSG_Check_whole_output"));
        CommandOutputCollector commandOutputCollector = (CommandOutputCollector)this.outputContainers.get(vcsCommandExecutor);
        if (commandOutputCollector != null) {
            commandOutputCollector.addErrorOutputListener(new CommandOutputListener(){

                public void outputLine(String string) {
                    vcsFileSystem.debugErr(string);
                }
            });
        }
    }

    public synchronized void startExecutor(VcsCommandExecutor vcsCommandExecutor) {
        this.startExecutor(vcsCommandExecutor, null);
    }

    public synchronized void startExecutor(VcsCommandExecutor vcsCommandExecutor, VcsFileSystem vcsFileSystem) {
        VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)this.commandsWrappers.get(vcsCommandExecutor);
        if (vcsCommandWrapper == null) {
            vcsCommandWrapper = new VcsCommandWrapper(vcsCommandExecutor, vcsFileSystem);
            this.commandsWrappers.put(vcsCommandExecutor, vcsCommandWrapper);
        }
        vcsCommandWrapper.setSubmittingThread(Thread.currentThread());
        ((AbstractCollection)this.commandsToRun).remove(vcsCommandWrapper);
        this.commandsWaitQueue.add(vcsCommandWrapper);
        this.notifyAll();
        if (!this.execStarterLoopStarted) {
            this.runExecutorStarterLoop();
        }
    }

    private synchronized void executorStarter(final VcsCommandWrapper vcsCommandWrapper) {
        this.commandsRunning.add(vcsCommandWrapper);
        this.threadsPool.processCommand(new Runnable(){

            public void run() {
                VcsCommandExecutor vcsCommandExecutor;
                CommandsPool commandsPool = CommandsPool.this;
                synchronized (commandsPool) {
                    vcsCommandExecutor = vcsCommandWrapper.getExecutor();
                    vcsCommandWrapper.setRunningThread(Thread.currentThread());
                    if (CommandsPool.this.isListCommand(vcsCommandExecutor.getCommand())) {
                        CommandsPool.this.numRunningListCommands++;
                    }
                    CommandsPool.this.commandStarted(vcsCommandWrapper);
                }
                ThreadDeath threadDeath = null;
                try {
                    vcsCommandExecutor.run();
                }
                catch (RuntimeException runtimeException) {
                    TopManager.getDefault().notifyException((Throwable)runtimeException);
                }
                catch (ThreadDeath threadDeath2) {
                    threadDeath = threadDeath2;
                }
                catch (Throwable throwable) {
                    TopManager.getDefault().notifyException(throwable);
                }
                CommandsPool.this.commandDone(vcsCommandWrapper);
                if (threadDeath != null) {
                    throw threadDeath;
                }
            }
        });
    }

    private synchronized void executorStarterLoop() {
        while (true) {
            VcsCommandWrapper vcsCommandWrapper = null;
            Iterator iterator = ((AbstractList)this.commandsWaitQueue).iterator();
            while (iterator.hasNext()) {
                VcsCommandWrapper vcsCommandWrapper2 = (VcsCommandWrapper)iterator.next();
                if (!this.canRun(vcsCommandWrapper2)) continue;
                vcsCommandWrapper = vcsCommandWrapper2;
                break;
            }
            if (vcsCommandWrapper != null) {
                ((AbstractCollection)this.commandsWaitQueue).remove(vcsCommandWrapper);
                this.executorStarter(vcsCommandWrapper);
            }
            if (vcsCommandWrapper != null) continue;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.execStarterLoopRunning) break;
        }
    }

    private void runExecutorStarterLoop() {
        Thread thread = new Thread(this.threadsPool.getThreadGroup(), new Runnable(){

            public void run() {
                CommandsPool.this.executorStarterLoop();
            }
        }, "VCS Command Executor Starter Loop");
        thread.setDaemon(true);
        thread.start();
        this.execStarterLoopStarted = true;
    }

    public boolean openCommandOutput(final VcsCommandExecutor vcsCommandExecutor) {
        CommandOutputVisualizer commandOutputVisualizer = (CommandOutputVisualizer)((Object)this.outputVisualizers.get(vcsCommandExecutor));
        if (commandOutputVisualizer != null) {
            commandOutputVisualizer.requestFocus();
            return true;
        }
        CommandOutputCollector commandOutputCollector = (CommandOutputCollector)this.outputContainers.get(vcsCommandExecutor);
        if (commandOutputCollector == null) {
            return false;
        }
        final CommandOutputVisualizer commandOutputVisualizer2 = new CommandOutputVisualizer(vcsCommandExecutor);
        commandOutputVisualizer2.addCloseListener(new TopComponentCloseListener(){

            public void closing() {
                CommandsPool.this.outputVisualizers.remove(vcsCommandExecutor);
            }
        });
        if (this.isRunning(vcsCommandExecutor)) {
            commandOutputVisualizer2.setCommandsPool(this);
        }
        commandOutputVisualizer2.open();
        this.outputVisualizers.put(vcsCommandExecutor, commandOutputVisualizer2);
        commandOutputCollector.addOutputListener(new CommandOutputListener(){

            public void outputLine(String string) {
                commandOutputVisualizer2.stdOutputLine(string);
            }
        });
        commandOutputCollector.addErrorOutputListener(new CommandOutputListener(){

            public void outputLine(String string) {
                commandOutputVisualizer2.errOutputLine(string);
            }
        });
        commandOutputCollector.addDataOutputListener(new CommandDataOutputListener(){

            public void outputData(String[] stringArray) {
                commandOutputVisualizer2.stdOutputData(stringArray);
            }
        });
        commandOutputCollector.addDataErrorOutputListener(new CommandDataOutputListener(){

            public void outputData(String[] stringArray) {
                commandOutputVisualizer2.errOutputData(stringArray);
            }
        });
        if (!this.isRunning(vcsCommandExecutor) && !this.isWaiting(vcsCommandExecutor)) {
            commandOutputVisualizer2.setExitStatus(vcsCommandExecutor.getExitStatus());
        }
        return true;
    }

    public synchronized boolean isSomeRunning() {
        return this.commandsRunning.size() > 0;
    }

    public synchronized boolean isWaiting(VcsCommandExecutor vcsCommandExecutor) {
        VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)this.commandsWrappers.get(vcsCommandExecutor);
        if (vcsCommandWrapper == null) {
            return false;
        }
        return this.commandsToRun.contains(vcsCommandWrapper) || this.commandsWaitQueue.contains(vcsCommandWrapper);
    }

    public synchronized boolean isRunning(VcsCommandExecutor vcsCommandExecutor) {
        VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)this.commandsWrappers.get(vcsCommandExecutor);
        return vcsCommandWrapper != null && this.commandsRunning.contains(vcsCommandWrapper);
    }

    public synchronized String[] getRunningCommandsLabels() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = ((AbstractList)this.commandsRunning).iterator();
        while (iterator.hasNext()) {
            VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)iterator.next();
            VcsCommandExecutor vcsCommandExecutor = vcsCommandWrapper.getExecutor();
            VcsCommand vcsCommand = vcsCommandExecutor.getCommand();
            String string = vcsCommand.getDisplayName();
            linkedList.add(string);
        }
        return linkedList.toArray(new String[0]);
    }

    private static boolean areFilesInSamePackage(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = VcsUtilities.getDirNamePart(string);
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                String string4 = VcsUtilities.getDirNamePart(string3);
                if (!string2.equals(string4)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isParentFolder(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (!string.startsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private HashMap createConcurrencyMap(String string) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (string != null) {
            String[] stringArray = VcsUtilities.getQuotedStrings(string);
            int n = 0;
            while (n < stringArray.length) {
                block5: {
                    int n2 = stringArray[n].lastIndexOf(32);
                    if (n2 >= 0) {
                        int n3;
                        String string2 = stringArray[n].substring(0, n2);
                        String string3 = stringArray[n].substring(n2 + 1);
                        try {
                            n3 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            break block5;
                        }
                        hashMap.put(string2, new Integer(n3));
                    }
                }
                ++n;
            }
        }
        return hashMap;
    }

    private boolean isListCommand(VcsCommand vcsCommand) {
        return vcsCommand.getName().startsWith("LIST");
    }

    private Collection getRunningThreadsFromCommands(Collection collection) {
        HashSet<Thread> hashSet = new HashSet<Thread>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)iterator.next();
            Thread thread = vcsCommandWrapper.getRunningThread();
            if (thread == null) continue;
            hashSet.add(thread);
        }
        return hashSet;
    }

    private boolean areExcRunningPredecessorsOf(VcsCommandWrapper vcsCommandWrapper) {
        boolean bl;
        HashSet hashSet = new HashSet(this.commandsExceptionallyRunning);
        block0: do {
            bl = false;
            Thread thread = vcsCommandWrapper.getSubmittingThread();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                VcsCommandWrapper vcsCommandWrapper2 = (VcsCommandWrapper)iterator.next();
                if (!thread.equals(vcsCommandWrapper2.getRunningThread())) continue;
                vcsCommandWrapper = vcsCommandWrapper2;
                hashSet.remove(vcsCommandWrapper2);
                bl = true;
                continue block0;
            }
        } while (bl);
        return hashSet.size() == 0;
    }

    private synchronized boolean canRun(VcsCommandWrapper vcsCommandWrapper) {
        VcsCommandExecutor vcsCommandExecutor = vcsCommandWrapper.getExecutor();
        VcsCommand vcsCommand = vcsCommandExecutor.getCommand();
        if (this.commandsRunning.size() >= 10 || this.isListCommand(vcsCommand) && this.numRunningListCommands >= 7) {
            Thread thread = vcsCommandWrapper.getSubmittingThread();
            if (this.getRunningThreadsFromCommands(this.commandsRunning).contains(thread) && (this.commandsExceptionallyRunning.size() == 0 || this.areExcRunningPredecessorsOf(vcsCommandWrapper))) {
                this.commandsExceptionallyRunning.add(vcsCommandWrapper);
                return true;
            }
            return false;
        }
        Collection collection = vcsCommandExecutor.getFiles();
        int n = VcsCommandIO.getIntegerPropertyAssumeZero(vcsCommand, "concurrentExec");
        String string = (String)vcsCommand.getProperty("concurrentExecWith");
        if (n == 0 && string == null || n == -1) {
            return true;
        }
        HashMap hashMap = this.createConcurrencyMap(string);
        String string2 = vcsCommand.getName();
        boolean bl = false;
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 2) != 0;
        boolean bl4 = (n & 4) != 0;
        boolean bl5 = (n & 8) != 0;
        boolean bl6 = (n & 0x10) != 0;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        ArrayList arrayList = new ArrayList(this.commandsRunning);
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Object object;
            VcsCommandWrapper vcsCommandWrapper2 = (VcsCommandWrapper)iterator.next();
            VcsCommandExecutor vcsCommandExecutor2 = vcsCommandWrapper2.getExecutor();
            Collection collection2 = vcsCommandExecutor2.getFiles();
            VcsCommand vcsCommand2 = vcsCommandExecutor2.getCommand();
            int n2 = VcsCommandIO.getIntegerPropertyAssumeZero(vcsCommand2, "concurrentExec");
            if (-1 == n2) continue;
            if (bl6) {
                bl = true;
                break;
            }
            String string3 = vcsCommand2.getName();
            if (bl2) {
                object = collection.iterator();
                while (object.hasNext()) {
                    String string4 = (String)object.next();
                    if (!collection2.contains(string4)) continue;
                    bl7 = true;
                    break;
                }
            }
            if (bl3 && CommandsPool.areFilesInSamePackage(collection, collection2)) {
                bl8 = true;
            }
            if (bl4 && CommandsPool.isParentFolder(collection, collection2)) {
                bl9 = true;
            }
            if (bl5) {
                bl10 = string2.equals(string3);
            }
            if (bl7 || bl8 || bl9 || bl10) {
                bl = true;
                break;
            }
            object = (Integer)hashMap.get(string3);
            if (object == null || !this.haveToWaitFor(collection, collection2, (Integer)object)) continue;
            bl = true;
            break;
        }
        return !bl;
    }

    private boolean haveToWaitFor(Collection collection, Collection collection2, int n) {
        boolean bl;
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 2) != 0;
        boolean bl4 = bl = (n & 4) != 0;
        if (bl2) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!collection2.contains(string)) continue;
                return true;
            }
        }
        if (bl3 && CommandsPool.areFilesInSamePackage(collection, collection2)) {
            return true;
        }
        return bl && CommandsPool.isParentFolder(collection, collection2);
    }

    private synchronized void addExecutorsOfCommand(ArrayList arrayList, VcsCommand vcsCommand) {
        Object object;
        Object object2;
        String string = vcsCommand.getName();
        Iterator iterator = ((AbstractList)this.commandsToRun).iterator();
        while (iterator.hasNext()) {
            object2 = (VcsCommandWrapper)iterator.next();
            object = ((VcsCommandWrapper)object2).getExecutor();
            if (!string.equals(object.getCommand().getName())) continue;
            arrayList.add(object);
        }
        iterator = ((AbstractList)this.commandsWaitQueue).iterator();
        while (iterator.hasNext()) {
            object2 = (VcsCommandWrapper)iterator.next();
            object = ((VcsCommandWrapper)object2).getExecutor();
            if (!string.equals(object.getCommand().getName())) continue;
            arrayList.add(object);
        }
        object2 = ((AbstractList)this.commandsRunning).iterator();
        while (object2.hasNext()) {
            object = (VcsCommandWrapper)object2.next();
            VcsCommandExecutor vcsCommandExecutor = ((VcsCommandWrapper)object).getExecutor();
            if (!string.equals(vcsCommandExecutor.getCommand().getName())) continue;
            arrayList.add(vcsCommandExecutor);
        }
    }

    public void waitToFinish(VcsCommand vcsCommand, Set set) throws InterruptedException {
        Object object;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        this.addExecutorsOfCommand(arrayList, vcsCommand);
        Iterator iterator = ((AbstractList)arrayList).iterator();
        block3: while (iterator.hasNext()) {
            object = (VcsCommandExecutor)iterator.next();
            Collection collection = object.getFiles();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (!set.contains(string)) continue;
                bl = true;
                continue block3;
            }
        }
        if (bl) {
            object = this;
            synchronized (object) {
                this.wait();
            }
        }
    }

    public void waitToFinish(VcsCommandExecutor vcsCommandExecutor) throws InterruptedException {
        VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)this.commandsWrappers.get(vcsCommandExecutor);
        if (vcsCommandWrapper == null) {
            return;
        }
        CommandsPool commandsPool = this;
        synchronized (commandsPool) {
            while (this.commandsToRun.contains(vcsCommandWrapper) || this.commandsWaitQueue.contains(vcsCommandWrapper) || this.commandsRunning.contains(vcsCommandWrapper)) {
                this.wait();
            }
        }
    }

    public synchronized void killAll() {
        Iterator iterator = ((AbstractList)this.commandsRunning).iterator();
        while (iterator.hasNext()) {
            VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)iterator.next();
            Thread thread = vcsCommandWrapper.getRunningThread();
            if (thread == null) continue;
            thread.interrupt();
        }
    }

    public synchronized void kill(VcsCommandExecutor vcsCommandExecutor) {
        VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)this.commandsWrappers.get(vcsCommandExecutor);
        if (vcsCommandWrapper != null) {
            Thread thread = vcsCommandWrapper.getRunningThread();
            if (thread != null) {
                thread.interrupt();
            } else {
                ((AbstractCollection)this.commandsWaitQueue).remove(vcsCommandWrapper);
                vcsCommandWrapper.setInterrupted(true);
                this.commandDone(vcsCommandWrapper);
            }
        }
    }

    public void addCommandListener(CommandListener commandListener) {
        ArrayList arrayList = this.commandListeners;
        synchronized (arrayList) {
            this.commandListeners.add(commandListener);
        }
    }

    public void removeCommandListener(final CommandListener commandListener) {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                ArrayList arrayList = CommandsPool.this.commandListeners;
                synchronized (arrayList) {
                    ((AbstractCollection)CommandsPool.this.commandListeners).remove(commandListener);
                }
            }
        });
    }

    public long getStartTime(VcsCommandExecutor vcsCommandExecutor) {
        VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)this.commandsWrappers.get(vcsCommandExecutor);
        if (vcsCommandWrapper == null) {
            return 0L;
        }
        return vcsCommandWrapper.getStartTime();
    }

    public long getFinishTime(VcsCommandExecutor vcsCommandExecutor) {
        VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)this.commandsWrappers.get(vcsCommandExecutor);
        if (vcsCommandWrapper == null) {
            return 0L;
        }
        return vcsCommandWrapper.getFinishTime();
    }

    public long getExecutionTime(VcsCommandExecutor vcsCommandExecutor) {
        VcsCommandWrapper vcsCommandWrapper = (VcsCommandWrapper)this.commandsWrappers.get(vcsCommandExecutor);
        if (vcsCommandWrapper == null) {
            return 0L;
        }
        return vcsCommandWrapper.getExecutionTime();
    }

    public static String getExitStatusString(int n) {
        String string = 0 == n ? NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandsPool == null ? (class$org$netbeans$modules$vcscore$commands$CommandsPool = CommandsPool.class$("org.netbeans.modules.vcscore.commands.CommandsPool")) : class$org$netbeans$modules$vcscore$commands$CommandsPool)).getString("CommandExitStatus.success") : (1 == n ? NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandsPool == null ? (class$org$netbeans$modules$vcscore$commands$CommandsPool = CommandsPool.class$("org.netbeans.modules.vcscore.commands.CommandsPool")) : class$org$netbeans$modules$vcscore$commands$CommandsPool)).getString("CommandExitStatus.failed") : (2 == n ? NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandsPool == null ? (class$org$netbeans$modules$vcscore$commands$CommandsPool = CommandsPool.class$("org.netbeans.modules.vcscore.commands.CommandsPool")) : class$org$netbeans$modules$vcscore$commands$CommandsPool)).getString("CommandExitStatus.interrupted") : NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandsPool == null ? (class$org$netbeans$modules$vcscore$commands$CommandsPool = CommandsPool.class$("org.netbeans.modules.vcscore.commands.CommandsPool")) : class$org$netbeans$modules$vcscore$commands$CommandsPool)).getString("CommandExitStatus.unknown")));
        return string;
    }

    private String g(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandsPool == null ? (class$org$netbeans$modules$vcscore$commands$CommandsPool = CommandsPool.class$("org.netbeans.modules.vcscore.commands.CommandsPool")) : class$org$netbeans$modules$vcscore$commands$CommandsPool)).getString(string);
    }

    private String g(String string, Object object) {
        return MessageFormat.format(this.g(string), object);
    }

    private String g(String string, Object object, Object object2) {
        return MessageFormat.format(this.g(string), object, object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class VcsCommandWrapper {
        private static long lastId = 0L;
        private VcsCommandExecutor vce;
        private VcsFileSystem fileSystem;
        private long id;
        private Reference submittingThread;
        private Thread runningThread;
        private RuntimeCommand runtimeCommand;
        private boolean interrupted = false;
        private long startTime = 0L;
        private long finishTime = 0L;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandsPool$VcsCommandWrapper;

        public VcsCommandWrapper(VcsCommandExecutor vcsCommandExecutor, VcsFileSystem vcsFileSystem) {
            this.vce = vcsCommandExecutor;
            this.fileSystem = vcsFileSystem;
            Class clazz = class$org$netbeans$modules$vcscore$commands$CommandsPool$VcsCommandWrapper == null ? (class$org$netbeans$modules$vcscore$commands$CommandsPool$VcsCommandWrapper = VcsCommandWrapper.class$("org.netbeans.modules.vcscore.commands.CommandsPool$VcsCommandWrapper")) : class$org$netbeans$modules$vcscore$commands$CommandsPool$VcsCommandWrapper;
            synchronized (clazz) {
                this.id = lastId++;
            }
        }

        public VcsCommandExecutor getExecutor() {
            return this.vce;
        }

        public VcsFileSystem getFileSystem() {
            return this.fileSystem;
        }

        public long getCommandID() {
            return this.id;
        }

        public void setSubmittingThread(Thread thread) {
            this.submittingThread = new WeakReference<Thread>(thread);
        }

        public Thread getSubmittingThread() {
            return (Thread)this.submittingThread.get();
        }

        public void setRunningThread(Thread thread) {
            this.runningThread = thread;
        }

        public Thread getRunningThread() {
            return this.runningThread;
        }

        public void setRuntimeCommand(RuntimeCommand runtimeCommand) {
            this.runtimeCommand = runtimeCommand;
        }

        public RuntimeCommand getRuntimeCommand() {
            return this.runtimeCommand;
        }

        public void setInterrupted(boolean bl) {
            this.interrupted = bl;
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public void setStartTime(long l) {
            this.startTime = l;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setFinishTime(long l) {
            this.finishTime = l;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public long getExecutionTime() {
            if (this.startTime != 0L && this.finishTime != 0L) {
                return this.finishTime - this.startTime;
            }
            return 0L;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

