/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.diff;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vcscore.diff.DiffComponent;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.TopComponentCloseListener;
import org.openide.TopManager;
import org.openide.util.RequestProcessor;

public class AbstractDiff
implements Serializable {
    private Debug D = new Debug("AbstractDiff", true);
    private static final Color colorMissing = new Color(255, 160, 180);
    private static final Color colorAdded = new Color(180, 255, 180);
    private static final Color colorChanged = new Color(160, 200, 255);
    private String mimeType = null;
    private File file1 = null;
    private File file2 = null;
    private String title1 = null;
    private String title2 = null;
    private String mainTitle = null;
    private Vector diffActions = new Vector();
    private volatile transient DiffComponent diffFrame = null;
    private int currentDiffLine = -1;
    static final long serialVersionUID = 2364195735462564757L;

    protected DiffComponent createDiffComponent(AbstractDiff abstractDiff) {
        return new DiffComponent(abstractDiff);
    }

    boolean setDiffComponent(DiffComponent diffComponent) {
        this.diffFrame = diffComponent;
        if (this.mimeType != null) {
            diffComponent.setMimeType1(this.mimeType);
            diffComponent.setMimeType2(this.mimeType);
        }
        try {
            diffComponent.setFile1(this.file1);
            diffComponent.setFile2(this.file2);
        }
        catch (IOException iOException) {
            TopManager.getDefault().notifyException((Throwable)iOException);
            return false;
        }
        diffComponent.setFile1Title(this.title1);
        diffComponent.setFile2Title(this.title2);
        diffComponent.setName(this.mainTitle);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractDiff.this.insertEmptyLines(false);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        AbstractDiff.access$200(1.access$100(this.this$1), true);
                    }
                });
            }

            static /* synthetic */ AbstractDiff access$100(1 var0) {
                return var0.AbstractDiff.this;
            }
        });
        return true;
    }

    public void addAddAction(int n, int n2, int n3) {
        DiffAction diffAction = new DiffAction();
        diffAction.setAddAction(n, n2, n3);
        this.diffActions.add(diffAction);
    }

    public void addDeleteAction(int n, int n2, int n3) {
        DiffAction diffAction = new DiffAction();
        diffAction.setDeleteAction(n, n2, n3);
        this.diffActions.add(diffAction);
    }

    public void addChangeAction(int n, int n2, int n3, int n4) {
        DiffAction diffAction = new DiffAction();
        diffAction.setChangeAction(n, n2, n3, n4);
        this.diffActions.add(diffAction);
    }

    public int getNumActions() {
        return this.diffActions.size();
    }

    public void open(String string, String string2, final String string3, final String string4, final String string5, final String string6) {
        this.setTitle(string);
        this.setMIMEType(string2);
        RequestProcessor.Task task = RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                AbstractDiff.this.openEditors(string3, string4, string5, string6);
                AbstractDiff.this.insertEmptyLines(true);
                AbstractDiff.this.setDiffHighlight(true);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        AbstractDiff.access$500(3.access$400(this.this$1)).open();
                    }
                });
            }

            static /* synthetic */ AbstractDiff access$400(3 var0) {
                return var0.AbstractDiff.this;
            }
        });
    }

    public void addCloseListener(TopComponentCloseListener topComponentCloseListener) {
        if (this.diffFrame == null) {
            this.diffFrame = this.createDiffComponent(this);
        }
        this.diffFrame.addCloseListener(topComponentCloseListener);
    }

    private void setMIMEType(String string) {
        this.mimeType = string;
    }

    private void setTitle(String string) {
        this.mainTitle = string;
        if (this.diffFrame == null) {
            this.diffFrame = this.createDiffComponent(this);
        }
        this.diffFrame.setName(string);
    }

    private boolean openEditors(String string, String string2, final String string3, final String string4) {
        this.D.deb("I have MIME = " + this.mimeType);
        this.title1 = string3;
        this.title2 = string4;
        this.file1 = new File(string);
        this.file2 = new File(string2);
        if (this.diffFrame == null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        AbstractDiff.this.diffFrame = AbstractDiff.this.createDiffComponent(AbstractDiff.this);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
        }
        if (this.mimeType != null) {
            this.diffFrame.setMimeType1(this.mimeType);
            this.diffFrame.setMimeType2(this.mimeType);
        }
        try {
            this.diffFrame.setFile1(this.file1);
            this.diffFrame.setFile2(this.file2);
        }
        catch (IOException iOException) {
            TopManager.getDefault().notifyException((Throwable)iOException);
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractDiff.this.diffFrame.setFile1Title(string3);
                AbstractDiff.this.diffFrame.setFile2Title(string4);
            }
        });
        return true;
    }

    private void insertEmptyLines(boolean bl) {
        int n = this.diffActions.size();
        int n2 = 0;
        int n3 = 0;
        this.D.deb("insertEmptyLines():");
        int n4 = 0;
        while (n4 < n) {
            DiffAction diffAction = (DiffAction)this.diffActions.get(n4);
            int n5 = diffAction.getF1Line1() + n2;
            int n6 = diffAction.getF1Line2() + n2;
            int n7 = diffAction.getF2Line1() + n3;
            int n8 = diffAction.getF2Line2() + n3;
            this.D.deb("Action: " + diffAction.getAction() + ": (" + n5 + "," + n6 + "," + n7 + "," + n8 + ")");
            this.D.deb("ins1 = " + n2 + ", ins2 = " + n3);
            switch (diffAction.getAction()) {
                case 0: {
                    this.diffFrame.addEmptyLines2(n7, n6 - n5 + 1);
                    n3 += n6 - n5 + 1;
                    break;
                }
                case 2: {
                    this.diffFrame.addEmptyLines1(n5, n8 - n7 + 1);
                    n2 += n8 - n7 + 1;
                    break;
                }
                case 1: {
                    int n9 = n6 - n5;
                    int n10 = n8 - n7;
                    if (n9 < n10) {
                        this.diffFrame.addEmptyLines1(n6, n10 - n9);
                        n2 += n10 - n9;
                        break;
                    }
                    if (n9 <= n10) break;
                    this.diffFrame.addEmptyLines2(n8, n9 - n10);
                    n3 += n9 - n10;
                }
            }
            if (bl) {
                diffAction.setF1Line1(n5);
                diffAction.setF1Line2(n6);
                diffAction.setF2Line1(n7);
                diffAction.setF2Line2(n8);
            }
            ++n4;
        }
    }

    private void setDiffHighlight(boolean bl) {
        int n = this.diffActions.size();
        this.D.deb("Num Actions = " + n);
        int n2 = 0;
        while (n2 < n) {
            DiffAction diffAction = (DiffAction)this.diffActions.get(n2);
            int n3 = diffAction.getF1Line1();
            int n4 = diffAction.getF1Line2();
            int n5 = diffAction.getF2Line1();
            int n6 = diffAction.getF2Line2();
            this.D.deb("Action: " + diffAction.getAction() + ": (" + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
            switch (diffAction.getAction()) {
                case 0: {
                    if (bl) {
                        this.diffFrame.highlightRegion1(n3, n4, colorMissing);
                        break;
                    }
                    this.diffFrame.highlightRegion1(n3, n4, Color.white);
                    break;
                }
                case 2: {
                    if (bl) {
                        this.diffFrame.highlightRegion2(n5, n6, colorAdded);
                        break;
                    }
                    this.diffFrame.highlightRegion2(n5, n6, Color.white);
                    break;
                }
                case 1: {
                    if (bl) {
                        this.diffFrame.highlightRegion1(n3, n4, colorChanged);
                        this.diffFrame.highlightRegion2(n5, n6, colorChanged);
                        break;
                    }
                    this.diffFrame.highlightRegion1(n3, n4, Color.white);
                    this.diffFrame.highlightRegion2(n5, n6, Color.white);
                }
            }
            ++n2;
        }
    }

    private int getActionLine(int n) {
        DiffAction diffAction = (DiffAction)this.diffActions.get(n);
        int n2 = diffAction.getF1Line1();
        if (diffAction.getAction() == 2) {
            ++n2;
        }
        return n2;
    }

    int getNextDiffLine() {
        if (this.diffActions.size() <= 0) {
            return -1;
        }
        ++this.currentDiffLine;
        if (this.currentDiffLine >= this.diffActions.size()) {
            this.currentDiffLine = 0;
        }
        return this.getActionLine(this.currentDiffLine);
    }

    int getPrevDiffLine() {
        if (this.diffActions.size() <= 0) {
            return -1;
        }
        --this.currentDiffLine;
        if (this.currentDiffLine < 0) {
            this.currentDiffLine = this.diffActions.size() - 1;
        }
        return this.getActionLine(this.currentDiffLine);
    }

    int getCurrentDiffLength() {
        DiffAction diffAction = (DiffAction)this.diffActions.get(this.currentDiffLine);
        int n = diffAction.getF1Line2() - diffAction.getF1Line1() + 1;
        int n2 = diffAction.getF2Line2() - diffAction.getF2Line1() + 1;
        return Math.max(n, n2);
    }

    private final class DiffAction
    implements Serializable {
        public static final int DELETE = 0;
        public static final int CHANGE = 1;
        public static final int ADD = 2;
        private int action = 0;
        private int f1Line1 = 0;
        private int f1Line2 = 0;
        private int f2Line1 = 0;
        private int f2Line2 = 0;
        private static final long serialVersionUID = 7638200981188907148L;

        public void setDeleteAction(int n, int n2, int n3) {
            this.action = 0;
            this.f1Line1 = n;
            this.f1Line2 = n2;
            this.f2Line1 = n3;
        }

        public void setAddAction(int n, int n2, int n3) {
            this.action = 2;
            this.f1Line1 = n;
            this.f2Line1 = n2;
            this.f2Line2 = n3;
        }

        public void setChangeAction(int n, int n2, int n3, int n4) {
            this.action = 1;
            this.f1Line1 = n;
            this.f1Line2 = n2;
            this.f2Line1 = n3;
            this.f2Line2 = n4;
        }

        public int getAction() {
            return this.action;
        }

        public int getF1Line1() {
            return this.f1Line1;
        }

        public void setF1Line1(int n) {
            this.f1Line1 = n;
        }

        public int getF1Line2() {
            return this.f1Line2;
        }

        public void setF1Line2(int n) {
            this.f1Line2 = n;
        }

        public int getF2Line1() {
            return this.f2Line1;
        }

        public void setF2Line1(int n) {
            this.f2Line1 = n;
        }

        public int getF2Line2() {
            return this.f2Line2;
        }

        public void setF2Line2(int n) {
            this.f2Line2 = n;
        }
    }
}

