/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.diff;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.openide.text.NbDocument;

public class LinesComponent
extends JComponent {
    private JEditorPane editorPane;
    private Color backgroundColor;
    private Color foreColor;
    private Font font;
    private int lineHeight = 1;
    private float lineHeightCorrection = 1.0f;
    private boolean init = false;
    private int numberWidth;
    private boolean showLineNumbers = true;
    private static final int ENLARGE_GUTTER_HEIGHT = 300;
    private int highestLineNumber = 0;
    private Insets lineNumberMargin;
    private int lineNumberDigitWidth;
    private int lineAscent;
    private LinkedList linesList;
    private int activeLine = -1;
    private static final long serialVersionUID = -4861542695772182147L;

    public LinesComponent(JEditorPane jEditorPane) {
        this.editorPane = jEditorPane;
        this.font = this.editorPane.getFont();
        this.foreColor = this.editorPane.getForeground();
        this.backgroundColor = this.editorPane.getBackground();
        this.setLineNumberDigitWidth(10);
        this.setLineNumberMargin(new Insets(2, 2, 2, 4));
        this.init();
        this.update();
    }

    protected void init() {
        this.createLines();
    }

    private void createLines() {
        this.linesList = new LinkedList();
        StyledDocument styledDocument = (StyledDocument)this.editorPane.getDocument();
        int n = styledDocument.getEndPosition().getOffset();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = 0;
        while (n3 < n2) {
            this.linesList.add("" + (n3 + 1));
            ++n3;
        }
    }

    public void addEmptyLines(int n, int n2) {
        boolean bl = false;
        if (n > this.linesList.size()) {
            bl = true;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (bl) {
                this.linesList.add("");
            } else {
                this.linesList.add(n, "");
            }
            ++n3;
        }
    }

    public void update() {
        Class<?> clazz = this.editorPane.getEditorKit().getClass();
        Object object = Settings.getValue(clazz, (String)"line-height-correction");
        if (!(object instanceof Float) || ((Float)object).floatValue() < 0.0f) {
            object = SettingsDefaults.defaultLineHeightCorrection;
        }
        this.lineHeightCorrection = ((Float)object).floatValue();
        Object object2 = Settings.getValue(clazz, (String)"line-number");
        Coloring coloring = null;
        coloring = object2 != null && object2 instanceof Coloring ? (Coloring)object2 : SettingsDefaults.defaultLineNumberColoring;
        this.foreColor = coloring.getForeColor();
        this.backgroundColor = coloring.getBackColor();
        this.font = this.editorPane.getFont();
        FontMetrics fontMetrics = ((Component)this.editorPane).getFontMetrics(this.font);
        int n = 1;
        int n2 = 0;
        if (fontMetrics != null) {
            n = Math.max(n, fontMetrics.getHeight());
            n2 = Math.max(n2, fontMetrics.getAscent());
        }
        this.lineHeight = (int)((float)n * this.lineHeightCorrection);
        this.lineAscent = (int)((float)n2 * this.lineHeightCorrection);
        this.showLineNumbers = true;
        this.init = true;
        if (this.highestLineNumber <= this.getLineCount()) {
            this.highestLineNumber = this.getLineCount();
        }
        int n3 = 1;
        char[] cArray = new char[1];
        int n4 = 0;
        while (n4 <= 9) {
            cArray[0] = (char)(48 + n4);
            n3 = Math.max(n3, fontMetrics.charsWidth(cArray, 0, 1));
            ++n4;
        }
        this.setLineNumberDigitWidth(n3);
        this.resize();
    }

    protected void resize() {
        Dimension dimension = new Dimension();
        dimension.width = this.getWidthDimension();
        dimension.height = this.getHeightDimension();
        dimension.height += 300 * this.lineHeight;
        this.numberWidth = this.getLineNumberWidth();
        this.setPreferredSize(dimension);
        this.revalidate();
    }

    protected int getLineCount() {
        return this.linesList.size();
    }

    protected int getDigitCount(int n) {
        return Integer.toString(n).length();
    }

    protected int getLineNumberWidth() {
        int n = 0;
        Insets insets = this.getLineNumberMargin();
        if (insets != null) {
            n += insets.left + insets.right;
        }
        return n += (this.getDigitCount(this.highestLineNumber) + 1) * this.getLineNumberDigitWidth();
    }

    protected int getWidthDimension() {
        int n = 0;
        if (this.showLineNumbers) {
            n += this.getLineNumberWidth();
        }
        return n;
    }

    protected int getHeightDimension() {
        return this.highestLineNumber * this.lineHeight;
    }

    /*
     * Unable to fully structure code
     */
    public void paintComponent(Graphics var1_1) {
        super.paintComponent(var1_1);
        this.update();
        if (!this.init) {
            return;
        }
        var2_2 = var1_1.getClipBounds();
        var1_1.setColor(this.backgroundColor);
        var1_1.fillRect(var2_2.x, var2_2.y, var2_2.width, var2_2.height);
        var1_1.setFont(this.font);
        var1_1.setColor(this.foreColor);
        var3_3 = FontMetricsCache.getFontMetrics((Font)this.font, (Component)this);
        var4_4 = 0;
        var5_5 = this.getLineNumberMargin();
        if (var5_5 != null) {
            var4_4 = var5_5.right;
        }
        if ((var6_6 = (int)((float)var2_2.y / (float)this.lineHeight)) > 0) {
            --var6_6;
        }
        var7_7 = var6_6 * this.lineHeight;
        if (!this.showLineNumbers || (var8_8 = (int)((float)(var2_2.y + var2_2.height) / (float)this.lineHeight) + 1) <= this.highestLineNumber) ** GOTO lbl38
        var9_10 = this.highestLineNumber;
        this.highestLineNumber = var8_8;
        if (this.getDigitCount(this.highestLineNumber) <= this.getDigitCount(var9_10)) ** GOTO lbl38
        this.resize();
        return;
lbl-1000:
        // 1 sources

        {
            if (this.showLineNumbers) {
                var8_9 = null;
                if (var6_6 < this.linesList.size()) {
                    var8_9 = (String)this.linesList.get(var6_6);
                }
                if (var8_9 == null) {
                    var8_9 = "";
                }
                var9_11 = "*";
                var10_12 = var3_3.stringWidth(var8_9);
                if (var6_6 == this.activeLine - 1) {
                    var8_9 = var8_9 + var9_11;
                }
                var11_13 = var3_3.stringWidth(var9_11);
                var1_1.drawString(var8_9, this.numberWidth - (var10_12 += var11_13) - var4_4, var7_7 + this.getLineAscent());
            }
            var7_7 += this.lineHeight;
            ++var6_6;
lbl38:
            // 3 sources

            ** while (var7_7 + this.lineHeight / 2 <= var2_2.y + var2_2.height)
        }
lbl39:
        // 1 sources

    }

    public void changedLine(int n) {
        if (!this.init) {
            return;
        }
        if (n > 0) {
            --n;
        }
        int n2 = n * this.lineHeight;
        this.repaint(0, n2, (int)this.getSize().getWidth(), 3 * this.lineHeight);
        this.checkSize();
    }

    public void changedAll() {
        if (!this.init) {
            return;
        }
        this.repaint();
        this.checkSize();
    }

    protected void checkSize() {
        int n = this.getLineCount();
        if (n > this.highestLineNumber) {
            this.highestLineNumber = n;
        }
        Dimension dimension = this.getPreferredSize();
        if (this.getWidthDimension() > dimension.width || this.getHeightDimension() > dimension.height) {
            this.resize();
        }
    }

    public Insets getLineNumberMargin() {
        return this.lineNumberMargin;
    }

    public void setLineNumberMargin(Insets insets) {
        this.lineNumberMargin = insets;
    }

    public int getLineNumberDigitWidth() {
        return this.lineNumberDigitWidth;
    }

    public void setLineNumberDigitWidth(int n) {
        this.lineNumberDigitWidth = n;
    }

    public int getLineAscent() {
        return this.lineAscent;
    }

    public void setLineAscent(int n) {
        this.lineAscent = n;
    }

    public int getActiveLine() {
        return this.activeLine;
    }

    public void setActiveLine(int n) {
        this.activeLine = n;
    }
}

