/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.revision;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.revision.RevisionAction;
import org.netbeans.modules.vcscore.revision.RevisionChildren;
import org.netbeans.modules.vcscore.revision.RevisionItem;
import org.netbeans.modules.vcscore.revision.RevisionList;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class RevisionNode
extends AbstractNode
implements OpenCookie,
Serializable {
    private static final String ICON_BRANCH = "/org/netbeans/modules/vcscore/revision/branchIcon";
    private static final String ICON_REVISION = "/org/netbeans/modules/vcscore/revision/revisionIcon";
    private static final String ICON_REVISION_CURRENT = "/org/netbeans/modules/vcscore/revision/revisionCurrentIcon";
    private String fileName = "Class.java";
    private RevisionItem item = null;
    private RevisionList list = null;
    private boolean fileNode = false;
    private static final long serialVersionUID = -5482439280257546236L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$revision$RevisionNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$revision$RevisionAction;

    public RevisionNode(RevisionList revisionList) {
        super((Children)new RevisionChildren(revisionList));
        ((RevisionChildren)this.getChildren()).setNode(this);
        this.init(revisionList, null);
    }

    public RevisionNode(RevisionChildren revisionChildren) {
        super((Children)revisionChildren);
        this.init(revisionChildren.getList(), null);
    }

    public RevisionNode(RevisionList revisionList, RevisionItem revisionItem) {
        super(Children.LEAF);
        this.setName(revisionItem.getRevisionVCS());
        this.init(revisionList, revisionItem);
    }

    private void init(RevisionList revisionList, RevisionItem revisionItem) {
        this.list = revisionList;
        this.item = revisionItem;
        this.addCookies();
        this.setIcon();
    }

    public RevisionNode createInstance(RevisionList revisionList, RevisionItem revisionItem) {
        return new RevisionNode(revisionList, revisionItem);
    }

    public RevisionNode createInstance(RevisionChildren revisionChildren) {
        return new RevisionNode(revisionChildren);
    }

    private void addCookies() {
        if (!this.isFileNode() && this.item != null && !this.item.isBranch()) {
            this.getCookieSet().add((Node.Cookie)this);
        }
    }

    private void setIcon() {
        if (!this.isFileNode()) {
            if (this.item != null && !this.item.isBranch()) {
                if (this.item.isCurrent()) {
                    this.setIconBase(ICON_REVISION_CURRENT);
                } else {
                    this.setIconBase(ICON_REVISION);
                }
            } else {
                this.setIconBase(ICON_BRANCH);
            }
        } else {
            this.setIconBase(ICON_BRANCH);
        }
    }

    public void refreshIcons() {
        this.setIcon();
        this.fireIconChange();
        Enumeration enumeration = this.getChildren().nodes();
        while (enumeration.hasMoreElements()) {
            ((RevisionNode)enumeration.nextElement()).refreshIcons();
        }
    }

    public void setItem(RevisionItem revisionItem) {
        this.item = revisionItem;
        this.addCookies();
        this.setIcon();
    }

    public RevisionItem getItem() {
        return this.item;
    }

    public void setFileNode(boolean bl) {
        this.fileNode = bl;
        this.setIcon();
    }

    protected boolean isFileNode() {
        return this.fileNode;
    }

    public String getType() {
        if (this.item == null || this.item.isBranch()) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$revision$RevisionNode == null ? (class$org$netbeans$modules$vcscore$revision$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.revision.RevisionNode")) : class$org$netbeans$modules$vcscore$revision$RevisionNode)).getString("CTL_TypeBranch");
        }
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$revision$RevisionNode == null ? (class$org$netbeans$modules$vcscore$revision$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.revision.RevisionNode")) : class$org$netbeans$modules$vcscore$revision$RevisionNode)).getString("CTL_TypeRevision");
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        if (this.item == null || this.isFileNode()) {
            set.put((Node.Property)new PropertySupport.Name((Node)this));
        }
        if (this.item != null) {
            this.createProperties(this.item, set);
        }
        return sheet;
    }

    private void createProperties(final RevisionItem revisionItem, Sheet.Set set) {
        String[] stringArray;
        if (revisionItem.getRevision() != null) {
            set.put((Node.Property)new PropertySupport.ReadOnly("revision", class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$revision$RevisionNode == null ? (class$org$netbeans$modules$vcscore$revision$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.revision.RevisionNode")) : class$org$netbeans$modules$vcscore$revision$RevisionNode)).getString("MSG_RevisionNumber"), ""){

                public Object getValue() {
                    return revisionItem.getRevisionVCS();
                }
            });
        }
        if (revisionItem.getMessage() != null) {
            set.put((Node.Property)new PropertySupport.ReadOnly("message", class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$revision$RevisionNode == null ? (class$org$netbeans$modules$vcscore$revision$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.revision.RevisionNode")) : class$org$netbeans$modules$vcscore$revision$RevisionNode)).getString("MSG_Message"), ""){

                public Object getValue() {
                    return revisionItem.getMessage();
                }
            });
        }
        if (revisionItem.getDate() != null) {
            set.put((Node.Property)new PropertySupport.ReadOnly("date", class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$revision$RevisionNode == null ? (class$org$netbeans$modules$vcscore$revision$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.revision.RevisionNode")) : class$org$netbeans$modules$vcscore$revision$RevisionNode)).getString("MSG_Date"), ""){

                public Object getValue() {
                    return revisionItem.getDate();
                }
            });
        }
        if (revisionItem.getAuthor() != null) {
            set.put((Node.Property)new PropertySupport.ReadOnly("author", class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$revision$RevisionNode == null ? (class$org$netbeans$modules$vcscore$revision$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.revision.RevisionNode")) : class$org$netbeans$modules$vcscore$revision$RevisionNode)).getString("MSG_Author"), ""){

                public Object getValue() {
                    return revisionItem.getAuthor();
                }
            });
        }
        Hashtable hashtable = revisionItem.getAdditionalProperties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray = (String)enumeration.nextElement();
            final String string = (String)hashtable.get(stringArray);
            set.put((Node.Property)new PropertySupport.ReadOnly("additional_" + (String)stringArray, class$java$lang$String == null ? RevisionNode.class$("java.lang.String") : class$java$lang$String, (String)stringArray, ""){

                public Object getValue() {
                    return string;
                }
            });
        }
        stringArray = revisionItem.getTagNames();
        if (stringArray != null && stringArray.length > 0) {
            set.put((Node.Property)new PropertySupport.ReadOnly("tag", class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, stringArray.length > 1 ? NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$revision$RevisionNode == null ? (class$org$netbeans$modules$vcscore$revision$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.revision.RevisionNode")) : class$org$netbeans$modules$vcscore$revision$RevisionNode)).getString("MSG_TagNames") : NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$revision$RevisionNode == null ? (class$org$netbeans$modules$vcscore$revision$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.revision.RevisionNode")) : class$org$netbeans$modules$vcscore$revision$RevisionNode)).getString("MSG_TagName"), ""){

                public Object getValue() {
                    String string = VcsUtilities.arrayToString(stringArray);
                    return string.substring(1, string.length() - 1);
                }
            });
        }
    }

    public FileSystem getFileSystem() {
        return this.list.getFileSystem();
    }

    public FileObject getFileObject() {
        return this.list.getFileObject();
    }

    public SystemAction[] getActions() {
        SystemAction[] systemActionArray;
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>();
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.getFileSystem();
        if (this.isFileNode()) {
            systemActionArray = vcsFileSystem.getActions(Collections.singleton(this.list.getFileObject()));
            if (systemActionArray != null) {
                int n = 0;
                while (n < systemActionArray.length) {
                    arrayList.add(systemActionArray[n]);
                    ++n;
                }
            }
            arrayList.add(null);
            arrayList.add(SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = RevisionNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)));
        } else {
            arrayList.add(SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = RevisionNode.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)));
            arrayList.add(null);
            arrayList.add(SystemAction.get((Class)(class$org$netbeans$modules$vcscore$revision$RevisionAction == null ? (class$org$netbeans$modules$vcscore$revision$RevisionAction = RevisionNode.class$("org.netbeans.modules.vcscore.revision.RevisionAction")) : class$org$netbeans$modules$vcscore$revision$RevisionAction)));
            arrayList.add(null);
            arrayList.add(SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = RevisionNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)));
        }
        systemActionArray = new SystemAction[arrayList.size()];
        arrayList.toArray(systemActionArray);
        return systemActionArray;
    }

    public void open() {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.getFileSystem();
        RevisionAction.openAction(this.item.getRevisionVCS(), vcsFileSystem, this.getFileObject());
    }

    private String g(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$revision$RevisionNode == null ? (class$org$netbeans$modules$vcscore$revision$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.revision.RevisionNode")) : class$org$netbeans$modules$vcscore$revision$RevisionNode)).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

