/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.runtime;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.runtime.RuntimeFolderNode;
import org.netbeans.modules.vcscore.runtime.RuntimeSupport;
import org.openide.TopManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryAdapter;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Utilities;

public class RuntimeMainChildren
extends Children.Keys {
    private static final String NUM_OF_FINISHED_CMDS_TO_COLLECT_CHANGED_METHOD = "numOfFinishedCmdsToCollectChanged";
    private LinkedList fsList = new LinkedList();

    public RuntimeMainChildren() {
        Repository repository = TopManager.getDefault().getRepository();
        Enumeration enumeration = repository.getFileSystems();
        while (enumeration.hasMoreElements()) {
            BeanDescriptor beanDescriptor;
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            boolean bl = this.checkFileSystem(fileSystem, beanDescriptor = RuntimeMainChildren.getFsBeanDescriptor(fileSystem));
            if (!bl) continue;
            this.fsList.add(fileSystem);
        }
        repository.addRepositoryListener((RepositoryListener)new RuntimeRepositoryListener());
    }

    protected void addNotify() {
        this.setKeys(this.getFileSystems());
        RuntimeSupport.getInstance().setMainChildren(this);
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        RuntimeSupport.getInstance().setMainChildren(null);
    }

    private void refreshAll() {
        this.setKeys(this.getFileSystems());
    }

    private Collection getFileSystems() {
        return this.fsList;
    }

    protected Node[] createNodes(Object object) {
        FileSystem fileSystem = (FileSystem)object;
        if (this.fsList.contains(fileSystem)) {
            RuntimeFolderNode runtimeFolderNode = this.createFolderNode(fileSystem);
            return new Node[]{runtimeFolderNode};
        }
        return new Node[0];
    }

    private RuntimeFolderNode createFolderNode(FileSystem fileSystem) {
        String string;
        Index.ArrayChildren arrayChildren = new Index.ArrayChildren();
        RuntimeFolderNode runtimeFolderNode = new RuntimeFolderNode((Children)arrayChildren);
        runtimeFolderNode.setName(fileSystem.getSystemName());
        runtimeFolderNode.setDisplayName(fileSystem.getDisplayName());
        this.propagateProperty(runtimeFolderNode, fileSystem);
        BeanDescriptor beanDescriptor = RuntimeMainChildren.getFsBeanDescriptor(fileSystem);
        if (beanDescriptor != null && (string = (String)beanDescriptor.getValue("VCS Icon Base")) != null) {
            runtimeFolderNode.setIconBase(string);
        }
        RuntimeSupport.getInstance().addScheduledRuntimeNodeCommands(runtimeFolderNode, fileSystem.getSystemName());
        return runtimeFolderNode;
    }

    private void propagateProperty(RuntimeFolderNode runtimeFolderNode, FileSystem fileSystem) {
        Method method = null;
        try {
            method = fileSystem.getClass().getMethod(NUM_OF_FINISHED_CMDS_TO_COLLECT_CHANGED_METHOD, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (SecurityException securityException) {
            method = null;
        }
        final Method method2 = method;
        if (method2 == null) {
            return;
        }
        final WeakReference<FileSystem> weakReference = new WeakReference<FileSystem>(fileSystem);
        final WeakReference<RuntimeFolderNode> weakReference2 = new WeakReference<RuntimeFolderNode>(runtimeFolderNode);
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("numOfFinishedCmdsToCollect".equals(propertyChangeEvent.getPropertyName())) {
                    Object t = weakReference.get();
                    if (t != null) {
                        try {
                            method2.invoke(t, new Object[0]);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                    } else {
                        RuntimeFolderNode runtimeFolderNode = (RuntimeFolderNode)((Object)weakReference2.get());
                        if (runtimeFolderNode != null) {
                            runtimeFolderNode.removePropertyChangeListener(this);
                        }
                    }
                }
            }
        };
        runtimeFolderNode.addPropertyChangeListener(propertyChangeListener);
        runtimeFolderNode.addNodeListener(new NodeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            }

            public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            }

            public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            }

            public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            }

            public void nodeDestroyed(NodeEvent nodeEvent) {
                RuntimeFolderNode runtimeFolderNode = (RuntimeFolderNode)((Object)weakReference2.get());
                if (runtimeFolderNode != null) {
                    runtimeFolderNode.removeNodeListener(this);
                    runtimeFolderNode.removePropertyChangeListener(propertyChangeListener);
                }
            }
        });
    }

    private boolean checkFileSystem(FileSystem fileSystem, BeanDescriptor beanDescriptor) {
        VcsFileSystem vcsFileSystem;
        if (beanDescriptor == null) {
            return false;
        }
        if (fileSystem instanceof MultiFileSystem) {
            return false;
        }
        Object object = beanDescriptor.getValue("VCS Provider");
        Boolean bl = object instanceof Boolean ? (Boolean)object : Boolean.FALSE;
        if (bl.booleanValue() && fileSystem instanceof VcsFileSystem && !(vcsFileSystem = (VcsFileSystem)fileSystem).isCreateRuntimeCommands()) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    static BeanDescriptor getFsBeanDescriptor(FileSystem fileSystem) {
        BeanInfo beanInfo;
        try {
            beanInfo = Utilities.getBeanInfo(fileSystem.getClass());
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        if (beanInfo != null) {
            return beanInfo.getBeanDescriptor();
        }
        return null;
    }

    public class RuntimeRepositoryListener
    extends RepositoryAdapter {
        public void fileSystemAdded(RepositoryEvent repositoryEvent) {
            BeanDescriptor beanDescriptor;
            FileSystem fileSystem = repositoryEvent.getFileSystem();
            boolean bl = RuntimeMainChildren.this.checkFileSystem(fileSystem, beanDescriptor = RuntimeMainChildren.getFsBeanDescriptor(fileSystem));
            if (bl) {
                RuntimeMainChildren.this.fsList.add(fileSystem);
                RuntimeMainChildren.super.setKeys(RuntimeMainChildren.this.fsList);
            }
        }

        public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
            super.fileSystemPoolReordered(repositoryReorderedEvent);
        }

        public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
            FileSystem fileSystem = repositoryEvent.getFileSystem();
            BeanDescriptor beanDescriptor = RuntimeMainChildren.getFsBeanDescriptor(fileSystem);
            boolean bl = RuntimeMainChildren.this.checkFileSystem(repositoryEvent.getFileSystem(), beanDescriptor);
            if (bl) {
                RuntimeMainChildren.this.fsList.remove(fileSystem);
                RuntimeSupport.getInstance().runtimeFolderRemoved(fileSystem.getSystemName());
                RuntimeMainChildren.super.setKeys(RuntimeMainChildren.this.fsList);
            }
        }
    }
}

