/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.runtime;

import java.util.Date;
import org.netbeans.modules.vcscore.commands.CommandsPool;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.runtime.CommandOutputViewAction;
import org.netbeans.modules.vcscore.runtime.KillRunningCommandAction;
import org.netbeans.modules.vcscore.runtime.RuntimeCommand;
import org.netbeans.modules.vcscore.runtime.RuntimeSupport;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class VcsRuntimeCommand
extends RuntimeCommand {
    private VcsCommandExecutor executor;
    private CommandsPool pool;
    private int state;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$runtime$VcsRuntimeCommand;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public VcsRuntimeCommand(VcsCommandExecutor vcsCommandExecutor, CommandsPool commandsPool) {
        this.executor = vcsCommandExecutor;
        this.pool = commandsPool;
        this.state = 10;
    }

    public String getName() {
        return this.executor.getCommand().getName();
    }

    public String getDisplayName() {
        return this.executor.getCommand().getDisplayName();
    }

    public int getExitStatus() {
        return this.executor.getExitStatus();
    }

    public void openCommandOutputDisplay() {
        this.pool.openCommandOutput(this.executor);
    }

    public Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        this.createProperties(set);
        return sheet;
    }

    private void createProperties(Sheet.Set set) {
        set.put((Node.Property)new PropertySupport.ReadOnly("name", class$java$lang$String == null ? (class$java$lang$String = VcsRuntimeCommand.class$("java.lang.String")) : class$java$lang$String, this.g("CTL_Name"), this.g("HINT_Name")){

            public Object getValue() {
                return VcsRuntimeCommand.this.executor.getCommand().getName();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("exec", class$java$lang$String == null ? (class$java$lang$String = VcsRuntimeCommand.class$("java.lang.String")) : class$java$lang$String, this.g("CTL_Exec"), this.g("HINT_Exec")){

            public Object getValue() {
                return VcsRuntimeCommand.this.executor.getExec();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("files", class$java$lang$String == null ? (class$java$lang$String = VcsRuntimeCommand.class$("java.lang.String")) : class$java$lang$String, this.g("CTL_Files"), this.g("HINT_Files")){

            public Object getValue() {
                String[] stringArray = VcsRuntimeCommand.this.executor.getFiles().toArray(new String[0]);
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].length() == 0) {
                        stringArray[n] = ".";
                    }
                    ++n;
                }
                return VcsUtilities.array2stringNl(stringArray);
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("status", class$java$lang$String == null ? (class$java$lang$String = VcsRuntimeCommand.class$("java.lang.String")) : class$java$lang$String, this.g("CTL_Status"), this.g("HINT_Status")){

            public Object getValue() {
                if (VcsRuntimeCommand.this.pool.isWaiting(VcsRuntimeCommand.this.executor)) {
                    return VcsRuntimeCommand.this.g("CTL_Status_Waiting");
                }
                if (VcsRuntimeCommand.this.pool.isRunning(VcsRuntimeCommand.this.executor)) {
                    if (VcsRuntimeCommand.this.state == 14) {
                        return VcsRuntimeCommand.this.g("CTL_Status_Killed_But_Running");
                    }
                    return VcsRuntimeCommand.this.g("CTL_Status_Running");
                }
                return CommandsPool.getExitStatusString(VcsRuntimeCommand.this.executor.getExitStatus());
            }
        });
        if (Boolean.getBoolean("netbeans.vcsdebug")) {
            set.put((Node.Property)new PropertySupport.ReadOnly("startTime", class$java$lang$String == null ? (class$java$lang$String = VcsRuntimeCommand.class$("java.lang.String")) : class$java$lang$String, "Start Time", null){

                public Object getValue() {
                    long l = VcsRuntimeCommand.this.pool.getStartTime(VcsRuntimeCommand.this.executor);
                    if (l == 0L) {
                        return null;
                    }
                    return new Date(l).toLocaleString();
                }
            });
            set.put((Node.Property)new PropertySupport.ReadOnly("finishTime", class$java$lang$String == null ? (class$java$lang$String = VcsRuntimeCommand.class$("java.lang.String")) : class$java$lang$String, "Finish Time", null){

                public Object getValue() {
                    long l = VcsRuntimeCommand.this.pool.getFinishTime(VcsRuntimeCommand.this.executor);
                    if (l == 0L) {
                        return null;
                    }
                    return new Date(l).toLocaleString();
                }
            });
            set.put((Node.Property)new PropertySupport.ReadOnly("executionTime", class$java$lang$String == null ? (class$java$lang$String = VcsRuntimeCommand.class$("java.lang.String")) : class$java$lang$String, "Execution Time", null){

                public Object getValue() {
                    long l = VcsRuntimeCommand.this.pool.getExecutionTime(VcsRuntimeCommand.this.executor);
                    if (l == 0L) {
                        return null;
                    }
                    long l2 = l;
                    int n = (int)(l - l / 1000L * 1000L);
                    int n2 = (int)((l /= 1000L) - l / 60L * 60L);
                    int n3 = (int)((l /= 60L) - l / 60L * 60L);
                    int n4 = (int)((l /= 60L) - l / 24L * 24L);
                    int n5 = (int)(l /= 24L);
                    return l2 + " ms = " + n5 + "d " + n4 + "h " + n3 + "min " + n2 + "s " + n + "ms";
                }
            });
        }
    }

    private String g(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$runtime$VcsRuntimeCommand == null ? (class$org$netbeans$modules$vcscore$runtime$VcsRuntimeCommand = VcsRuntimeCommand.class$("org.netbeans.modules.vcscore.runtime.VcsRuntimeCommand")) : class$org$netbeans$modules$vcscore$runtime$VcsRuntimeCommand)).getString(string);
    }

    public SystemAction[] getActions() {
        return new SystemAction[]{CommandOutputViewAction.getInstance(), KillRunningCommandAction.getInstance(), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = VcsRuntimeCommand.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public String getId() {
        VcsCommandExecutor vcsCommandExecutor = this.executor;
        return Integer.toString(vcsCommandExecutor.hashCode());
    }

    public void killCommand() {
        this.pool.kill(this.executor);
        this.state = 14;
        RuntimeSupport.getInstance().findRuntimeNode(this).setState(this.state);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public void notifyRemoved() {
        this.pool.removeFinishedCommand(this.executor);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

