/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.settings;

import java.io.File;
import java.util.LinkedList;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class GeneralVcsSettings
extends SystemOption {
    public static final String PROP_USE_GLOBAL = "useGlobal";
    public static final String PROP_OFFLINE = "offLine";
    public static final String PROP_AUTO_REFRESH = "autoRefresh";
    public static final String PROP_HOME = "home";
    public static final String PROP_HIDE_SHADOW_FILES = "hideShadowFiles";
    public static final String PROP_LAST_DIRECTORIES = "wizardDirectoryCache";
    public static final String PROP_CVS_COMMAND_PATH = "wizardCvsCommandPath";
    public static final String PROP_SH_COMMAND_PATH = "wizardShellCommandPath";
    public static final String PROP_SSH_WARNINGS_DONE = "wizardSshWarningsDone";
    public static final String PROP_AUTO_DETECT = "autoDetect";
    public static final int AUTO_REFRESH_NO_REFRESH = 0;
    public static final int AUTO_REFRESH_ON_DIR_OPEN = 1;
    public static final int AUTO_REFRESH_ON_MOUNT = 2;
    public static final int AUTO_REFRESH_ON_RESTART = 3;
    public static final int AUTO_REFRESH_ON_MOUNT_AND_RESTART = 4;
    private static final String DEFAULT_CVS_EXEC = "cvs";
    private static final String DEFAULT_SHELL_EXEC = "sh";
    private static String wizardCvsCommandPath;
    private static String wizardShellCommandPath;
    static final long serialVersionUID = -3279219340064367270L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$settings$VcsSettings;

    protected void initialize() {
        super.initialize();
        this.setAutoDetect(true);
        this.setAutoRefresh(1);
        this.setHideShadowFiles(false);
        this.setOffLine(false);
        this.setUseGlobal(true);
        this.setWizardSshWarningsDone(false);
    }

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$settings$VcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$VcsSettings = GeneralVcsSettings.class$("org.netbeans.modules.vcscore.settings.VcsSettings")) : class$org$netbeans$modules$vcscore$settings$VcsSettings)).getString("CTL_VcsSettings");
    }

    public boolean isUseGlobal() {
        return (Boolean)this.getProperty(PROP_USE_GLOBAL);
    }

    public void setUseGlobal(boolean bl) {
        this.putProperty(PROP_USE_GLOBAL, new Boolean(bl), true);
    }

    public boolean isOffLine() {
        return (Boolean)this.getProperty(PROP_OFFLINE);
    }

    public void setOffLine(boolean bl) {
        this.putProperty(PROP_OFFLINE, new Boolean(bl), true);
    }

    public int getAutoRefresh() {
        return (Integer)this.getProperty(PROP_AUTO_REFRESH);
    }

    public void setAutoRefresh(int n) {
        this.putProperty(PROP_AUTO_REFRESH, new Integer(n), true);
    }

    public boolean isAutoDetect() {
        return (Boolean)this.getProperty(PROP_AUTO_DETECT);
    }

    public void setAutoDetect(boolean bl) {
        this.putProperty(PROP_AUTO_DETECT, new Boolean(bl), true);
    }

    public File getHome() {
        Object object;
        String string = System.getProperty("Env-HOME");
        if (string == null && Utilities.isWindows()) {
            object = System.getProperty("Env-HOMEDRIVE");
            String string2 = System.getProperty("Env-HOMEPATH");
            if (object != null && string2 != null) {
                string = (String)object + string2;
            }
        }
        if (string == null) {
            string = System.getProperty("user.home");
            object = new File(string);
            this.setHome((File)object);
            return object;
        }
        return new File(string);
    }

    public void setHome(File file) {
        int n;
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        System.setProperty("Env-HOME", string);
        System.setProperty("env-home", string.toLowerCase());
        if (Utilities.isWindows() && (n = string.indexOf(58)) > 0) {
            String string2 = string.substring(0, n + 1);
            String string3 = n + 1 < string.length() ? string.substring(n + 1) : "\\";
            System.setProperty("Env-HOMEDRIVE", string2);
            System.setProperty("env-homedrive", string2.toLowerCase());
            System.setProperty("Env-HOMEPATH", string3);
            System.setProperty("env-homepath", string3.toLowerCase());
        }
        this.firePropertyChange(PROP_HOME, null, file);
    }

    public void setHideShadowFiles(boolean bl) {
        this.putProperty(PROP_HIDE_SHADOW_FILES, new Boolean(bl), true);
    }

    public boolean isHideShadowFiles() {
        return (Boolean)this.getProperty(PROP_HIDE_SHADOW_FILES);
    }

    public LinkedList getWizardDirectoryCache() {
        Object[] objectArray = (Object[])this.getProperty(PROP_LAST_DIRECTORIES);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                linkedList.add(objectArray[n]);
                ++n;
            }
        }
        return linkedList;
    }

    public void setWizardDirectoryCache(LinkedList linkedList) {
        if (linkedList == null) {
            linkedList = new LinkedList();
        }
        this.putProperty(PROP_LAST_DIRECTORIES, linkedList.toArray());
        this.firePropertyChange(PROP_LAST_DIRECTORIES, null, linkedList.toArray());
    }

    public String getWizardCvsCommandPath() {
        if (wizardCvsCommandPath == null || wizardCvsCommandPath.length() == 0) {
            return DEFAULT_CVS_EXEC;
        }
        return wizardCvsCommandPath;
    }

    public void setWizardCvsCommandPath(String string) {
        wizardCvsCommandPath = string;
    }

    public String getWizardShellCommandPath() {
        if (wizardShellCommandPath == null || wizardShellCommandPath.length() == 0) {
            return DEFAULT_SHELL_EXEC;
        }
        return wizardShellCommandPath;
    }

    public void setWizardShellCommandPath(String string) {
        wizardShellCommandPath = string;
    }

    public void setWizardSshWarningsDone(boolean bl) {
        this.putProperty(PROP_SSH_WARNINGS_DONE, new Boolean(bl));
    }

    public boolean isWizardSshWarningsDone() {
        return (Boolean)this.getProperty(PROP_SSH_WARNINGS_DONE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

