/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.vcscore.util.TableMap;

public class TableSorter
extends TableMap {
    int[] indexes;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    int sortedColumn = -1;
    boolean keepSortedOnChanges = true;
    int compares;
    private static final long serialVersionUID = 6824746536363157563L;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;

    public TableSorter() {
        this.indexes = new int[0];
    }

    public TableSorter(TableModel tableModel) {
        this.setModel(tableModel);
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        Object object;
        String string;
        Class<?> clazz = this.model.getColumnClass(n3);
        TableModel tableModel = this.model;
        Object object2 = tableModel.getValueAt(n, n3);
        Object object3 = tableModel.getValueAt(n2, n3);
        if (object2 == null && object3 == null) {
            return 0;
        }
        if (object2 == null) {
            return -1;
        }
        if (object3 == null) {
            return 1;
        }
        if (clazz.getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = TableSorter.class$("java.lang.Number")) : class$java$lang$Number)) {
            Number number;
            double d;
            Number number2 = (Number)tableModel.getValueAt(n, n3);
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)tableModel.getValueAt(n2, n3)).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = TableSorter.class$("java.lang.String")) : class$java$lang$String)) {
            String string2;
            String string3 = (String)tableModel.getValueAt(n, n3);
            int n4 = string3.compareTo(string2 = (String)tableModel.getValueAt(n2, n3));
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        Object object4 = tableModel.getValueAt(n, n3);
        String string4 = object4.toString();
        int n5 = string4.compareTo(string = (object = tableModel.getValueAt(n2, n3)).toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int n, int n2) {
        ++this.compares;
        int n3 = 0;
        while (n3 < this.sortingColumns.size()) {
            Integer n4 = (Integer)this.sortingColumns.elementAt(n3);
            int n5 = this.compareRowsByColumn(n, n2, n4);
            if (n5 != 0) {
                return this.ascending ? n5 : -n5;
            }
            ++n3;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int n = this.model.getRowCount();
        this.indexes = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.indexes[n2] = n2;
            ++n2;
        }
        if (this.keepSortedOnChanges && this.sortedColumn >= 0) {
            this.sortByColumn(this.sortedColumn, this.ascending);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes();
        super.tableChanged(tableModelEvent);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            // empty if block
        }
    }

    public void sort(Object object) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        int n = 0;
        while (n < this.getRowCount()) {
            int n2 = n + 1;
            while (n2 < this.getRowCount()) {
                if (this.compare(this.indexes[n], this.indexes[n2]) == -1) {
                    this.swap(n, n2);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            int n6 = n;
            while (n6 < n2) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            return;
        }
        int n7 = n;
        while (n7 < n2) {
            nArray2[n7] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
            ++n7;
        }
    }

    public void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    public Object getValueAt(int n, int n2) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[n], n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        this.model.setValueAt(object, this.indexes[n], n2);
    }

    public int getModelRow(int n) {
        this.checkModel();
        return this.indexes[n];
    }

    public int getSorterRow(int n) {
        int n2 = 0;
        while (n2 < this.indexes.length) {
            if (this.indexes[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, true);
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortedColumn = n;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(n));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final TableSorter tableSorter = this;
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    int n3 = mouseEvent.getModifiers() & 1;
                    boolean bl = n3 == 0;
                    tableSorter.sortByColumn(n2, bl);
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

