/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.util.Debug;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

public class VcsUtilities {
    private Debug E;
    private Debug D;
    private static final String GET_BUNDLE = "getBundle(";
    private static final String SYSTEM_ENV_PREFIX = "Env-";
    private static HashMap systemEnvVariables = null;
    private static final Object systemEnvVariablesLock = new Object();

    public VcsUtilities() {
        this.D = this.E = new Debug("VcsUtilities", false);
    }

    public static int max3(int n, int n2, int n3) {
        return Math.max(Math.max(n, n2), n3);
    }

    public static int max7(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return VcsUtilities.max3(VcsUtilities.max3(n, n2, n3), VcsUtilities.max3(n4, n5, n6), n7);
    }

    public static boolean withinRange(int n, int n2, int n3) {
        return n <= n2 && n2 <= n3;
    }

    public static int getPairIndex(String string, int n, char c, char c2) {
        int n2 = string.length();
        int n3 = 1;
        int n4 = n;
        while (n4 < n2) {
            if (string.charAt(n4) == c) {
                ++n3;
            }
            if (string.charAt(n4) == c2) {
                --n3;
            }
            if (n3 == 0) break;
            ++n4;
        }
        if (n4 < n2) {
            return n4;
        }
        return -1;
    }

    public static int charCount(String string, char c) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == c) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public static String arrayToString(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                stringBuffer.append(stringArray[n]);
            }
            if (n < stringArray.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String array2string(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(255);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n] + " ");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static String array2stringNl(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n] + "\n");
                ++n;
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static String arrayToSpaceSeparatedString(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                stringBuffer.append(stringArray[n]);
            }
            if (n < stringArray.length - 1) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public static String arrayToQuotedString(String[] stringArray, boolean bl) {
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                stringBuffer.append("");
            } else {
                stringBuffer.append(VcsUtilities.msg2CmdlineStr(stringArray[n], bl));
            }
            if (n < stringArray.length - 1) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public static String arrayToQuotedStrings(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                stringBuffer.append("");
            } else {
                stringBuffer.append("\"" + stringArray[n] + "\"");
            }
            if (n < stringArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String replaceBackslashDollars(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '\\' || n2 >= n - 1 || '$' != string.charAt(n2 + 1)) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    public static String[] mergeArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        int n = stringArray.length;
        int n2 = stringArray2.length;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n + n2);
        int n3 = 0;
        while (n3 < n) {
            hashtable.put(stringArray[n3], stringArray[n3]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            hashtable.put(stringArray2[n4], stringArray2[n4]);
            ++n4;
        }
        int n5 = hashtable.size();
        String[] stringArray3 = new String[n5];
        int n6 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringArray3[n6++] = string;
        }
        return stringArray3;
    }

    public static String toSpaceSeparatedString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer(30);
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            stringBuffer.append(" " + e);
            ++n;
        }
        return new String(stringBuffer);
    }

    /*
     * Unable to fully structure code
     */
    private static String getQuotedString(String var0, int[] var1_1) {
        block7: {
            while (var1_1[0] < var0.length() && Character.isWhitespace(var0.charAt(var1_1[0]))) {
                var1_1[0] = var1_1[0] + 1;
            }
            if (var1_1[0] >= var0.length()) {
                return null;
            }
            var2_2 = new StringBuffer();
            if (var0.charAt(var1_1[0]) != '\"') ** GOTO lbl22
            var1_1[0] = var1_1[0] + 1;
            while (var1_1[0] < var0.length()) {
                if (var0.charAt(var1_1[0]) != '\"') {
                    var2_2.append(var0.charAt(var1_1[0]));
                } else {
                    if (var0.charAt(var1_1[0] - 1) != '\\') break block7;
                    var2_2.setCharAt(var2_2.length() - 1, '\"');
                }
                var1_1[0] = var1_1[0] + 1;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                var2_2.append(var0.charAt(var1_1[0]));
                var1_1[0] = var1_1[0] + 1;
lbl22:
                // 2 sources

                ** while (var1_1[0] < var0.length() && var0.charAt((int)var1_1[0]) != ',')
            }
        }
        return var2_2.toString();
    }

    public static String[] getQuotedStrings(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int[] nArray = new int[]{0};
        String string2 = VcsUtilities.getQuotedString(string, nArray);
        while (string2 != null) {
            linkedList.add(string2);
            while (nArray[0] < string.length() && string.charAt(nArray[0]) != ',') {
                nArray[0] = nArray[0] + 1;
            }
            nArray[0] = nArray[0] + 1;
            string2 = VcsUtilities.getQuotedString(string, nArray);
        }
        return linkedList.toArray(new String[0]);
    }

    public static boolean matchQuotedStringToSet(String string, Set set) {
        if (string != null && set != null) {
            String[] stringArray = VcsUtilities.getQuotedStrings(string);
            int n = 0;
            while (n < stringArray.length) {
                if (set.contains(stringArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static boolean areQuotedStringsContainedInSet(String string, Set set) {
        if (string != null && set != null) {
            String[] stringArray = VcsUtilities.getQuotedStrings(string);
            int n = 0;
            while (n < stringArray.length) {
                if (!set.contains(stringArray[n])) {
                    return false;
                }
                ++n;
            }
        } else {
            if (string != null) {
                return false;
            }
            if (set != null) {
                return true;
            }
        }
        return true;
    }

    public static boolean isSetContainedInQuotedStrings(String string, Set set) {
        if (string != null && set != null) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(VcsUtilities.getQuotedStrings(string)));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (hashSet.contains(iterator.next())) continue;
                return false;
            }
        } else {
            if (string != null) {
                return true;
            }
            if (set != null) {
                return false;
            }
        }
        return true;
    }

    public static String getBundleString(String string) {
        int n = string.indexOf(GET_BUNDLE);
        while (n >= 0) {
            int n2 = VcsUtilities.getPairIndex(string, n += GET_BUNDLE.length(), '(', ')');
            if (n2 >= 0) {
                int n3;
                String string2 = string.substring(n, n2);
                int n4 = string.indexOf(40, n2);
                if (n4 >= 0 && (n3 = VcsUtilities.getPairIndex(string, ++n4, '(', ')')) >= 0) {
                    String string3 = string.substring(n4, n3);
                    String string4 = VcsUtilities.getBundleString(string2, string3);
                    string = string.substring(0, n - GET_BUNDLE.length()) + string4 + string.substring(n3 + 1);
                    n = n - GET_BUNDLE.length() + string4.length();
                }
            }
            n = string.indexOf(GET_BUNDLE, n);
        }
        return string;
    }

    private static String getBundleString(String stringArray, String string) {
        Class<?> clazz;
        Object object;
        try {
            object = stringArray;
            if (object.endsWith(".class")) {
                object = object.substring(0, object.length() - ".class".length());
            }
            clazz = Class.forName((String)object, false, TopManager.getDefault().systemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        object = VcsUtilities.getQuotedStrings(string);
        Object[] objectArray = null;
        if (((String[])object).length > 0) {
            string = object[0];
            objectArray = new String[((String[])object).length - 1];
            System.arraycopy(object, 1, objectArray, 0, ((String[])object).length - 1);
        }
        String string2 = string;
        try {
            string2 = clazz != null ? NbBundle.getBundle(clazz).getString(string) : NbBundle.getBundle((String)stringArray, (Locale)Locale.getDefault(), (ClassLoader)TopManager.getDefault().currentClassLoader()).getString(string);
            if (objectArray != null) {
                string2 = MessageFormat.format(string2, objectArray);
            }
        }
        catch (MissingResourceException missingResourceException) {
            TopManager.getDefault().notifyException((Throwable)new Exception(){

                public String getLocalizedMessage() {
                    return "MissingResourceException:" + missingResourceException.getMessage();
                }
            });
        }
        return string2;
    }

    public static String getDirNamePart(String string) {
        String string2 = "";
        int n = string.lastIndexOf(47);
        string2 = n < 0 ? "" : string.substring(0, n);
        return string2;
    }

    public static String getFileNamePart(String string) {
        String string2 = "";
        int n = string.lastIndexOf(47);
        string2 = n < 0 ? string : string.substring(n + 1);
        return string2;
    }

    public static void centerWindow(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        ((Component)window).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public static boolean deleteRecursive(File file) {
        boolean bl = true;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                bl = fileArray[n].isDirectory() ? bl && VcsUtilities.deleteRecursive(fileArray[n]) : bl && fileArray[n].delete();
                ++n;
            }
        }
        bl = bl && file.delete();
        return bl;
    }

    public static void removeEnterFromKeymap(JTextField jTextField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = jTextField.getKeymap();
        keymap.removeKeyStrokeBinding(keyStroke);
    }

    public static int numChars(String string, char c) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if ((n2 = string.indexOf(c, n2 + 1)) < 0) break;
            ++n;
        }
        return n;
    }

    public static String msg2CmdlineStr(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        String string2 = Utilities.replaceString((String)string, (String)"\\", (String)"\\\\");
        string2 = bl ? Utilities.replaceString((String)string2, (String)"\"", (String)"\\\\\\\"\\\\\\\"") : Utilities.replaceString((String)string2, (String)"\"", (String)"\\\\\\\"");
        if (Utilities.isUnix() || bl) {
            string2 = Utilities.replaceString((String)string2, (String)"$", (String)"\\$");
            string2 = Utilities.replaceString((String)string2, (String)"`", (String)"\\`");
        }
        return string2;
    }

    public static void removeKeys(HashMap hashMap, HashMap hashMap2) {
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            hashMap.remove(iterator.next());
        }
    }

    public static Map getSystemEnvVars() {
        systemEnvVariables = new HashMap();
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(SYSTEM_ENV_PREFIX) || (string = System.getProperty(string2)) == null) continue;
            systemEnvVariables.put(string2.substring(SYSTEM_ENV_PREFIX.length()), string);
        }
        return systemEnvVariables;
    }

    public static Map addEnvVars(Map map, Hashtable hashtable, String string) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string) || (string2 = (String)hashtable.get(string3)) == null) continue;
            map.put(string3.substring(string.length()), string2);
        }
        return map;
    }

    public static Map addEnvVars(Map map, Hashtable hashtable, String string, String string2) {
        Object object;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith(string2)) continue;
            map.remove(((String)object).substring(string2.length()));
        }
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            String string3;
            String string4 = (String)object.nextElement();
            if (!string4.startsWith(string) || (string3 = (String)hashtable.get(string4)) == null) continue;
            map.put(string4.substring(string.length()), string3);
        }
        return map;
    }

    public static String[] getEnvString(Map map) {
        String[] stringArray = new String[map.size()];
        int n = 0;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringArray[n] = entry.getKey() + "=" + entry.getValue();
            ++n;
        }
        return stringArray;
    }

    public static ArrayList reorderFileObjects(Collection collection) {
        ArrayList arrayList = new ArrayList();
        TreeSet<FileObject> treeSet = new TreeSet<FileObject>(new FileObjectNameComparator());
        FileObject fileObject = null;
        DataObject dataObject = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof FileObject)) {
                arrayList.add(e);
                continue;
            }
            FileObject fileObject2 = (FileObject)e;
            DataObject dataObject2 = null;
            try {
                dataObject2 = DataObject.find((FileObject)fileObject2);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            if (dataObject2 == null) {
                arrayList.add(fileObject2);
                continue;
            }
            if (!dataObject2.equals(dataObject)) {
                if (fileObject != null) {
                    arrayList.add(fileObject);
                }
                arrayList.addAll(treeSet);
                fileObject = null;
                treeSet.clear();
                dataObject = dataObject2;
            }
            if (fileObject2.equals(dataObject2.getPrimaryFile())) {
                fileObject = fileObject2;
                continue;
            }
            treeSet.add(fileObject2);
        }
        if (fileObject != null) {
            arrayList.add(fileObject);
        }
        arrayList.addAll(treeSet);
        return arrayList;
    }

    public static File createTMP() {
        long l;
        String string = System.getProperty("netbeans.user") + File.separator + "system" + File.separator + "vcs" + File.separator + "tmp";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        do {
            l = 10000L * (1L + Math.round(Math.random() * 8.0)) + Math.round(Math.random() * 1000.0);
        } while (new File(string + File.separator + "tmp" + l).exists());
        file = new File(string = string + File.separator + "tmp" + l);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static String createUniqueName(String string, Collection collection) {
        String string2 = string;
        boolean bl = false;
        int n = 1;
        while (!bl) {
            if (!collection.contains(string2)) break;
            string2 = string + "_" + n;
            ++n;
        }
        return string2;
    }

    public static ArrayList createIgnoreList(CacheDir cacheDir, String string, VcsFileSystem.IgnoreListSupport ignoreListSupport) {
        CacheDir cacheDir2 = cacheDir.getParent();
        ArrayList arrayList = null;
        if (cacheDir2 == null) {
            arrayList = ignoreListSupport.createIgnoreList(string, ignoreListSupport.createInitialIgnoreList());
        } else {
            ArrayList arrayList2 = !cacheDir2.isIgnoreListSet() ? VcsUtilities.createIgnoreList(cacheDir2, VcsUtilities.getDirNamePart(string), ignoreListSupport) : cacheDir2.getIgnoreList();
            arrayList = ignoreListSupport.createIgnoreList(string, arrayList2);
        }
        cacheDir.setIgnoreList(arrayList);
        return arrayList;
    }

    public static String encodeValue(Object object) throws IOException {
        Object object2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object2 = new NbObjectOutputStream((OutputStream)byteArrayOutputStream);
            object2.writeObject(object);
            object2.close();
        }
        catch (SecurityException securityException) {
            throw (IOException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IOException(), (Throwable)securityException);
        }
        object2 = byteArrayOutputStream.toByteArray();
        StringBuffer stringBuffer = new StringBuffer(((NbObjectOutputStream)object2).length * 2);
        int n = 0;
        while (n < ((NbObjectOutputStream)object2).length) {
            if (object2[n] < 16 && object2[n] >= 0) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString((int)(object2[n] < 0 ? object2[n] + 256 : object2[n])));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Object decodeValue(String string) throws IOException {
        if (string == null || string.length() == 0) {
            return null;
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            try {
                int n3 = Integer.parseInt(string.substring(n2, n2 + 2), 16);
                if (n3 > 127) {
                    n3 -= 256;
                }
                byArray[n++] = (byte)n3;
            }
            catch (NumberFormatException numberFormatException) {
                throw (IOException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IOException(), (Throwable)numberFormatException);
            }
            n2 += 2;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
        try {
            NbObjectInputStream nbObjectInputStream = new NbObjectInputStream((InputStream)byteArrayInputStream);
            Object object = nbObjectInputStream.readObject();
            return object;
        }
        catch (OptionalDataException optionalDataException) {
            throw (IOException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IOException(), (Throwable)optionalDataException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (IOException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IOException(), (Throwable)classNotFoundException);
        }
    }

    public static class FileObjectNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof FileObject && object2 instanceof FileObject) {
                return ((FileObject)object).getNameExt().compareTo(((FileObject)object2).getNameExt());
            }
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }
    }
}

