/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.tomcat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.debugger.delegator.DefaultDebuggerType;
import org.netbeans.modules.web.tomcat.Context;
import org.netbeans.modules.web.tomcat.TomcatChildrenNode;
import org.netbeans.modules.web.tomcat.TomcatNode;
import org.netbeans.modules.web.tomcat.TomcatServerExecution;
import org.netbeans.modules.web.tomcat.TomcatServerInstance;
import org.netbeans.modules.web.tomcat.TomcatWebServer;
import org.netbeans.modules.web.xmlutils.SAXParseError;
import org.netbeans.modules.web.xmlutils.XMLJ2eeDataObject;
import org.netbeans.modules.web.xmlutils.XMLJ2eeEditorSupport;
import org.netbeans.modules.web.xmlutils.XMLJ2eeUtils;
import org.openide.TopManager;
import org.openide.cookies.ExecCookie;
import org.openide.cookies.SaveCookie;
import org.openide.execution.Executor;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TomcatDataObject
extends XMLJ2eeDataObject
implements ExecCookie {
    static final String ICON_BASE = "org/netbeans/modules/web/tomcat/resources/tomcat_16x16";
    static final String ICON_BASE_INV = "org/netbeans/modules/web/tomcat/resources/tomcat_inv_16x16";
    static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$tomcat$TomcatDataObject == null ? (class$org$netbeans$modules$web$tomcat$TomcatDataObject = TomcatDataObject.class$("org.netbeans.modules.web.tomcat.TomcatDataObject")) : class$org$netbeans$modules$web$tomcat$TomcatDataObject));
    public static final String TOMCAT_COMPILE_SERVER = "TOMCAT_COMPILE_SERVER";
    private static final String HTTP_HANDLER = "org.apache.tomcat.service.http.HttpConnectionHandler";
    private static final String SERVICE_HANDLER = "org.apache.tomcat.service.connector.Ajp12ConnectionHandler";
    private static final String DEFAULT_NAME_FOR_SHARED_MEMORY_ACCESS = "tomcat_shared_memory_id";
    private static final int DEFAULT_DEBUGGER_PORT = 11555;
    protected static final String DEBUGGER_DESCRIPTOR = "debugger_descriptor";
    protected static final String EXEC_DESCRIPTOR = "exec_descriptor";
    protected static final String DEBUGGER_PORT = "debugger_port";
    protected static final String DEBUGGING_TYPE = "debugging_type";
    protected static final String CLASSIC = "classic";
    protected static final String NAME_FOR_SHARED_MEMORY_ACCESS = "name_for_shared_memory_access";
    private static final NbProcessDescriptor DEBUG_TOMCAT_DESCRIPTOR = new NbProcessDescriptor("{java.home}{/}bin{/}java", "{classic} {debuggerOptions} {database} -classpath {tomcat_filesystems} {classname} {arguments}", bundle.getString("MSG_TomcatBuildinExecution"));
    private static final NbProcessDescriptor EXEC_TOMCAT_DESCRIPTOR = new NbProcessDescriptor("{java.home}{/}bin{/}java", "{database} -cp {tomcat_filesystems} {classname} {arguments}", bundle.getString("MSG_TomcatBuildinExecution"));
    TomcatNodeChildren dataNodechildren;
    private Context[] context;
    private int port;
    private int servicePort;
    private NbProcessDescriptor debugProcessDescriptor;
    private NbProcessDescriptor execProcessDescriptor;
    private String debuggingType;
    private int debuggerPort;
    private String nameForSharedMemoryAccess;
    private FileObject pf;
    private boolean isHttpHandler;
    private boolean isServiceHandler;
    private TomcatWebServer server = null;
    private MyDefaultDebuggerType myDefaultDebuggerType = new MyDefaultDebuggerType();
    private Timer timer;
    private static final long serialVersionUID = -3601997184973689147L;
    Vector selectedContexts = new Vector();
    static /* synthetic */ Class class$org$netbeans$modules$web$tomcat$TomcatDataObject;
    static /* synthetic */ Class class$org$openide$cookies$ExecCookie;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$server$web$WebServerInstance;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$ServerExecutor;

    public TomcatDataObject(FileObject fileObject, UniFileLoader uniFileLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)uniFileLoader);
        Integer n;
        this.pf = fileObject;
        this.debugProcessDescriptor = (NbProcessDescriptor)fileObject.getAttribute(DEBUGGER_DESCRIPTOR);
        this.execProcessDescriptor = (NbProcessDescriptor)fileObject.getAttribute(EXEC_DESCRIPTOR);
        if (this.debugProcessDescriptor == null) {
            this.debugProcessDescriptor = DEBUG_TOMCAT_DESCRIPTOR;
        }
        if (this.execProcessDescriptor == null) {
            this.execProcessDescriptor = EXEC_TOMCAT_DESCRIPTOR;
        }
        this.debuggerPort = (n = (Integer)fileObject.getAttribute(DEBUGGER_PORT)) == null ? 11555 : n;
        this.debuggingType = (String)fileObject.getAttribute(DEBUGGING_TYPE);
        if (this.debuggingType == null) {
            this.debuggingType = bundle.getString("SEL_debuggingType_1");
        }
        this.nameForSharedMemoryAccess = (String)fileObject.getAttribute(NAME_FOR_SHARED_MEMORY_ACCESS);
        if (this.nameForSharedMemoryAccess == null) {
            this.nameForSharedMemoryAccess = DEFAULT_NAME_FOR_SHARED_MEMORY_ACCESS;
        }
        this.timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TomcatDataObject.this.removeSelectedContexts();
            }
        });
        this.timer.setInitialDelay(200);
        this.timer.setRepeats(false);
        this.parsingDocument();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz.isAssignableFrom(class$org$openide$cookies$ExecCookie == null ? (class$org$openide$cookies$ExecCookie = TomcatDataObject.class$("org.openide.cookies.ExecCookie")) : class$org$openide$cookies$ExecCookie)) {
            return this;
        }
        if (clazz.isAssignableFrom(class$org$netbeans$modules$j2ee$server$web$WebServerInstance == null ? (class$org$netbeans$modules$j2ee$server$web$WebServerInstance = TomcatDataObject.class$("org.netbeans.modules.j2ee.server.web.WebServerInstance")) : class$org$netbeans$modules$j2ee$server$web$WebServerInstance)) {
            return this.server.getWebServerInstances()[0];
        }
        return super.getCookie(clazz);
    }

    public FileObject getTomcatFileObject(Context[] contextArray) {
        this.mergeContext(contextArray);
        return this.pf;
    }

    public void setServer(TomcatWebServer tomcatWebServer) {
        this.server = tomcatWebServer;
    }

    public TomcatWebServer getServer() {
        return this.server;
    }

    public boolean isRenameAllowed() {
        return false;
    }

    public boolean getCompileInIDE() {
        return this.getPrimaryFile().getAttribute(TOMCAT_COMPILE_SERVER) == null;
    }

    public void setCompileInIDE(boolean bl) {
        try {
            this.getPrimaryFile().setAttribute(TOMCAT_COMPILE_SERVER, (Object)(bl ? null : "x"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((TomcatServerExecution)TomcatServerInstance.getInstance().getTestRunSupport()).setRestart();
    }

    public NbProcessDescriptor getDebugProcessDescriptor() {
        return this.debugProcessDescriptor;
    }

    public NbProcessDescriptor getExecProcessDescriptor() {
        return this.execProcessDescriptor;
    }

    public void setDebugProcessDescriptor(NbProcessDescriptor nbProcessDescriptor) {
        this.debugProcessDescriptor = nbProcessDescriptor;
        try {
            this.pf.setAttribute(DEBUGGER_DESCRIPTOR, (Object)nbProcessDescriptor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setExecProcessDescriptor(NbProcessDescriptor nbProcessDescriptor) {
        this.execProcessDescriptor = nbProcessDescriptor;
        try {
            this.pf.setAttribute(EXEC_DESCRIPTOR, (Object)nbProcessDescriptor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((TomcatServerExecution)TomcatServerInstance.getInstance().getTestRunSupport()).setRestart();
    }

    public String getDebuggingType() {
        return this.debuggingType;
    }

    public void setDebuggingType(String string) {
        this.debuggingType = string;
        try {
            this.pf.setAttribute(DEBUGGING_TYPE, (Object)string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getDebuggerPort() {
        return this.debuggerPort;
    }

    public void setDebuggerPort(int n) {
        this.debuggerPort = n;
        try {
            this.pf.setAttribute(DEBUGGER_PORT, (Object)new Integer(n));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean getClassic() {
        Object object = this.pf.getAttribute(CLASSIC);
        if (object == null) {
            return this.myDefaultDebuggerType.getMyClassicDefault();
        }
        return (Boolean)object;
    }

    public void setClassic(boolean bl) {
        try {
            this.pf.setAttribute(CLASSIC, (Object)new Boolean(bl));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getNameForSharedMemoryAccess() {
        return this.nameForSharedMemoryAccess;
    }

    public void setNameForSharedMemoryAccess(String string) {
        this.nameForSharedMemoryAccess = string;
        try {
            this.pf.setAttribute(NAME_FOR_SHARED_MEMORY_ACCESS, (Object)string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(int n) {
        int n2 = this.servicePort;
        this.servicePort = n;
        if (n2 != n) {
            ((TomcatNode)this.getNodeDelegate()).updateNode("service_port", new Integer(n2), new Integer(n));
        }
        ((TomcatServerExecution)TomcatServerInstance.getInstance().getTestRunSupport()).setRestart();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        int n2 = this.port;
        this.port = n;
        if (n2 != n) {
            ((TomcatNode)this.getNodeDelegate()).updateNode("port", new Integer(n2), new Integer(n));
        }
        ((TomcatServerExecution)TomcatServerInstance.getInstance().getTestRunSupport()).setRestart();
    }

    public Context[] getContext() {
        return this.context;
    }

    public FileObject[] getDocBasesFromContext() {
        FileObject fileObject;
        HashSet<File> hashSet = new HashSet<File>();
        if (this.context != null) {
            int n = 0;
            while (n < this.context.length) {
                try {
                    hashSet.add(new File(this.context[n].getDocBase().getCanonicalPath()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n;
            }
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Enumeration enumeration = TopManager.getDefault().getRepository().getFileSystems();
        while (enumeration.hasMoreElements()) {
            fileObject = ((FileSystem)enumeration.nextElement()).getRoot();
            File file = NbClassPath.toFile((FileObject)fileObject);
            if (file == null) continue;
            try {
                File file2 = new File(file.getCanonicalPath());
                if (!hashSet.contains(file2)) continue;
                arrayList.add(fileObject);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        fileObject = new FileObject[arrayList.size()];
        arrayList.toArray((T[])fileObject);
        return fileObject;
    }

    public void setContext(Context[] contextArray) {
        this.context = contextArray;
        this.setNodeDirty(true, true);
    }

    public void mergeContext(Context[] contextArray) {
        ArrayList<Context> arrayList = new ArrayList<Context>();
        if (this.context == null) {
            this.context = contextArray;
            return;
        }
        int n = 0;
        while (n < this.context.length) {
            arrayList.add(this.context[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < contextArray.length) {
            boolean bl = false;
            int n3 = 0;
            while (n3 < this.context.length) {
                if (this.context[n3].getPath().equals(contextArray[n2].getPath())) {
                    this.context[n3].setDocBase(contextArray[n2].getDocBase());
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                arrayList.add(contextArray[n2]);
            }
            ++n2;
        }
        this.context = new Context[arrayList.size()];
        arrayList.toArray(this.context);
        this.setNodeDirty(true, true);
    }

    void addSelectedContext(Context context) {
        this.selectedContexts.add(context);
    }

    void restartTimer() {
        this.timer.restart();
    }

    void removeSelectedContexts() {
        ArrayList<Context> arrayList = new ArrayList<Context>();
        int n = 0;
        while (n < this.context.length) {
            arrayList.add(this.context[n]);
            ++n;
        }
        arrayList.removeAll(this.selectedContexts);
        this.selectedContexts.removeAllElements();
        this.context = new Context[arrayList.size()];
        arrayList.toArray(this.context);
        this.setNodeDirty(true, true);
    }

    private SAXParseError reparse(InputSource inputSource) {
        SAXParseError sAXParseError = null;
        try {
            sAXParseError = this.parse(inputSource, (ErrorHandler)new XMLJ2eeDataObject.J2eeErrorHandler(), false);
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)iOException);
            return sAXParseError;
        }
        catch (SAXException sAXException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)sAXException);
            }
            return sAXParseError;
        }
        return sAXParseError;
    }

    private SAXParseError parse(InputSource inputSource, ErrorHandler errorHandler, boolean bl) throws IOException, SAXException {
        XMLReader xMLReader = XMLUtil.createXMLReader();
        Vector vector = new Vector();
        xMLReader.setContentHandler(new TomcatDocumentHandler(vector));
        try {
            xMLReader.parse(inputSource);
            this.context = new Context[vector.size()];
            vector.toArray(this.context);
        }
        catch (SAXParseException sAXParseException) {
            return new SAXParseError(sAXParseException);
        }
        return null;
    }

    protected SAXParseError updateNode(InputSource inputSource) throws IOException {
        SAXParseError sAXParseError = this.reparse(inputSource);
        ((TomcatNodeChildren)this.getNodeDelegate().getChildren()).updateKeys();
        return sAXParseError;
    }

    protected String updateDocument(Document document) {
        String string = null;
        StringBuffer stringBuffer = null;
        try {
            string = document.getText(0, document.getLength());
            stringBuffer = new StringBuffer(string);
            int n = string.indexOf(HTTP_HANDLER);
            int n2 = string.indexOf("\"port\"", n + HTTP_HANDLER.length());
            int n3 = string.indexOf("value", n2 + 6);
            int n4 = string.indexOf("\"", n3 + 5) + 1;
            int n5 = string.indexOf("\"", n4);
            int n6 = string.indexOf(SERVICE_HANDLER);
            int n7 = string.indexOf("\"port\"", n6 + SERVICE_HANDLER.length());
            int n8 = string.indexOf("value", n7 + 6);
            int n9 = string.indexOf("\"", n8 + 5) + 1;
            int n10 = string.indexOf("\"", n9);
            int n11 = string.lastIndexOf("</Connector>");
            int n12 = string.indexOf("</ContextManager>");
            int n13 = this.context.length;
            if (n11 >= 0 && n12 >= 0) {
                String string2;
                n11 += 12;
                StringBuffer stringBuffer2 = new StringBuffer(System.getProperty("line.separator"));
                int n14 = 0;
                while (n14 < n13) {
                    string2 = this.context[n14].getPath();
                    String string3 = this.context[n14].getDocBase().getPath();
                    int n15 = this.context[n14].getDebug();
                    boolean bl = this.context[n14].isCrossContext();
                    boolean bl2 = this.context[n14].isReloadable();
                    boolean bl3 = this.context[n14].isTrusted();
                    stringBuffer2.append("\t\t<Context ");
                    stringBuffer2.append("path=\"" + string2 + "\" ");
                    stringBuffer2.append("docBase=\"" + string3 + "\" ");
                    stringBuffer2.append("debug=\"" + String.valueOf(n15) + "\" ");
                    stringBuffer2.append("reloadable=\"" + String.valueOf(bl2) + "\" ");
                    stringBuffer2.append("crossContext=\"" + String.valueOf(bl) + "\" ");
                    stringBuffer2.append("trusted=\"" + String.valueOf(bl3) + "\" ");
                    stringBuffer2.append("/>" + System.getProperty("line.separator"));
                    ++n14;
                }
                stringBuffer2.append("\t");
                string2 = stringBuffer2.toString();
                stringBuffer.replace(n11, n12, string2);
            }
            int n16 = 0;
            if (n > 0 && n4 > 1 && n5 >= n4) {
                String string4 = String.valueOf(this.getPort());
                stringBuffer.replace(n4, n5, string4);
                n16 = n5 - n4 - string4.length();
            }
            if (n6 > 0 && n9 > 1 && n10 >= n9) {
                stringBuffer.replace(n9 - n16, n10 - n16, String.valueOf(this.getServicePort()));
            }
            XMLJ2eeUtils.replaceDocument((Document)document, (String)stringBuffer.toString());
        }
        catch (BadLocationException badLocationException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)badLocationException);
        }
        return string;
    }

    protected Node createNodeDelegate() {
        this.dataNodechildren = new TomcatNodeChildren();
        TomcatNode tomcatNode = new TomcatNode(this, this.dataNodechildren);
        tomcatNode.setIconBase(ICON_BASE);
        tomcatNode.setDisplayName(bundle.getString("MSG_tomcatName"));
        return tomcatNode;
    }

    public void setNodeDirty(boolean bl, boolean bl2) {
        if (bl) {
            TomcatDataObject tomcatDataObject = this;
            synchronized (tomcatDataObject) {
                this.nodeDirty = true;
                this.restartUpdate(bl2);
            }
        }
    }

    protected void restartUpdate(boolean bl) {
        XMLJ2eeEditorSupport xMLJ2eeEditorSupport = this.getEditorSupport();
        try {
            try {
                StyledDocument styledDocument = this.getEditorSupport().openDocument();
                this.updateDocument(styledDocument);
                SaveCookie saveCookie = (SaveCookie)this.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = TomcatDataObject.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
                if (saveCookie != null) {
                    saveCookie.save();
                }
                xMLJ2eeEditorSupport.getUndo().discardAllEdits();
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)iOException);
                Object var6_7 = null;
                this.nodeDirty = false;
            }
            Object var6_6 = null;
            this.nodeDirty = false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.nodeDirty = false;
            throw throwable;
        }
        if (bl) {
            this.parsingDocument();
        }
    }

    protected String getIconBaseForValidDocument() {
        return ICON_BASE;
    }

    protected String getIconBaseForInvalidDocument() {
        return ICON_BASE_INV;
    }

    public void start() {
        try {
            Executor.find((Class)(class$org$netbeans$modules$j2ee$impl$ServerExecutor == null ? (class$org$netbeans$modules$j2ee$impl$ServerExecutor = TomcatDataObject.class$("org.netbeans.modules.j2ee.impl.ServerExecutor")) : class$org$netbeans$modules$j2ee$impl$ServerExecutor)).execute((DataObject)this);
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MyDefaultDebuggerType
    extends DefaultDebuggerType {
        MyDefaultDebuggerType() {
        }

        public boolean getMyClassicDefault() {
            return this.getClassicDefault();
        }
    }

    private class TomcatNodeChildren
    extends Children.Keys {
        private TomcatNodeChildren() {
        }

        protected void addNotify() {
            try {
                Context[] contextArray = TomcatDataObject.this.getContext();
                this.setKeys(contextArray == null ? new Object[]{} : contextArray);
            }
            catch (Exception exception) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
            }
        }

        protected void removeNotify() {
            this.setKeys(new Object[0]);
        }

        void updateKeys() {
            Object[] objectArray = TomcatDataObject.this.getContext();
            if (objectArray != null) {
                this.setKeys(objectArray);
            }
        }

        public Node[] createNodes(Object object) {
            try {
                TomcatChildrenNode tomcatChildrenNode = new TomcatChildrenNode(TomcatDataObject.this, (Context)object);
                String string = MessageFormat.format(bundle.getString("CTL_contextNodeName"), ((Context)object).getPath(), ((Context)object).getDocBase());
                tomcatChildrenNode.setName(string);
                tomcatChildrenNode.addPropertyChangeListener(new NodeListener((Context)object));
                return new Node[]{tomcatChildrenNode};
            }
            catch (IntrospectionException introspectionException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)introspectionException);
                return new Node[0];
            }
        }

        private class NodeListener
        implements PropertyChangeListener {
            Context ctx;

            public NodeListener(Context context) {
                this.ctx = context;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TomcatDataObject.this.setNodeDirty(true, false);
                String string = MessageFormat.format(bundle.getString("CTL_contextNodeName"), this.ctx.getPath(), this.ctx.getDocBase());
                ((BeanNode)propertyChangeEvent.getSource()).setName(string);
            }
        }
    }

    private class TomcatDocumentHandler
    implements ContentHandler {
        private Vector vec;

        public TomcatDocumentHandler(Vector vector) {
            this.vec = vector;
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Object object;
            if (string3.equals("Context")) {
                object = new Context();
                int n = 0;
                while (n < attributes.getLength()) {
                    String string4 = attributes.getQName(n);
                    String string5 = attributes.getValue(n);
                    if (string4.equals("path")) {
                        ((Context)object).setPath(string5);
                    }
                    if (string4.equals("docBase")) {
                        ((Context)object).setDocBase(new File(string5));
                    }
                    if (string4.equals("reloadable")) {
                        ((Context)object).setReloadable(new Boolean(string5));
                    }
                    if (string4.equals("crossContext")) {
                        ((Context)object).setCrossContext(new Boolean(string5));
                    }
                    if (string4.equals("trusted")) {
                        ((Context)object).setTrusted(new Boolean(string5));
                    }
                    if (string4.equals("debug")) {
                        ((Context)object).setDebug(new Integer(string5));
                    }
                    ++n;
                }
                this.vec.add(object);
            }
            if (string3.equals("Parameter")) {
                object = attributes.getValue("value");
                if (((String)object).equals(TomcatDataObject.HTTP_HANDLER)) {
                    TomcatDataObject.this.isHttpHandler = true;
                }
                if (((String)object).equals(TomcatDataObject.SERVICE_HANDLER)) {
                    TomcatDataObject.this.isServiceHandler = true;
                }
                if (attributes.getValue("name").equals("port")) {
                    if (TomcatDataObject.this.isHttpHandler) {
                        TomcatDataObject.this.isHttpHandler = false;
                        TomcatDataObject.this.setPort(new Integer(attributes.getValue("value")));
                    }
                    if (TomcatDataObject.this.isServiceHandler) {
                        TomcatDataObject.this.isServiceHandler = false;
                        TomcatDataObject.this.setServicePort(new Integer(attributes.getValue("value")));
                    }
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }
    }
}

