/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.tomcat.compile;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import org.netbeans.modules.j2ee.server.web.JspSourceMapper;

public class TomcatSourceMapper
implements JspSourceMapper,
Serializable {
    private static final boolean findDynamicRange = true;
    private transient JspSourceMapper.NameConverter converter;
    public static final String ARTIFICIAL_SUFFIX = ".:\\/,.";
    private static final boolean debug = false;
    private static final boolean verbose = true;
    private static final boolean haveOneOffBug = true;
    private int size = 0;
    private int MAX_SIZE = 500;
    private boolean ready = false;
    private transient Reader reader = null;
    private static final int JSP_CODE = 0;
    private static final int JAVA_CODE = 1;
    private Range[][] map;
    private Map fileNames = new Hashtable(5);
    private String primaryJspFileName;
    private transient Hashtable privateMaps;
    private transient String currentDir;
    private int debugLine = -1;
    private static final String PROLOG = ":START:";
    private static final String EPILOG = ":END:";
    private static final String GLUE = ":GLUE:";
    private static final String GLUE_SAME_LINE = ":GLUE_SAME_LINE:";
    private static final String EMPTY_JSP_FILE_NAME = "@@@EMPTY@@@";
    private static final int EMPTY_JAVA_LINE = 33;
    private boolean isEmptyJspPage = true;

    public TomcatSourceMapper() {
    }

    public TomcatSourceMapper(Reader reader, JspSourceMapper.NameConverter nameConverter) throws IOException {
        if (null == nameConverter) {
            throw new IllegalArgumentException("null == converter");
        }
        this.converter = nameConverter;
        this.init(reader);
    }

    private Hashtable getPrivateMaps() {
        if (null == this.privateMaps) {
            this.privateMaps = new Hashtable(11);
        }
        return this.privateMaps;
    }

    private void init(Reader reader) throws IOException {
        if (null == reader) {
            throw new IllegalArgumentException("null == reader");
        }
        this.size = 0;
        this.reader = reader;
        this.readAll();
        this.compress();
        this.reader.close();
        this.ready = true;
        this.reader = null;
    }

    public String getPrimaryJspFileName() {
        if (null != this.primaryJspFileName) {
            return this.primaryJspFileName;
        }
        if (this.isEmpty()) {
            return EMPTY_JSP_FILE_NAME;
        }
        return null;
    }

    public void setPrimaryJspFileName(String string) {
        this.primaryJspFileName = string;
    }

    Range javaToJsp(String string, Range range) {
        return this.mapRange(string, 1, range, 0);
    }

    Range javaToJsp(String string, Position position) {
        Range range = new Range(position);
        return this.mapRange(string, 1, range, 0);
    }

    public String toString() {
        String string = this.getClass().getName() + "\tsource\ttarget\n";
        int n = 0;
        while (n < this.size) {
            string = string + "\t" + this.map[0][n] + "\t" + this.map[1][n] + "\n";
            ++n;
        }
        return string;
    }

    Range jspToJava(String string, Range range) {
        return this.mapRange(string, 0, range, 1);
    }

    public int size() {
        if (!this.ready) {
            throw new IllegalArgumentException("SourceMapper: Not ready");
        }
        if (this.isEmpty()) {
            return 1;
        }
        return this.size;
    }

    Range jspToJava(String string, Position position) {
        Range range = new Range(position);
        return this.mapRange(string, 0, range, 1);
    }

    private String adjustJspFileName(String string) throws IOException {
        String string2 = string;
        if (null != this.converter) {
            string2 = this.converter.convert(string);
        }
        return string2;
    }

    public boolean isEmpty() {
        return this.isEmptyJspPage;
    }

    private synchronized void readAll() {
        String string = "// begin [file=\"";
        int n = string.length();
        String string2 = "// end";
        int n2 = string2.length();
        String string3 = "from=(";
        int n3 = string3.length();
        String string4 = ";to=(";
        int n4 = string4.length();
        String string5 = "// HTML ";
        int n5 = string5.length();
        boolean bl = false;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Stack<String> stack = new Stack<String>();
        int n6 = 1;
        this.map = new Range[2][this.MAX_SIZE];
        int n7 = 0;
        while (n7 < this.MAX_SIZE) {
            this.map[0][n7] = new Range();
            this.map[1][n7] = new Range();
            ++n7;
        }
        try {
            String string6;
            LineNumberReader lineNumberReader = new LineNumberReader(this.reader);
            while (null != (string6 = lineNumberReader.readLine())) {
                String string7;
                String string8;
                String string9;
                String string10 = string6.trim();
                if (string10.startsWith(string5)) {
                    bl = true;
                    string10 = string10.substring(n5);
                } else {
                    bl = false;
                }
                if (!string10.startsWith(string)) continue;
                this.isEmptyJspPage = false;
                int n8 = n;
                int n9 = string10.indexOf(59, n8);
                if (n9 < 0) continue;
                String string11 = string10.substring(n8, n9 - 1);
                string11 = this.adjustJspFileName(string11);
                Integer n10 = (Integer)hashtable.get(string10);
                int n11 = 1;
                if (null != n10) {
                    n11 = n10;
                }
                if (stack.empty()) {
                    stack.push(string11);
                } else {
                    string9 = (String)stack.peek();
                    if (!string11.equals(string9)) {
                        stack.pop();
                        if (stack.empty() || !string11.equals(stack.peek())) {
                            stack.push(string9);
                            stack.push(string11);
                            if (null != n10 && null != this.getPrimaryJspFileName() && !this.getPrimaryJspFileName().equals(string11)) {
                                n11 = n10 + 1;
                            }
                        }
                        n6 = n11;
                    } else {
                        n11 = n6;
                    }
                }
                if (n11 > 1) {
                    string11 = string11 + ARTIFICIAL_SUFFIX + n11;
                }
                if (null == (string9 = this.fileNames.get(string11))) {
                    this.fileNames.put(string11, string11);
                } else {
                    string11 = string9;
                }
                if (null == this.getPrimaryJspFileName()) {
                    this.setPrimaryJspFileName(string11);
                }
                if (this.size >= this.map[0].length) {
                    this.realloc();
                }
                this.map[0][this.size].start.fileName = string11;
                this.map[0][this.size].stop.fileName = string11;
                n8 = n9 + n3;
                if ((n9 = string10.indexOf(44, n8)) < 0) continue;
                String string12 = string10.substring(n8 + 1, n9);
                this.map[0][this.size].start.line = 1 + Integer.parseInt(string12);
                this.map[1][this.size].start.line = lineNumberReader.getLineNumber() + 1;
                n8 = n9 + 1;
                if ((n9 = string10.indexOf(41, n8)) < 0) continue;
                string12 = string10.substring(n8, n9);
                this.map[0][this.size].start.column = 1 + Integer.parseInt(string12);
                this.map[1][this.size].start.column = 1;
                n8 = n9 + n4;
                if ((n9 = string10.indexOf(44, n8)) < 0) continue;
                string12 = string10.substring(n8 + 1, n9);
                this.map[0][this.size].stop.line = 1 + Integer.parseInt(string12);
                n8 = n9 + 1;
                if ((n9 = string10.indexOf(41, n8)) < 0) continue;
                string12 = string10.substring(n8, n9);
                this.map[0][this.size].stop.column = 1 + Integer.parseInt(string12);
                this.map[0][this.size].start.type = string8 = string10.substring(n9 + 2).trim().intern();
                this.map[0][this.size].stop.type = string8;
                this.map[1][this.size].start.type = string8;
                this.map[1][this.size].stop.type = string8;
                if (this.size > 1 && this.map[0][this.size].start.line == this.map[0][this.size - 1].start.line && this.map[0][this.size].start.column == this.map[0][this.size - 1].start.column && this.map[0][this.size].start.fileName.equals(this.map[0][this.size - 1].start.fileName)) {
                    --this.size;
                }
                int n12 = lineNumberReader.getLineNumber();
                do {
                    if (this.size < this.map[0].length) continue;
                    this.realloc();
                } while (null != (string6 = lineNumberReader.readLine()) && !(string7 = string6.trim()).equals(string2));
                if (null != string6) {
                    if (lineNumberReader.getLineNumber() == n12 + 1) continue;
                    this.map[1][this.size].stop.line = lineNumberReader.getLineNumber() + 1;
                    this.map[1][this.size].stop.column = string6.length();
                    this.map[1][this.size].htmlCode = bl;
                    this.map[0][this.size].htmlCode = bl;
                    hashtable.put(string10, new Integer(n11));
                    ++this.size;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (null == this.getPrimaryJspFileName()) {
            // empty if block
        }
        this.sanityCheck();
        this.postprocess();
    }

    private void postprocess() {
        int n = 0;
        while (n < this.size - 1) {
            String string = this.map[1][n].start.type;
            if ("TagBegin".equals(string)) {
                ++this.map[1][n].start.line;
            }
            ++n;
        }
    }

    private void sanityCheck() {
        int n = 0;
        while (n < this.size - 1) {
            if (!this.map[1][n].start.before(this.map[1][n + 1].start)) {
                throw new Error("FATAL ERROR: JAVA_CODE index is not sorted: i=" + n);
            }
            ++n;
        }
        if (!this.isEmpty() && null == this.getPrimaryJspFileName()) {
            throw new Error("FATAL ERROR: null == getPrimaryJspFileName()");
        }
    }

    public int mangle(int n) {
        return this.mangle(null, n, 1);
    }

    public int mangle(int n, int n2) {
        return this.mangle(null, n, n2);
    }

    public int mangle(String string, int n) {
        return this.mangle(string, n, 1);
    }

    public synchronized int mangle(String string, int n, int n2) {
        if (this.isEmpty()) {
            return 33;
        }
        if (null == string) {
            string = this.primaryJspFileName;
        }
        Range range = this.jspToJava(string, new Position(n, n2));
        int n3 = range.start.line;
        return n3;
    }

    public int unmangle(int n) {
        return this.unmangle(n, 1);
    }

    public int unmangle(int n, int n2) {
        return this.unmangle(null, n, n2);
    }

    public synchronized int unmangle(String string, int n, int n2) {
        if (this.isEmpty()) {
            return 1;
        }
        Range range = this.javaToJsp(string, new Position(n, n2));
        int n3 = range.start.line;
        return n3;
    }

    public String getJavaLineType(int n, int n2) {
        if (this.isEmpty()) {
            return PROLOG;
        }
        Range range = this.findRangeOfPosition(this.getPrimaryJspFileName(), 1, new Position(n, n2), 0);
        return range.start.type;
    }

    public String getJspFileName(int n, int n2) throws IOException {
        if (this.isEmpty()) {
            return EMPTY_JSP_FILE_NAME;
        }
        Range range = this.javaToJsp(null, new Position(n, n2));
        String string = this.getRealJspFileName(range.start.fileName);
        return string;
    }

    public boolean isProperJspFileName(String string) {
        if (null == string) {
            throw new IllegalArgumentException("null == name");
        }
        return string.indexOf(ARTIFICIAL_SUFFIX) < 0;
    }

    private String getRealJspFileName(String string) {
        String string2 = string;
        int n = string.indexOf(ARTIFICIAL_SUFFIX);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private boolean isDynamicType(String string) {
        return PROLOG != string && EPILOG != string && GLUE != string && GLUE_SAME_LINE != string && string.indexOf("CharData") < 0;
    }

    public boolean isJavaCodeInJspPage(int n, int n2) {
        if (this.isEmpty()) {
            return false;
        }
        String string = this.getJavaLineType(n, n2);
        return this.isDynamicType(string);
    }

    private synchronized Range mapRange(String string, int n, Range range, int n2) {
        if (!this.ready) {
            throw new IllegalArgumentException("SourceMapper: not ready yet");
        }
        if (range.stop.line < range.start.line || range.start.line == range.stop.line && range.stop.column < range.start.column) {
            throw new IllegalArgumentException("Illegal source Range" + range);
        }
        Range range2 = this.findRangeOfPosition(string, n, range.start, n2);
        if (range.start.line == range.stop.line && range.start.column == range.stop.column) {
            return range2;
        }
        Range range3 = new Range();
        range3.start.line = range2.start.line;
        range3.start.column = range2.start.column;
        range3.start.fileName = range2.start.fileName;
        range3.start.type = range2.start.type;
        Range range4 = this.findRangeOfPosition(string, n, range.stop, n2);
        if (range2.stop.line > range4.stop.line || range2.stop.line == range4.stop.line && range2.stop.column > range4.stop.column) {
            range3.stop.line = range2.stop.line;
            range3.stop.column = range2.stop.column;
            range3.stop.fileName = range2.stop.fileName;
            range3.stop.type = range2.stop.type;
        } else {
            range3.stop.line = range4.stop.line;
            range3.stop.column = range4.stop.column;
            range3.stop.fileName = range4.stop.fileName;
            range3.stop.type = range4.stop.type;
        }
        return range3;
    }

    public Map getFileNames() {
        if (null == this.fileNames) {
            throw new IllegalArgumentException("null == fileNames");
        }
        return this.fileNames;
    }

    public boolean hasIncludeFiles() {
        return this.getFileNames().size() > 1;
    }

    private void sort(Range[][] rangeArray) {
        if (null == rangeArray) {
            throw new IllegalArgumentException("null == theMap");
        }
        int n = rangeArray[0].length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            while (n3 > 0) {
                if (rangeArray[0][n3 - 1].start.before(rangeArray[0][n3].start)) break;
                Range range = rangeArray[0][n3];
                rangeArray[0][n3] = rangeArray[0][n3 - 1];
                rangeArray[0][n3 - 1] = range;
                range = rangeArray[1][n3];
                rangeArray[1][n3] = rangeArray[1][n3 - 1];
                rangeArray[1][n3 - 1] = range;
                --n3;
            }
            ++n2;
        }
    }

    private Range[][] getMap(String string) {
        int n;
        if (null == string) {
            throw new IllegalArgumentException("null == jspFileName");
        }
        Range[][] rangeArray = (Range[][])this.getPrivateMaps().get(string);
        if (null != rangeArray) {
            if (rangeArray.length > 0 && rangeArray[0].length > 0) {
                rangeArray[0][0].start.column = 1;
            }
            return rangeArray;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if (string.equals(this.map[0][n3].start.fileName)) {
                ++n2;
            }
            ++n3;
        }
        if (0 == n2) {
            String string2 = string;
            string = '/' == string.charAt(0) ? string.substring(1) : "/" + string;
            n = 0;
            while (n < this.size) {
                if (string.equals(this.map[0][n].start.fileName)) {
                    ++n2;
                }
                ++n;
            }
        }
        if (0 == n2) {
            throw new IllegalArgumentException("No mappings found for jspFileName=" + string);
        }
        rangeArray = new Range[2][n2];
        int n4 = 0;
        n = 0;
        while (n < this.size) {
            if (string.equals(this.map[0][n].start.fileName)) {
                rangeArray[0][n4] = this.map[0][n];
                rangeArray[1][n4] = this.map[1][n];
                ++n4;
            }
            ++n;
        }
        this.sort(rangeArray);
        this.getPrivateMaps().put(string, rangeArray);
        if (rangeArray.length > 0 && rangeArray[0].length > 0) {
            rangeArray[0][0].start.column = 1;
        }
        return rangeArray;
    }

    private int findPositionIndexOfJspFile(String string, Position position) {
        if (null == string) {
            throw new IllegalArgumentException("null == jspFileName");
        }
        if (null == position) {
            throw new IllegalArgumentException("null == position");
        }
        Range[][] rangeArray = this.getMap(string);
        return this.findPositionIndex(string, 0, position, rangeArray, rangeArray[0].length);
    }

    private int findPositionIndex(String string, int n, Position position) {
        if (0 == n && null != string) {
            return this.findPositionIndexOfJspFile(string, position);
        }
        return this.findPositionIndex(string, n, position, this.map, this.size);
    }

    private int findPositionIndex(String string, int n, Position position, Range[][] rangeArray, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = position.line;
        int n6 = position.column;
        int n7 = n3;
        while (n7 < n4) {
            int n8 = rangeArray[n][n7].stop.line;
            int n9 = rangeArray[n][n7].stop.column;
            if ((n5 < n8 || n8 == n5 && n6 <= n9) && n7 < n4) {
                if (n8 == rangeArray[n][n7 + 1].start.line && n9 == rangeArray[n][n7 + 1].start.column && n8 == n5 && n9 == n6) {
                    return n7 + 1;
                }
                return n7;
            }
            ++n7;
        }
        return n4;
    }

    private Range findRangeOfPosition(String string, int n, Position position, int n2) {
        String string2;
        int n3;
        if (null == position) {
            throw new IllegalArgumentException("null == position");
        }
        Range range = new Range();
        int n4 = position.line;
        int n5 = position.column;
        Range[][] rangeArray = this.map;
        int n6 = this.size;
        if (0 == n && null != string) {
            rangeArray = this.getMap(string);
            n6 = rangeArray[0].length;
        }
        if (n6 == 0 || n4 < rangeArray[n][0].start.line || n4 == rangeArray[n][0].start.line && n5 < rangeArray[n][0].start.column) {
            range.start.fileName = this.getPrimaryJspFileName();
            range.start.type = PROLOG;
            range.stop.fileName = range.start.fileName;
            range.stop.type = range.start.type;
            return range;
        }
        if (n4 > rangeArray[n][n6 - 1].stop.line) {
            range.start.line = n4 - rangeArray[n][n6 - 1].stop.line + rangeArray[n2][n6 - 1].stop.line;
            range.start.column = n5;
            range.start.fileName = this.getPrimaryJspFileName();
            range.start.type = EPILOG;
            range.stop.line = range.start.line;
            range.stop.column = range.start.column;
            range.stop.fileName = this.getPrimaryJspFileName();
            range.stop.type = EPILOG;
            return range;
        }
        if (n4 == rangeArray[n][n6 - 1].stop.line && n5 > rangeArray[n][n6 - 1].stop.column) {
            range.start.line = rangeArray[n2][n6 - 1].stop.line;
            range.start.column = n5 - rangeArray[n][n6 - 1].stop.column + rangeArray[n2][n6 - 1].stop.column;
            range.start.fileName = this.getPrimaryJspFileName();
            range.start.type = EPILOG;
            range.stop.line = range.start.line;
            range.stop.column = range.start.column;
            range.stop.fileName = this.getPrimaryJspFileName();
            range.stop.type = EPILOG;
            return range;
        }
        int n7 = this.findPositionIndex(string, n, position);
        if (0 == n && n7 < n6 - 1 && (n3 = this.isDynamicType(string2 = rangeArray[n2][n7].start.type)) == 0) {
            int n8;
            int n9 = n7 + 1;
            string2 = rangeArray[n2][n9].start.type;
            n3 = this.isDynamicType(string2) ? 1 : 0;
            if (n3 != 0 && (n8 = this.unmangle(string, rangeArray[n2][n9].start.line, rangeArray[n2][n9].start.column)) == n4) {
                n7 = n9;
            }
        }
        if (n7 < 0 || n7 >= n6) {
            string2 = this.getClass().getName() + "\tsource\ttarget============================================\n";
            n3 = 0;
            while (n3 < n6) {
                string2 = string2 + "\t" + rangeArray[0][n3] + "\t" + rangeArray[1][n3] + "\n";
                ++n3;
            }
            throw new IllegalArgumentException("Internal error: line/col not found:" + n4 + "/" + n5 + " idx=" + n7);
        }
        if (n4 < rangeArray[n][n7].stop.line || n4 == rangeArray[n][n7].stop.line && n5 <= rangeArray[n][n7].stop.column) {
            range.start.line = rangeArray[n2][n7].start.line;
            range.start.column = rangeArray[n2][n7].start.column;
            range.start.fileName = rangeArray[n2][n7].start.fileName;
            range.start.type = rangeArray[n2][n7].start.type;
            range.stop.line = rangeArray[n2][n7].stop.line;
            range.stop.column = rangeArray[n2][n7].stop.column;
            range.stop.fileName = rangeArray[n2][n7].stop.fileName;
            range.stop.type = rangeArray[n2][n7].stop.type;
            range.start.line += n4 - rangeArray[n][n7].start.line;
            if (range.start.line > range.stop.line) {
                range.start.line = range.stop.line;
            }
            return range;
        }
        if (rangeArray[n][n7].stop.line < n4) {
            range.start.line = n4 - rangeArray[n][n7].stop.line + rangeArray[n2][n7].stop.line;
            range.start.column = n5;
            range.start.fileName = this.getPrimaryJspFileName();
            range.start.type = GLUE;
            range.stop.line = range.start.line;
            range.stop.column = range.start.column;
            range.stop.fileName = range.start.fileName;
            range.stop.type = range.start.type;
            if (1 == n && rangeArray[n][n7].start.type.equals("Declaration")) {
                range.start.line = 1;
                range.start.column = 1;
                range.stop.line = 1;
                range.stop.column = 1;
            }
            return range;
        }
        range.start.line = rangeArray[n2][n7].stop.line;
        range.start.column = n5 - rangeArray[n][n7].stop.column + rangeArray[n2][n7].stop.column;
        range.start.fileName = this.getPrimaryJspFileName();
        range.start.type = GLUE_SAME_LINE;
        range.stop.line = range.start.line;
        range.stop.column = range.start.column;
        range.stop.fileName = range.start.fileName;
        range.stop.type = range.start.type;
        return range;
    }

    private void realloc() {
        int n;
        int n2 = (int)((double)this.MAX_SIZE * 1.2);
        Range[][] rangeArray = new Range[2][n2];
        int n3 = 0;
        while (n3 < 2) {
            n = 0;
            while (n < this.MAX_SIZE) {
                rangeArray[n3][n] = this.map[n3][n];
                ++n;
            }
            ++n3;
        }
        this.map = rangeArray;
        n = this.MAX_SIZE;
        while (n < n2) {
            this.map[0][n] = new Range();
            this.map[1][n] = new Range();
            ++n;
        }
        this.MAX_SIZE = n2;
    }

    private void compress() {
        Range[][] rangeArray = new Range[2][this.size];
        int n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 < this.size) {
                rangeArray[n][n2] = this.map[n][n2];
                ++n2;
            }
            ++n;
        }
        this.map = rangeArray;
        this.MAX_SIZE = this.size;
    }

    static class Range
    implements Serializable {
        Position start;
        Position stop;
        boolean htmlCode;

        Range() {
            this.start = new Position();
            this.stop = new Position();
        }

        Range(Position position) {
            this(position, position);
        }

        Range(Position position, Position position2) {
            this.start = new Position(position);
            this.stop = new Position(position2);
        }

        Range(Range range) {
            this.start = new Position(range.start);
            this.stop = new Position(range.stop);
            this.htmlCode = range.htmlCode;
        }

        Position getStart() {
            return this.start;
        }

        Position getStop() {
            return this.stop;
        }

        public String toString() {
            return "'" + this.start.fileName + "' " + "[(" + this.start.line + "," + this.start.column + (this.htmlCode ? ") +++ (" : ") --- (") + this.stop.line + "," + this.stop.column + ")] " + this.start.type;
        }
    }

    static class Position
    implements Serializable {
        int line = 1;
        int column = 1;
        String fileName = "";
        String type = ":START:";

        Position() {
        }

        Position(Position position) {
            this(position.line, position.column, position.fileName, position.type);
        }

        Position(int n, int n2) {
            this.line = n;
            this.column = n2;
        }

        Position(int n, int n2, String string, String string2) {
            this.line = n;
            this.column = n2;
            this.fileName = string;
            this.type = string2;
        }

        boolean before(Position position) {
            return this.line < position.line || this.line == position.line && this.column <= position.column;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Position)) {
                return false;
            }
            Position position = (Position)object;
            return position == this || this.line == position.line && this.column == position.column && this.type == position.type && this.fileName == position.fileName;
        }

        public String toString() {
            return "[" + this.fileName + ":" + this.type + "-" + this.line + "." + this.column + "]";
        }
    }
}

