/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.registry;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.netbeans.modules.rmi.registry.ServiceItem;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class RegistryItem
implements Node.Cookie,
Serializable {
    static final long serialVersionUID = -4780961588255414026L;
    private static final transient ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$registry$RegistryItem == null ? (class$org$netbeans$modules$rmi$registry$RegistryItem = RegistryItem.class$("org.netbeans.modules.rmi.registry.RegistryItem")) : class$org$netbeans$modules$rmi$registry$RegistryItem));
    public static final String PROP_SERVICES = "services";
    static final String SERVER_ICON_BASE = "/org/netbeans/modules/rmi/resources/rmiServer";
    static final String INTERFACE_ICON_BASE = "/org/openide/resources/src/interface";
    static final MessageFormat FMT_URL = new MessageFormat(bundle.getString("FMT_ItemURL"));
    static final MessageFormat FMT_REGISTRY_ITEM = new MessageFormat(bundle.getString("FMT_RegistryItem"));
    public static final String LOCALHOST = "localhost";
    protected InetAddress address;
    protected int port;
    private transient Collection services;
    private transient PropertyChangeSupport support;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$registry$RegistryItem;

    public RegistryItem() throws RemoteException, UnknownHostException {
        this(LOCALHOST, 1099);
    }

    public RegistryItem(String string, int n) throws RemoteException, UnknownHostException {
        this(InetAddress.getByName(string), n);
    }

    public RegistryItem(InetAddress inetAddress, int n) throws RemoteException {
        this.address = inetAddress;
        this.port = n;
    }

    public boolean equals(Object object) {
        RegistryItem registryItem;
        if (object == this) {
            return true;
        }
        return object != null && this.getClass() == object.getClass() && (registryItem = (RegistryItem)object).getAddress().equals(this.getAddress()) && registryItem.getPort() == this.getPort();
    }

    public int hashCode() {
        return this.getAddress().hashCode() ^ this.getPort();
    }

    public String toString() {
        return FMT_REGISTRY_ITEM.format(this.getItemObjects());
    }

    public Registry getRegistry() throws RemoteException {
        return LocateRegistry.getRegistry(this.getHostName(), this.getPort());
    }

    public String getURLString() {
        return FMT_URL.format(this.getItemObjects());
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getHostName() {
        return this.getAddress().getHostName();
    }

    public int getPort() {
        return this.port;
    }

    protected Object[] getItemObjects() {
        return new Object[]{this.getHostName(), new Integer(this.getPort())};
    }

    public synchronized Collection getServices() {
        return this.services;
    }

    public synchronized void setServices(Collection collection) {
        Collection collection2 = this.services;
        this.services = collection;
        this.firePropertyChange(PROP_SERVICES, collection2, collection);
    }

    public void updateServices() {
        try {
            Registry registry = this.getRegistry();
            String[] stringArray = registry.list();
            TreeSet<ServiceItem> treeSet = new TreeSet<ServiceItem>();
            int n = 0;
            while (n < stringArray.length) {
                Class<?> clazz = null;
                try {
                    Remote remote = registry.lookup(stringArray[n]);
                    clazz = remote.getClass();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                treeSet.add(new ServiceItem(stringArray[n], clazz));
                ++n;
            }
            this.setServices(treeSet);
        }
        catch (Exception exception) {
            this.setServices(null);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support == null) {
            RegistryItem registryItem = this;
            synchronized (registryItem) {
                if (this.support == null) {
                    this.support = new PropertyChangeSupport(this);
                }
            }
        }
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support != null) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (this.support != null) {
            this.support.firePropertyChange(string, object, object2);
        }
    }

    protected void finalize() throws Throwable {
        this.setServices(null);
        super.finalize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

