/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.util.Collection;
import java.util.LinkedList;
import org.netbeans.lib.cvsclient.request.GlobalOptionRequest;

public class GlobalOptions
implements Cloneable {
    private boolean doNoChanges;
    private boolean checkedOutFilesReadOnly;
    private String cvsRoot;
    private boolean useGzip = true;
    private boolean noHistoryLogging;
    private boolean moderatelyQuiet;
    private boolean veryQuiet;
    private boolean traceExecution;

    public Collection createRequestList() {
        LinkedList<GlobalOptionRequest> linkedList = new LinkedList<GlobalOptionRequest>();
        if (this.isNoHistoryLogging()) {
            linkedList.add(new GlobalOptionRequest("-l"));
        }
        if (this.isDoNoChanges()) {
            linkedList.add(new GlobalOptionRequest("-n"));
        }
        if (this.isModeratelyQuiet()) {
            linkedList.add(new GlobalOptionRequest("-q"));
        }
        if (this.isVeryQuiet()) {
            linkedList.add(new GlobalOptionRequest("-Q"));
        }
        if (this.isTraceExecution()) {
            linkedList.add(new GlobalOptionRequest("-t"));
        }
        return linkedList;
    }

    public String getOptString() {
        return "nd:lqQtr";
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'n') {
            this.setDoNoChanges(true);
        } else if (c == 'd') {
            this.setCVSRoot(string);
        } else if (c == 'l') {
            this.setNoHistoryLogging(true);
        } else if (c == 'q') {
            this.setModeratelyQuiet(true);
        } else if (c == 'Q') {
            this.setVeryQuiet(true);
        } else if (c == 't') {
            this.setTraceExecution(true);
        } else if (c == 't') {
            this.setTraceExecution(true);
        } else if (c == 'r') {
            this.setCheckedOutFilesReadOnly(true);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setCheckedOutFilesReadOnly(false);
        this.setDoNoChanges(false);
        this.setModeratelyQuiet(false);
        this.setNoHistoryLogging(false);
        this.setTraceExecution(false);
        this.setUseGzip(true);
        this.setVeryQuiet(false);
        this.setCVSRoot("");
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDoNoChanges()) {
            stringBuffer.append("-n ");
        }
        if (this.isNoHistoryLogging()) {
            stringBuffer.append("-l ");
        }
        if (this.isModeratelyQuiet()) {
            stringBuffer.append("-q ");
        }
        if (this.isVeryQuiet()) {
            stringBuffer.append("-Q ");
        }
        if (this.isTraceExecution()) {
            stringBuffer.append("-t ");
        }
        if (this.isCheckedOutFilesReadOnly()) {
            stringBuffer.append("-r ");
        }
        return stringBuffer.toString();
    }

    public void setDoNoChanges(boolean bl) {
        this.doNoChanges = bl;
    }

    public boolean isDoNoChanges() {
        return this.doNoChanges;
    }

    public boolean isCheckedOutFilesReadOnly() {
        return this.checkedOutFilesReadOnly;
    }

    public void setCheckedOutFilesReadOnly(boolean bl) {
        this.checkedOutFilesReadOnly = bl;
    }

    public String getCVSRoot() {
        return this.cvsRoot;
    }

    public void setCVSRoot(String string) {
        this.cvsRoot = string;
    }

    public void setUseGzip(boolean bl) {
        this.useGzip = bl;
    }

    public boolean isUseGzip() {
        return this.useGzip;
    }

    public boolean isNoHistoryLogging() {
        return this.noHistoryLogging;
    }

    public void setNoHistoryLogging(boolean bl) {
        this.noHistoryLogging = bl;
    }

    public boolean isModeratelyQuiet() {
        return this.moderatelyQuiet;
    }

    public void setModeratelyQuiet(boolean bl) {
        this.moderatelyQuiet = bl;
    }

    public boolean isVeryQuiet() {
        return this.veryQuiet;
    }

    public void setVeryQuiet(boolean bl) {
        this.veryQuiet = bl;
    }

    public boolean isTraceExecution() {
        return this.traceExecution;
    }

    public void setTraceExecution(boolean bl) {
        this.traceExecution = bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

