/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.checkout;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.PipedFilesBuilder;
import org.netbeans.lib.cvsclient.command.TemporaryFileCreator;
import org.netbeans.lib.cvsclient.command.checkout.ModuleListBuilder;
import org.netbeans.lib.cvsclient.command.update.UpdateBuilder;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.RootRequest;

public class CheckoutCommand
extends BasicCommand
implements TemporaryFileCreator {
    private final Set emptyDirectories = new HashSet();
    private final List modules = new LinkedList();
    private final List expandedModules = new LinkedList();
    private boolean showModules;
    private boolean showModulesWithStatus;
    private boolean pipeToOutput;
    private boolean pruneDirectories;
    private boolean resetStickyOnes;
    private boolean useHeadIfNotFound;
    private String checkoutByDate;
    private String checkoutByRevision;
    private KeywordSubstitutionOptions keywordSubst;

    public CheckoutCommand(boolean bl, String[] stringArray) {
        this.resetCVSCommand();
        this.setRecursive(bl);
        this.setModules(stringArray);
    }

    public CheckoutCommand(boolean bl, String string) {
        this.resetCVSCommand();
        this.setRecursive(bl);
        this.setModule(string);
    }

    public CheckoutCommand() {
        this.resetCVSCommand();
        this.setRecursive(true);
    }

    public void setModule(String string) {
        this.modules.add(string);
    }

    public void clearModules() {
        this.modules.clear();
    }

    public void setModules(String[] stringArray) {
        this.clearModules();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.modules.add(string);
            ++n;
        }
    }

    public String[] getModules() {
        String[] stringArray = new String[this.modules.size()];
        stringArray = this.modules.toArray(stringArray);
        return stringArray;
    }

    private void processExistingModules(String string) {
        Object object;
        if (this.expandedModules.size() == 0) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>(this.expandedModules.size());
        Iterator iterator = this.expandedModules.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (((String)object).equals(".")) {
                arrayList.add(new File(string));
                break;
            }
            File file = null;
            File file2 = new File(string, (String)object);
            file = file2.isFile() ? file2.getParentFile() : file2;
            File file3 = new File(file, "CVS/Repository");
            if (!file3.exists()) continue;
            arrayList.add(file2);
        }
        object = new File[arrayList.size()];
        object = arrayList.toArray((T[])object);
        this.setFiles((File[])object);
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        this.requests = new LinkedList();
        if (clientServices.isFirstCommand()) {
            this.requests.add(new RootRequest(clientServices.getRepository()));
        }
        if (this.showModules || this.showModulesWithStatus) {
            if (this.builder == null && !this.builderSet) {
                this.builder = this.createBuilder(eventManager);
            }
            if (this.showModules) {
                this.requests.add(new ArgumentRequest("-c"));
            }
            if (this.showModulesWithStatus) {
                this.requests.add(new ArgumentRequest("-s"));
            }
            this.requests.add(CommandRequest.CHECKOUT);
            try {
                clientServices.processRequests(this.requests);
                this.requests.clear();
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (EOFException eOFException) {
                throw new CommandException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
            }
            catch (Exception exception) {
                throw new CommandException(exception, exception.getLocalizedMessage());
            }
            return;
        }
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.requests.add(new ArgumentRequest(string));
        }
        this.expandedModules.clear();
        this.requests.add(new ExpandModulesRequest());
        try {
            clientServices.processRequests(this.requests);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        this.requests.clear();
        this.postExpansionExecute(clientServices, eventManager);
    }

    protected boolean assumeLocalPathWhenUnspecified() {
        return false;
    }

    public void moduleExpanded(ModuleExpansionEvent moduleExpansionEvent) {
        this.expandedModules.add(moduleExpansionEvent.getModule());
    }

    private void postExpansionExecute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        this.processExistingModules(clientServices.getLocalPath());
        super.execute(clientServices, eventManager);
        if (!this.isRecursive()) {
            this.requests.add(0, new ArgumentRequest("-l"));
        }
        if (this.pipeToOutput) {
            this.requests.add(0, new ArgumentRequest("-p"));
        }
        if (this.resetStickyOnes) {
            this.requests.add(0, new ArgumentRequest("-A"));
        }
        if (this.useHeadIfNotFound) {
            this.requests.add(0, new ArgumentRequest("-f"));
        }
        if (this.checkoutByDate != null && !this.checkoutByDate.equals("")) {
            this.requests.add(0, new ArgumentRequest("-D"));
            this.requests.add(1, new ArgumentRequest(this.getCheckoutByDate()));
        }
        if (this.checkoutByRevision != null && !this.checkoutByRevision.equals("")) {
            this.requests.add(0, new ArgumentRequest("-r"));
            this.requests.add(1, new ArgumentRequest(this.getCheckoutByRevision()));
        }
        if (this.getKeywordSubst() != null && !this.getKeywordSubst().equals("")) {
            this.requests.add(new ArgumentRequest("-k" + this.getKeywordSubst()));
        }
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.requests.add(new ArgumentRequest(string));
        }
        this.requests.add(new DirectoryRequest(".", clientServices.getRepository()));
        this.requests.add(CommandRequest.CHECKOUT);
        try {
            clientServices.processRequests(this.requests);
            if (this.pruneDirectories) {
                this.pruneEmptyDirectories();
            }
            this.requests.clear();
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
    }

    public boolean isShowModules() {
        return this.showModules;
    }

    public void setShowModules(boolean bl) {
        this.showModules = bl;
    }

    public boolean isShowModulesWithStatus() {
        return this.showModulesWithStatus;
    }

    public void setShowModulesWithStatus(boolean bl) {
        this.showModulesWithStatus = bl;
    }

    public void setPruneDirectories(boolean bl) {
        this.pruneDirectories = bl;
    }

    public boolean getPruneDirectories() {
        return this.pruneDirectories;
    }

    public boolean isPipeToOutput() {
        return this.pipeToOutput;
    }

    public void setPipeToOutput(boolean bl) {
        this.pipeToOutput = bl;
    }

    public boolean isResetStickyOnes() {
        return this.resetStickyOnes;
    }

    public void setResetStickyOnes(boolean bl) {
        this.resetStickyOnes = bl;
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean bl) {
        this.useHeadIfNotFound = bl;
    }

    public String getCheckoutByDate() {
        return this.checkoutByDate;
    }

    public void setCheckoutByDate(String string) {
        this.checkoutByDate = string;
    }

    public String getCheckoutByRevision() {
        return this.checkoutByRevision;
    }

    public void setCheckoutByRevision(String string) {
        this.checkoutByRevision = string;
    }

    public KeywordSubstitutionOptions getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(KeywordSubstitutionOptions keywordSubstitutionOptions) {
        this.keywordSubst = keywordSubstitutionOptions;
    }

    public Builder createBuilder(EventManager eventManager) {
        if (this.isShowModules() || this.isShowModulesWithStatus()) {
            return new ModuleListBuilder(eventManager, this);
        }
        if (this.isPipeToOutput()) {
            return new PipedFilesBuilder(eventManager, this, this);
        }
        return new UpdateBuilder(eventManager, this.getLocalPath());
    }

    public File createTempFile(String string) throws IOException {
        File file = File.createTempFile("cvs", ".dff");
        return file;
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("checkout ");
        stringBuffer.append(this.getCVSArguments());
        if (!this.isShowModules() && !this.isShowModulesWithStatus()) {
            Iterator iterator = this.modules.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'c') {
            this.setShowModules(true);
        } else if (c == 's') {
            this.setShowModulesWithStatus(true);
        } else if (c == 'p') {
            this.setPipeToOutput(true);
        } else if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'A') {
            this.setResetStickyOnes(true);
        } else if (c == 'f') {
            this.setUseHeadIfNotFound(true);
        } else if (c == 'P') {
            this.setPruneDirectories(true);
        } else if (c == 'D') {
            this.setCheckoutByDate(string.trim());
        } else if (c == 'r') {
            this.setCheckoutByRevision(string.trim());
        } else if (c == 'k') {
            KeywordSubstitutionOptions keywordSubstitutionOptions = KeywordSubstitutionOptions.findKeywordSubstOption(string);
            this.setKeywordSubst(keywordSubstitutionOptions);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "cpslPRAD:r:fk:";
    }

    public void resetCVSCommand() {
        this.setShowModules(false);
        this.setShowModulesWithStatus(false);
        this.setPipeToOutput(false);
        this.setRecursive(true);
        this.setResetStickyOnes(false);
        this.setUseHeadIfNotFound(false);
        this.setCheckoutByDate(null);
        this.setCheckoutByRevision(null);
        this.setKeywordSubst(null);
        this.setPruneDirectories(false);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isShowModules()) {
            stringBuffer.append("-c ");
        }
        if (this.isShowModulesWithStatus()) {
            stringBuffer.append("-s ");
        }
        if (this.isPipeToOutput()) {
            stringBuffer.append("-p ");
        }
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.isResetStickyOnes()) {
            stringBuffer.append("-A ");
        }
        if (this.isUseHeadIfNotFound()) {
            stringBuffer.append("-f ");
        }
        if (this.getPruneDirectories()) {
            stringBuffer.append("-P ");
        }
        if (this.getKeywordSubst() != null && !this.getKeywordSubst().equals("")) {
            stringBuffer.append("-k");
            stringBuffer.append(this.getKeywordSubst());
            stringBuffer.append(' ');
        }
        if (this.getCheckoutByRevision() != null && !this.getCheckoutByRevision().equals("")) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getCheckoutByRevision());
            stringBuffer.append(' ');
        }
        if (this.getCheckoutByDate() != null && !this.getCheckoutByDate().equals("")) {
            stringBuffer.append("-D ");
            stringBuffer.append(this.getCheckoutByDate());
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public void messageSent(MessageEvent messageEvent) {
        super.messageSent(messageEvent);
        if (this.pruneDirectories && messageEvent.getMessage().startsWith("cvs server: Updating ")) {
            File file = new File(this.getLocalPath(), messageEvent.getMessage().substring(21));
            this.emptyDirectories.add(file);
        }
    }

    private boolean pruneEmptyDirectory(File file) throws IOException {
        boolean bl = true;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            File file2;
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isFile()) {
                    bl = false;
                } else if (!fileArray[n].getName().equals("CVS")) {
                    bl = this.pruneEmptyDirectory(fileArray[n]);
                }
                if (!bl) break;
                ++n;
            }
            if (bl && (file2 = new File(file, "CVS/Entries")).exists()) {
                File file3 = new File(file, "CVS");
                File[] fileArray2 = file3.listFiles();
                int n2 = 0;
                while (n2 < fileArray2.length) {
                    fileArray2[n2].delete();
                    ++n2;
                }
                file3.delete();
                file.delete();
            }
        }
        return bl;
    }

    private void pruneEmptyDirectories() throws IOException {
        Iterator iterator = this.emptyDirectories.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists()) continue;
            this.pruneEmptyDirectory(file);
        }
        this.emptyDirectories.clear();
    }
}

