/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;

public class LogInformation
extends FileInfoContainer {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private File file;
    private String repositoryFilename;
    private String headRevision;
    private String branch;
    private String accessList;
    private String keywordSubstitution;
    private String totalRevisions;
    private String selectedRevisions;
    private String description;
    private String locks;
    private List revisions = new LinkedList();
    private List symbolicNames = null;
    private StringBuffer symNamesBuffer = new StringBuffer();

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getRepositoryFilename() {
        return this.repositoryFilename;
    }

    public void setRepositoryFilename(String string) {
        this.repositoryFilename = string;
    }

    public String getHeadRevision() {
        return this.headRevision;
    }

    public void setHeadRevision(String string) {
        this.headRevision = string;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String string) {
        this.branch = string;
    }

    public String getAccessList() {
        return this.accessList;
    }

    public void setAccessList(String string) {
        this.accessList = string;
    }

    public String getKeywordSubstitution() {
        return this.keywordSubstitution;
    }

    public void setKeywordSubstitution(String string) {
        this.keywordSubstitution = string;
    }

    public String getTotalRevisions() {
        return this.totalRevisions;
    }

    public void setTotalRevisions(String string) {
        this.totalRevisions = string;
    }

    public String getSelectedRevisions() {
        return this.selectedRevisions;
    }

    public void setSelectedRevisions(String string) {
        this.selectedRevisions = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getLocks() {
        return this.locks;
    }

    public void setLocks(String string) {
        this.locks = string;
    }

    public void addRevision(Revision revision) {
        this.revisions.add(revision);
    }

    public List getRevisionList() {
        return this.revisions;
    }

    public Revision getRevision(String string) {
        Iterator iterator = this.revisions.iterator();
        while (iterator.hasNext()) {
            Revision revision = (Revision)iterator.next();
            if (!revision.getNumber().equals(string)) continue;
            return revision;
        }
        return null;
    }

    public void addSymbolicName(String string, String string2) {
        this.symNamesBuffer.append(string);
        this.symNamesBuffer.append(" ");
        this.symNamesBuffer.append(string2);
        this.symNamesBuffer.append("\n");
    }

    /*
     * Unable to fully structure code
     */
    private void createSymNames() {
        var1_1 = 0;
        var2_2 = 0;
        this.symbolicNames = new LinkedList<E>();
        ** GOTO lbl19
        {
            ++var1_1;
            do {
                if (var1_1 < this.symNamesBuffer.length() && this.symNamesBuffer.charAt(var1_1) != '\n') continue block0;
                if (var1_1 <= var2_2) continue;
                var3_3 = this.symNamesBuffer.substring(var2_2, var1_1);
                var4_4 = var3_3.substring(0, var3_3.indexOf(32));
                var5_5 = var3_3.substring(var3_3.indexOf(32) + 1);
                var6_6 = new SymName();
                var6_6.setName(var4_4);
                var6_6.setRevision(var5_5);
                this.symbolicNames.add(var6_6);
                var2_2 = var1_1 + 1;
                ++var1_1;
lbl19:
                // 3 sources

            } while (var1_1 <= this.symNamesBuffer.length() - 1);
        }
        this.symNamesBuffer = new StringBuffer();
    }

    public List getAllSymbolicNames() {
        if (this.symbolicNames == null) {
            this.createSymNames();
        }
        return this.symbolicNames;
    }

    public List getSymNamesForRevision(String string) {
        if (this.symbolicNames == null) {
            this.createSymNames();
        }
        Iterator iterator = this.symbolicNames.iterator();
        LinkedList<SymName> linkedList = new LinkedList<SymName>();
        while (iterator.hasNext()) {
            SymName symName = (SymName)iterator.next();
            if (!symName.getRevision().equals(string)) continue;
            linkedList.add(symName);
        }
        return linkedList;
    }

    public SymName getSymName(String string) {
        if (this.symbolicNames == null) {
            this.createSymNames();
        }
        Iterator iterator = this.symbolicNames.iterator();
        while (iterator.hasNext()) {
            SymName symName = (SymName)iterator.next();
            if (!symName.getName().equals(string)) continue;
            return symName;
        }
        return null;
    }

    public Revision createNewRevision(String string) {
        Revision revision = new Revision();
        revision.setNumber(string);
        return revision;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("\nFile: " + (this.file != null ? this.file.getAbsolutePath() : "null"));
        stringBuffer.append("\nRepositoryFile: " + this.repositoryFilename);
        stringBuffer.append("\nHead revision: " + this.headRevision);
        return stringBuffer.toString();
    }

    public class Revision {
        private String number;
        private Date date;
        private String dateString;
        private String author;
        private String state;
        private String lines;
        private String message;
        private String branches;

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String string) {
            this.number = string;
        }

        public Date getDate() {
            return this.date;
        }

        public String getDateString() {
            return this.dateString;
        }

        public void setDateString(String string) {
            this.dateString = string;
            if (string == null) {
                this.date = null;
                return;
            }
            try {
                this.date = DATE_FORMAT.parse(string);
            }
            catch (Exception exception) {
                System.err.println("Couldn't parse date " + string);
            }
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String string) {
            this.author = string;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String string) {
            this.state = string;
        }

        public String getLines() {
            return this.lines;
        }

        public void setLines(String string) {
            this.lines = string;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String string) {
            this.message = string;
        }

        public String getBranches() {
            return this.branches;
        }

        public void setBranches(String string) {
            this.branches = string;
        }
    }

    public class SymName {
        private String name;
        private String revision;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setRevision(String string) {
            this.revision = string;
        }

        public String getRevision() {
            return this.revision;
        }
    }
}

