/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.update;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class UpdateBuilder
implements Builder {
    private DefaultFileInfoContainer fileInfoContainer;
    private EventManager eventManager;
    private String localPath;
    private static final String UNKNOWN = "server: nothing known about";
    private static final String EXAM_DIR = "server: Updating";
    private static final String TO_ADD = "server: use `cvs add' to create an entry for";
    private static final String STATES = "U P A R M C ? ";
    private static final String WARNING = "server: warning: ";
    private static final String SERVER = "server: ";
    private static final String PERTINENT = "is not (any longer) pertinent";
    private static final String MERGING = "Merging differences between ";
    private static final String CONFLICTS = "rcsmerge: warning: conflicts during merge";
    private static final String NOT_IN_REPOSITORY = "is no longer in the repository";

    public UpdateBuilder(EventManager eventManager, String string) {
        this.eventManager = eventManager;
        this.localPath = string;
    }

    public void outputDone() {
        if (this.fileInfoContainer != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.fileInfoContainer));
            this.fileInfoContainer = null;
        }
    }

    public void parseLine(String string, boolean bl) {
        if (string.indexOf(UNKNOWN) >= 0) {
            this.processUnknownFile(string, string.indexOf(UNKNOWN) + UNKNOWN.length());
        } else if (string.indexOf(TO_ADD) >= 0) {
            this.processUnknownFile(string, string.indexOf(TO_ADD) + TO_ADD.length());
        } else {
            if (string.indexOf(EXAM_DIR) >= 0) {
                return;
            }
            if (string.startsWith(MERGING)) {
                this.outputDone();
                if (this.fileInfoContainer == null) {
                    this.fileInfoContainer = new DefaultFileInfoContainer();
                }
                this.fileInfoContainer.setType("G");
            } else if (string.startsWith(CONFLICTS)) {
                if (this.fileInfoContainer != null) {
                    this.fileInfoContainer.setType("C");
                }
            } else {
                String string2;
                if (string.indexOf(WARNING) >= 0) {
                    if (string.indexOf(PERTINENT) > 0) {
                        String string3 = string.substring(string.indexOf(WARNING) + WARNING.length(), string.indexOf(PERTINENT)).trim();
                        this.processNotPertinent(string3);
                    }
                    return;
                }
                if (string.indexOf(NOT_IN_REPOSITORY) > 0) {
                    String string4 = string.substring(string.indexOf(SERVER) + SERVER.length(), string.indexOf(NOT_IN_REPOSITORY)).trim();
                    this.processNotPertinent(string4);
                    return;
                }
                if (string.length() > 2 && STATES.indexOf(string2 = string.substring(0, 2)) >= 0) {
                    this.processFile(string);
                    return;
                }
            }
        }
    }

    private File createFile(String string) {
        return new File(this.localPath, string);
    }

    private void ensureExistingFileInfoContainer() {
        if (this.fileInfoContainer != null) {
            return;
        }
        this.fileInfoContainer = new DefaultFileInfoContainer();
    }

    private void processUnknownFile(String string, int n) {
        this.outputDone();
        this.fileInfoContainer = new DefaultFileInfoContainer();
        this.fileInfoContainer.setType("?");
        String string2 = string.substring(n).trim();
        this.fileInfoContainer.setFile(this.createFile(string2));
    }

    private void processFile(String string) {
        String string2 = string.substring(2).trim();
        if (string2.startsWith("no file")) {
            string2 = string2.substring(8);
        }
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        File file = this.createFile(string2);
        if (this.fileInfoContainer != null && file.equals(this.fileInfoContainer.getFile())) {
            this.outputDone();
            return;
        }
        this.outputDone();
        this.ensureExistingFileInfoContainer();
        this.fileInfoContainer.setType(string.substring(0, 1));
        this.fileInfoContainer.setFile(file);
    }

    private void processLog(String string) {
        this.ensureExistingFileInfoContainer();
    }

    private void processNotPertinent(String string) {
        this.outputDone();
        File file = this.createFile(string);
        this.ensureExistingFileInfoContainer();
        this.fileInfoContainer.setType("Y");
        this.fileInfoContainer.setFile(file);
    }

    public void parseEnhancedMessage(String string, Object object) {
        if (string.equals("Merged_Response_File_Path") && this.fileInfoContainer != null) {
            String string2 = object.toString();
            File file = new File(string2);
            this.fileInfoContainer.setFile(file);
        }
    }
}

