/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.scripting;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.scripting.AbstractScriptType;
import org.openide.execution.ScriptType;

public class BeanShellScriptType
extends AbstractScriptType {
    static final long serialVersionUID = -3650287473944191532L;
    private static final String BSH_EXTENSION = "bsh";
    private static final String BSH_DISPLAY_NAME = "BeanShell";
    private transient Interpreter bshInterpreter;

    public BeanShellScriptType() {
        this.getExtensions().addExtension(BSH_EXTENSION);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new BeanShellScriptType();
    }

    private Interpreter getInterpreter() {
        if (this.bshInterpreter == null) {
            this.bshInterpreter = new Interpreter();
        }
        return this.bshInterpreter;
    }

    protected String displayName() {
        return BSH_DISPLAY_NAME;
    }

    public void addVariable(String string, Object object) {
        this.getInterpreter().setVariable(string, object);
    }

    public Object eval(String string, ScriptType.Context context) throws InvocationTargetException {
        try {
            return this.getInterpreter().eval(string);
        }
        catch (TargetError targetError) {
            Throwable throwable = targetError.getTarget();
            throw new InvocationTargetException(throwable, throwable.getMessage());
        }
        catch (EvalError evalError) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                evalError.printStackTrace();
            }
            return null;
        }
    }

    public Object eval(Reader reader, ScriptType.Context context) throws InvocationTargetException {
        try {
            return this.getInterpreter().eval(reader);
        }
        catch (TargetError targetError) {
            Throwable throwable = targetError.getTarget();
            throw new InvocationTargetException(throwable, throwable.getMessage());
        }
        catch (EvalError evalError) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                evalError.printStackTrace();
            }
            return null;
        }
    }

    public void exec(Reader reader, ScriptType.Context context) throws InvocationTargetException {
        block3: {
            try {
                this.getInterpreter().eval(reader);
            }
            catch (TargetError targetError) {
                Throwable throwable = targetError.getTarget();
                throw new InvocationTargetException(throwable, throwable.getMessage());
            }
            catch (EvalError evalError) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                evalError.printStackTrace();
            }
        }
    }
}

