/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.scripting;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Utilities;
import org.netbeans.modules.scripting.navigation.NavigationSupport;
import org.netbeans.modules.scripting.navigation.NodeNavigation;
import org.openide.TopManager;
import org.openide.execution.ExecutorTask;
import org.openide.execution.ScriptType;
import org.openide.filesystems.FileObject;
import org.openide.util.io.ReaderInputStream;
import org.openide.windows.InputOutput;

public class ScriptUtils {
    public static String LINE_CONTINUATION_CHAR = "\\";
    private static final String SEPARATOR = "\r\n";

    public static void execute(JEditorPane jEditorPane, ScriptType scriptType) {
        ScriptUtils.evaluate0(jEditorPane, scriptType, false);
    }

    public static void evaluate(JEditorPane jEditorPane, ScriptType scriptType) {
        ScriptUtils.evaluate0(jEditorPane, scriptType, true);
    }

    private static void evaluate0(final JEditorPane jEditorPane, ScriptType scriptType, boolean bl) {
        if (scriptType == null) {
            scriptType = ScriptType.getDefault();
        }
        final Object[] objectArray = new Object[1];
        try {
            int n = jEditorPane.getCaretPosition();
            String string = jEditorPane.getSelectedText();
            if (string == null) {
                int n2 = Utilities.getRowStart(jEditorPane, n);
                int n3 = Utilities.getRowEnd(jEditorPane, n);
                string = jEditorPane.getText(n2, n3 - n2);
                bl = false;
            }
            final String string2 = string;
            final ScriptType scriptType2 = scriptType;
            final InputOutput inputOutput = TopManager.getDefault().getIO(scriptType2.getName(), false);
            if (bl) {
                ExecutorTask executorTask = TopManager.getDefault().getExecutionEngine().execute("scripting", new Runnable(){

                    public void run() {
                        try {
                            objectArray[0] = scriptType2.eval(string2);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Throwable throwable = invocationTargetException.getTargetException();
                            if (throwable != null) {
                                throwable.printStackTrace((PrintWriter)inputOutput.getOut());
                            }
                            invocationTargetException.printStackTrace((PrintWriter)inputOutput.getOut());
                        }
                    }
                }, inputOutput);
                executorTask.result();
                final String string3 = objectArray[0] == null ? "null" : objectArray[0].toString();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Document document = jEditorPane.getDocument();
                        try {
                            int n = document.getLength();
                            document.insertString(n, "\n" + string3, null);
                            jEditorPane.setCaretPosition(n + 1 + string3.length());
                        }
                        catch (BadLocationException badLocationException) {
                            TopManager.getDefault().getErrorManager().notify((Throwable)badLocationException);
                        }
                    }
                });
            } else {
                ExecutorTask executorTask = TopManager.getDefault().getExecutionEngine().execute("scripting", new Runnable(){

                    public void run() {
                        try {
                            scriptType2.exec(string2);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Throwable throwable = invocationTargetException.getTargetException();
                            if (throwable != null) {
                                throwable.printStackTrace((PrintWriter)inputOutput.getOut());
                            }
                            invocationTargetException.printStackTrace((PrintWriter)inputOutput.getOut());
                        }
                    }
                }, inputOutput);
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify((Throwable)exception);
        }
    }

    public static String getLangFromFilename(FileObject fileObject) {
        String string = null;
        Enumeration enumeration = ScriptType.scriptTypes();
        while (enumeration.hasMoreElements()) {
            ScriptType scriptType = (ScriptType)enumeration.nextElement();
            if (!scriptType.acceptFileObject(fileObject)) continue;
            string = scriptType.getName();
        }
        return string;
    }

    public static String[] getLanguages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = ScriptType.scriptTypes();
        while (enumeration.hasMoreElements()) {
            ScriptType scriptType = (ScriptType)enumeration.nextElement();
            arrayList.add(scriptType.getName());
        }
        return arrayList.toArray(new String[0]);
    }

    public static ScriptType getScriptType(String string) {
        Enumeration enumeration = ScriptType.scriptTypes();
        while (enumeration.hasMoreElements()) {
            ScriptType scriptType = (ScriptType)enumeration.nextElement();
            if (!scriptType.getName().equals(string)) continue;
            return scriptType;
        }
        return null;
    }

    public static Map readParameters(BufferedReader bufferedReader, BufferedWriter bufferedWriter, String[] stringArray, String[] stringArray2) throws IOException {
        boolean bl;
        bufferedWriter.write("Please enter following keys (type key=value each on separate line): \r\n");
        bufferedWriter.flush();
        Properties properties = new Properties();
        do {
            String string = null;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = ScriptUtils.readLine(bufferedReader)) != null) {
                if (string.endsWith("\\")) {
                    stringBuffer.append(string.substring(0, string.length() - 1));
                    continue;
                }
                stringBuffer.append(string);
                break;
            }
            Properties properties2 = new Properties();
            properties2.load((InputStream)new ReaderInputStream((Reader)new StringReader(stringBuffer.toString())));
            ((Hashtable)properties).putAll(properties2);
            bl = true;
            int n = 0;
            while (n < stringArray.length) {
                if (!((Hashtable)properties).containsKey(stringArray[n])) {
                    bl = false;
                    bufferedWriter.write("Key " + stringArray[n] + " not suplied" + SEPARATOR);
                    bufferedWriter.flush();
                }
                ++n;
            }
            bufferedWriter.flush();
        } while (!bl);
        return properties;
    }

    public static String readLine(BufferedReader bufferedReader) throws IOException {
        String string = "";
        String string2 = null;
        do {
            if ((string2 = bufferedReader.readLine()) == null || !(string = string + string2).endsWith(LINE_CONTINUATION_CHAR)) continue;
            string = string.substring(0, string.length() - 1);
        } while (string2 != null && string2.endsWith(LINE_CONTINUATION_CHAR));
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static String convertLine(String var0) {
        var1_1 = new StringBuffer(var0);
        var2_2 = 0;
        ** GOTO lbl25
        {
            if (var2_2 > 0) {
                var1_1.deleteCharAt(var2_2 - 1);
                var1_1.deleteCharAt(var2_2 - 1);
                --var2_2;
            } else if (var2_2 == 0) {
                var1_1.deleteCharAt(0);
            }
            do {
                if (var2_2 < var1_1.length() && var1_1.charAt(var2_2) == '\b') continue block0;
                while (var2_2 < var1_1.length() && Character.isISOControl(var1_1.charAt(var2_2))) {
                    var1_1.deleteCharAt(var2_2);
                }
                while (var2_2 < var1_1.length() && var1_1.charAt(var2_2) > '\u007f') {
                    var1_1.deleteCharAt(var2_2);
                }
                ++var2_2;
lbl25:
                // 2 sources

            } while (var2_2 < var1_1.length());
        }
        return var1_1.toString().trim();
    }

    public static void registerNavigationSupport(ScriptType scriptType, Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            scriptType.addVariable(string, map.get(string));
        }
    }

    public static void registerNavigationSupport(ScriptType scriptType) {
        NavigationSupport navigationSupport = new NavigationSupport();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        hashMap.put("fjscript", navigationSupport);
        hashMap.put("Fjscript", navigationSupport);
        hashMap.put("ide", new NodeNavigation());
        ScriptUtils.registerNavigationSupport(scriptType, hashMap);
    }

    public static void unregisterNavigationSupport(ScriptType scriptType, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            scriptType.addVariable(string, null);
        }
    }

    public static void unregisterNavigationSupport(ScriptType scriptType) {
        HashSet<String> hashSet = new HashSet<String>(3);
        hashSet.add("fjscript");
        hashSet.add("Fjscript");
        hashSet.add("ide");
        ScriptUtils.unregisterNavigationSupport(scriptType, hashSet);
    }
}

