/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.javac.v8.comp;

import org.netbeans.lib.javac.v8.code.Flags;
import org.netbeans.lib.javac.v8.code.Kinds;
import org.netbeans.lib.javac.v8.code.Symbol;
import org.netbeans.lib.javac.v8.code.Type;
import org.netbeans.lib.javac.v8.code.TypeTags;
import org.netbeans.lib.javac.v8.comp.Check;
import org.netbeans.lib.javac.v8.comp.Symtab;
import org.netbeans.lib.javac.v8.util.Hashtable;
import org.netbeans.lib.javac.v8.util.List;
import org.netbeans.lib.javac.v8.util.ListBuffer;
import org.netbeans.lib.javac.v8.util.Log;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Infer
implements Kinds,
Flags,
TypeTags {
    Log log;
    Symtab syms;
    Check chk;
    private Hashtable<Type, List<Type>> closureCache = Hashtable.make();

    public Infer(Log log, Symtab symtab) {
        this.syms = symtab;
        this.log = log;
    }

    public static Constraint genTypeC(Type type, Type type2, List<Type> list, Constraint constraint) {
        if (type.tag == 18) {
            return constraint;
        }
        switch (type2.tag) {
            case 14: {
                if (type.tag == 16) {
                    return constraint;
                }
                if (type.tag == 14 || type.tag == 11 || type.tag == 10) {
                    List<Type> list2 = list;
                    while (list2.nonEmpty()) {
                        if (type2 == list2.head) {
                            return constraint.addEq(type, type2);
                        }
                        list2 = list2.tail;
                    }
                }
                return type == type2 ? constraint : Constraint.failure("% is different from %", type, type2);
            }
            case 10: {
                if (type.tag == 16) {
                    return constraint;
                }
                if (type2.tsym == type.tsym) {
                    constraint = Infer.genTypeC(type.outer(), type2.outer(), list, constraint);
                    constraint = Infer.genTypeC(type.typarams(), type2.typarams(), list, constraint);
                    return constraint;
                }
                return Constraint.failure("% is different from %", type, type2);
            }
            case 11: {
                if (type.tag == 16) {
                    return constraint;
                }
                if (type.tag == 11) {
                    return Infer.genTypeC(type.elemtype(), type2.elemtype(), list, constraint);
                }
                return Constraint.failure("% is different from %", type, type2);
            }
        }
        if (type.isGenType(type2)) {
            return constraint;
        }
        return Constraint.failure("% is different from %", type, type2);
    }

    public static Constraint genTypeC(List<Type> list, List<Type> list2, List<Type> list3, Constraint constraint) {
        List<Type> list4 = list;
        List<Type> list5 = list2;
        while (constraint != Constraint.fail && list4.nonEmpty() && list5.nonEmpty()) {
            constraint = Infer.genTypeC((Type)list4.head, (Type)list5.head, list3, constraint);
            list4 = list4.tail;
            list5 = list5.tail;
        }
        if (list4.isEmpty() == list5.isEmpty()) {
            return constraint;
        }
        return Constraint.failure("different lengths: (%) and (%)", list, list2);
    }

    public static Constraint subTypeC(Type type, Type type2, List<Type> list, Constraint constraint) {
        if (type.tag == 18) {
            return constraint;
        }
        switch (type2.tag) {
            case 14: {
                if (type.tag == 16) {
                    return constraint;
                }
                if (type.tag == 14 || type.tag == 11 || type.tag == 10) {
                    List<Type> list2 = list;
                    while (list2.nonEmpty()) {
                        if (type2 == list2.head) {
                            return constraint.addSub(type, type2);
                        }
                        list2 = list2.tail;
                    }
                }
                return type == type2 ? constraint : Constraint.failure("% is not a subtype of %", type, type2);
            }
            case 10: {
                if (type.tag == 16) {
                    return constraint;
                }
                if (type.tsym == type2.tsym) {
                    return type2.allparams().length() == 0 ? constraint : Infer.genTypeC(type, type2, list, constraint);
                }
                if (type.tag == 11) {
                    if (type.isSubType(type2)) {
                        return constraint;
                    }
                    return Constraint.failure("% is not a subtype of %", type, type2);
                }
                if (type.tag == 14) {
                    List<Type> list3 = ((Type.TypeVar)type).getBounds();
                    while (list3.nonEmpty()) {
                        if (((Type)list3.head).tag == 14 || ((Type)list3.head).tsym.isSubClass(type2.tsym)) {
                            return Infer.subTypeC((Type)list3.head, type2, list, constraint);
                        }
                        list3 = list3.tail;
                    }
                    return Constraint.failure("% is not a subtype of %", type, type2);
                }
                if (type.tag == 10) {
                    List list4;
                    Type type3 = type.supertype();
                    if (type3.tag == 10 && (list4 = Infer.subTypeC(type3, type2, list, constraint)) != Constraint.fail) {
                        return list4;
                    }
                    if ((type2.tsym.flags() & 0x200) != 0) {
                        list4 = type.interfaces();
                        while (list4.nonEmpty()) {
                            Constraint constraint2 = Infer.subTypeC((Type)list4.head, type2, list, constraint);
                            if (constraint2 != Constraint.fail) {
                                return constraint2;
                            }
                            list4 = list4.tail;
                        }
                    }
                }
                return Constraint.failure("% is not a subtype of %", type, type2);
            }
            case 11: {
                if (type.tag == 16) {
                    return constraint;
                }
                if (type.tag == 11) {
                    if (type2.elemtype().tag <= 8) {
                        return Infer.genTypeC(type.elemtype(), type2.elemtype(), list, constraint);
                    }
                    return Infer.subTypeC(type.elemtype(), type2.elemtype(), list, constraint);
                }
                return Constraint.failure("% is not a subtype of %", type, type2);
            }
        }
        if (type.isSubType(type2)) {
            return constraint;
        }
        return Constraint.failure("% is not a subtype of %", type, type2);
    }

    public static Constraint subTypeC(List<Type> list, List<Type> list2, List<Type> list3, Constraint constraint) {
        List<Type> list4 = list;
        List<Type> list5 = list2;
        while (constraint != Constraint.fail && list4.nonEmpty() && list5.nonEmpty()) {
            constraint = Infer.subTypeC((Type)list4.head, (Type)list5.head, list3, constraint);
            list4 = list4.tail;
            list5 = list5.tail;
        }
        if (list4.isEmpty() == list5.isEmpty()) {
            return constraint;
        }
        return Constraint.failure("different lengths: (%) and (%)", list, list2);
    }

    public static Type join(Type type, Type type2) {
        if (type == type2 || type2.tag == 16) {
            return type;
        }
        switch (type.tag) {
            case 16: {
                return type2;
            }
            case 10: {
                if (type.tsym == type2.tsym) {
                    Type type3 = type.outer();
                    Type type4 = type2.outer();
                    List<Type> list = type.typarams();
                    List<Type> list2 = type2.typarams();
                    Type type5 = Infer.join(type3, type4);
                    List<Type> list3 = Infer.join(list, list2);
                    if (type5 == null || list3 == null) {
                        return null;
                    }
                    if (type5 == type3 && list3 == list) {
                        return type;
                    }
                    if (type5 == type4 && list3 == list2) {
                        return type2;
                    }
                    return new Type.ClassType(type5, list3, type.tsym);
                }
                return null;
            }
            case 11: {
                if (type2.tag == 11) {
                    Type type6;
                    Type type7 = type.elemtype();
                    Type type8 = Infer.join(type7, type6 = type2.elemtype());
                    if (type8 == null) {
                        return null;
                    }
                    if (type8 == type7) {
                        return type;
                    }
                    if (type8 == type6) {
                        return type2;
                    }
                    return new Type.ArrayType(type8);
                }
                return null;
            }
        }
        return type.isSameType(type2) ? type : null;
    }

    public static List<Type> join(List<Type> list, List<Type> list2) {
        if (list.isEmpty() && list2.isEmpty()) {
            return Type.emptyList;
        }
        if (list.nonEmpty() && list2.nonEmpty()) {
            Type type = Infer.join((Type)list.head, (Type)list2.head);
            List<Type> list3 = Infer.join(list.tail, list2.tail);
            if (type == null || list3 == null) {
                return null;
            }
            if (type == list.head && list3 == list.tail) {
                return list;
            }
            if (type == list2.head && list3 == list2.tail) {
                return list2;
            }
            return list3.prepend(type);
        }
        return null;
    }

    List<Type> closure(Type type) {
        List<Type> list = this.closureCache.get(type);
        if (list == null) {
            Type type2 = type.supertype();
            list = type2.tag == 10 ? this.insert(this.closure(type2), type) : Type.emptyList.prepend(type);
            List<Type> list2 = type.interfaces();
            while (list2.nonEmpty()) {
                list = this.union(list, this.closure((Type)list2.head));
                list2 = list2.tail;
            }
            this.closureCache.put(type, list);
        }
        return list;
    }

    private List<Type> insert(List<Type> list, Type type) {
        if (list.isEmpty() || type.tsym.precedes(((Type)list.head).tsym)) {
            return list.prepend(type);
        }
        if (((Type)list.head).tsym.precedes(type.tsym)) {
            return this.insert(list.tail, type).prepend((Type)list.head);
        }
        return list;
    }

    private List<Type> union(List<Type> list, List<Type> list2) {
        if (list.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list;
        }
        if (((Type)list.head).tsym.precedes(((Type)list2.head).tsym)) {
            return this.union(list.tail, list2).prepend((Type)list.head);
        }
        if (((Type)list2.head).tsym.precedes(((Type)list.head).tsym)) {
            return this.union(list, list2.tail).prepend((Type)list2.head);
        }
        return this.union(list.tail, list2.tail).prepend((Type)list.head);
    }

    List<Type> intersect(List<Type> list, List<Type> list2) {
        if (list == list2) {
            return list;
        }
        if (list.isEmpty() || list2.isEmpty()) {
            return Type.emptyList;
        }
        if (((Type)list.head).tsym.precedes(((Type)list2.head).tsym)) {
            return this.intersect(list.tail, list2);
        }
        if (((Type)list2.head).tsym.precedes(((Type)list.head).tsym)) {
            return this.intersect(list, list2.tail);
        }
        Type type = Infer.join((Type)list.head, (Type)list2.head);
        List<Type> list3 = this.intersect(list.tail, list2.tail);
        return type == null ? list3 : list3.prepend(type);
    }

    Type firstInDiff(List<Type> list, List<Type> list2) {
        while (list.nonEmpty() && list2.nonEmpty() && list.head == list2.head) {
            list = list.tail;
            list2 = list2.tail;
        }
        return list.nonEmpty() ? (Type)list.head : null;
    }

    Type min(List<Type> list) {
        if (list.isEmpty()) {
            return Type.botType;
        }
        Type type = this.firstInDiff(list, this.closure((Type)list.head));
        return type == null ? (Type)list.head : null;
    }

    List<Constraint> distribute(Constraint constraint, List<Type> list) {
        List<Constraint> list2 = List.make(list.length(), Constraint.empty);
        while (constraint != Constraint.empty) {
            List<Type> list3 = list;
            List<Constraint> list4 = list2;
            while (list3.nonEmpty() && list3.head != constraint.hi) {
                list3 = list3.tail;
                list4 = list4.tail;
            }
            if (list3.nonEmpty()) {
                list4.head = new Constraint(constraint.kind, constraint.lo, constraint.hi, (Constraint)list4.head);
            }
            constraint = constraint.rest;
        }
        return list2;
    }

    Type lub(Constraint constraint) {
        if (constraint == Constraint.empty) {
            return Type.botType;
        }
        if (constraint == Constraint.fail) {
            return null;
        }
        switch (constraint.lo.tag) {
            case 16: {
                return this.lub(constraint.rest);
            }
            case 11: {
                Constraint constraint2 = Constraint.empty;
                Constraint constraint3 = constraint;
                while (constraint3 != Constraint.empty) {
                    switch (constraint3.lo.tag) {
                        case 16: {
                            break;
                        }
                        case 11: {
                            constraint2 = new Constraint(constraint3.kind, constraint3.lo.elemtype(), constraint3.hi, constraint2);
                            break;
                        }
                        case 10: {
                            if (constraint3.kind == 2) {
                                return null;
                            }
                            return this.lub(new Constraint(1, this.syms.objectType, constraint3.hi, constraint3.rest));
                        }
                        default: {
                            return null;
                        }
                    }
                    constraint3 = constraint3.rest;
                }
                Type type = this.lub(constraint2);
                return type == null ? this.syms.objectType : new Type.ArrayType(type);
            }
            case 10: {
                List<Type> list = this.closure(constraint.lo);
                boolean bl = false;
                Constraint constraint4 = constraint.rest;
                while (constraint4 != Constraint.empty) {
                    switch (constraint4.lo.tag) {
                        case 16: {
                            break;
                        }
                        case 11: {
                            if (constraint4.kind == 2) {
                                return null;
                            }
                            list = this.intersect(list, this.closure(this.syms.objectType));
                            break;
                        }
                        case 10: {
                            if (bl) {
                                Type type = Infer.join((Type)list.head, constraint4.lo);
                                if (type == null) {
                                    return type;
                                }
                                list.head = type;
                                break;
                            }
                            list = this.intersect(list, this.closure(constraint4.lo));
                            if (constraint4.kind != 2) break;
                            bl = true;
                            if (constraint4.lo.isGenType((Type)list.head)) break;
                            return null;
                        }
                        default: {
                            return null;
                        }
                    }
                    constraint4 = constraint4.rest;
                }
                return this.min(list);
            }
        }
        Type type = this.lub(constraint.rest);
        return type == null ? type : Infer.join(constraint.lo, type);
    }

    List<Type> typeParams(List<Type> list, List<Type> list2, List<Type> list3) {
        List<Type> list4;
        Constraint constraint = Infer.subTypeC(Type.baseTypes(list3), list2, list, Constraint.empty);
        if (constraint == Constraint.fail) {
            return null;
        }
        ListBuffer<Object> listBuffer = new ListBuffer<Object>();
        List<Constraint> list5 = this.distribute(constraint, list);
        while (list5.nonEmpty()) {
            list4 = this.lub((Constraint)list5.head);
            if (list4 == null) {
                return null;
            }
            listBuffer.append(list4);
            list5 = list5.tail;
        }
        list4 = listBuffer.toList();
        return this.isWithinBounds(list, list4) ? list4 : null;
    }

    String substitute(String string, Object[] objectArray) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '%') {
                stringBuffer.append(objectArray[n++]);
            } else {
                stringBuffer.append(cArray[n2]);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    boolean isWithinBounds(List<Type> list, List<Type> list2) {
        List<Type> list3 = list;
        List<Type> list4 = list2;
        while (list3.nonEmpty()) {
            if (!((Type)list4.head).isSubType(Type.subst(((Type.TypeVar)list3.head).getBounds(), list, list2))) {
                return false;
            }
            list3 = list3.tail;
            list4 = list4.tail;
        }
        return true;
    }

    void checkSafe(int n, Type type, Symbol symbol) {
        if (type.occCount(Type.botType) >= 2) {
            this.checkSafe(n, symbol, type.restype(), symbol.type.restype(), Type.emptyList);
        }
    }

    private List<Type> checkSafe(int n, Symbol symbol, Type type, Type type2, List<Type> list) {
        if (list == null) {
            return null;
        }
        switch (type2.tag) {
            case 14: {
                if (type.occCount(Type.botType) > 0) {
                    List<Type> list2 = list;
                    while (list2.nonEmpty()) {
                        if (list2.head == type2) {
                            if (symbol.kind == 16) {
                                this.log.error(n, "type.var.more.than.once.in.result", type2.tsym.toJava(), symbol.toJava());
                            } else {
                                this.log.error(n, "type.var.more.than.once", type2.tsym.toJava(), symbol.toJava());
                            }
                            return null;
                        }
                        list2 = list2.tail;
                    }
                    return list.prepend(type2);
                }
                return list;
            }
            case 10: {
                return this.checkSafe(n, symbol, type.outer(), type2.outer(), this.checkSafe(n, symbol, type.typarams(), type2.typarams(), list));
            }
            case 11: {
                return this.checkSafe(n, symbol, type.elemtype(), type2.elemtype(), list);
            }
        }
        return list;
    }

    private List<Type> checkSafe(int n, Symbol symbol, List<Type> list, List<Type> list2, List<Type> list3) {
        List<Type> list4 = list;
        List<Type> list5 = list2;
        while (list4.nonEmpty()) {
            list3 = this.checkSafe(n, symbol, (Type)list4.head, (Type)list5.head, list3);
            list4 = list4.tail;
            list5 = list5.tail;
        }
        return list3;
    }

    static class Constraint {
        static final int FAIL = -1;
        static final int EMPTY = 0;
        static final int SUB = 1;
        static final int GEN = 2;
        int kind;
        Type lo;
        Type hi;
        Constraint rest;
        static Constraint empty = new Constraint(0, null, null, null);
        static Constraint fail = new Constraint(-1, null, null, null);
        static String cause;
        static Object arg1;
        static Object arg2;

        public String toString() {
            switch (this.kind) {
                case -1: {
                    return "<fail>";
                }
                case 0: {
                    return "true";
                }
                case 1: {
                    return this.lo + " < " + this.hi + ", " + this.rest;
                }
                case 2: {
                    return this.lo + " = " + this.hi + ", " + this.rest;
                }
            }
            return "?";
        }

        Constraint(int n, Type type, Type type2, Constraint constraint) {
            this.lo = type;
            this.hi = type2;
            this.kind = n;
            this.rest = constraint;
        }

        Constraint addSub1(Type type, Type type2) {
            if (this.kind == 0) {
                return new Constraint(1, type, type2, this);
            }
            if (this.kind == -1) {
                return this;
            }
            if (this.kind == 2 && this.hi == type2) {
                if (type.isSubType(this.lo)) {
                    return this;
                }
                return Constraint.failure("% is not a subtype of %", type, this.lo);
            }
            Constraint constraint = this.rest.addSub(type, type2);
            if (this.rest == constraint) {
                return this;
            }
            if (constraint.kind == -1) {
                return constraint;
            }
            return new Constraint(this.kind, this.lo, this.hi, constraint);
        }

        Constraint addSub(Type type, Type type2) {
            Constraint constraint = this.addSub1(type, type2);
            if (type2.bound().tag == 14) {
                constraint = constraint.addSub(type, type2.bound());
            }
            return constraint;
        }

        Constraint addEq1(Type type, Type type2) {
            if (this.kind == 0) {
                return new Constraint(2, type, type2, this);
            }
            if (this.kind == -1) {
                return this;
            }
            if (this.kind == 2 && this.hi == type2) {
                if (this.lo.isSameType(type)) {
                    return this;
                }
                return Constraint.failure("% is different from %", this.lo, type);
            }
            if (this.kind == 1 && this.hi == type2) {
                if (this.lo.isSubType(type)) {
                    return this.rest.addEq(type, type2);
                }
                return Constraint.failure("% is not a subtype of %", this.lo, type);
            }
            Constraint constraint = this.rest.addEq(type, type2);
            if (this.rest == constraint) {
                return this;
            }
            if (constraint.kind == -1) {
                return constraint;
            }
            return new Constraint(this.kind, this.lo, this.hi, constraint);
        }

        Constraint addEq(Type type, Type type2) {
            Constraint constraint = this.addEq1(type, type2);
            if (type2.bound().tag == 14) {
                constraint = constraint.addSub(type, type2.bound());
            }
            return constraint;
        }

        static Constraint failure(String string, Object object, Object object2) {
            cause = string;
            arg1 = object;
            arg2 = object2;
            return fail;
        }
    }
}

