/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.util.Vector;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.BExtent;
import org.netbeans.lib.terminalemulator.Line;
import org.netbeans.lib.terminalemulator.LineVisitor;
import org.netbeans.lib.terminalemulator.WordDelineator;

class Buffer {
    private OurVector lines = new OurVector();
    public int nlines;
    private int visible_cols;
    private int extra_cols;

    public int visibleCols() {
        return this.visible_cols;
    }

    public int totalCols() {
        return this.visible_cols + this.extra_cols;
    }

    public Buffer(int n) {
        this.visible_cols = n;
    }

    public void setVisibleCols(int n) {
        int n2 = n - this.visible_cols;
        this.visible_cols = n;
        this.extra_cols -= n2;
        if (this.extra_cols < 0) {
            this.extra_cols = 0;
        }
    }

    public void noteColumn(int n) {
        int n2 = n - this.visible_cols;
        if (n2 > this.extra_cols) {
            this.extra_cols = n2;
        }
    }

    Line lineAt(int n) {
        try {
            return (Line)this.lines.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    Line bottom() {
        return this.lineAt(this.nlines);
    }

    public Line appendLine() {
        Line line = new Line();
        this.lines.add(line);
        ++this.nlines;
        return line;
    }

    public Line addLineAt(int n) {
        Line line = new Line();
        this.lines.add(n, line);
        ++this.nlines;
        return line;
    }

    public void removeLinesAt(int n, int n2) {
        this.lines.removeRange(n, n + n2);
        this.nlines -= n2;
    }

    public void removeLineAt(int n) {
        this.lines.remove(n);
        --this.nlines;
    }

    public Line moveLineFromTo(int n, int n2) {
        Line line = (Line)this.lines.remove(n);
        this.lines.add(n2, line);
        return line;
    }

    void visitLines(BCoord bCoord, BCoord bCoord2, boolean bl, LineVisitor lineVisitor) {
        if (bCoord.row == bCoord2.row) {
            Line line = this.lineAt(bCoord.row);
            lineVisitor.visit(line, bCoord.row, bCoord.col, bCoord2.col);
        } else {
            boolean bl2 = false;
            Line line = this.lineAt(bCoord.row);
            bl2 = bl && !line.isWrapped() ? lineVisitor.visit(line, bCoord.row, bCoord.col, this.totalCols()) : lineVisitor.visit(line, bCoord.row, bCoord.col, line.length() - 1);
            if (!bl2) {
                return;
            }
            int n = bCoord.row + 1;
            while (n < bCoord2.row) {
                line = this.lineAt(n);
                bl2 = bl && !line.isWrapped() ? lineVisitor.visit(line, n, 0, this.totalCols()) : lineVisitor.visit(line, n, 0, line.length() - 1);
                if (!bl2) {
                    return;
                }
                ++n;
            }
            line = this.lineAt(bCoord2.row);
            bl2 = lineVisitor.visit(line, bCoord2.row, 0, bCoord2.col);
            if (!bl2) {
                return;
            }
        }
    }

    void reverseVisitLines(BCoord bCoord, BCoord bCoord2, boolean bl, LineVisitor lineVisitor) {
        if (bCoord.row == bCoord2.row) {
            Line line = this.lineAt(bCoord.row);
            lineVisitor.visit(line, bCoord.row, bCoord.col, bCoord2.col);
        } else {
            boolean bl2 = false;
            Line line = this.lineAt(bCoord2.row);
            bl2 = lineVisitor.visit(line, bCoord2.row, 0, bCoord2.col);
            if (!bl2) {
                return;
            }
            int n = bCoord2.row - 1;
            while (n > bCoord.row) {
                line = this.lineAt(n);
                bl2 = bl && !line.isWrapped() ? lineVisitor.visit(line, n, 0, this.totalCols()) : lineVisitor.visit(line, n, 0, line.length() - 1);
                if (!bl2) {
                    return;
                }
                --n;
            }
            line = this.lineAt(bCoord.row);
            bl2 = bl && !line.isWrapped() ? lineVisitor.visit(line, bCoord.row, bCoord.col, this.totalCols()) : lineVisitor.visit(line, bCoord.row, bCoord.col, line.length() - 1);
            if (!bl2) {
                return;
            }
        }
    }

    public BExtent find_word(WordDelineator wordDelineator, BCoord bCoord) {
        Line line = this.lineAt(bCoord.row);
        if (bCoord.col >= line.length()) {
            return new BExtent(bCoord, bCoord);
        }
        int n = wordDelineator.findLeft(line.stringBuffer(), bCoord.col);
        int n2 = wordDelineator.findRight(line.stringBuffer(), bCoord.col);
        return new BExtent(new BCoord(bCoord.row, n), new BCoord(bCoord.row, n2));
    }

    public BCoord backup(BCoord bCoord) {
        if (bCoord.col > 0) {
            return new BCoord(bCoord.row, bCoord.col - 1);
        }
        int n = bCoord.row - 1;
        while (n >= 0) {
            Line line = this.lineAt(n);
            if (line.length() != 0) {
                return new BCoord(n, line.length() - 1);
            }
            --n;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public BCoord advance(BCoord var1_1) {
        var2_2 = var1_1.row;
        var3_3 = var1_1.col;
        var4_4 = this.lineAt(var2_2);
        if (++var3_3 >= var4_4.length()) ** GOTO lbl9
        return new BCoord(var2_2, var3_3);
lbl-1000:
        // 1 sources

        {
            var4_4 = this.lineAt(var2_2);
            if (var4_4.length() == 0) continue;
            return new BCoord(var2_2, 0);
lbl9:
            // 2 sources

            ** while (++var2_2 < this.nlines)
        }
lbl10:
        // 1 sources

        return null;
    }

    public void printStats() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.nlines) {
            Line line = this.lineAt(n3);
            n2 += line.capacity();
            n += line.length();
            ++n3;
        }
        System.out.println("  nlines " + this.nlines + "  nchars " + n + "  ncapacity " + n2);
    }

    class OurVector
    extends Vector {
        OurVector() {
        }

        public void removeRange(int n, int n2) {
            super.removeRange(n, n2);
        }
    }
}

