/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Code;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.Field;

public final class Method
extends Field {
    private boolean includeCode;
    private Code code;
    private CPClassInfo[] exceptions;

    static Method[] loadMethods(DataInputStream dataInputStream, ConstantPool constantPool, ClassFile classFile, boolean bl) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        Method[] methodArray = new Method[n];
        int n2 = 0;
        while (n2 < n) {
            methodArray[n2] = new Method(dataInputStream, constantPool, classFile, bl);
            ++n2;
        }
        return methodArray;
    }

    Method(DataInputStream dataInputStream, ConstantPool constantPool, ClassFile classFile, boolean bl) throws IOException {
        super(dataInputStream, constantPool, classFile);
        this.includeCode = bl;
        super.loadAttributes(dataInputStream, constantPool);
    }

    final boolean loadAttribute(String string, int n, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        if (this.includeCode && string.equals("Code")) {
            this.code = new Code(dataInputStream, constantPool);
            return true;
        }
        if (string.equals("Exceptions")) {
            this.exceptions = ClassFile.getCPClassList(dataInputStream, constantPool);
            return true;
        }
        return false;
    }

    public final Code getCode() {
        return this.code;
    }

    public final CPClassInfo[] getExceptionClasses() {
        if (this.exceptions == null) {
            this.exceptions = new CPClassInfo[0];
        }
        return this.exceptions;
    }

    public String toString() {
        String string = super.toString();
        CPClassInfo[] cPClassInfoArray = this.getExceptionClasses();
        if (cPClassInfoArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(", throws");
            int n = 0;
            while (n < cPClassInfoArray.length) {
                stringBuffer.append(' ');
                stringBuffer.append(cPClassInfoArray[n].getName());
                ++n;
            }
        }
        return string;
    }

    public final String getDeclaration() {
        return CPMethodInfo.getFullMethodName(this.getName(), this.getDescriptor());
    }
}

