/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.openide.windows.TopComponent;

public class GUIManager
implements Serializable {
    public static final String PROP_VIEWS = "views";
    public static final String PROP_ROOT_NODES = "nodes";
    public static final String PROP_VISIBLE = "visible";
    private static GUIManager defaultManager = null;
    private transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private View[] views = new View[0];
    private String[] nodes = new String[0];

    public static synchronized GUIManager getDefault() {
        if (defaultManager == null) {
            defaultManager = new GUIManager();
        }
        return defaultManager;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pcs = new PropertyChangeSupport(this);
    }

    public View[] getViews() {
        return this.views;
    }

    public void addView(View view) {
        this.addView(this.getViews().length, view);
    }

    public void addView(int n, View view) {
        if (this.views.length == 0) {
            this.setViews(new View[]{view});
            return;
        }
        View[] viewArray = new View[this.views.length + 1];
        if (n > 0) {
            System.arraycopy(this.views, 0, viewArray, 0, n);
        }
        if (n < this.views.length) {
            System.arraycopy(this.views, n, viewArray, n + 1, this.views.length - n);
        }
        viewArray[Math.min((int)n, (int)this.views.length)] = view;
        this.setViews(viewArray);
    }

    public boolean removeView(View view) {
        int n = this.views.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.views[n2] == view) {
                if (n == 1) {
                    this.setViews(new View[0]);
                } else {
                    View[] viewArray = new View[n - 1];
                    if (n2 > 0) {
                        System.arraycopy(this.views, 0, viewArray, 0, n2);
                    }
                    if (n2 < n - 1) {
                        System.arraycopy(this.views, n2 + 1, viewArray, n2, n - n2 - 1);
                    }
                    this.setViews(viewArray);
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setViews(View[] viewArray) {
        View[] viewArray2 = this.views;
        this.views = viewArray;
        this.pcs.firePropertyChange(PROP_VIEWS, viewArray2, this.views);
    }

    public String[] getRootNodes() {
        return this.nodes;
    }

    public void addRootNode(String string) {
        this.addRootNode(this.getRootNodes().length, string);
    }

    public void addRootNode(int n, String string) {
        if (this.nodes.length == 0) {
            this.setRootNodes(new String[]{string});
            return;
        }
        String[] stringArray = new String[this.nodes.length + 1];
        if (n > 0) {
            System.arraycopy(this.nodes, 0, stringArray, 0, n);
        }
        if (n < this.nodes.length) {
            System.arraycopy(this.nodes, n, stringArray, n + 1, this.nodes.length - n);
        }
        stringArray[Math.min((int)n, (int)this.nodes.length)] = string;
        this.setRootNodes(stringArray);
    }

    public boolean removeRootNode(String string) {
        int n = this.nodes.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.nodes[n2] == string) {
                if (n == 1) {
                    this.setRootNodes(new String[0]);
                } else {
                    String[] stringArray = new String[n - 1];
                    if (n2 > 0) {
                        System.arraycopy(this.nodes, 0, stringArray, 0, n2);
                    }
                    if (n2 < n - 1) {
                        System.arraycopy(this.nodes, n2 + 1, stringArray, n2, n - n2 - 1);
                    }
                    this.setRootNodes(stringArray);
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setRootNodes(String[] stringArray) {
        String[] stringArray2 = this.nodes;
        this.nodes = stringArray;
        this.pcs.firePropertyChange(PROP_ROOT_NODES, stringArray2, this.nodes);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public static abstract class View
    implements Serializable {
        public abstract String getDisplayName();

        public abstract String getIconBase();

        public abstract TopComponent getComponent();
    }
}

