/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.netbeans.modules.debugger.multisession.Session;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.openide.nodes.FilterNode;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public final class SessionThreadNode
extends FilterNode {
    static final long serialVersionUID = -4736310787521117464L;
    public static final String PROP_SESSION_NAME = "sessionName";
    public static final String PROP_LOCATION_NAME = "locationName";
    public static final String PROP_PERSISTENT = "persistent";
    protected static Image sessionIcon;
    protected static Image sessionCurrentIcon;
    private static SystemAction[] staticActions;
    private final Session session;
    private SessionListener listener;

    SessionThreadNode(Session session) {
        super(DebuggerNode.createNode(session.getThreadsProducer()));
        this.session = session;
        this.initialize();
    }

    private void initialize() {
        String string = this.session.getLocationName();
        String string2 = this.session.getSessionName() + (string.equals("localhost") ? "" : " : " + string);
        this.setDisplayName(string2);
        this.setName(string2);
        this.refreshIcon();
        this.createProperties();
        this.listener = new SessionListener();
        this.session.addPropertyChangeListener(this.listener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerThreadNode");
    }

    private void createProperties() {
    }

    public void destroy() throws IOException {
        super.destroy();
        this.session.removePropertyChangeListener(this.listener);
    }

    protected void refreshIcon() {
    }

    private class SessionListener
    implements PropertyChangeListener {
        private SessionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == null && propertyChangeEvent.getPropertyName().equals("current")) {
                SessionThreadNode.this.refreshIcon();
            }
        }
    }
}

