/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.io.Serializable;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.BreakpointSupport;

public class BreakpointGroupSupport
extends BreakpointGroup
implements Serializable {
    static final long serialVersionUID = 368001278961932551L;
    public static final String PROP_TOP_BREAKPOINT = "topBreakpoint";
    private CoreBreakpoint topBreakpoint = null;

    public BreakpointGroupSupport(String string) {
        this.setName(string == null ? "" : string);
        this.init();
    }

    public boolean addBreakpoint(CoreBreakpoint coreBreakpoint) {
        if (this.topBreakpoint != null && this.topBreakpoint != coreBreakpoint) {
            coreBreakpoint.setHidden(this.topBreakpoint.isHidden());
        }
        return super.addBreakpoint(coreBreakpoint);
    }

    public boolean removeBreakpoint(CoreBreakpoint coreBreakpoint) {
        if (super.removeBreakpoint(coreBreakpoint)) {
            if (coreBreakpoint == this.topBreakpoint) {
                this.setTopBreakpoint(null);
            }
            return true;
        }
        return false;
    }

    public void setName(String string) {
        super.setName(string);
    }

    public CoreBreakpoint getTopBreakpoint() {
        return this.topBreakpoint;
    }

    public void setTopBreakpoint(CoreBreakpoint coreBreakpoint) {
        if (this.topBreakpoint == coreBreakpoint) {
            return;
        }
        if (coreBreakpoint != null) {
            this.addBreakpoint(coreBreakpoint);
        }
        CoreBreakpoint coreBreakpoint2 = this.topBreakpoint;
        this.topBreakpoint = coreBreakpoint;
        if (this.topBreakpoint != null) {
            this.setHidden(this.topBreakpoint.isHidden());
        }
        this.firePropertyChange(PROP_TOP_BREAKPOINT, coreBreakpoint2, coreBreakpoint);
    }

    public void deleteBreakpoints() {
        if (this.topBreakpoint != null) {
            this.delete();
            return;
        }
        CoreBreakpoint[] coreBreakpointArray = this.getBreakpoints();
        int n = coreBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.removeBreakpoint(coreBreakpointArray[n2]);
            coreBreakpointArray[n2].remove();
            ++n2;
        }
        BreakpointGroup[] breakpointGroupArray = this.getGroups();
        n = breakpointGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            if (breakpointGroupArray[n2] instanceof BreakpointGroupSupport) {
                ((BreakpointGroupSupport)breakpointGroupArray[n2]).deleteBreakpoints();
            }
            ++n2;
        }
    }

    public void delete() {
        if (this.getParentGroup() != null) {
            this.getParentGroup().removeGroup(this);
        }
        CoreBreakpoint[] coreBreakpointArray = this.getBreakpoints();
        int n = coreBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.removeBreakpoint(coreBreakpointArray[n2]);
            coreBreakpointArray[n2].remove();
            ++n2;
        }
        BreakpointGroup[] breakpointGroupArray = this.getGroups();
        n = breakpointGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            if (breakpointGroupArray[n2] instanceof BreakpointGroupSupport) {
                ((BreakpointGroupSupport)breakpointGroupArray[n2]).delete();
            }
            ++n2;
        }
    }

    public void setEnabled(boolean bl) {
        CoreBreakpoint[] coreBreakpointArray = this.getBreakpoints();
        int n = coreBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            coreBreakpointArray[n2].setEnabled(bl);
            ++n2;
        }
        BreakpointGroup[] breakpointGroupArray = this.getGroups();
        n = breakpointGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            if (breakpointGroupArray[n2] instanceof BreakpointGroupSupport) {
                ((BreakpointGroupSupport)breakpointGroupArray[n2]).setEnabled(bl);
            }
            ++n2;
        }
    }

    public void setHidden(boolean bl) {
        CoreBreakpoint[] coreBreakpointArray = this.getBreakpoints();
        int n = coreBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            coreBreakpointArray[n2].setHidden(bl);
            ++n2;
        }
        BreakpointGroup[] breakpointGroupArray = this.getGroups();
        n = breakpointGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            if (breakpointGroupArray[n2] instanceof BreakpointGroupSupport) {
                ((BreakpointGroupSupport)breakpointGroupArray[n2]).setHidden(bl);
            }
            ++n2;
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string + this.hashCode() + "[nam. " + this.getName() + " :par. " + this.getParentGroup() + " :br. " + this.getBreakpoints().length + " :gr. " + this.getGroups().length + " :topB. " + (this.topBreakpoint instanceof BreakpointSupport ? ((BreakpointSupport)this.topBreakpoint).toStringIn() : "") + "]";
    }
}

