/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.debugger.support.actions.AddBreakpointAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.text.NbDocument;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class JUtils
extends Utils {
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction;
    static /* synthetic */ Class class$org$openide$src$Element;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$src$ConstructorElement;
    static /* synthetic */ Class class$org$openide$src$FieldElement;

    public static String convertToStringInitializer(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            switch (string.charAt(n2)) {
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                default: {
                    stringBuffer.append(string.charAt(n2));
                }
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    public static String getDefaultType() {
        String string = JUtils.getCurrentFieldName();
        if (string != null && string.length() > 0) {
            return "java-field";
        }
        string = JUtils.getCurrentMethodName();
        if ((string == null || string.length() < 1) && (string = JUtils.getCurrentClassName()) != null && string.length() > 0) {
            return "java-class";
        }
        return "java-line";
    }

    public static String getCurrentClassName() {
        FileObject fileObject;
        AddBreakpointAction addBreakpointAction = (AddBreakpointAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = JUtils.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        Node[] nodeArray = addBreakpointAction.getActivatedNodes();
        if (nodeArray == null) {
            return "";
        }
        if (nodeArray.length != 1) {
            return "";
        }
        Node node = nodeArray[0];
        Element element = (Element)node.getCookie(class$org$openide$src$Element == null ? (class$org$openide$src$Element = JUtils.class$("org.openide.src.Element")) : class$org$openide$src$Element);
        if (element != null) {
            return JUtils.getClassNameForElement(element);
        }
        DataObject dataObject = null;
        if (node instanceof DataNode) {
            dataObject = ((DataNode)node).getDataObject();
        }
        if (dataObject == null) {
            dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = JUtils.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        }
        if (dataObject == null) {
            return "";
        }
        if (dataObject instanceof DataShadow) {
            dataObject = ((DataShadow)dataObject).getOriginal();
        }
        if (!(fileObject = dataObject.getPrimaryFile()).getMIMEType().equals("text/x-java")) {
            return "";
        }
        return fileObject.getPackageName('.');
    }

    public static String getClassNameForElement(Element element) {
        if (element == null) {
            return "";
        }
        if (element instanceof ClassElement) {
            return JUtils.getClassName((ClassElement)element);
        }
        if (element instanceof ConstructorElement) {
            return JUtils.getClassName(((ConstructorElement)element).getDeclaringClass());
        }
        if (element instanceof FieldElement) {
            return JUtils.getClassName(((FieldElement)element).getDeclaringClass());
        }
        return "";
    }

    private static String getClassName(ClassElement classElement) {
        String string = classElement.getName().getFullName();
        if (!classElement.isInner()) {
            return string;
        }
        SourceElement sourceElement = classElement.getSource();
        if (sourceElement == null) {
            return string;
        }
        Identifier identifier = sourceElement.getPackage();
        String string2 = identifier == null ? "" : identifier.getFullName();
        if (string2.length() > 0) {
            return string2 + '.' + string.substring(string2.length() + 1).replace('.', '$');
        }
        return string.replace('.', '$');
    }

    public static String getCurrentMethodName() {
        AddBreakpointAction addBreakpointAction = (AddBreakpointAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = JUtils.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        Node[] nodeArray = addBreakpointAction.getActivatedNodes();
        if (nodeArray == null) {
            return "";
        }
        if (nodeArray.length != 1) {
            return "";
        }
        Node node = nodeArray[0];
        ConstructorElement constructorElement = (ConstructorElement)node.getCookie(class$org$openide$src$ConstructorElement == null ? (class$org$openide$src$ConstructorElement = JUtils.class$("org.openide.src.ConstructorElement")) : class$org$openide$src$ConstructorElement);
        if (constructorElement == null) {
            return "";
        }
        String string = constructorElement.getName().getName();
        String string2 = JUtils.getCurrentClassName();
        int n = string2.lastIndexOf(46);
        int n2 = string2.lastIndexOf(36);
        if (n2 > n) {
            n = n2;
        }
        if (string2.substring(n + 1).equals(string)) {
            return "<init>";
        }
        return string;
    }

    public static String getCurrentFieldName() {
        AddBreakpointAction addBreakpointAction = (AddBreakpointAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = JUtils.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        Node[] nodeArray = addBreakpointAction.getActivatedNodes();
        if (nodeArray == null) {
            return "";
        }
        if (nodeArray.length != 1) {
            return "";
        }
        Node node = nodeArray[0];
        FieldElement fieldElement = (FieldElement)node.getCookie(class$org$openide$src$FieldElement == null ? (class$org$openide$src$FieldElement = JUtils.class$("org.openide.src.FieldElement")) : class$org$openide$src$FieldElement);
        if (fieldElement != null) {
            return fieldElement.getName().getName();
        }
        return JUtils.getSelectedIdentifier();
    }

    public static String getIdentifier() {
        EditorCookie editorCookie = Utils.getCurrentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane jEditorPane = Utils.getCurrentEditor(editorCookie);
        if (jEditorPane == null) {
            return null;
        }
        return JUtils.getIdentifier(editorCookie.getDocument(), jEditorPane, jEditorPane.getCaret().getDot());
    }

    public static String getIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            javax.swing.text.Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset() - n4;
            string = styledDocument.getText(n4, n5);
            int n6 = n3;
            while (n6 > 0 && (Character.isJavaIdentifierPart(string.charAt(n6 - 1)) || string.charAt(n6 - 1) == '.')) {
                --n6;
            }
            int n7 = n3;
            while (n7 < n5 && (Character.isJavaIdentifierPart(string.charAt(n7)) || string.charAt(n7) == '.')) {
                ++n7;
            }
            if (n6 == n7) {
                return null;
            }
            return string.substring(n6, n7);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static String getSelectedIdentifier() {
        String string = Utils.getSelectedText();
        if (string == null) {
            return "";
        }
        if (!Utilities.isJavaIdentifier((String)string)) {
            return "";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

