/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesRoot;
import org.netbeans.modules.debugger.support.DebuggerAnnotation;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.SecondaryDebuggerSupport;
import org.netbeans.modules.debugger.support.SharedIO;
import org.netbeans.modules.debugger.support.StateSupport;
import org.netbeans.modules.debugger.support.actions.CreateVariableAction;
import org.netbeans.modules.debugger.support.actions.RunToCursorAction;
import org.netbeans.modules.debugger.support.actions.SuspendResumeSupport;
import org.netbeans.modules.debugger.support.java.JavaDebuggerSettings;
import org.netbeans.modules.debugger.support.java.JavaProjectSettings;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaThreadGroup;
import org.netbeans.modules.debugger.support.util.Utils;
import org.netbeans.modules.debugger.support.util.ValidatorImpl;
import org.openide.TopManager;
import org.openide.actions.AbstractCompileAction;
import org.openide.cookies.CompilerCookie;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.InputOutput;

public abstract class JavaDebugger
extends SecondaryDebuggerSupport
implements ThreadsRoot,
SharedIO,
ValidatorHolder,
SuspendResumeSupport,
VariablesRoot {
    static final long serialVersionUID = 2791304615739651906L;
    public static final State STATE_RUNNING = new StateSupport(32);
    public static final State STATE_STARTING = new StateSupport(0);
    private static ResourceBundle bundle;
    private transient boolean generalIOName = true;
    private transient Validator validator = new ValidatorImpl();
    boolean showMessages = false;
    boolean followedByEditor = true;
    private transient IOManager io;
    private String sharedIOName;
    private transient HashMap stackAnnotations = new HashMap();
    private transient DebuggerAnnotation currentPC = new DebuggerAnnotation.CurrentPC();
    private VariablesFilter filter;
    private JavaThread markedThread = null;
    private static String errMsgPattern;
    private transient int markedCallStackFrame;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$CreateVariableAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaProjectSettings;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$RunToCursorAction;
    static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebugger == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebugger = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaDebugger")) : class$org$netbeans$modules$debugger$support$java$JavaDebugger));
        }
        return bundle.getString(string);
    }

    public void startDebugger(DebuggerInfo debuggerInfo) throws DebuggerException {
        super.startDebugger(debuggerInfo);
        this.io = this.sharedIOName != null ? new IOManager(this.sharedIOName, false, true) : new IOManager(this.getProcessName(debuggerInfo), true, true);
        this.sharedIOName = null;
        this.io.select();
        this.io.println(JavaDebugger.getString("CTL_Debugger_starting"), 4);
        ((CreateVariableAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateVariableAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateVariableAction = JavaDebugger.class$("org.netbeans.modules.debugger.support.actions.CreateVariableAction")) : class$org$netbeans$modules$debugger$support$actions$CreateVariableAction))).changeEnabled(true);
    }

    public boolean compile(DebuggerInfo debuggerInfo) {
        JavaDebuggerSettings javaDebuggerSettings = (JavaDebuggerSettings)JavaDebuggerSettings.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaDebuggerSettings")) : class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings), (boolean)true);
        if (!javaDebuggerSettings.getRunCompilation()) {
            return true;
        }
        String string = debuggerInfo.getClassName();
        if (string == null) {
            return true;
        }
        ClassElement classElement = ClassElement.forName((String)string);
        if (classElement == null) {
            return true;
        }
        HashSet<CompilerCookie> hashSet = new HashSet<CompilerCookie>();
        CompilerCookie compilerCookie = (CompilerCookie)classElement.getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = JavaDebugger.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        if (compilerCookie == null) {
            return true;
        }
        hashSet.add(compilerCookie);
        return AbstractCompileAction.compile(Collections.enumeration(hashSet), (String)"");
    }

    public synchronized void finishDebugger() throws DebuggerException {
        if (this.getState() == 1) {
            return;
        }
        this.io.stop();
        JavaThreadGroup javaThreadGroup = (JavaThreadGroup)this.getThreadsRoot();
        if (javaThreadGroup != null) {
            javaThreadGroup.removeAll();
        }
        this.setCurrentThread(null);
        this.setState(1);
        ((CreateVariableAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateVariableAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateVariableAction = JavaDebugger.class$("org.netbeans.modules.debugger.support.actions.CreateVariableAction")) : class$org$netbeans$modules$debugger$support$actions$CreateVariableAction))).changeEnabled(false);
        this.validator.clear();
        this.updateWatches();
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void traceInto() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(3);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void traceOver() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(2);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void go() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(5);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void stepOut() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(4);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void runToCursor(Line line) {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(10);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void pause() {
        ((JavaThreadGroup)this.getThreadsRoot()).setSuspended(true);
        this.setState(4);
    }

    public void goToCalledMethod() {
        this.updateCurrentStackPosition();
        if (this.markedThread != null && this.markedCallStackFrame > 0) {
            this.markedThread.setCurrentFrameIndex(--this.markedCallStackFrame);
            JavaDebugger.showCallStackLocation(this.markedThread.getCallStack()[this.markedCallStackFrame]);
            this.updateStoppedState();
        }
    }

    public void goToCallingMethod() {
        this.updateCurrentStackPosition();
        if (this.markedThread != null && this.markedCallStackFrame < this.markedThread.getStackDepth() - 1) {
            this.markedThread.setCurrentFrameIndex(++this.markedCallStackFrame);
            JavaDebugger.showCallStackLocation(this.markedThread.getCallStack()[this.markedCallStackFrame]);
            this.updateStoppedState();
        }
    }

    public void println(String string) {
        this.io.println(string);
    }

    public void setCurrentLine(Line line) {
        if (line != null) {
            Utils.showInEditor(line);
            this.currentPC.attachLine(line);
        } else {
            this.currentPC.detachLine();
        }
        super.setCurrentLine(line);
    }

    public void annotateCallStack() {
        Line line;
        JavaThread javaThread = (JavaThread)this.getCurrentThread();
        Location[] locationArray = javaThread != null ? javaThread.getFilteredCallStack() : new Location[]{};
        HashMap<Line, DebuggerAnnotation> hashMap = new HashMap<Line, DebuggerAnnotation>();
        int n = 1;
        while (n < locationArray.length) {
            line = locationArray[n].getLine();
            if (line != null) {
                DebuggerAnnotation debuggerAnnotation = (DebuggerAnnotation)((Object)this.stackAnnotations.remove(line));
                if (debuggerAnnotation == null) {
                    debuggerAnnotation = new DebuggerAnnotation.CallSite();
                    DebuggerAnnotation debuggerAnnotation2 = hashMap.put(line, debuggerAnnotation);
                    if (debuggerAnnotation2 == null) {
                        debuggerAnnotation.attachLine(line);
                    } else {
                        hashMap.put(line, debuggerAnnotation2);
                    }
                } else {
                    hashMap.put(line, debuggerAnnotation);
                }
            }
            ++n;
        }
        line = this.stackAnnotations.entrySet().iterator();
        while (line.hasNext()) {
            ((DebuggerAnnotation)((Object)((Map.Entry)line.next()).getValue())).detachLine();
        }
        this.stackAnnotations = hashMap;
    }

    public void clearCallStackAnnotations() {
        Iterator iterator = this.stackAnnotations.entrySet().iterator();
        while (iterator.hasNext()) {
            ((DebuggerAnnotation)((Object)iterator.next().getValue())).detachLine();
        }
        this.stackAnnotations.clear();
    }

    public InputOutput getIO() {
        if (this.io != null) {
            return this.io.getIO();
        }
        return null;
    }

    public void setSharedIOName(String string) {
        this.sharedIOName = string;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public abstract AbstractThread getCurrentThread();

    public abstract void setCurrentThread(AbstractThread var1);

    protected void setState(int n) {
        super.setState(n);
        this.updateCurrentStackPosition();
        switch (n) {
            case 1: {
                this.setDebuggerState(SecondaryDebuggerSupport.STATE_NOT_RUNNING);
                break;
            }
            case 3: {
                this.setDebuggerState(STATE_RUNNING);
                break;
            }
            case 2: {
                this.setDebuggerState(STATE_STARTING);
                break;
            }
            case 4: {
                this.updateStoppedState();
            }
        }
    }

    public String getProcessName(DebuggerInfo debuggerInfo) {
        String string;
        if (debuggerInfo instanceof AbstractDebuggerInfo && (string = ((AbstractDebuggerInfo)debuggerInfo).getProcessName()) != null) {
            return string;
        }
        return debuggerInfo.getStopClassName() != null ? debuggerInfo.getStopClassName() : debuggerInfo.getClassName();
    }

    public abstract String getLocationName(DebuggerInfo var1);

    public void updateWatches() {
        this.getValidator().validate();
    }

    public void disconnect() throws DebuggerException {
    }

    public void reconnect() throws DebuggerException {
    }

    public boolean canBeCurrent(Line line, boolean bl) {
        return line.canBeMarkedCurrent(bl ? 1 : this.getLastAction(), this.getCurrentLine());
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        JavaProjectSettings javaProjectSettings = (JavaProjectSettings)JavaProjectSettings.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaProjectSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaProjectSettings = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaProjectSettings")) : class$org$netbeans$modules$debugger$support$java$JavaProjectSettings), (boolean)true);
        return javaProjectSettings.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter variablesFilter) {
        if (variablesFilter == this.filter) {
            return;
        }
        if (variablesFilter != null && variablesFilter.equals(this.filter)) {
            return;
        }
        VariablesFilter variablesFilter2 = this.filter;
        this.filter = variablesFilter;
        this.firePropertyChange("variablesFilter", variablesFilter2, variablesFilter);
    }

    public String getInfo() {
        return null;
    }

    protected void updateStoppedState() {
        Node[] nodeArray;
        int n = 64;
        JavaThread javaThread = (JavaThread)this.getCurrentThread();
        if (javaThread != null && javaThread.isSuspended()) {
            n |= 7;
            if (this.markedCallStackFrame > 0) {
                n |= 0x100;
            }
            if (this.markedCallStackFrame < javaThread.getStackDepth() - 1) {
                n |= 0x80;
            }
        }
        if ((nodeArray = ((RunToCursorAction)RunToCursorAction.findObject((Class)(class$org$netbeans$modules$debugger$support$actions$RunToCursorAction == null ? (class$org$netbeans$modules$debugger$support$actions$RunToCursorAction = JavaDebugger.class$("org.netbeans.modules.debugger.support.actions.RunToCursorAction")) : class$org$netbeans$modules$debugger$support$actions$RunToCursorAction))).getActivatedNodes()) != null && nodeArray.length == 1 && null != nodeArray[0].getCookie(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = JavaDebugger.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie)) {
            n |= 0x10;
        }
        this.setDebuggerState(new StateSupport(n));
    }

    public IOManager getIOManager() {
        return this.io;
    }

    protected void updateCurrentStackPosition() {
        if (this.getState() != 4) {
            this.markedThread = null;
            return;
        }
        JavaThread javaThread = (JavaThread)this.getCurrentThread();
        if (javaThread != this.markedThread) {
            this.markedThread = javaThread;
            if (this.markedThread != null) {
                this.markedCallStackFrame = 0;
                this.markedThread.setCurrentFrameIndex(0);
            }
        }
    }

    private static void showCallStackLocation(Location location) {
        Line line = location.getLine();
        if (line != null) {
            line.show(1);
        } else {
            if (errMsgPattern == null) {
                errMsgPattern = NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebugger == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebugger = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaDebugger")) : class$org$netbeans$modules$debugger$support$java$JavaDebugger), (String)"MSG_Call_stack_location_not_available");
            }
            TopManager.getDefault().setStatusText(MessageFormat.format(errMsgPattern, location.getLocationName()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

