/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.support.java.DNFilter;
import org.netbeans.modules.debugger.support.java.HashSetFilter;
import org.netbeans.modules.debugger.support.java.HashtableFilter;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.JavaVariablesFilter;
import org.netbeans.modules.debugger.support.java.LinkedListFilter;
import org.netbeans.modules.debugger.support.java.ListFilter;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.openide.options.ContextSystemOption;
import org.openide.util.HelpCtx;

public class JavaProjectSettings
extends ContextSystemOption {
    static final long serialVersionUID = 811103321325025600L;
    public static final String PROP_VARIABLES_FILTER = "variablesFilter";
    public static final String PROP_VARIABLES_NAME_RESOLVER = "variablesNameResolver";
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaProjectSettings;

    public String displayName() {
        return JavaDebugger.getString("CTL_JavaProjectSettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$debugger$support$java$JavaProjectSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaProjectSettings = JavaProjectSettings.class$("org.netbeans.modules.debugger.support.java.JavaProjectSettings")) : class$org$netbeans$modules$debugger$support$java$JavaProjectSettings);
    }

    public boolean isGlobal() {
        return false;
    }

    public VariablesFilter getVariablesFilter() {
        VariablesFilter variablesFilter = (VariablesFilter)this.getProperty(PROP_VARIABLES_FILTER);
        if (variablesFilter == null) {
            variablesFilter = JavaProjectSettings.createDefaultFilter();
        }
        this.putProperty(PROP_VARIABLES_FILTER, variablesFilter, false);
        return variablesFilter;
    }

    public void setVariablesFilter(VariablesFilter variablesFilter) {
        this.putProperty(PROP_VARIABLES_FILTER, variablesFilter, true);
    }

    private static VariablesFilter createDefaultFilter() {
        ModifiersFilter modifiersFilter = new ModifiersFilter("{name} = ({stype}) {value}");
        JavaVariablesFilter javaVariablesFilter = new JavaVariablesFilter(modifiersFilter);
        javaVariablesFilter.registerTag("name", new JavaVariablesFilter.Tag(){

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "?";
                }
                return abstractVariable.getVariableName();
            }
        });
        javaVariablesFilter.registerTag("value", new JavaVariablesFilter.Tag(){

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "null";
                }
                return abstractVariable.getAsText();
            }
        });
        javaVariablesFilter.registerTag("type", new JavaVariablesFilter.Tag(){

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "";
                }
                return ((JavaVariable)abstractVariable).getInnerType();
            }
        });
        javaVariablesFilter.registerTag("stype", new JavaVariablesFilter.Tag(){

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "";
                }
                String string = ((JavaVariable)abstractVariable).getInnerType();
                if (string == null) {
                    return "";
                }
                int n = string.lastIndexOf(46);
                if (n < 0) {
                    return string;
                }
                return string.substring(n + 1);
            }
        });
        javaVariablesFilter.registerTag("fieldType", new JavaVariablesFilter.Tag(){

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "";
                }
                return abstractVariable.getType();
            }
        });
        javaVariablesFilter.registerTag("sFieldType", new JavaVariablesFilter.Tag(){

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "";
                }
                String string = abstractVariable.getType();
                if (string == null) {
                    return "";
                }
                int n = string.lastIndexOf(46);
                if (n < 0) {
                    return string;
                }
                return string.substring(n + 1);
            }
        });
        javaVariablesFilter.registerTag("toString", new JavaVariablesFilter.Tag(){

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "null";
                }
                return ((JavaVariable)abstractVariable).toStringValue();
            }
        });
        javaVariablesFilter.registerTag("arrayStype", new JavaVariablesFilter.Tag(){

            public String resolve(AbstractVariable abstractVariable) {
                if (abstractVariable == null) {
                    return "";
                }
                String string = ((JavaVariable)abstractVariable).getInnerType();
                if (string == null) {
                    return "";
                }
                int n = string.indexOf("[]");
                if (n >= 0) {
                    string = string.substring(0, n + 1) + ((JavaVariable)abstractVariable).getSize() + string.substring(n + 1, string.length());
                }
                return string;
            }
        });
        javaVariablesFilter.register("int", new DNFilter("{name} = {value}"));
        javaVariablesFilter.register("short", new DNFilter("{name} = {value}"));
        javaVariablesFilter.register("double", new DNFilter("{name} = {value}"));
        javaVariablesFilter.register("float", new DNFilter("{name} = {value}"));
        javaVariablesFilter.register("boolean", new DNFilter("{name} = {value}"));
        javaVariablesFilter.register("byte", new DNFilter("{name} = {value}"));
        javaVariablesFilter.register("char", new DNFilter("{name} = {value}"));
        javaVariablesFilter.register("long", new DNFilter("{name} = {value}"));
        javaVariablesFilter.register("java.lang.String", new DNFilter("{name} = {toString}"));
        javaVariablesFilter.register("java.lang.Class", new DNFilter("{name} = {toString}"));
        javaVariablesFilter.register("java.util.HashMap$Entry", new DNFilter("({key.stype}) {key.value} => ({value.stype}) {value.value}"));
        javaVariablesFilter.register("java.util.Hashtable$Entry", new DNFilter("({key.stype}) {key.value} => ({value.stype}) {value.value}"));
        javaVariablesFilter.register("java.util.Vector", new ListFilter("{name} = ({stype}) {value}", new String[]{"elementData"}, true, false, true));
        javaVariablesFilter.register("java.util.Stack", new ListFilter("{name} = ({stype}) {value}", new String[]{"elementData"}, true, false, false));
        javaVariablesFilter.register("java.util.ArrayList", new ListFilter("{name} = ({stype}) {value}", new String[]{"elementData"}, true, false, true));
        javaVariablesFilter.register("java.beans.PropertyChangeSupport", new ListFilter("{name} = ({stype}) {value}", new String[]{"listeners", "elementData"}, true, true, false));
        javaVariablesFilter.register("java.util.HashMap", new HashtableFilter("{name} = ({stype}) {value}"));
        javaVariablesFilter.register("java.util.Hashtable", new HashtableFilter("{name} = ({stype}) {value}"));
        javaVariablesFilter.register("java.util.HashSet", new HashSetFilter("{name} = ({stype}) {value}"));
        javaVariablesFilter.register("java.util.LinkedList", new LinkedListFilter("{name} = ({stype}) {value}"));
        return javaVariablesFilter;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

