/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaThreadGroup;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.Node;
import org.openide.text.Line;

public abstract class JavaThread
extends AbstractThread
implements Location,
VariablesProducer,
CallStackProducer,
ModifiersFilter.Filterable {
    public static final String PROP_ADITIONAL_THREAD_INFO = "aditionalThreadInfo";
    public static final String PROP_CALL_STACK = "callStack";
    public static final String PROP_CURRENT_LINE = "currentCallStackLine";
    protected JavaDebugger debugger;
    private boolean current = false;
    private PropertyChangeSupport pcs;
    private JavaThreadGroup parentThreadGroup;
    private Node aditionalThreadInfo;
    protected VariablesFilter filter;
    private int currentCallStackLine;

    protected JavaThread(JavaDebugger javaDebugger, JavaThreadGroup javaThreadGroup) {
        this.parentThreadGroup = javaThreadGroup;
        this.debugger = javaDebugger;
        this.currentCallStackLine = -1;
        this.pcs = new PropertyChangeSupport(this);
    }

    protected final JavaDebugger getDebugger() {
        return this.debugger;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean bl) {
        this.current = bl;
        AbstractThread abstractThread = this.debugger.getCurrentThread();
        if (!bl) {
            if (abstractThread != null && abstractThread.equals(this)) {
                this.debugger.setCurrentThread(null);
            }
            if (this.getParentThreadGroup() != null) {
                this.getParentThreadGroup().setCurrent(false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JavaThread.this.pcs.firePropertyChange(null, null, null);
                }
            });
            this.debugger.setCurrentLine(null);
            this.debugger.clearCallStackAnnotations();
            return;
        }
        if (abstractThread != null && abstractThread != this) {
            abstractThread.setCurrent(false);
        }
        this.debugger.setState(this.isSuspended() ? 4 : 3);
        this.debugger.setCurrentThread(this);
        this.debugger.setCurrentLine(null);
        int n = this.getLineNumber();
        if (n >= 0) {
            Line line = this.getLine();
            if (line != null) {
                this.debugger.setCurrentLine(line);
            }
        } else {
            Location[] locationArray = this.getCallStack();
            int n2 = locationArray.length;
            int n3 = 1;
            while (n3 < n2) {
                if (Utils.showInEditor(locationArray[n3].getLine()) != null) break;
                ++n3;
            }
        }
        this.debugger.annotateCallStack();
        if (this.getParentThreadGroup() != null) {
            this.getParentThreadGroup().setCurrent(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaThread.this.pcs.firePropertyChange("current", null, null);
            }
        });
        this.debugger.updateWatches();
    }

    public int getCurrentFrameIndex() {
        return this.currentCallStackLine;
    }

    public void setCurrentFrameIndex(int n) {
        if (n != this.currentCallStackLine) {
            int n2 = this.currentCallStackLine;
            this.currentCallStackLine = n;
            this.firePropertyChange(PROP_CURRENT_LINE, new Integer(n2), new Integer(this.currentCallStackLine));
        }
    }

    public Line getLine() {
        String string = this.getSourceName();
        if (string != null) {
            return Utils.getLineForSource(this.getClassName(), this.getSourceName(), this.getLineNumber());
        }
        return Utils.getLine(this.getClassName(), this.getLineNumber());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public abstract boolean isSuspended();

    public void setSuspended(boolean bl) throws DebuggerException {
        if (this.isCurrent()) {
            if (bl) {
                this.setCurrent(true);
                this.debugger.updateWatches();
                this.debugger.setState(4);
            } else {
                this.debugger.setCurrentLine(null);
                this.debugger.clearCallStackAnnotations();
                this.debugger.setState(3);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaThread.this.firePropertyChange(JavaThread.PROP_CALL_STACK, null, null);
            }
        });
    }

    public abstract void refreshStack();

    public JavaThreadGroup getParentThreadGroup() {
        return this.parentThreadGroup;
    }

    public abstract int getLineNumber();

    public abstract String getState();

    public abstract String getClassName();

    public abstract String getMethod();

    public abstract int getStackDepth();

    public abstract void stop() throws DebuggerException;

    public Location[] getFilteredCallStack() {
        return this.getCallStack();
    }

    public abstract String getSourceName();

    public void setAditionalThreadInfo(Node node) {
        if (this.aditionalThreadInfo == node) {
            return;
        }
        Node node2 = this.aditionalThreadInfo;
        this.aditionalThreadInfo = node;
        this.firePropertyChange(PROP_ADITIONAL_THREAD_INFO, node2, this.aditionalThreadInfo);
    }

    public Node getAditionalThreadInfo() {
        if (this.aditionalThreadInfo == null) {
            return null;
        }
        return this.aditionalThreadInfo.cloneNode();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    public boolean isLeaf() {
        return false;
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.debugger.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter variablesFilter) {
        if (variablesFilter == this.filter) {
            return;
        }
        if (variablesFilter != null && variablesFilter.equals(this.filter)) {
            return;
        }
        VariablesFilter variablesFilter2 = this.filter;
        this.filter = variablesFilter;
        this.pcs.firePropertyChange("variablesFilter", variablesFilter2, variablesFilter);
    }

    public String getLocationName() {
        CallStackFrame[] callStackFrameArray = (CallStackFrame[])this.getCallStack();
        if (callStackFrameArray.length < 1) {
            return "";
        }
        return callStackFrameArray[0].getClassName() + '.' + callStackFrameArray[0].getMethodName() + " : " + callStackFrameArray[0].getLineNumber();
    }

    public String toString() {
        try {
            return "The Thread: " + this.getName() + " (" + super.toString() + ")";
        }
        catch (Exception exception) {
            return super.toString();
        }
    }
}

