/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.ThreadListener;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.support.ThreadPAdapter;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.openide.debugger.DebuggerException;

public abstract class JavaThreadGroup
extends AbstractThread
implements ThreadsProducer {
    public static final String PROP_CURRENT = "current";
    private boolean current = false;
    private Vector threadGroups = new Vector();
    private Vector threads = new Vector();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private JavaThreadGroup parentThreadGroup;
    private ThreadPAdapter threadProducer = new ThreadPAdapter();

    protected JavaThreadGroup(JavaThreadGroup javaThreadGroup) {
        this.parentThreadGroup = javaThreadGroup;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean bl) {
        if (this.current == bl) {
            return;
        }
        this.current = bl;
        this.firePropertyChange(PROP_CURRENT, new Boolean(!bl), new Boolean(bl));
        JavaThreadGroup javaThreadGroup = this.getParentThreadGroup();
        if (javaThreadGroup == null) {
            return;
        }
        javaThreadGroup.setCurrent(bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public JavaThread[] getJavaThreads() {
        return this.threads.toArray(new JavaThread[this.threads.size()]);
    }

    public JavaThreadGroup[] getThreadGroups() {
        return this.threadGroups.toArray(new JavaThreadGroup[this.threadGroups.size()]);
    }

    public JavaThreadGroup getParentThreadGroup() {
        return this.parentThreadGroup;
    }

    public void setSuspended(boolean bl) {
        JavaThread[] javaThreadArray = this.getJavaThreads();
        int n = javaThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                javaThreadArray[n2].setSuspended(bl);
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
            ++n2;
        }
        JavaThreadGroup[] javaThreadGroupArray = this.getThreadGroups();
        n = javaThreadGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            javaThreadGroupArray[n2].setSuspended(bl);
            ++n2;
        }
    }

    public void refreshStacks() {
        JavaThread[] javaThreadArray = this.getJavaThreads();
        int n = 0;
        while (n < javaThreadArray.length) {
            javaThreadArray[n].refreshStack();
            ++n;
        }
        JavaThreadGroup[] javaThreadGroupArray = this.getThreadGroups();
        int n2 = 0;
        while (n2 < javaThreadGroupArray.length) {
            javaThreadGroupArray[n2].refreshStacks();
            ++n2;
        }
    }

    protected void addThreadGroup(JavaThreadGroup javaThreadGroup) {
        this.threadGroups.add(javaThreadGroup);
        this.threadProducer.addThread(javaThreadGroup);
    }

    protected void removeThreadGroup(JavaThreadGroup javaThreadGroup) {
        this.threadGroups.remove(javaThreadGroup);
        this.threadProducer.removeThread(javaThreadGroup);
    }

    protected void addThread(JavaThread javaThread) {
        this.threads.add(javaThread);
        this.threadProducer.addThread(javaThread);
    }

    protected void removeThread(JavaThread javaThread) {
        this.threads.remove(javaThread);
        this.threadProducer.removeThread(javaThread);
    }

    protected void removeAll() {
        int n = this.threadGroups.size() - 1;
        while (n >= 0) {
            this.removeThreadGroup((JavaThreadGroup)this.threadGroups.get(n));
            --n;
        }
        n = this.threads.size() - 1;
        while (n >= 0) {
            this.removeThread((JavaThread)this.threads.get(n));
            --n;
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    public AbstractThread[] getThreads() {
        return this.threadProducer.getThreads();
    }

    public void addThreadListener(ThreadListener threadListener) {
        this.threadProducer.addThreadListener(threadListener);
    }

    public void removeThreadListener(ThreadListener threadListener) {
        this.threadProducer.removeThreadListener(threadListener);
    }
}

