/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.support.util.AbstractHistory;

public final class PackageClassHistory
extends AbstractHistory
implements Serializable {
    private final int maxSize;
    private final int maxClassListSize;
    private final ArrayList entries;
    private transient ArrayList selectedClasses;
    private transient String pkg;

    public PackageClassHistory(int n, int n2, String[] stringArray) {
        this.maxSize = n;
        this.maxClassListSize = n2;
        this.entries = new ArrayList(n);
        if (stringArray != null) {
            int n3 = stringArray.length / 2;
            if (n3 > n) {
                n3 = n;
            }
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                String string = stringArray[n4++];
                String string2 = stringArray[n4++];
                this.entries.add(new PackageClassEntry(string, string2));
                ++n5;
            }
        }
    }

    public void addItem(Object object) {
        if (this.pkg == null) {
            throw new IllegalStateException("Package was not specified.");
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("Argument must be non-null String.");
        }
        String string = (String)object;
        int n = this.selectedClasses.indexOf(string);
        if (n == -1) {
            int n2 = this.getSize();
            if (n2 == this.maxClassListSize) {
                PackageClassEntry packageClassEntry;
                Iterator iterator = this.entries.iterator();
                do {
                    packageClassEntry = (PackageClassEntry)iterator.next();
                } while (!packageClassEntry.pkg.equals(this.pkg));
                iterator.remove();
                this.selectedClasses.remove(0);
                this.entries.add(new PackageClassEntry(this.pkg, string));
                this.selectedClasses.add(string);
                this.fireShifted(packageClassEntry.cls, string);
            } else {
                if (this.entries.size() == this.maxSize) {
                    PackageClassEntry packageClassEntry;
                    Iterator iterator = this.entries.iterator();
                    do {
                        packageClassEntry = (PackageClassEntry)iterator.next();
                    } while (packageClassEntry.pkg.equals(this.pkg));
                    iterator.remove();
                }
                this.entries.add(new PackageClassEntry(this.pkg, string));
                this.selectedClasses.add(string);
                this.fireAdded(string);
            }
        } else if (n != this.getSize() - 1) {
            PackageClassEntry packageClassEntry = null;
            Iterator iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                packageClassEntry = (PackageClassEntry)iterator.next();
                if (packageClassEntry.pkg.equals(this.pkg) && packageClassEntry.cls.equals(string)) break;
            }
            iterator.remove();
            this.entries.add(packageClassEntry);
            this.selectedClasses.remove(n);
            this.selectedClasses.add(object);
            this.fireChanged();
        }
    }

    public List getItems() {
        if (this.pkg == null) {
            throw new IllegalStateException("Package was not specified.");
        }
        return Collections.unmodifiableList(this.selectedClasses);
    }

    public String[] getItemsAsArray() {
        if (this.entries.isEmpty()) {
            return new String[0];
        }
        String[] stringArray = new String[2 * this.entries.size()];
        int n = 0;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            PackageClassEntry packageClassEntry = (PackageClassEntry)iterator.next();
            stringArray[n++] = packageClassEntry.pkg;
            stringArray[n++] = (String)packageClassEntry.cls;
        }
        return stringArray;
    }

    public int getMaxSize() {
        return this.maxClassListSize;
    }

    public int getSize() {
        if (this.pkg == null) {
            throw new IllegalStateException("Package was not specified.");
        }
        return this.selectedClasses.size();
    }

    public boolean isEmpty() {
        if (this.pkg == null) {
            throw new IllegalStateException("Package was not specified.");
        }
        return this.selectedClasses.isEmpty();
    }

    public void setPackage(String string) {
        if (string.equals(this.pkg)) {
            return;
        }
        this.pkg = string;
        if (this.selectedClasses == null) {
            this.selectedClasses = new ArrayList(this.maxClassListSize);
        } else {
            this.selectedClasses.clear();
        }
        Iterator iterator = this.entries.iterator();
        int n = this.maxClassListSize;
        while (iterator.hasNext() && n > 0) {
            PackageClassEntry packageClassEntry = (PackageClassEntry)iterator.next();
            if (!packageClassEntry.pkg.equals(string)) continue;
            this.selectedClasses.add(packageClassEntry.cls);
            --n;
        }
        this.fireChanged();
    }

    private static class PackageClassEntry
    implements Serializable {
        String pkg;
        Object cls;

        public PackageClassEntry(String string, Object object) {
            this.pkg = string;
            this.cls = object;
        }

        public boolean equals(Object object) {
            if (object instanceof PackageClassEntry) {
                PackageClassEntry packageClassEntry = (PackageClassEntry)object;
                return packageClassEntry.pkg.equals(this.pkg) && packageClassEntry.cls.equals(this.cls);
            }
            return false;
        }
    }
}

