/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LeafRefresher;
import org.netbeans.modules.debugger.support.nodes.WatchDelegate;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class VariableNode
extends AbstractNode {
    static final long serialVersionUID = -4167730461290769518L;
    protected static String ICON_BASE = "/org/netbeans/core/resources/variable";
    protected static String ICON_STATIC_VARIABLE = "/org/netbeans/modules/debugger/resources/staticVariable";
    public static final String PROP_MODIFIERS = "modifiers";
    public static final String PROP_INNER_TYPE = "innerType";
    public static final String PROP_BASE_INDEX = "baseIndex";
    public static final String PROP_DISPLAYED_LENGTH = "displayedLength";
    public static final int TYPE_VARIABLE = 0;
    public static final int TYPE_LOCAL_VARIABLE = 1;
    public static final int TYPE_FIXED_VARIABLE = 2;
    private static ResourceBundle bundle;
    protected int type;
    protected AbstractVariable variable = null;
    protected transient Debugger debugger;
    private PropertyChangeListener pcl;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$VariableNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$VariableNode == null ? (class$org$netbeans$modules$debugger$support$nodes$VariableNode = VariableNode.class$("org.netbeans.modules.debugger.support.nodes.VariableNode")) : class$org$netbeans$modules$debugger$support$nodes$VariableNode));
        }
        return bundle.getString(string);
    }

    public VariableNode(AbstractVariable abstractVariable, int n) {
        super((Children)(abstractVariable instanceof VariablesProducer ? (((VariablesProducer)((Object)abstractVariable)).isLeaf() ? Children.LEAF : new VariableContextChildren()) : Children.LEAF));
        this.type = n;
        this.variable = abstractVariable;
        this.init();
    }

    public VariableNode(AbstractVariable abstractVariable) {
        this(abstractVariable, 0);
    }

    protected void init() {
        this.variable.addPropertyChangeListener(new VariableListener(this));
        this.setDisplayName(this.getName());
        this.setName(this.getName());
        this.setIconBase(ICON_BASE);
        try {
            this.debugger = TopManager.getDefault().getDebugger();
        }
        catch (DebuggerException debuggerException) {
            TopManager.getDefault().notifyException((Throwable)debuggerException);
        }
        this.createProperties();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerVariableNode");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, NotActiveException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public String getVariableValue() {
        return this.variable.getAsText();
    }

    public void setVariableValue(String string) {
        try {
            this.variable.setAsText(string);
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    protected void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(Utils.createProperty(this.variable, class$java$lang$String == null ? (class$java$lang$String = VariableNode.class$("java.lang.String")) : class$java$lang$String, "variableName", VariableNode.getLocalizedString("PROP_watch_name"), VariableNode.getLocalizedString("HINT_watch_name"), "getVariableName", null));
        set.put(Utils.createProperty(this.variable, class$java$lang$String == null ? (class$java$lang$String = VariableNode.class$("java.lang.String")) : class$java$lang$String, "type", VariableNode.getLocalizedString("PROP_watch_type"), VariableNode.getLocalizedString("HINT_watch_type"), "getType", null));
        set.put(Utils.createProperty((Object)this, class$java$lang$String == null ? (class$java$lang$String = VariableNode.class$("java.lang.String")) : class$java$lang$String, "asText", VariableNode.getLocalizedString("PROP_watch_value"), VariableNode.getLocalizedString("HINT_watch_value"), "getVariableValue", this.type == 2 ? null : "setVariableValue"));
        this.setSheet(sheet);
    }

    public SystemAction[] getActions() {
        if (this.type == 2) {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = VariableNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = VariableNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = VariableNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = VariableNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = VariableNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public boolean canDestroy() {
        return this.type == 2;
    }

    public void destroy() throws IOException {
        if (this.variable == null) {
            return;
        }
        this.variable.removePropertyChangeListener(this.pcl);
        this.variable = null;
        if (this.getChildren() == Children.LEAF) {
            return;
        }
        VariableContextChildren variableContextChildren = (VariableContextChildren)this.getChildren();
        if (!variableContextChildren.initialized) {
            return;
        }
        Node[] nodeArray = variableContextChildren.getNodes();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ((VariableNode)nodeArray[n2]).destroy();
            ++n2;
        }
        super.destroy();
    }

    public AbstractVariable getVariable() {
        return this.variable;
    }

    public String getName() {
        String string = this.variable.getVariableName();
        if (string == null || this.debugger == null) {
            return "???";
        }
        if (this.debugger.getState() == 1) {
            return string + " " + VariableNode.getLocalizedString("CTL_NoSession");
        }
        String string2 = this.variable.getType();
        String string3 = this.variable.getAsText();
        if (string3 == null) {
            return string + " " + VariableNode.getLocalizedString("CTL_NotInitialized");
        }
        if (string2 == null) {
            return string + " = " + string3;
        }
        return string + " = (" + string2 + ") " + string3;
    }

    protected void parameterChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = this.getName();
        this.setDisplayName(string);
        this.setName(string);
        this.changeChildren();
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    protected void changeChildren() {
        AbstractVariable abstractVariable;
        if (this.getChildren() == Children.LEAF) {
            Node node = this.getParentNode();
            if (node == null) {
                return;
            }
            AbstractVariable abstractVariable2 = this.getVariable();
            if (!((VariablesProducer)((Object)abstractVariable2)).isLeaf()) {
                LeafRefresher leafRefresher = (LeafRefresher)node.getChildren();
                leafRefresher.refreshMyKey(abstractVariable2);
            }
            return;
        }
        VariableContextChildren variableContextChildren = (VariableContextChildren)this.getChildren();
        if (!variableContextChildren.initialized) {
            return;
        }
        AbstractVariable abstractVariable3 = abstractVariable = this.variable instanceof WatchDelegate ? (AbstractVariable)((WatchDelegate)((Object)this.variable)).getInnerWatch() : this.variable;
        if (abstractVariable == null) {
            variableContextChildren.setMyKeys(new AbstractVariable[0]);
            return;
        }
        VariablesFilter variablesFilter = ((VariablesProducer)((Object)abstractVariable)).getVariablesFilter();
        Object[] objectArray = variablesFilter.getVariables((VariablesProducer)((Object)abstractVariable));
        Arrays.sort(objectArray, Utils.variablesComparator);
        variableContextChildren.setMyKeys(objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class VariableListener
    implements PropertyChangeListener {
        private WeakReference node;
        private AbstractVariable variable;

        VariableListener(VariableNode variableNode) {
            this.node = new WeakReference<VariableNode>(variableNode);
            this.variable = variableNode.variable;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            VariableNode variableNode = (VariableNode)((Object)this.node.get());
            if (variableNode == null) {
                this.variable.removePropertyChangeListener(this);
                return;
            }
            variableNode.parameterChanged(propertyChangeEvent);
        }
    }

    private static final class VariableContextChildren
    extends Children.Keys
    implements LeafRefresher {
        private boolean initialized = false;

        private VariableContextChildren() {
        }

        protected void addNotify() {
            this.initialized = true;
            ((VariableNode)this.getNode()).changeChildren();
        }

        protected void removeNotify() {
            this.initialized = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            Node node = DebuggerNode.createNode(object);
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        private void setMyKeys(Object[] objectArray) {
            this.setKeys(objectArray);
        }

        public void refreshMyKey(Object object) {
            this.refreshKey(object);
        }
    }
}

