/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.debugger.support.util.AbstractHistory;

public class SimpleHistory
extends AbstractHistory
implements Serializable {
    protected final int maxSize;
    protected final ArrayList items;

    public SimpleHistory(int n, String[] stringArray) {
        this.maxSize = n;
        this.items = new ArrayList(n);
        if (stringArray != null) {
            int n2 = stringArray.length;
            if (n2 > n) {
                n2 = n;
            }
            int n3 = 0;
            while (n3 < n2) {
                this.items.add(stringArray[n3]);
                ++n3;
            }
        }
    }

    public void addItem(Object object) {
        if (!this.items.contains(object)) {
            if (this.items.size() == this.maxSize) {
                Object e = this.items.remove(0);
                this.items.add(object);
                this.fireShifted(e, object);
            } else {
                this.items.add(object);
                this.fireAdded(object);
            }
        }
    }

    public List getItems() {
        if (this.items.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.items);
    }

    public String[] getItemsAsArray() {
        if (this.items.isEmpty()) {
            return new String[0];
        }
        String[] stringArray = new String[this.items.size()];
        return this.items.toArray(stringArray);
    }

    public int getSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

