/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import com.sun.jdi.ReferenceType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.support.ProcessDebuggerInfo;
import org.netbeans.modules.debugger.support.actions.AddBreakpointAction;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.debugger.DebuggerInfo;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.src.ClassElement;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Utils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$DebuggerSupport == null ? (class$org$netbeans$modules$debugger$support$DebuggerSupport = Utils.class$("org.netbeans.modules.debugger.support.DebuggerSupport")) : class$org$netbeans$modules$debugger$support$DebuggerSupport));
    static boolean hotSpotDetected;
    public static Comparator variablesComparator;
    public static Comparator localsComparator;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$DebuggerSupport;
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;
    static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public static RuntimeException localizeException(Exception exception, String string) {
        return new ExceptionHack(exception, string);
    }

    private static String removeQuotationMarks(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static HashMap processDebuggerInfo(DebuggerInfo debuggerInfo, String string, String string2) {
        Serializable serializable;
        String string3 = Utils.removeQuotationMarks(NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.DEBUG).getClassPath());
        String string4 = Utils.removeQuotationMarks(NbClassPath.createLibraryPath().getClassPath());
        String string5 = Utils.removeQuotationMarks(NbClassPath.createClassPath().getClassPath());
        String string6 = Utils.removeQuotationMarks(NbClassPath.createBootClassPath().getClassPath());
        String string7 = System.getProperty("path.separator");
        String string8 = System.getProperty("java.home");
        String string9 = System.getProperty("jdk.home");
        boolean bl = false;
        if (debuggerInfo instanceof ProcessDebuggerInfo) {
            serializable = (ProcessDebuggerInfo)debuggerInfo;
            if (((ProcessDebuggerInfo)serializable).getClassPath() != null) {
                string5 = Utils.removeQuotationMarks(((ProcessDebuggerInfo)serializable).getClassPath());
            }
            if (((ProcessDebuggerInfo)serializable).getBootClassPath() != null) {
                string6 = Utils.removeQuotationMarks(((ProcessDebuggerInfo)serializable).getBootClassPath());
            }
            if (((ProcessDebuggerInfo)serializable).getRepositoryPath() != null) {
                string3 = Utils.removeQuotationMarks(((ProcessDebuggerInfo)serializable).getRepositoryPath());
            }
            if (((ProcessDebuggerInfo)serializable).getLibraryPath() != null) {
                string4 = Utils.removeQuotationMarks(((ProcessDebuggerInfo)serializable).getLibraryPath());
            }
            bl = ((ProcessDebuggerInfo)serializable).isClassic();
        }
        serializable = new HashMap();
        ((HashMap)serializable).put("classic", bl ? "-classic " : "");
        ((HashMap)serializable).put("debuggerOptions", string);
        ((HashMap)serializable).put("filesystems", string3);
        ((HashMap)serializable).put("library", string4.length() > 0 && string3.length() > 0 ? string7 + string4 : string4);
        ((HashMap)serializable).put("classpath", string5.length() > 0 && string4.length() + string3.length() > 0 ? string7 + string5 : string5);
        ((HashMap)serializable).put("bootclasspath", string6);
        ((HashMap)serializable).put("bootclasspathSwitch", string6.length() < 1 ? "" : "-Xbootclasspath:");
        ((HashMap)serializable).put("main", string2);
        ((HashMap)serializable).put("q", "\"");
        ((HashMap)serializable).put("java.home", string8);
        ((HashMap)serializable).put("jdk.home", string9);
        ((HashMap)serializable).put("/", System.getProperty("file.separator"));
        ((HashMap)serializable).put(":", string7);
        return serializable;
    }

    public static boolean hasHotSpot(String string) {
        Object object;
        Object object2;
        try {
            object2 = string.substring(0, string.lastIndexOf(File.separatorChar));
            object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(File.separatorChar));
            object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(File.separatorChar));
            object = new File((String)object2 + File.separatorChar + "bin" + File.separatorChar + "hotspot");
            if (((File)object).exists()) {
                return true;
            }
            object = new File((String)object2 + File.separatorChar + "lib" + File.separatorChar + "sparc" + File.separatorChar + "hotspot");
            if (((File)object).exists()) {
                return true;
            }
            object = new File((String)(object2 = ((String)object2).concat(File.separator).concat("lib")));
            String[] stringArray = ((File)object).list();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    if (new File((String)object2 + File.separatorChar + stringArray[n] + File.separatorChar + "hotspot").exists()) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hotSpotDetected = false;
        try {
            object2 = Runtime.getRuntime().exec(string.concat(" -version"));
            object = new Thread((Process)object2){
                private final /* synthetic */ Process val$process;
                {
                    this.val$process = process;
                }

                public boolean checkStream(BufferedReader bufferedReader) {
                    int n = 0;
                    boolean bl = false;
                    try {
                        String string = bufferedReader.readLine();
                        while (string != null && n < 10) {
                            if (string.toLowerCase().indexOf("hotspot") > -1) {
                                bl = true;
                                break;
                            }
                            string = bufferedReader.readLine();
                            ++n;
                        }
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return bl;
                }

                public void run() {
                    hotSpotDetected = false;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.val$process.getErrorStream()));
                    hotSpotDetected = this.checkStream(bufferedReader);
                    if (!hotSpotDetected) {
                        bufferedReader = new BufferedReader(new InputStreamReader(this.val$process.getInputStream()));
                        hotSpotDetected = this.checkStream(bufferedReader);
                    }
                }
            };
            ((Thread)object).start();
            int n = 12;
            while (n-- > 0 && ((Thread)object).isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ((Process)object2).destroy();
            if (((Thread)object).isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ((Thread)object).stop();
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return hotSpotDetected;
    }

    public static boolean classicPreferred(String string) {
        if (Utilities.getOperatingSystem() == 2048) {
            return false;
        }
        String string2 = System.getProperty("java.version");
        if (string2.startsWith("1.3.0")) {
            return Utilities.getOperatingSystem() != 8;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        try {
            String string3 = stringTokenizer.nextToken();
            if (Integer.parseInt(string3) > 1) {
                return false;
            }
            string3 = stringTokenizer.nextToken();
            if (Integer.parseInt(string3) >= 3) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            string = System.getProperty("jdk.home") + File.separatorChar + "bin" + File.separatorChar + "java";
        }
        return Utils.hasHotSpot(string);
    }

    public static int[] getJavaVersion() {
        String string = System.getProperty("java.version");
        int[] nArray = new int[]{0, 0, 0};
        if (string == null) {
            return nArray;
        }
        int n = string.indexOf(46);
        if (n <= 0) {
            return nArray;
        }
        try {
            nArray[0] = Integer.parseInt(string.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            return nArray;
        }
        char[] cArray = string.toCharArray();
        int n2 = n + 1;
        while (n2 < cArray.length && Character.isDigit(cArray[n2])) {
            ++n2;
        }
        if (n2 == n + 1) {
            nArray[0] = 0;
            return nArray;
        }
        try {
            nArray[1] = Integer.parseInt(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            nArray[0] = 0;
            return nArray;
        }
        if (n2 < cArray.length && cArray[n2] == '.') {
            n = n2++;
            while (n2 < cArray.length && Character.isDigit(cArray[n2])) {
                ++n2;
            }
            if (n2 > n + 1) {
                try {
                    nArray[2] = Integer.parseInt(string.substring(n + 1, n2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return nArray;
    }

    public static String getShortInstanceName(Object object) {
        if (object == null) {
            return "null";
        }
        return Utils.getClassName(object.getClass().getName()) + " @ " + System.identityHashCode(object);
    }

    public static String getClassName(String string) {
        int n = string.lastIndexOf(46);
        return n > 0 ? string.substring(n + 1) : string;
    }

    public static String getTopClassName(String string) {
        int n = string.indexOf(36);
        return n > 0 ? string.substring(0, n) : string;
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        return n > 0 ? string.substring(0, n) : "";
    }

    public static List anonymousInnerClasses(String string, List list) {
        if (string == null) {
            throw new IllegalArgumentException("outerClazzName == null");
        }
        if (list == null) {
            throw new IllegalArgumentException("refTypes == null");
        }
        if (list.isEmpty()) {
            return list;
        }
        if (string.trim().length() == 0) {
            return Collections.EMPTY_LIST;
        }
        String string2 = string + '$';
        int n = string2.length();
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ReferenceType referenceType = (ReferenceType)iterator.next();
            String string3 = referenceType.name();
            if (string3.length() <= n || !string3.startsWith(string2) || Character.isJavaIdentifierStart(string3.charAt(n))) continue;
            arrayList.add(referenceType);
        }
        if (arrayList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return arrayList;
    }

    public static Line getLineForSource(String string, String string2, int n) {
        if (string2 == null) {
            return Utils.getLine(string, n);
        }
        int n2 = string2.lastIndexOf(46);
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
        }
        return Utils.getLine(Utils.getPackageName(string), string2, n);
    }

    public static Line getLine(String string, int n) {
        Line.Set set = Utils.getLineSet(string);
        if (set == null) {
            return null;
        }
        try {
            return set.getOriginal(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static Line.Set getLineSet(String string) {
        LineCookie lineCookie = null;
        ClassElement classElement = ClassElement.forName((String)Utils.getTopClassName(string));
        if (classElement != null) {
            lineCookie = (LineCookie)classElement.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = Utils.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
        }
        if (lineCookie == null) {
            FileObject fileObject = TopManager.getDefault().getRepository().find(Utils.getPackageName(string), Utils.getClassName(Utils.getTopClassName(string)), "java");
            if (fileObject == null) {
                fileObject = TopManager.getDefault().getRepository().find(Utils.getPackageName(string), Utils.getClassName(Utils.getTopClassName(string)), "jsp");
            }
            if (fileObject == null) {
                return null;
            }
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (Exception exception) {
                return null;
            }
            if (dataObject.getCookie(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = Utils.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie) == null) {
                return null;
            }
            lineCookie = (LineCookie)dataObject.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = Utils.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
            if (lineCookie == null) {
                return null;
            }
        }
        return lineCookie.getLineSet();
    }

    public static Line getCurrentLine(String string, int n) {
        Line.Set set = Utils.getLineSet(string);
        if (set == null) {
            return null;
        }
        try {
            return set.getCurrent(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static Line getLine(String string, String string2, int n) {
        String string3 = string.length() == 0 ? string2 : string + '.' + string2;
        return Utils.getLine(string3, n);
    }

    public static Line showInEditor(Line line) {
        if (line == null) {
            return null;
        }
        try {
            line.show(2);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(throwable, (Object)bundle.getString("EXC_Editor")));
        }
        return line;
    }

    public static String getExceptionName(String string) {
        try {
            int n = string.indexOf(58) + 1;
            String string2 = string.substring(n);
            string2 = string2.trim();
            n = string2.indexOf(58);
            int n2 = string2.indexOf(32);
            if (n2 >= 0 && n2 < n) {
                n = n2;
            }
            if ((n2 = string2.indexOf(10)) >= 0 && n2 < n) {
                n = n2;
            }
            if ((n2 = string2.indexOf(9)) >= 0 && n2 < n) {
                n = n2;
            }
            if ((string2 = string2.substring(0, n).trim()).length() == 0) {
                return null;
            }
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static String getSelectedText() {
        JEditorPane jEditorPane = Utils.getCurrentEditor();
        if (jEditorPane == null) {
            return null;
        }
        return jEditorPane.getSelectedText();
    }

    public static EditorCookie getCurrentEditorCookie() {
        AddBreakpointAction addBreakpointAction = (AddBreakpointAction)AddBreakpointAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = Utils.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        Node[] nodeArray = addBreakpointAction.getActivatedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0];
        return (EditorCookie)node.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = Utils.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
    }

    public static JEditorPane getCurrentEditor() {
        EditorCookie editorCookie = Utils.getCurrentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    public static JEditorPane getCurrentEditor(EditorCookie editorCookie) {
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    public static int getCurrentLineNumber() {
        EditorCookie editorCookie = Utils.getCurrentEditorCookie();
        if (editorCookie == null) {
            return -1;
        }
        JEditorPane jEditorPane = Utils.getCurrentEditor(editorCookie);
        if (jEditorPane == null) {
            return -1;
        }
        return NbDocument.findLineNumber((StyledDocument)editorCookie.getDocument(), (int)jEditorPane.getCaret().getDot()) + 1;
    }

    public static Line getCurrentLine() {
        EditorCookie editorCookie = Utils.getCurrentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane jEditorPane = Utils.getCurrentEditor(editorCookie);
        if (jEditorPane == null) {
            return null;
        }
        return editorCookie.getLineSet().getCurrent(NbDocument.findLineNumber((StyledDocument)editorCookie.getDocument(), (int)jEditorPane.getCaret().getDot()));
    }

    public static Node.Property createProperty(Object object, Class clazz, String string, String string2, String string3, String string4, String string5) {
        PropertySupport.Reflection reflection;
        try {
            reflection = new PropertySupport.Reflection(object, clazz, string4, string5);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException.getMessage());
        }
        reflection.setName(string);
        reflection.setDisplayName(string2);
        reflection.setShortDescription(string3);
        return reflection;
    }

    public static final String[] getPackageNames(boolean bl, boolean bl2, boolean bl3) {
        PackageTree packageTree = Utils.buildPackageTree();
        PackageTree[] packageTreeArray = packageTree.getSubpackages();
        int n = packageTreeArray.length;
        if (n == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>(20);
        if (n > 1) {
            Arrays.sort(packageTreeArray, PackageTree.getComparator());
        }
        int n2 = 0;
        while (n2 < n) {
            PackageTree packageTree2 = packageTreeArray[n2];
            String string = packageTree2.getPackageName();
            if (!(bl2 && string.equals("META-INF") || bl && packageTree2.isLeaf() && string.equals("CVS") || bl3 && string.equals("resources"))) {
                arrayList.add(string);
                Utils.addPackageNames(arrayList, string, packageTree2, bl, bl3);
            }
            ++n2;
        }
        return arrayList.toArray(EMPTY_STRING_ARRAY);
    }

    private static final void addPackageNames(List list, String string, PackageTree packageTree, boolean bl, boolean bl2) {
        PackageTree[] packageTreeArray = packageTree.getSubpackages();
        int n = packageTreeArray.length;
        if (n == 0) {
            return;
        }
        if (n > 1) {
            Arrays.sort(packageTreeArray, PackageTree.getComparator());
        }
        String string2 = string + '.';
        int n2 = 0;
        while (n2 < n) {
            PackageTree packageTree2 = packageTreeArray[n2];
            String string3 = packageTree2.getPackageName();
            if (!(bl && packageTree2.isLeaf() && string3.equals("CVS") || bl2 && string3.equals("resources"))) {
                String string4 = string2 + string3;
                list.add(string4);
                Utils.addPackageNames(list, string4, packageTree2, bl, bl2);
            }
            ++n2;
        }
    }

    private static final PackageTree buildPackageTree() {
        Repository repository = Repository.getDefault();
        Enumeration enumeration = repository.getFileSystems();
        PackageTree packageTree = new PackageTree("");
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            if (fileSystem.isDefault()) continue;
            FileObject fileObject = fileSystem.getRoot();
            Utils.processPackage(fileObject, packageTree);
        }
        return packageTree;
    }

    private static final void processPackage(FileObject fileObject, PackageTree packageTree) {
        PackageTree[] packageTreeArray;
        Enumeration enumeration = fileObject.getFolders(false);
        if (!enumeration.hasMoreElements()) {
            return;
        }
        ArrayList arrayList = new ArrayList(10);
        do {
            arrayList.add(enumeration.nextElement());
        } while (enumeration.hasMoreElements());
        int n = arrayList.size();
        enumeration = null;
        String[] stringArray = new String[n];
        FileObject[] fileObjectArray = new FileObject[n];
        Iterator iterator = arrayList.iterator();
        int n2 = 0;
        while (n2 < n) {
            fileObjectArray[n2] = packageTreeArray = (PackageTree[])iterator.next();
            stringArray[n2] = packageTreeArray.getName();
            ++n2;
        }
        iterator = null;
        arrayList = null;
        packageTreeArray = packageTree.addSubpackages(stringArray);
        stringArray = null;
        int n3 = 0;
        while (n3 < n) {
            Utils.processPackage(fileObjectArray[n3], packageTreeArray[n3]);
            ++n3;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        variablesComparator = new Comparator(){

            public int compare(Object object, Object object2) throws ClassCastException {
                boolean bl;
                boolean bl2 = ((JavaVariable)object).getModifiers().indexOf("static") >= 0;
                boolean bl3 = bl = ((JavaVariable)object2).getModifiers().indexOf("static") >= 0;
                if (bl2 == bl) {
                    return ((AbstractVariable)object).getVariableName().compareToIgnoreCase(((AbstractVariable)object2).getVariableName());
                }
                return bl2 ? 1 : -1;
            }
        };
        localsComparator = new Comparator(){

            public int compare(Object object, Object object2) throws ClassCastException {
                return ((AbstractVariable)object).getVariableName().compareToIgnoreCase(((AbstractVariable)object2).getVariableName());
            }
        };
    }

    static class ExceptionHack
    extends RuntimeException {
        private Throwable t;
        private String text;

        ExceptionHack(Throwable throwable, String string) {
            super("");
            this.t = throwable;
            this.text = string;
        }

        public String getMessage() {
            return this.text + " ";
        }

        public String getLocalizedMessage() {
            return this.text;
        }

        public void printStackTrace(PrintStream printStream) {
            this.t.printStackTrace(printStream);
        }

        public void printStackTrace(PrintWriter printWriter) {
            this.t.printStackTrace(printWriter);
        }
    }

    private static final class PackageTree {
        private static final PackageTree[] EMPTY_PACKAGE_ARRAY = new PackageTree[0];
        private static Comparator comparator;
        private final String packageName;
        private PackageTree[] subpackages;

        private PackageTree(String string) {
            this.packageName = string;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String[] getSubpackagesNames() {
            if (this.subpackages == null) {
                return EMPTY_STRING_ARRAY;
            }
            int n = this.subpackages.length;
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.subpackages[n2].packageName;
                ++n2;
            }
            return stringArray;
        }

        public PackageTree[] getSubpackages() {
            if (this.subpackages == null) {
                return EMPTY_PACKAGE_ARRAY;
            }
            PackageTree[] packageTreeArray = new PackageTree[this.subpackages.length];
            System.arraycopy(this.subpackages, 0, packageTreeArray, 0, this.subpackages.length);
            return packageTreeArray;
        }

        public boolean isLeaf() {
            return this.subpackages == null;
        }

        public PackageTree[] addSubpackages(String[] stringArray) {
            PackageTree[] packageTreeArray;
            int n = stringArray.length;
            if (n == 0) {
                return EMPTY_PACKAGE_ARRAY;
            }
            if (this.subpackages == null) {
                this.subpackages = new PackageTree[n];
                int n2 = 0;
                while (n2 < n) {
                    this.subpackages[n2] = new PackageTree(stringArray[n2]);
                    ++n2;
                }
                return this.subpackages;
            }
            HashMap<Object, PackageTree> hashMap = new HashMap<Object, PackageTree>((int)Math.ceil((double)(this.subpackages.length + stringArray.length) * 1.35), 0.75f);
            int n3 = this.subpackages.length;
            int n4 = 0;
            while (n4 < n3) {
                PackageTree packageTree = this.subpackages[n4];
                hashMap.put(packageTree.packageName, packageTree);
                ++n4;
            }
            int n5 = 0;
            PackageTree[] packageTreeArray2 = new PackageTree[n];
            PackageTree[] packageTreeArray3 = new PackageTree[n];
            int n6 = 0;
            while (n6 < n) {
                packageTreeArray = stringArray[n6];
                Object v = hashMap.get(packageTreeArray);
                if (v == null) {
                    PackageTree packageTree = new PackageTree((String)packageTreeArray);
                    hashMap.put(packageTreeArray, packageTree);
                    packageTreeArray2[n5++] = packageTree;
                    packageTreeArray3[n6] = packageTree;
                } else {
                    packageTreeArray3[n6] = (PackageTree)v;
                }
                ++n6;
            }
            if (n5 > 0) {
                packageTreeArray = this.subpackages;
                this.subpackages = new PackageTree[n3 + n5];
                System.arraycopy(packageTreeArray, 0, this.subpackages, 0, n3);
                System.arraycopy(packageTreeArray2, 0, this.subpackages, n3, n5);
            }
            return packageTreeArray3;
        }

        public static Comparator getComparator() {
            if (comparator == null) {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        PackageTree packageTree = (PackageTree)object;
                        PackageTree packageTree2 = (PackageTree)object2;
                        return PackageTree.access$200(packageTree).compareTo(PackageTree.access$200(packageTree2));
                    }
                };
            }
            return comparator;
        }

        static /* synthetic */ String access$200(PackageTree packageTree) {
            return packageTree.packageName;
        }
    }
}

